/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleMultiPhaseArgs {
    int action = 0;
    int nsites = 0;
    Vector dbLinks = null;
    Vector xids = null;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Wed_Feb_01_11:36:14_PST_2023";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleMultiPhaseArgs() {
    }

    public OracleMultiPhaseArgs(int n2, int n3, Vector vector, Vector vector2) {
        if (n3 <= 1) {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
        } else if (!vector.isEmpty() && !vector2.isEmpty() && vector2.size() == n3) {
            if (vector.size() != 3 * n3) {
            } else {
                this.action = n2;
                this.nsites = n3;
                this.xids = vector;
                this.dbLinks = vector2;
            }
        }
    }

    public OracleMultiPhaseArgs(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.xids = new Vector();
        this.dbLinks = new Vector();
        try {
            this.action = dataInputStream.readInt();
            this.nsites = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            byte[] byArray2 = new byte[n3];
            int n4 = dataInputStream.read(byArray2, 0, n3);
            for (int i2 = 0; i2 < this.nsites; ++i2) {
                int n5 = dataInputStream.readInt();
                byte[] byArray3 = new byte[n5];
                int n6 = dataInputStream.read(byArray3, 0, n5);
                this.xids.addElement(n2);
                this.xids.addElement(byArray2);
                this.xids.addElement(byArray3);
                String string = dataInputStream.readUTF();
                this.dbLinks.addElement(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] toByteArray() {
        return this.toByteArrayOS().toByteArray();
    }

    public ByteArrayOutputStream toByteArrayOS() {
        byte[] byArray = null;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.action);
            dataOutputStream.writeInt(this.nsites);
            for (int i2 = 0; i2 < this.nsites; ++i2) {
                String string = (String)this.dbLinks.elementAt(i2);
                int n3 = (Integer)this.xids.elementAt(i2 * 3);
                byte[] byArray2 = (byte[])this.xids.elementAt(i2 * 3 + 1);
                byte[] byArray3 = (byte[])this.xids.elementAt(i2 * 3 + 2);
                if (i2 == 0) {
                    n2 = n3;
                    byArray = byArray2;
                    dataOutputStream.writeInt(n3);
                    dataOutputStream.writeInt(byArray2.length);
                    dataOutputStream.write(byArray2, 0, byArray2.length);
                }
                dataOutputStream.writeInt(byArray3.length);
                dataOutputStream.write(byArray3, 0, byArray3.length);
                dataOutputStream.writeUTF(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream;
    }

    public int getAction() {
        return this.action;
    }

    public int getnsite() {
        return this.nsites;
    }

    public Vector getdbLinks() {
        return this.dbLinks;
    }

    public Vector getXids() {
        return this.xids;
    }

    public void printMPArgs() {
        for (int i2 = 0; i2 < this.nsites; ++i2) {
            String string = (String)this.dbLinks.elementAt(i2);
            int n2 = (Integer)this.xids.elementAt(i2 * 3);
            byte[] byArray = (byte[])this.xids.elementAt(i2 * 3 + 1);
            byte[] byArray2 = (byte[])this.xids.elementAt(i2 * 3 + 2);
            this.printByteArray(byArray);
            this.printByteArray(byArray2);
        }
    }

    private void printByteArray(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(byArray[i2] + " ");
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$11 = OracleMultiPhaseArgs.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleMultiPhaseArgs.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Vector.class, Vector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleMultiPhaseArgs.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleMultiPhaseArgs.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleMultiPhaseArgs.class.getDeclaredMethod("printByteArray", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleMultiPhaseArgs.class.getDeclaredMethod("printMPArgs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleMultiPhaseArgs.class.getDeclaredMethod("getXids", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleMultiPhaseArgs.class.getDeclaredMethod("getdbLinks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleMultiPhaseArgs.class.getDeclaredMethod("getnsite", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleMultiPhaseArgs.class.getDeclaredMethod("getAction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleMultiPhaseArgs.class.getDeclaredMethod("toByteArrayOS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleMultiPhaseArgs.class.getDeclaredMethod("toByteArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleMultiPhaseArgs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

