/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.XSNamespaceI;
import oracle.jdbc.driver.XSSecureIdI;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIoxsns
extends T4CTTIfun {
    private OracleConnection.XSOperationCode operationCode;
    private byte[] sessionId;
    private XSNamespace[] namespaces;
    private XSSecureId secureId;
    private XSNamespace[] outNamespaces;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    T4CTTIoxsns(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)178);
    }

    void doOXSNS(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray, XSSecureId xSSecureId, boolean bl) throws IOException, SQLException {
        if (bl) {
            this.setTTCCode((byte)3);
        } else {
            this.setTTCCode((byte)17);
        }
        this.operationCode = xSOperationCode;
        this.sessionId = byArray;
        this.namespaces = xSNamespaceArray;
        this.secureId = xSSecureId;
        if (this.namespaces != null) {
            for (int i2 = 0; i2 < this.namespaces.length; ++i2) {
                ((XSNamespaceI)this.namespaces[i2]).doCharConversion(this.meg.conv);
            }
        }
        if (bl) {
            this.doRPC();
        } else {
            this.doPigRPC();
        }
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(this.operationCode.getCode());
        boolean bl = false;
        if (this.sessionId != null && this.sessionId.length > 0) {
            bl = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.sessionId.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean bl2 = false;
        this.meg.marshalPTR();
        if (this.namespaces != null && this.namespaces.length > 0) {
            bl2 = true;
            this.meg.marshalUB4(this.namespaces.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        if (this.secureId == null) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        if (bl) {
            this.meg.marshalB1Array(this.sessionId);
        }
        if (bl2) {
            for (int i2 = 0; i2 < this.namespaces.length; ++i2) {
                ((XSNamespaceI)this.namespaces[i2]).marshal(this.meg);
            }
        }
        if (this.secureId != null) {
            ((XSSecureIdI)this.secureId).marshal(this.meg);
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        this.outNamespaces = null;
        int n2 = (int)this.meg.unmarshalUB4();
        if (n2 > 0) {
            this.outNamespaces = new XSNamespace[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.outNamespaces[i2] = XSNamespaceI.unmarshal(this.meg);
            }
        }
    }

    XSNamespace[] getNamespaces() throws SQLException {
        return this.outNamespaces;
    }

    static {
        try {
            $$$methodRef$$$4 = T4CTTIoxsns.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoxsns.class.getDeclaredMethod("getNamespaces", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoxsns.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoxsns.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoxsns.class.getDeclaredMethod("doOXSNS", OracleConnection.XSOperationCode.class, byte[].class, XSNamespace[].class, XSSecureId.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

