/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class LobCommonAccessor
extends Accessor {
    long[] prefetchedDataOffset;
    int[] prefetchedDataLength;
    long[] prefetchedLength;
    int[] prefetchedChunkSize;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    LobCommonAccessor(Representation representation, OracleStatement oracleStatement, int n2, boolean bl) {
        super(representation, oracleStatement, n2, bl);
    }

    @Override
    void setNull(int n2, boolean bl) throws SQLException {
        super.setNull(n2, bl);
        if (bl && this.isPrefetched()) {
            this.prefetchedDataOffset[n2] = -1L;
            this.prefetchedDataLength[n2] = -1;
            this.prefetchedLength[n2] = -1L;
            this.prefetchedChunkSize[n2] = -1;
        }
    }

    @Override
    void setCapacity(int n2) {
        super.setCapacity(n2);
        if (this.isPrefetched() && this.prefetchedDataOffset == null) {
            this.prefetchedDataOffset = new long[n2];
            this.prefetchedDataLength = new int[n2];
            this.prefetchedLength = new long[n2];
            this.prefetchedChunkSize = new int[n2];
        } else if (this.isPrefetched() && n2 > this.prefetchedDataOffset.length) {
            Object[] objectArray = new long[n2];
            System.arraycopy(this.prefetchedDataOffset, 0, objectArray, 0, this.prefetchedDataOffset.length);
            this.prefetchedDataOffset = objectArray;
            objectArray = new int[n2];
            System.arraycopy(this.prefetchedDataLength, 0, objectArray, 0, this.prefetchedDataLength.length);
            this.prefetchedDataLength = (int[])objectArray;
            objectArray = new long[n2];
            System.arraycopy(this.prefetchedLength, 0, objectArray, 0, this.prefetchedLength.length);
            this.prefetchedLength = objectArray;
            objectArray = new int[n2];
            System.arraycopy(this.prefetchedChunkSize, 0, objectArray, 0, this.prefetchedChunkSize.length);
            this.prefetchedChunkSize = (int[])objectArray;
        }
    }

    @Override
    void insertNull(int n2) throws SQLException {
        if (this.isPrefetched()) {
            System.arraycopy(this.prefetchedDataOffset, n2, this.prefetchedDataOffset, n2 + 1, this.prefetchedDataOffset.length - n2 - 1);
            System.arraycopy(this.prefetchedDataLength, n2, this.prefetchedDataLength, n2 + 1, this.prefetchedDataLength.length - n2 - 1);
            System.arraycopy(this.prefetchedLength, n2, this.prefetchedLength, n2 + 1, this.prefetchedLength.length - n2 - 1);
            System.arraycopy(this.prefetchedChunkSize, n2, this.prefetchedChunkSize, n2 + 1, this.prefetchedChunkSize.length - n2 - 1);
        }
        super.insertNull(n2);
    }

    @Override
    Accessor copyForDefine(OracleStatement oracleStatement) {
        LobCommonAccessor lobCommonAccessor = (LobCommonAccessor)super.copyForDefine(oracleStatement);
        lobCommonAccessor.prefetchedDataOffset = null;
        lobCommonAccessor.prefetchedDataLength = null;
        lobCommonAccessor.prefetchedLength = null;
        lobCommonAccessor.prefetchedChunkSize = null;
        return lobCommonAccessor;
    }

    @Override
    protected void copyFromInternal(Accessor accessor, int n2, int n3) throws SQLException {
        super.copyFromInternal(accessor, n2, n3);
        if (this.isPrefetched()) {
            long l2;
            LobCommonAccessor lobCommonAccessor = (LobCommonAccessor)accessor;
            assert (lobCommonAccessor.isPrefetched()) : "srcLobAcc is not prefetched";
            int n4 = lobCommonAccessor.getPrefetchedDataLength(n2);
            long l3 = l2 = n4 <= this.getPrefetchedDataLength(n3) ? this.getPrefetchedDataOffset(n3) : this.statement.allocateRowDataSpace(n4);
            if (n4 > 0) {
                this.rowData.put(l2, lobCommonAccessor.rowData, lobCommonAccessor.getPrefetchedDataOffset(n2), n4);
            }
            this.setPrefetchedDataOffset(n3, l2);
            this.setPrefetchedDataLength(n3, n4);
            this.setPrefetchedLength(n3, lobCommonAccessor.getPrefetchedLength(n2));
            this.setPrefetchedChunkSize(n3, lobCommonAccessor.getPrefetchedChunkSize(n2));
        }
    }

    @Override
    void deleteRow(int n2) throws SQLException {
        super.deleteRow(n2);
        if (this.isPrefetched()) {
            this.rowData.freeSpace(this.getPrefetchedDataOffset(n2), this.getPrefetchedDataLength(n2));
            this.delete(this.prefetchedDataOffset, n2);
            this.delete(this.prefetchedDataLength, n2);
            this.delete(this.prefetchedLength, n2);
            this.delete(this.prefetchedChunkSize, n2);
        }
    }

    final boolean isPrefetched() {
        return !this.isDMLReturnedParam && this.lobPrefetchSizeForThisColumn > -1;
    }

    @Override
    void setNoPrefetch() {
        this.lobPrefetchSizeForThisColumn = -1;
        this.prefetchedDataOffset = null;
        this.prefetchedDataLength = null;
        this.prefetchedLength = null;
        this.prefetchedChunkSize = null;
    }

    final int getPrefetchLength() {
        return this.lobPrefetchSizeForThisColumn;
    }

    @Override
    void setPrefetchLength(int n2) {
        if (n2 == -1) {
            this.setNoPrefetch();
        } else {
            this.lobPrefetchSizeForThisColumn = n2;
            if (this.rowNull != null) {
                this.setCapacity(this.rowNull.length);
            }
        }
    }

    final void setPrefetchedDataOffset(int n2) {
        assert (this.prefetchedDataOffset.length > n2) : "prefetchedDataOffset.length: " + this.prefetchedDataOffset.length + " currentRow: " + n2;
        this.prefetchedDataOffset[n2] = this.rowData.getPosition();
    }

    final void setPrefetchedDataOffset(int n2, long l2) {
        assert (this.prefetchedDataOffset.length > n2) : "prefetchedDataOffset.length: " + this.prefetchedDataOffset.length + " currentRow: " + n2;
        this.prefetchedDataOffset[n2] = l2;
    }

    final void setPrefetchedDataLength(int n2, int n3) {
        assert (this.prefetchedDataLength.length > n2) : "prefetchedDataLength.length: " + this.prefetchedDataLength.length + " currentRow: " + n2;
        this.prefetchedDataLength[n2] = n3;
    }

    final void setPrefetchedLength(int n2, long l2) {
        assert (this.prefetchedLength.length > n2) : "prefetchedLength.length: " + this.prefetchedLength.length + " currentRow: " + n2;
        this.prefetchedLength[n2] = l2;
    }

    final void setPrefetchedChunkSize(int n2, int n3) {
        assert (this.prefetchedChunkSize.length > n2) : "prefetchedChunkSize.length: " + this.prefetchedChunkSize.length + " currentRow: " + n2;
        this.prefetchedChunkSize[n2] = n3;
    }

    final long getPrefetchedDataOffset(int n2) {
        return this.prefetchedDataOffset[n2];
    }

    final int getPrefetchedDataLength(int n2) {
        return this.prefetchedDataLength[n2];
    }

    final long getPrefetchedLength(int n2) {
        return this.prefetchedLength[n2];
    }

    final int getPrefetchedChunkSize(int n2) {
        return this.prefetchedChunkSize[n2];
    }

    final byte[] getPrefetchedData(int n2) {
        if (this.getPrefetchLength() > -1) {
            if (this.getPrefetchedDataLength(n2) == 0) {
                return new byte[0];
            }
            return this.rowData.get(this.getPrefetchedDataOffset(n2), this.getPrefetchedDataLength(n2));
        }
        return null;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getOracleObject(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getOracleObject(n2);
    }

    static {
        try {
            $$$methodRef$$$22 = LobCommonAccessor.class.getDeclaredConstructor(Representation.class, OracleStatement.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = LobCommonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = LobCommonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedData", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedChunkSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedDataLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchedDataOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedChunkSize", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedLength", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedDataLength", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedDataOffset", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchedDataOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LobCommonAccessor.class.getDeclaredMethod("setPrefetchLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LobCommonAccessor.class.getDeclaredMethod("getPrefetchLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LobCommonAccessor.class.getDeclaredMethod("setNoPrefetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LobCommonAccessor.class.getDeclaredMethod("isPrefetched", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LobCommonAccessor.class.getDeclaredMethod("deleteRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LobCommonAccessor.class.getDeclaredMethod("copyFromInternal", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LobCommonAccessor.class.getDeclaredMethod("copyForDefine", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LobCommonAccessor.class.getDeclaredMethod("insertNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LobCommonAccessor.class.getDeclaredMethod("setCapacity", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LobCommonAccessor.class.getDeclaredMethod("setNull", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

