/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFJMSConnection;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public class NTFJMSConnectionGroup {
    ArrayList<NTFJMSConnection> jmsListenerConnections = new ArrayList();
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId = new HashMap();
    private int noOfRegistrationsInThisGroup = 0;
    String uniqueIdentifier;
    static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS;
    private int aliveConnections = 0;
    private HashMap<Long, NTFJMSRegistration> jmsRegIdToNtfReg = new HashMap();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public static synchronized void setMaxNtfConnection(int n2) {
        if (n2 <= 0) {
            n2 = 16;
        }
        if (MAX_NTF_CONNECTIONS > 0) {
            return;
        }
        MAX_NTF_CONNECTIONS = n2;
    }

    public static int getMaxNtfConnection() {
        if (MAX_NTF_CONNECTIONS == 0) {
            return 16;
        }
        return MAX_NTF_CONNECTIONS;
    }

    NTFJMSConnectionGroup(String string) {
        this.uniqueIdentifier = string;
    }

    synchronized void checkForActiveRegistrations() {
        if (this.noOfRegistrationsInThisGroup == 0) {
            if (!this.jmsListenerConnections.isEmpty()) {
                for (NTFJMSConnection nTFJMSConnection : this.jmsListenerConnections) {
                    if (nTFJMSConnection == null) continue;
                    nTFJMSConnection.setNeedToBeClosed(true);
                    nTFJMSConnection.interrupt();
                    nTFJMSConnection.closeThisListener();
                    --this.aliveConnections;
                }
                this.jmsListenerConnections.clear();
            }
            PhysicalConnection.ntfManager.removeJMSConnectionGroup(this.uniqueIdentifier);
        }
    }

    synchronized void startJMSListenerConnection(String string, String string2, String string3, String string4, ArrayList<String> arrayList, String string5, int n2) {
        assert (string5 != null) : "jmsConnectionId is null";
        String string6 = "notify" + string5;
        NTFJMSConnection nTFJMSConnection = new NTFJMSConnection(string5, arrayList, string, string2, string3, string4, string6, n2);
        this.jmsListenerConnections.add(nTFJMSConnection);
        nTFJMSConnection.setDaemon(true);
        nTFJMSConnection.start();
        ++this.aliveConnections;
    }

    synchronized void decrementNumberOfRegistrations() {
        --this.noOfRegistrationsInThisGroup;
    }

    synchronized NTFJMSConnection getNTFJMSConnection(int n2) {
        this.noOfRegistrationsInThisGroup += n2;
        if (this.noOfRegistrationsInThisGroup > NTFJMSConnectionGroup.getMaxNtfConnection()) {
            int n3 = this.noOfRegistrationsInThisGroup;
            NTFJMSConnection nTFJMSConnection = this.jmsListenerConnections.get(0);
            for (NTFJMSConnection nTFJMSConnection2 : this.jmsListenerConnections) {
                int n4 = nTFJMSConnection2.getNumberOfRegistrations();
                if (n4 >= n3) continue;
                nTFJMSConnection = nTFJMSConnection2;
                n3 = n4;
            }
            nTFJMSConnection.incrementNumberOfRegistrations(n2);
            return nTFJMSConnection;
        }
        return null;
    }

    synchronized void resetRegistrationNumbers(int n2, NTFJMSConnection nTFJMSConnection) {
        this.noOfRegistrationsInThisGroup -= n2;
        if (nTFJMSConnection != null) {
            nTFJMSConnection.decrementNumberOfRegistrations(n2);
        }
    }

    synchronized void raiseException() {
        --this.aliveConnections;
        if (this.aliveConnections == 0) {
            NTFJMSRegistration nTFJMSRegistration = null;
            Iterator<Long> iterator = this.jmsRegIdToNtfReg.keySet().iterator();
            while (iterator.hasNext()) {
                nTFJMSRegistration = this.jmsRegIdToNtfReg.get(iterator.next());
                try {
                    nTFJMSRegistration.raiseException(1);
                }
                catch (Exception exception) {}
            }
        }
    }

    void addNtfRegistrationByRegId(long l2, NTFJMSRegistration nTFJMSRegistration) {
        this.jmsRegIdToNtfReg.put(l2, nTFJMSRegistration);
    }

    NTFJMSRegistration getNtfRegistrationByRegId(long l2) {
        return this.jmsRegIdToNtfReg.get(l2);
    }

    NTFJMSRegistration removeNtfRegistrationByRegId(long l2) {
        return this.jmsRegIdToNtfReg.remove(l2);
    }

    synchronized void stopNTFJMSConnection(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        for (NTFJMSConnection nTFJMSConnection : this.jmsListenerConnections) {
            if (nTFJMSConnection == null || !string.equals(nTFJMSConnection.getJMSConnectionId())) continue;
            nTFJMSConnection.decrementNumberOfRegistrations(1);
            if (nTFJMSConnection.getNumberOfRegistrations() > 0) break;
            nTFJMSConnection.setNeedToBeClosed(true);
            break;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = NTFJMSConnectionGroup.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFJMSConnectionGroup.class.getDeclaredMethod("stopNTFJMSConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFJMSConnectionGroup.class.getDeclaredMethod("removeNtfRegistrationByRegId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFJMSConnectionGroup.class.getDeclaredMethod("getNtfRegistrationByRegId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFJMSConnectionGroup.class.getDeclaredMethod("addNtfRegistrationByRegId", Long.TYPE, NTFJMSRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFJMSConnectionGroup.class.getDeclaredMethod("raiseException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFJMSConnectionGroup.class.getDeclaredMethod("resetRegistrationNumbers", Integer.TYPE, NTFJMSConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFJMSConnectionGroup.class.getDeclaredMethod("getNTFJMSConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFJMSConnectionGroup.class.getDeclaredMethod("decrementNumberOfRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFJMSConnectionGroup.class.getDeclaredMethod("startJMSListenerConnection", String.class, String.class, String.class, String.class, ArrayList.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFJMSConnectionGroup.class.getDeclaredMethod("checkForActiveRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFJMSConnectionGroup.class.getDeclaredMethod("getMaxNtfConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFJMSConnectionGroup.class.getDeclaredMethod("setMaxNtfConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        MAX_NTF_CONNECTIONS = 0;
    }
}

