/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.resolver.EnvVariableResolver;

public class LDAPSSLSocketFactory
extends SSLSocketFactory {
    static final ThreadLocal<Properties> connectionProperties;
    private static SSLSocketFactory defaultFactory;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public static SocketFactory getDefault() {
        return new LDAPSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return defaultFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return defaultFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n2, boolean bl) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(socket, string, n2, bl), properties);
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(string, n2), properties);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(inetAddress, n2), properties);
    }

    @Override
    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(string, n2, inetAddress, n3), properties);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(inetAddress, n2, inetAddress2, n3), properties);
    }

    private SSLSocketFactory getSSLSocketFactory(Properties properties) throws IOException {
        return CustomSSLSocketFactory.getSSLSocketFactory(properties, null);
    }

    private Properties getSSLProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        Properties properties2 = new Properties();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.walletLocation")) {
                string = properties.getProperty("oracle.net.ldap.ssl.walletLocation");
                properties2.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(string, properties));
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.walletPassword")) {
                string = properties.getProperty("oracle.net.ldap.ssl.walletPassword");
                properties2.put((Object)16, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.supportedVersions")) {
                string = properties.getProperty("oracle.net.ldap.ssl.supportedVersions");
                properties2.put((Object)6, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.supportedCiphers")) {
                string = properties.getProperty("oracle.net.ldap.ssl.supportedCiphers");
                properties2.put((Object)7, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.keyStore")) {
                string = properties.getProperty("oracle.net.ldap.ssl.keyStore");
                properties2.put((Object)8, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.keyStoreType")) {
                string = properties.getProperty("oracle.net.ldap.ssl.keyStoreType");
                properties2.put((Object)9, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.keyStorePassword")) {
                string = properties.getProperty("oracle.net.ldap.ssl.keyStorePassword");
                properties2.put((Object)10, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.trustStore")) {
                string = properties.getProperty("oracle.net.ldap.ssl.trustStore");
                properties2.put((Object)11, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.trustStoreType")) {
                string = properties.getProperty("oracle.net.ldap.ssl.trustStoreType");
                properties2.put((Object)12, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.trustStorePassword")) {
                string = properties.getProperty("oracle.net.ldap.ssl.trustStorePassword");
                properties2.put((Object)13, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.keyManagerFactory.algorithm")) {
                string = properties.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
                properties2.put((Object)14, string);
                continue;
            }
            if (!string2.equalsIgnoreCase("oracle.net.ldap.ssl.trustManagerFactory.algorithm")) continue;
            string = properties.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
            properties2.put((Object)15, string);
        }
        return properties2;
    }

    private Socket initializeSSLSocket(SSLSocket sSLSocket, Properties properties) {
        Object object;
        String string = (String)properties.get(6);
        if (string != null && !string.trim().isEmpty()) {
            object = string.split(",");
            sSLSocket.setEnabledProtocols((String[])object);
        } else {
            sSLSocket.setEnabledProtocols(sSLSocket.getSupportedProtocols());
        }
        object = (String)properties.get(7);
        if (object != null && !((String)object).trim().isEmpty()) {
            String[] stringArray = ((String)object).split(",");
            sSLSocket.setEnabledCipherSuites(stringArray);
        } else {
            sSLSocket.setEnabledCipherSuites(sSLSocket.getSupportedCipherSuites());
        }
        return sSLSocket;
    }

    static {
        try {
            $$$methodRef$$$11 = LDAPSSLSocketFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LDAPSSLSocketFactory.class.getDeclaredMethod("initializeSSLSocket", SSLSocket.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LDAPSSLSocketFactory.class.getDeclaredMethod("getSSLProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LDAPSSLSocketFactory.class.getDeclaredMethod("getSSLSocketFactory", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", InetAddress.class, Integer.TYPE, InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", String.class, Integer.TYPE, InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", Socket.class, String.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LDAPSSLSocketFactory.class.getDeclaredMethod("getSupportedCipherSuites", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LDAPSSLSocketFactory.class.getDeclaredMethod("getDefaultCipherSuites", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LDAPSSLSocketFactory.class.getDeclaredMethod("getDefault", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        connectionProperties = new ThreadLocal();
        defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }
}

