/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.LogicalConnectionImpl;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

@ProxyFor(value={OracleConnection.class})
@ProxyLocale
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableConnection
extends TxnReplayableBase
implements JDBCReplayable,
ReplayableConnection {
    private static final Method CREATEARRAY_METHOD;
    private static final Method CREATEARRAYOF_METHOD;
    private static final Method CREATESTRUCT_METHOD;
    private static final Method CREATECLOB_METHOD;
    private static final Method CREATECLOB_WITH_LOCATOR_METHOD;
    private static final Method CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD;
    private static final Method CREATECLOB_WITH_UNPICKLEDBYTES_METHOD;
    private static final Method CREATENCLOB_METHOD;
    private static final Method CREATEBLOB_METHOD;
    private static final Method CREATEBLOB_WITH_LOCATOR_METHOD;
    private static final Method CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD;
    private static final Method CREATEBFILE_WITH_LOCATOR_METHOD;
    private static final Method GETDESCRIPTOR_WITH_NAME_METHOD;
    OracleConnectionBuilderImpl originalConnectionBuilder;
    private Object logicalProxy = null;
    boolean autoCommitBeforeOutage = true;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;

    protected TxnReplayableConnection() {
        this.thisProxyNameInLog = "CONN" + this.thisProxyNameInLog;
    }

    private static final Method getCreateARRAYMethod() {
        try {
            return OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateArrayOfMethod() {
        try {
            return Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateStructMethod() {
        try {
            return Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateLobMethod(String string) {
        try {
            return OracleConnection.class.getMethod(string, new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateLobWithLocatorMethod(String string, Class<?> clazz) {
        try {
            return OracleConnection.class.getMethod(string, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateClobWithLocatorAndCSFORMMethod() {
        try {
            return OracleConnection.class.getMethod("createClob", byte[].class, Short.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getMethod(String string, Class<?> clazz) {
        try {
            return OracleConnection.class.getMethod(string, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class}), @Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class})})
    protected void preForStatementCreation(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="setAutoCommit", args={Boolean.class})})
    protected void preForSetAutoCommit(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                this.autoCommitBeforeOutage = (Boolean)objectArray[0];
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="abort", args={Executor.class})})
    protected void preForAbort(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="close", args={})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        String string;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = string = stackTraceElementArray != null && stackTraceElementArray.length > 4 ? stackTraceElementArray[4].getClassName() : "";
        this.isClosedAndNoReplay = !string.startsWith("oracle.ucp") || this.isClosedAndNoReplay || !this.abortCalledBeforeLatestClose;
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="openProxySession", args={int.class, Properties.class})})
    protected void preForOpenProxySession(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="isValid", args={int.class}), @Signature(name="isValid", args={OracleConnection.ConnectionValidation.class, int.class}), @Signature(name="pingDatabase", args={}), @Signature(name="pingDatabase", args={int.class}), @Signature(name="isUsable", args={}), @Signature(name="isUsable", args={boolean.class})})
    protected void preForSafeDrainingAPIs(Method method, Object object, Object ... objectArray) {
    }

    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="abort", args={Executor.class})})
    protected void postForAbort(Method method) {
        this.abortCalledBeforeLatestClose = true;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="isValid", args={int.class}), @Signature(name="isValid", args={OracleConnection.ConnectionValidation.class, int.class}), @Signature(name="isUsable", args={}), @Signature(name="isUsable", args={boolean.class})})
    protected boolean postForSafeDrainingAPIs(Method method, boolean bl) {
        block0: {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            if (this.failoverMngr == null || oracleConnection.isUsable(false)) break block0;
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
        return bl;
    }

    @Post
    @Methods(signatures={@Signature(name="pingDatabase", args={}), @Signature(name="pingDatabase", args={int.class})})
    protected int postForPingDatabase(Method method, int n2) {
        return n2;
    }

    @Post
    @Methods(signatures={@Signature(name="commit", args={}), @Signature(name="commit", args={EnumSet.class}), @Signature(name="rollback", args={})})
    protected void postForTxnCompletion(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED) {
            try {
                this.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setClientInfo", args={Properties.class})})
    protected void postForSetClientInfo(Method method) {
        super.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.failoverMngr.setStateSignatureSyncUp();
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        this.failoverMngr.setReplayInitiationTimeout(n2);
    }

    @Override
    public void initialize(OracleDataSource oracleDataSource, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        TxnFailoverManagerImpl txnFailoverManagerImpl = (TxnFailoverManagerImpl)TxnFailoverManagerImpl.getFailoverManager(this, oracleDataSource);
        this.setFailoverManager(txnFailoverManagerImpl);
        this.originalConnectionBuilder = oracleConnectionBuilderImpl;
        txnFailoverManagerImpl.setRequestSizeLimit(oracleDataSource.getRequestSizeLimit());
    }

    @Override
    public void setSessionStateConsistency(boolean bl) throws SQLException {
        this.failoverMngr.setSessionStateConsistency(bl);
    }

    @Override
    public void setSessionStateRestoration(ReplayableConnection.StateRestorationType stateRestorationType) throws SQLException {
        this.failoverMngr.setSessionStateRestoration(stateRestorationType);
    }

    @Override
    public void setAutoAC(boolean bl) throws SQLException {
        this.failoverMngr.setAutoAC(bl);
    }

    @Override
    public Object getProxyObject() throws SQLException {
        return this.logicalProxy;
    }

    @Override
    public void setProxyObject(Object object) throws SQLException {
        this.logicalProxy = object;
    }

    @Override
    public void setProxyObject(Object object, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        this.logicalProxy = object;
        this.originalConnectionBuilder = oracleConnectionBuilderImpl;
    }

    @Override
    public OracleConnectionBuilderImpl getConnectionBuilder() {
        return this.originalConnectionBuilder;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.failoverMngr.beginRequest();
    }

    @Override
    public void beginRequest(boolean bl) throws SQLException {
        this.failoverMngr.beginRequest(bl);
    }

    @Override
    public void endRequest() throws SQLException {
        this.endRequest(false);
    }

    public void endRequest(boolean bl) throws SQLException {
        this.failoverMngr.endRequest();
        OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
        oracleConnection.endRequest(bl);
        this.failoverMngr.checkStateSignatureSyncUp();
        this.abortCalledBeforeLatestClose = false;
    }

    public void checkImplicitRequestBoundary() throws SQLException {
        if (this.failoverMngr.isStateUnrestorable()) {
            return;
        }
        OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
        if (this.failoverMngr.isAutoAC && oracleConnection.hasNoOpenHandles()) {
            this.endRequest(true);
            this.beginRequest(true);
        }
    }

    @Override
    public void disableReplay() throws SQLException {
        this.failoverMngr.disableReplay();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ARRAY createARRAY(String string, Object object) throws SQLException {
        Object object2 = object != null ? (!object.getClass().isArray() || this.isElementTypePrimitive(object) ? object : this.unwrapProxies(object)) : null;
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        Method method = CREATEARRAY_METHOD;
        this.preForAll(method, this, string, object2);
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            ARRAY aRRAY = oracleConnection.createARRAY(string, object2);
            return (ARRAY)this.postForAll(method, aRRAY);
        }
        catch (SQLException sQLException) {
            return (ARRAY)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ARRAY ARRAYConstructorRecording(String string, Object object, ARRAY aRRAY) throws SQLException {
        Object object2 = object != null ? (!object.getClass().isArray() || this.isElementTypePrimitive(object) ? object : this.unwrapProxies(object)) : null;
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        Method method = CREATEARRAY_METHOD;
        this.preForAll(method, this, string, object2);
        return (ARRAY)this.postForAll(method, aRRAY);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.createARRAY(string, object);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2 = (Object[])this.unwrapProxies(objectArray);
        if (CREATEARRAYOF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        Method method = CREATEARRAYOF_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Array array = connection.createArrayOf(string, objectArray2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof TxnReplayableBase ? ((TxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method method = CREATESTRUCT_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Struct struct = connection.createStruct(string, objectArray2);
            return (Struct)this.postForAll(method, struct);
        }
        catch (SQLException sQLException) {
            return (Struct)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public STRUCT STRUCTConstructorRecording(String string, Object[] objectArray, STRUCT sTRUCT) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof TxnReplayableBase ? ((TxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method method = CREATESTRUCT_METHOD;
        this.preForAll(method, this, string, objectArray2);
        return (STRUCT)this.postForAll(method, sTRUCT);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob createClob() throws SQLException {
        if (CREATECLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB instance");
        }
        Method method = CREATECLOB_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            Connection connection = (Connection)this.getDelegate();
            Clob clob = connection.createClob();
            return (Clob)this.postForAll(method, clob);
        }
        catch (SQLException sQLException) {
            return (Clob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClob(byte[] byArray) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes instance");
        }
        Method method = CREATECLOB_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            CLOB cLOB = oracleConnection.createClob(byArray);
            return (CLOB)this.postForAll(method, cLOB);
        }
        catch (SQLException sQLException) {
            return (CLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClob(byte[] byArray, short s2) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes and csform instance");
        }
        Method method = CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD;
        this.preForAll(method, this, byArray, s2);
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            CLOB cLOB = oracleConnection.createClob(byArray, s2);
            return (CLOB)this.postForAll(method, cLOB);
        }
        catch (SQLException sQLException) {
            return (CLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB CLOBConstructorRecording(byte[] byArray, short s2, CLOB cLOB) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes and csform instance");
        }
        Method method = CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD;
        this.preForAll(method, this, byArray, s2);
        return (CLOB)this.postForAll(method, cLOB);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClobWithUnpickledBytes(byte[] byArray) throws SQLException {
        if (CREATECLOB_WITH_UNPICKLEDBYTES_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with unpickled bytes instance");
        }
        Method method = CREATECLOB_WITH_UNPICKLEDBYTES_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            CLOB cLOB = oracleConnection.createClobWithUnpickledBytes(byArray);
            return (CLOB)this.postForAll(method, cLOB);
        }
        catch (SQLException sQLException) {
            return (CLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob createNClob() throws SQLException {
        if (CREATENCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create NCLOB instance");
        }
        Method method = CREATENCLOB_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            Connection connection = (Connection)this.getDelegate();
            NClob nClob = connection.createNClob();
            return (NClob)this.postForAll(method, nClob);
        }
        catch (SQLException sQLException) {
            return (NClob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob createBlob() throws SQLException {
        if (CREATEBLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB instance");
        }
        Method method = CREATEBLOB_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            Connection connection = (Connection)this.getDelegate();
            Blob blob = connection.createBlob();
            return (Blob)this.postForAll(method, blob);
        }
        catch (SQLException sQLException) {
            return (Blob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB createBlob(byte[] byArray) throws SQLException {
        if (CREATEBLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with locater bytes instance");
        }
        Method method = CREATEBLOB_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            BLOB bLOB = oracleConnection.createBlob(byArray);
            return (BLOB)this.postForAll(method, bLOB);
        }
        catch (SQLException sQLException) {
            return (BLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB createBlobWithUnpickledBytes(byte[] byArray) throws SQLException {
        if (CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with unpickled bytes instance");
        }
        Method method = CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            BLOB bLOB = oracleConnection.createBlobWithUnpickledBytes(byArray);
            return (BLOB)this.postForAll(method, (Clob)((Object)bLOB));
        }
        catch (SQLException sQLException) {
            return (BLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB BLOBConstructorRecording(byte[] byArray, BLOB bLOB) throws SQLException {
        if (CREATEBLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with locater bytes instance");
        }
        Method method = CREATEBLOB_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        return (BLOB)this.postForAll(method, bLOB);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE createBfile(byte[] byArray) throws SQLException {
        if (CREATEBFILE_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BFILE with locater bytes instance");
        }
        Method method = CREATEBFILE_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            BFILE bFILE = oracleConnection.createBfile(byArray);
            return (BFILE)this.postForAll(method, bFILE);
        }
        catch (SQLException sQLException) {
            return (BFILE)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE BFILEConstructorRecording(byte[] byArray, BFILE bFILE) throws SQLException {
        if (CREATEBFILE_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BFILE with locater bytes instance");
        }
        Method method = CREATEBFILE_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        return (BFILE)this.postForAll(method, bFILE);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getDescriptor(String string) throws SQLException {
        if (GETDESCRIPTOR_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get getDescriptor method");
        }
        Method method = GETDESCRIPTOR_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ProxyFactory proxyFactory;
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            Object object = oracleConnection.getDescriptor(string);
            if (!(object instanceof StructDescriptor) && !(object instanceof ArrayDescriptor) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    Object unwrapProxies(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            if (n2 > 0) {
                Object[] objectArray2 = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray2[i2] = this.unwrapProxies(objectArray[i2]);
                }
                return objectArray2;
            }
            return object;
        }
        if (object instanceof TxnReplayableBase) {
            return ((TxnReplayableBase)object).getDelegate();
        }
        return object;
    }

    boolean isElementTypePrimitive(Object object) {
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.isPrimitive();
    }

    @Override
    public ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        return this.failoverMngr.getReplayStatistics(statisticsReportType);
    }

    @Override
    public void clearReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        this.failoverMngr.clearReplayStatistics(statisticsReportType);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        LogicalConnectionImpl logicalConnectionImpl = new LogicalConnectionImpl(oraclePooledConnection, (OracleConnection)((Object)this), bl);
        return logicalConnectionImpl;
    }

    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case REPLAYING_CALLBACK: {
                throw (SQLException)DatabaseError.createSqlException(368).fillInStackTrace();
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
                return oracleConnection.isUsable(false) ? this.failoverMngr.getLogicalTransactionId() : this.failoverMngr.getLtxidAtOriginalOutage();
            }
        }
        return this.failoverMngr.getLogicalTransactionId();
    }

    static {
        try {
            $$$methodRef$$$67 = TxnReplayableConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$66 = TxnReplayableConnection.class.getDeclaredMethod("getLogicalTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$65 = TxnReplayableConnection.class.getDeclaredMethod("getLogicalConnection", OraclePooledConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$64 = TxnReplayableConnection.class.getDeclaredMethod("clearReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$63 = TxnReplayableConnection.class.getDeclaredMethod("getReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$62 = TxnReplayableConnection.class.getDeclaredMethod("isElementTypePrimitive", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$61 = TxnReplayableConnection.class.getDeclaredMethod("unwrapProxies", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$60 = TxnReplayableConnection.class.getDeclaredMethod("getDescriptor", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$59 = TxnReplayableConnection.class.getDeclaredMethod("BFILEConstructorRecording", byte[].class, BFILE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$58 = TxnReplayableConnection.class.getDeclaredMethod("createBfile", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$57 = TxnReplayableConnection.class.getDeclaredMethod("BLOBConstructorRecording", byte[].class, BLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$56 = TxnReplayableConnection.class.getDeclaredMethod("createBlobWithUnpickledBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$55 = TxnReplayableConnection.class.getDeclaredMethod("createBlob", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$54 = TxnReplayableConnection.class.getDeclaredMethod("createBlob", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$53 = TxnReplayableConnection.class.getDeclaredMethod("createNClob", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$52 = TxnReplayableConnection.class.getDeclaredMethod("createClobWithUnpickledBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$51 = TxnReplayableConnection.class.getDeclaredMethod("CLOBConstructorRecording", byte[].class, Short.TYPE, CLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$50 = TxnReplayableConnection.class.getDeclaredMethod("createClob", byte[].class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$49 = TxnReplayableConnection.class.getDeclaredMethod("createClob", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$48 = TxnReplayableConnection.class.getDeclaredMethod("createClob", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$47 = TxnReplayableConnection.class.getDeclaredMethod("STRUCTConstructorRecording", String.class, Object[].class, STRUCT.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$46 = TxnReplayableConnection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$45 = TxnReplayableConnection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$44 = TxnReplayableConnection.class.getDeclaredMethod("createOracleArray", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$43 = TxnReplayableConnection.class.getDeclaredMethod("ARRAYConstructorRecording", String.class, Object.class, ARRAY.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$42 = TxnReplayableConnection.class.getDeclaredMethod("createARRAY", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$41 = TxnReplayableConnection.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$40 = TxnReplayableConnection.class.getDeclaredMethod("checkImplicitRequestBoundary", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$39 = TxnReplayableConnection.class.getDeclaredMethod("endRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$38 = TxnReplayableConnection.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$37 = TxnReplayableConnection.class.getDeclaredMethod("beginRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$36 = TxnReplayableConnection.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$35 = TxnReplayableConnection.class.getDeclaredMethod("getConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = TxnReplayableConnection.class.getDeclaredMethod("setProxyObject", Object.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = TxnReplayableConnection.class.getDeclaredMethod("setProxyObject", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = TxnReplayableConnection.class.getDeclaredMethod("getProxyObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = TxnReplayableConnection.class.getDeclaredMethod("setAutoAC", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = TxnReplayableConnection.class.getDeclaredMethod("setSessionStateRestoration", ReplayableConnection.StateRestorationType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = TxnReplayableConnection.class.getDeclaredMethod("setSessionStateConsistency", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = TxnReplayableConnection.class.getDeclaredMethod("initialize", OracleDataSource.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = TxnReplayableConnection.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = TxnReplayableConnection.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = TxnReplayableConnection.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = TxnReplayableConnection.class.getDeclaredMethod("postForSetClientInfo", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = TxnReplayableConnection.class.getDeclaredMethod("postForTxnCompletion", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = TxnReplayableConnection.class.getDeclaredMethod("postForPingDatabase", Method.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = TxnReplayableConnection.class.getDeclaredMethod("postForSafeDrainingAPIs", Method.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = TxnReplayableConnection.class.getDeclaredMethod("postForCancel", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnReplayableConnection.class.getDeclaredMethod("postForClosure", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnReplayableConnection.class.getDeclaredMethod("postForAbort", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableConnection.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableConnection.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableConnection.class.getDeclaredMethod("preForMethodWithConcreteClass", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableConnection.class.getDeclaredMethod("preForSafeDrainingAPIs", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableConnection.class.getDeclaredMethod("preForOpenProxySession", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableConnection.class.getDeclaredMethod("preForCancel", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableConnection.class.getDeclaredMethod("preForClosure", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableConnection.class.getDeclaredMethod("preForAbort", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableConnection.class.getDeclaredMethod("preForSetAutoCommit", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableConnection.class.getDeclaredMethod("preForStatementCreation", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableConnection.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableConnection.class.getDeclaredMethod("getMethod", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableConnection.class.getDeclaredMethod("getCreateClobWithLocatorAndCSFORMMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableConnection.class.getDeclaredMethod("getCreateLobWithLocatorMethod", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableConnection.class.getDeclaredMethod("getCreateLobMethod", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableConnection.class.getDeclaredMethod("getCreateStructMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableConnection.class.getDeclaredMethod("getCreateArrayOfMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableConnection.class.getDeclaredMethod("getCreateARRAYMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        CREATEARRAY_METHOD = TxnReplayableConnection.getCreateARRAYMethod();
        CREATEARRAYOF_METHOD = TxnReplayableConnection.getCreateArrayOfMethod();
        CREATESTRUCT_METHOD = TxnReplayableConnection.getCreateStructMethod();
        CREATECLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createClob");
        CREATECLOB_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createClob", byte[].class);
        CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD = TxnReplayableConnection.getCreateClobWithLocatorAndCSFORMMethod();
        CREATECLOB_WITH_UNPICKLEDBYTES_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createClobWithUnpickledBytes", byte[].class);
        CREATENCLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createNClob");
        CREATEBLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createBlob");
        CREATEBLOB_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBlob", byte[].class);
        CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBlobWithUnpickledBytes", byte[].class);
        CREATEBFILE_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBfile", byte[].class);
        GETDESCRIPTOR_WITH_NAME_METHOD = TxnReplayableConnection.getMethod("getDescriptor", String.class);
    }
}

