/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NIOControlPacket;
import oracle.net.ns.NIODataDescriptorPacket;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.NetworkCompressionCodec;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpsNTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class SessionAtts
implements SQLnetDef {
    protected NSProtocol ns;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    private int sdu;
    private int tdu;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;
    boolean noAnoServices;
    int negotiatedOptions;
    public boolean poolEnabled = false;
    protected byte[] sessionId;
    protected int timeout;
    protected int tick;
    protected byte[] reconnectAddress;
    protected long timestampLastIO;
    protected boolean attemptingReconnect = false;
    protected String connectData;
    public boolean anoActive;
    protected boolean isLargeSDU = false;
    protected int negotiatedSDU = -1;
    protected boolean redirecting = false;
    protected boolean isJavaNetNIO = false;
    SocketChannel socketChannel;
    public NIONSDataChannel dataChannel;
    NIOMarkerPacket markerPacket;
    NIODataDescriptorPacket ddPacket;
    NIOControlPacket controlPacket;
    NTAdapter.NetworkAdapterType networkType;
    public ByteBuffer readBuffer = null;
    public ByteBuffer payloadDataBufferForRead = null;
    ByteBuffer payloadBufferForRead = null;
    ByteBuffer headerBufferForRead = null;
    public ByteBuffer writeBuffer = null;
    public ByteBuffer payloadDataBufferForWrite = null;
    ByteBuffer payloadBufferForWrite = null;
    ByteBuffer headerBufferForWrite = null;
    boolean useNativeBuffers = false;
    boolean needToReleaseMSGQBuffer = false;
    String networkCompression;
    ArrayList<String> networkCompressionLevelsArray;
    int networkCompressionThreshold;
    String negotiatedNetworkCompression;
    boolean networkCompressionEnabled;
    int negotiatedNetworkCompressionScheme;
    NetworkCompressionCodec compressionCodec;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    boolean needsToBeClosed;
    String traceId;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;

    public SessionAtts(NSProtocol nSProtocol, int n2, int n3, boolean bl, boolean bl2) {
        this.sdu = n2;
        this.tdu = n3;
        this.ns = nSProtocol;
        this.anoActive = false;
        this.connected = false;
        if (bl) {
            this.dataChannel = new NIONSDataChannel(this);
            this.markerPacket = new NIOMarkerPacket(this);
            this.ddPacket = new NIODataDescriptorPacket(this);
            this.controlPacket = new NIOControlPacket(this);
            this.useNativeBuffers = bl2;
            this.isJavaNetNIO = true;
        }
    }

    protected void initializeBuffer(int n2) throws IOException {
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            this.initializeBufferForMSGQ();
        } else {
            ((SocketChannelWrapper)this.socketChannel).setBufferSize(this.getSDU());
            if (this.useNativeBuffers) {
                this.setWriteBuffer(ByteBuffer.allocateDirect(n2));
                this.setReadBuffer(ByteBuffer.allocateDirect(n2));
            } else {
                this.setWriteBuffer(ByteBuffer.allocate(n2));
                this.setReadBuffer(ByteBuffer.allocate(n2));
            }
        }
    }

    private void initializeBufferForMSGQ() {
        if (this.writeBuffer != null) {
            MQLNTAdapter.getBufferManager().release(this.writeBuffer);
        }
        this.setWriteBuffer(MQLNTAdapter.getBufferManager().acquire(this.sdu));
        ((MQLNTAdapter)this.nt).setNegotiatedSDUAndTDU(this.sdu, this.tdu);
    }

    void resetWriteBuffersForMSGQ() {
        this.writeBuffer = null;
    }

    void setWriteBuffer(ByteBuffer byteBuffer) {
        this.writeBuffer = byteBuffer;
        this.sliceWriteBuffers();
    }

    void setReadBuffer(ByteBuffer byteBuffer) {
        this.readBuffer = byteBuffer;
        this.sliceReadBuffers();
    }

    void releaseWriteBuffer() {
        if (this.writeBuffer == null) {
            return;
        }
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            MQLNTAdapter.getBufferManager().release(this.writeBuffer);
        }
        this.writeBuffer = null;
    }

    void sliceWriteBuffers() {
        this.writeBuffer.clear();
        this.writeBuffer.limit(8);
        this.headerBufferForWrite = this.writeBuffer.slice();
        this.writeBuffer.position(8);
        this.writeBuffer.limit(this.sdu);
        this.payloadBufferForWrite = this.writeBuffer.slice();
        this.writeBuffer.position(10);
        this.payloadDataBufferForWrite = this.writeBuffer.slice();
        this.payloadDataBufferForWrite.limit(this.payloadDataBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
        this.payloadDataBufferForWrite.order(this.byteOrder);
        this.writeBuffer.rewind();
    }

    void sliceReadBuffers() {
        this.readBuffer.position(0);
        this.headerBufferForRead = this.readBuffer.slice();
        if (this.readBuffer.limit() >= 8) {
            this.readBuffer.position(8);
            this.payloadBufferForRead = this.readBuffer.slice();
        }
        if (this.readBuffer.limit() >= 10) {
            this.readBuffer.position(10);
            this.payloadDataBufferForRead = this.readBuffer.slice();
            this.payloadDataBufferForRead.order(this.byteOrder);
            this.payloadBufferForRead.rewind();
        }
        this.readBuffer.rewind();
    }

    public void prepareWriteBuffer() {
        if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            if (this.writeBuffer != null) {
                this.sliceWriteBuffers();
            } else {
                this.setWriteBuffer(MQLNTAdapter.getBufferManager().acquire(this.sdu));
            }
        } else {
            this.payloadDataBufferForWrite.clear();
            this.payloadBufferForWrite.clear();
            this.payloadDataBufferForWrite.limit(this.payloadDataBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
            this.payloadBufferForWrite.limit(this.payloadBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
        }
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setSDU(int n2) {
        this.sdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (n2 <= 0 ? 65518 : (n2 > 65518 ? 65518 : (n2 < 512 ? 512 : n2))) : (n2 <= 0 ? 8192 : (n2 > 0x200000 ? 0x200000 : (n2 < 512 ? 512 : n2)));
    }

    public int getSDU() {
        return this.sdu;
    }

    public void setTDU(int n2) {
        this.tdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (n2 <= 0 ? 65518 : (n2 > 65518 ? 65518 : (n2 < 255 ? 255 : n2))) : (n2 <= 0 ? 0x200000 : (n2 > 0x200000 ? 0x200000 : (n2 < 255 ? 255 : n2)));
    }

    public int getTDU() {
        return this.tdu;
    }

    void setNegotiatedSDUAndTDU(int n2, int n3) throws IOException {
        this.setTDU(n3);
        if (n3 < n2) {
            this.setSDU(n3);
        } else {
            this.setSDU(n2);
        }
        this.negotiatedSDU = this.sdu;
        this.initializeBuffer(this.getSDU());
    }

    public NTAdapter getNTAdapter() {
        return this.nt;
    }

    void renegotiateSSLSession() throws IOException {
        ((TcpsNTAdapter)this.nt).renegotiateSession();
        if (this.isJavaNetNIO) {
            this.socketChannel = this.nt.getSocketChannel();
        } else {
            this.ntInputStream = this.nt.getInputStream();
            this.ntOutputStream = this.nt.getOutputStream();
        }
    }

    @DisableTrace
    public String toString() {
        return "Session Attributes: \nsdu=" + this.sdu + ", tdu=" + this.tdu + "\nnt: " + this.nt + "\n\nntInputStream : " + this.ntInputStream + "\nntOutputStream: " + this.ntOutputStream + "\nnsInputStream : " + this.nsInputStream + "\nnsOutputStream: " + this.nsOutputStream + "\n\nClient Profile: " + this.profile + "\n\nConnection Options: " + this.cOption + "\n\nonBreakReset=" + this.onBreakReset + ", dataEOF=" + this.dataEOF + ", negotiatedOptions=0x" + Integer.toHexString(this.negotiatedOptions) + ", connected=" + this.connected;
    }

    public void turnEncryptionOn(NetInputStream netInputStream, NetOutputStream netOutputStream) throws NetException {
        if (netInputStream == null || netOutputStream == null) {
            throw new NetException(300);
        }
        this.nsInputStream = netInputStream;
        this.nsOutputStream = netOutputStream;
        this.anoActive = true;
    }

    public void turnEncryptionOn(NIONSDataChannel nIONSDataChannel) throws NetException {
        if (nIONSDataChannel == null) {
            throw new NetException(300);
        }
        this.dataChannel = nIONSDataChannel;
        this.anoActive = true;
    }

    public int getANOFlags() {
        int n2 = 1;
        if (this.ano != null) {
            n2 = this.ano.getNAFlags();
        }
        return n2;
    }

    public OutputStream getOutputStream() {
        return this.nsOutputStream;
    }

    public InputStream getInputStream() {
        return this.nsInputStream;
    }

    public void setNegotiatedOptions(int n2) {
        this.negotiatedOptions = n2;
    }

    public int getNegotiatedOptions() {
        return this.negotiatedOptions;
    }

    public ConnOption getcOption() {
        return this.cOption;
    }

    void setConnectData(String string) {
        this.connectData = string;
    }

    String getConnectData() {
        return this.connectData;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$28 = SessionAtts.class.getDeclaredConstructor(NSProtocol.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$27 = SessionAtts.class.getDeclaredMethod("getConnectData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$26 = SessionAtts.class.getDeclaredMethod("setConnectData", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$25 = SessionAtts.class.getDeclaredMethod("getcOption", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$24 = SessionAtts.class.getDeclaredMethod("getNegotiatedOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$23 = SessionAtts.class.getDeclaredMethod("setNegotiatedOptions", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$22 = SessionAtts.class.getDeclaredMethod("getInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$21 = SessionAtts.class.getDeclaredMethod("getOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$20 = SessionAtts.class.getDeclaredMethod("getANOFlags", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$19 = SessionAtts.class.getDeclaredMethod("turnEncryptionOn", NIONSDataChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$18 = SessionAtts.class.getDeclaredMethod("turnEncryptionOn", NetInputStream.class, NetOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$17 = SessionAtts.class.getDeclaredMethod("renegotiateSSLSession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$16 = SessionAtts.class.getDeclaredMethod("getNTAdapter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = SessionAtts.class.getDeclaredMethod("setNegotiatedSDUAndTDU", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = SessionAtts.class.getDeclaredMethod("getTDU", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = SessionAtts.class.getDeclaredMethod("setTDU", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = SessionAtts.class.getDeclaredMethod("getSDU", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = SessionAtts.class.getDeclaredMethod("setSDU", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = SessionAtts.class.getDeclaredMethod("setByteOrder", ByteOrder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = SessionAtts.class.getDeclaredMethod("getByteOrder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = SessionAtts.class.getDeclaredMethod("prepareWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = SessionAtts.class.getDeclaredMethod("sliceReadBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = SessionAtts.class.getDeclaredMethod("sliceWriteBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = SessionAtts.class.getDeclaredMethod("releaseWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = SessionAtts.class.getDeclaredMethod("setReadBuffer", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = SessionAtts.class.getDeclaredMethod("setWriteBuffer", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = SessionAtts.class.getDeclaredMethod("resetWriteBuffersForMSGQ", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = SessionAtts.class.getDeclaredMethod("initializeBufferForMSGQ", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = SessionAtts.class.getDeclaredMethod("initializeBuffer", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

