/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling.kdtree;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.pooling.kdtree.Range;

public class Point {
    private final Comparable[] coords;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public Point(Comparable ... comparableArray) {
        this.coords = comparableArray;
    }

    public Point(Point point) {
        this.coords = new Comparable[point.coords.length];
        System.arraycopy(point.coords, 0, this.coords, 0, point.coords.length);
    }

    public boolean sameSpace(Point point) {
        int n2 = this.size();
        if (n2 != point.size()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.coords[i2].getClass().equals(point.coords[i2].getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean sameSpace(Range[] rangeArray) {
        int n2 = this.size();
        if (n2 != rangeArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (rangeArray[i2].infinite() || this.coords[i2].getClass().equals(rangeArray[i2].low().getClass())) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.coords.length;
    }

    public Comparable get(int n2) {
        return this.coords[n2];
    }

    public boolean within(Range[] rangeArray) {
        if (!this.sameSpace(rangeArray)) {
            throw new IllegalArgumentException("incompatible vectors");
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (rangeArray[i2].infinite() || this.coords[i2].compareTo(rangeArray[i2].low()) >= 0 && this.coords[i2].compareTo(rangeArray[i2].high()) <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Point point) {
        if (this.coords.length != point.coords.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.coords.length; ++i2) {
            if (null == this.coords[i2]) {
                if (null == point.coords[i2]) continue;
                return false;
            }
            if (this.coords[i2].equals(point.coords[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i2 = 0; i2 < this.coords.length; ++i2) {
            stringBuilder.append(this.coords[i2]).append(i2 + 1 < this.coords.length ? ", " : "");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        try {
            $$$methodRef$$$8 = Point.class.getDeclaredConstructor(Point.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Point.class.getDeclaredConstructor(Comparable[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Point.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Point.class.getDeclaredMethod("equals", Point.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Point.class.getDeclaredMethod("within", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Point.class.getDeclaredMethod("get", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Point.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Point.class.getDeclaredMethod("sameSpace", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Point.class.getDeclaredMethod("sameSpace", Point.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

