/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4C8TTIClob
extends T4C8TTILob {
    int[] nBytes = new int[1];
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    T4C8TTIClob(T4CConnection t4CConnection) {
        super(t4CConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long read(byte[] byArray, long l2, long l3, boolean bl, char[] cArray, int n2) throws SQLException, IOException {
        long l4;
        byte[] byArray2 = null;
        try {
            this.initializeLobdef();
            boolean bl2 = this.isLobCharsetVariableWidth(byArray);
            int n3 = this.getByteBufferSizeForConversion(bl2, l3);
            byArray2 = this.connection.getByteBuffer(n3);
            this.littleEndianClob = this.isLobCharsetLE(byArray);
            this.lobops = 2L;
            this.sourceLobLocator = byArray;
            this.sourceOffset = l2;
            this.lobamt = l3;
            this.sendLobamt = true;
            this.outBuffer = byArray2;
            this.doRPC();
            long l5 = this.lobamt;
            this.decodeNetworkCharSet(cArray, n2, bl2, bl);
            l4 = l5;
            this.outBuffer = null;
        }
        catch (Throwable throwable) {
            this.outBuffer = null;
            this.connection.cacheBuffer(byArray2);
            throw throwable;
        }
        this.connection.cacheBuffer(byArray2);
        return l4;
    }

    final CompletionStage<Long> readAsync(byte[] byArray, long l3, long l4, boolean bl, char[] cArray, int n2) {
        this.initializeLobdef();
        this.littleEndianClob = this.isLobCharsetLE(byArray);
        this.lobops = 2L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l3;
        this.lobamt = l4;
        this.sendLobamt = true;
        boolean bl2 = this.isLobCharsetVariableWidth(byArray);
        int n3 = this.getByteBufferSizeForConversion(bl2, l4);
        byte[] byArray2 = this.connection.getByteBuffer(n3);
        this.outBuffer = byArray2;
        return this.doRPCAsync().thenApply(CompletionStageUtil.normalCompletionHandler(void_ -> {
            long l2 = this.lobamt;
            this.decodeNetworkCharSet(cArray, n2, bl2, bl);
            return l2;
        })).whenComplete((l2, throwable) -> {
            this.outBuffer = null;
            this.connection.cacheBuffer(byArray2);
        });
    }

    final boolean isLobCharsetVariableWidth(byte[] byArray) {
        return (byArray[6] & 0xFFFFFF80) == -128;
    }

    final int getByteBufferSizeForConversion(boolean bl, long l2) {
        if (bl) {
            return (int)l2 * 2;
        }
        return (int)l2 * 3;
    }

    private final boolean isLobCharsetLE(byte[] byArray) {
        return 64 == (byArray[7] & 0x40);
    }

    private final void decodeNetworkCharSet(char[] cArray, int n2, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            this.decodeVariableWidthCharSet(cArray, n2);
        } else {
            this.decodeFixedWidthCharSet(cArray, n2, bl2);
        }
    }

    private final void decodeVariableWidthCharSet(char[] cArray, int n2) throws SQLException {
        if (this.connection.versionNumber < 10101) {
            DBConversion.ucs2BytesToJavaChars(this.outBuffer, (int)this.lobBytesRead, cArray);
        } else if (this.littleEndianClob) {
            CharacterSet.convertAL16UTF16LEBytesToJavaChars(this.outBuffer, 0, cArray, n2, (int)this.lobBytesRead, true);
        } else {
            CharacterSet.convertAL16UTF16BytesToJavaChars(this.outBuffer, 0, cArray, n2, (int)this.lobBytesRead, true);
        }
    }

    private final void decodeFixedWidthCharSet(char[] cArray, int n2, boolean bl) throws SQLException {
        if (!bl) {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.CHARBytesToJavaChars(this.outBuffer, 0, cArray, n2, this.nBytes, cArray.length);
        } else {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.NCHARBytesToJavaChars(this.outBuffer, 0, cArray, n2, this.nBytes, cArray.length);
        }
    }

    long write(byte[] byArray, long l2, boolean bl, char[] cArray, long l3, long l4) throws SQLException, IOException {
        this.validateLobOperation(byArray, 64, "write()");
        boolean bl2 = this.isLobCharsetVariableWidth(byArray);
        this.littleEndianClob = this.isLobCharsetLE(byArray);
        int n2 = this.getByteBufferSizeForConversion(bl2, l4);
        byte[] byArray2 = new byte[n2];
        int n3 = this.encodeNetworkCharSet(cArray, (int)l3, (int)l4, byArray2, bl2, bl);
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l2;
        this.lobamt = l4;
        this.sendLobamt = true;
        this.inBuffer = byArray2;
        this.inBufferOffset = 0L;
        this.inBufferNumBytes = n3;
        this.doRPC();
        return this.lobamt;
    }

    final CompletionStage<Long> writeAsync(byte[] byArray, long l2, boolean bl, char[] cArray, long l3, long l4) {
        int n2;
        try {
            this.validateLobOperation(byArray, 64, "writeAsync()");
        }
        catch (SQLException sQLException) {
            return CompletableFuture.failedStage(sQLException);
        }
        boolean bl2 = this.isLobCharsetVariableWidth(byArray);
        this.littleEndianClob = this.isLobCharsetLE(byArray);
        int n3 = this.getByteBufferSizeForConversion(bl2, l4);
        byte[] byArray2 = new byte[n3];
        try {
            n2 = this.encodeNetworkCharSet(cArray, (int)l3, (int)l4, byArray2, bl2, bl);
        }
        catch (SQLException sQLException) {
            return CompletableFuture.failedStage(sQLException);
        }
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l2;
        this.lobamt = l4;
        this.sendLobamt = true;
        this.inBuffer = byArray2;
        this.inBufferOffset = 0L;
        this.inBufferNumBytes = n2;
        return this.doRPCAsync().thenApply(void_ -> this.lobamt);
    }

    final int encodeNetworkCharSet(char[] cArray, int n2, int n3, byte[] byArray, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            return this.encodeVariableWidthCharSet(cArray, n2, n3, byArray);
        }
        return this.encodeFixedWidthCharSet(cArray, n2, n3, byArray, bl2);
    }

    private final int encodeVariableWidthCharSet(char[] cArray, int n2, int n3, byte[] byArray) throws SQLException {
        if (this.connection.versionNumber < 10101) {
            DBConversion.javaCharsToUcs2Bytes(cArray, n2, byArray, 0, n3);
            return n3;
        }
        if (this.littleEndianClob) {
            CharacterSet.convertJavaCharsToAL16UTF16LEBytes(cArray, n2, byArray, 0, n3);
            return n3 * 2;
        }
        CharacterSet.convertJavaCharsToAL16UTF16Bytes(cArray, n2, byArray, 0, n3);
        return n3 * 2;
    }

    private final int encodeFixedWidthCharSet(char[] cArray, int n2, int n3, byte[] byArray, boolean bl) throws SQLException {
        if (!bl) {
            return this.meg.conv.javaCharsToCHARBytes(cArray, n2, byArray, 0, n3);
        }
        return this.meg.conv.javaCharsToNCHARBytes(cArray, n2, byArray, 0, n3);
    }

    @Override
    Datum createTemporaryLob(Connection connection, boolean bl, int n2) throws SQLException, IOException {
        return this.createTemporaryLob(connection, bl, n2, (short)1);
    }

    Datum createTemporaryLob(Connection connection, boolean bl, int n2, short s2) throws SQLException, IOException {
        if (n2 == 12) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 158).fillInStackTrace();
        }
        CLOB cLOB = null;
        this.initializeLobdef();
        this.lobops = 272L;
        int n3 = this.getTemporaryLobSize();
        this.sourceLobLocator = new byte[n3];
        this.sourceLobLocator[1] = (byte)(n3 - 2);
        this.sourceOffset = s2 == 1 ? 1L : 2L;
        this.destinationOffset = 112L;
        this.destinationLength = n2;
        this.lobamt = n2;
        this.sendLobamt = true;
        this.nullO2U = true;
        short s3 = this.characterSet = s2 == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId();
        if (this.connection.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = bl ? 1 : 0;
            this.lobscnl = 1;
        }
        this.doRPC();
        if (this.sourceLobLocator != null) {
            cLOB = s2 == 1 ? new CLOB((OracleConnection)connection, this.sourceLobLocator) : new NCLOB((OracleConnection)connection, this.sourceLobLocator);
        }
        return cLOB;
    }

    @Override
    boolean open(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = false;
        int n3 = 2;
        if (n2 == 0) {
            n3 = 1;
        }
        bl = this._open(byArray, n3, 32768);
        return bl;
    }

    @Override
    boolean close(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._close(byArray, 65536);
        return bl;
    }

    CompletionStage<Void> closeAsync(byte[] byArray) {
        return this._closeAsync(byArray, 65536);
    }

    @Override
    boolean isOpen(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._isOpen(byArray, 69632);
        return bl;
    }

    static {
        try {
            $$$methodRef$$$22 = T4C8TTIClob.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4C8TTIClob.class.getDeclaredMethod("lambda$readAsync$0", char[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4C8TTIClob.class.getDeclaredMethod("lambda$readAsync$1", byte[].class, Long.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4C8TTIClob.class.getDeclaredMethod("lambda$writeAsync$2", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4C8TTIClob.class.getDeclaredMethod("isOpen", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4C8TTIClob.class.getDeclaredMethod("closeAsync", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4C8TTIClob.class.getDeclaredMethod("close", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4C8TTIClob.class.getDeclaredMethod("open", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4C8TTIClob.class.getDeclaredMethod("createTemporaryLob", Connection.class, Boolean.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4C8TTIClob.class.getDeclaredMethod("createTemporaryLob", Connection.class, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4C8TTIClob.class.getDeclaredMethod("encodeFixedWidthCharSet", char[].class, Integer.TYPE, Integer.TYPE, byte[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4C8TTIClob.class.getDeclaredMethod("encodeVariableWidthCharSet", char[].class, Integer.TYPE, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4C8TTIClob.class.getDeclaredMethod("encodeNetworkCharSet", char[].class, Integer.TYPE, Integer.TYPE, byte[].class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4C8TTIClob.class.getDeclaredMethod("writeAsync", byte[].class, Long.TYPE, Boolean.TYPE, char[].class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4C8TTIClob.class.getDeclaredMethod("write", byte[].class, Long.TYPE, Boolean.TYPE, char[].class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4C8TTIClob.class.getDeclaredMethod("decodeFixedWidthCharSet", char[].class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4C8TTIClob.class.getDeclaredMethod("decodeVariableWidthCharSet", char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4C8TTIClob.class.getDeclaredMethod("decodeNetworkCharSet", char[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4C8TTIClob.class.getDeclaredMethod("isLobCharsetLE", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4C8TTIClob.class.getDeclaredMethod("getByteBufferSizeForConversion", Boolean.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4C8TTIClob.class.getDeclaredMethod("isLobCharsetVariableWidth", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4C8TTIClob.class.getDeclaredMethod("readAsync", byte[].class, Long.TYPE, Long.TYPE, Boolean.TYPE, char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4C8TTIClob.class.getDeclaredMethod("read", byte[].class, Long.TYPE, Long.TYPE, Boolean.TYPE, char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

