/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
class NTFListener
extends Thread {
    private ArrayList<NTFConnection> connections;
    private final Monitor connectionsMonitor = Monitor.newInstance();
    private int nbOfConnections = 0;
    private boolean needsToBeClosed = false;
    NTFManager dcnManager;
    ServerSocketChannel ssChannel;
    int tcpport;
    public Properties socketOptions;
    private Exception[] connectionCreationExceptionArr;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    NTFListener(NTFManager nTFManager, ServerSocketChannel serverSocketChannel, int n2, @Blind(value=PropertiesBlinder.class) Properties properties, Exception[] exceptionArray) {
        this.dcnManager = nTFManager;
        this.connections = new ArrayList(10);
        this.ssChannel = serverSocketChannel;
        this.tcpport = n2;
        this.socketOptions = properties;
        this.connectionCreationExceptionArr = exceptionArray;
    }

    @Override
    public void run() {
        try {
            Selector selector = Selector.open();
            this.ssChannel.register(selector, 16);
            block9: while (true) {
                selector.select();
                if (this.needsToBeClosed) break;
                Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (true) {
                    block14: {
                        if (!iterator.hasNext()) continue block9;
                        SelectionKey selectionKey = iterator.next();
                        if ((selectionKey.readyOps() & 0x10) != 16) continue;
                        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                        SocketChannel socketChannel = serverSocketChannel.accept();
                        try {
                            NTFConnection nTFConnection = new NTFConnection(this.dcnManager, socketChannel, this);
                            try (Monitor.CloseableLock closeableLock = this.connectionsMonitor.acquireCloseableLock();){
                                this.connections.add(nTFConnection);
                            }
                            nTFConnection.start();
                            if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
                                this.connectionCreationExceptionArr[0] = null;
                            }
                        }
                        catch (IOException iOException) {
                            if (this.connectionCreationExceptionArr == null || this.connectionCreationExceptionArr.length <= 0) break block14;
                            this.connectionCreationExceptionArr[0] = iOException;
                        }
                    }
                    iterator.remove();
                }
                break;
            }
            selector.close();
            this.ssChannel.close();
        }
        catch (IOException iOException) {
        }
    }

    void closeThisListener() {
        try (Monitor.CloseableLock closeableLock = this.connectionsMonitor.acquireCloseableLock();){
            for (NTFConnection nTFConnection : this.connections) {
                nTFConnection.closeThisConnection();
                nTFConnection.interrupt();
            }
            this.needsToBeClosed = true;
        }
    }

    void releaseConnection(NTFConnection nTFConnection) {
        try (Monitor.CloseableLock closeableLock = this.connectionsMonitor.acquireCloseableLock();){
            this.connections.remove(nTFConnection);
        }
    }

    Exception getRegistrationException() {
        if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
            return this.connectionCreationExceptionArr[0];
        }
        return null;
    }

    static {
        try {
            $$$methodRef$$$4 = NTFListener.class.getDeclaredConstructor(NTFManager.class, ServerSocketChannel.class, Integer.TYPE, Properties.class, Exception[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFListener.class.getDeclaredMethod("getRegistrationException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFListener.class.getDeclaredMethod("releaseConnection", NTFConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFListener.class.getDeclaredMethod("closeThisListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFListener.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

