/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EnvVariableResolver;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    private String osuser;
    private String programName;
    public int retryCount = 0;
    private int lastRetryCounter = 0;
    private int lastRetryConnectDescription = 0;
    private final Properties userProp;
    private ConnectDescription currentDescription;
    private ArrayList<ConnectDescription> descriptionList = new ArrayList(4);
    private final SecuredLogger securedLogger;
    private final SSLContext sslContext;
    private int outboundConnectTimeout = 0;
    private String connectionIdPrefix;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;

    public ConnStrategy(@Blind(value=PropertiesBlinder.class) Properties properties) {
        this(properties, null, SecuredLogger.noOpLogger());
    }

    public ConnStrategy(@Blind(value=PropertiesBlinder.class) Properties properties, SSLContext sSLContext, SecuredLogger securedLogger) {
        this.osuser = properties.getProperty("oracle.jdbc.v$session.osuser");
        this.programName = properties.getProperty("oracle.jdbc.v$session.program");
        DownHostsCache.DOWN_HOSTS_TIMEOUT = Integer.parseInt(properties.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT", "600"));
        this.userProp = properties;
        this.createSocketOptions(properties);
        this.sslContext = sSLContext;
        this.securedLogger = securedLogger;
        if (securedLogger != null) {
            this.socketOptions.put((Object)32, securedLogger.getId());
        }
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties properties) {
        ConnStrategy.createSocketOptions(properties, this.socketOptions, !this.reuseOpt);
    }

    static void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2) {
        ConnStrategy.createSocketOptions(properties, properties2, true);
    }

    static void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2, boolean bl) {
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase("TCP.NODELAY")) {
                bl2 = true;
                string2 = properties.getProperty("TCP.NODELAY").toUpperCase();
                if (string2.equals("NO")) {
                    properties2.put((Object)0, "NO");
                    continue;
                }
                properties2.put((Object)0, "YES");
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.READ_TIMEOUT");
                properties2.put((Object)3, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.CONNECT_TIMEOUT");
                properties2.put((Object)2, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(string2, false, 0)));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                string2 = properties.getProperty("oracle.net.ssl_server_dn_match");
                properties2.put((Object)4, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_cert_dn")) {
                string2 = properties.getProperty("oracle.net.ssl_server_cert_dn");
                properties2.put((Object)28, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_location")) {
                string2 = properties.getProperty("oracle.net.wallet_location");
                properties2.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(string2, properties));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_password")) {
                object = properties.get("oracle.net.wallet_password");
                properties2.put((Object)16, object instanceof String ? OpaqueString.newOpaqueString((String)object) : (OpaqueString)object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_version")) {
                string2 = properties.getProperty("oracle.net.ssl_version");
                properties2.put((Object)6, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                string2 = properties.getProperty("oracle.net.ssl_cipher_suites");
                properties2.put((Object)7, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                string2 = properties.getProperty("javax.net.ssl.keyStore");
                properties2.put((Object)8, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.keyStoreType");
                properties2.put((Object)9, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                object = properties.get("javax.net.ssl.keyStorePassword");
                properties2.put((Object)10, object instanceof String ? OpaqueString.newOpaqueString((String)object) : (OpaqueString)object);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                string2 = properties.getProperty("javax.net.ssl.trustStore");
                properties2.put((Object)11, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.trustStoreType");
                properties2.put((Object)12, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                object = properties.get("javax.net.ssl.trustStorePassword");
                properties2.put((Object)13, object instanceof String ? OpaqueString.newOpaqueString((String)object) : (OpaqueString)object);
                continue;
            }
            if (string.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) {
                string2 = properties.getProperty("ssl.keyManagerFactory.algorithm");
                properties2.put((Object)14, string2);
                continue;
            }
            if (string.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING")) {
                string2 = properties.getProperty("FORCE_DNS_LOAD_BALANCING");
                properties2.put((Object)18, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.keepAlive")) {
                string2 = properties.getProperty("oracle.net.keepAlive");
                if (Boolean.parseBoolean(string2)) {
                    properties2.put((Object)1, "YES");
                    continue;
                }
                properties2.put((Object)1, "NO");
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.useNio")) {
                string2 = properties.getProperty("oracle.jdbc.useNio");
                properties2.put((Object)20, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetLocalIPForMsgq")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
                properties2.put((Object)21, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqTransport")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqTransport");
                properties2.put((Object)22, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqBusyWait")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
                properties2.put((Object)23, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqKernelWait")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
                properties2.put((Object)24, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.OUTBOUND_CONNECT_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
                properties2.put((Object)25, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(string2, true, 0)));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.websocketUser")) {
                string2 = properties.getProperty("oracle.net.websocketUser");
                properties2.put((Object)26, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.websocketPassword")) {
                object = properties.get("oracle.net.websocketPassword");
                properties2.put((Object)27, object instanceof String ? OpaqueString.newOpaqueString((String)object) : (OpaqueString)object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_certificate_alias")) {
                string2 = properties.getProperty("oracle.net.ssl_certificate_alias");
                properties2.put((Object)29, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.httpsProxyHost")) {
                string2 = properties.getProperty("oracle.net.httpsProxyHost");
                properties2.put((Object)30, string2);
                properties2.put((Object)31, properties.getProperty("oracle.net.httpsProxyPort"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.socksProxyHost")) {
                string2 = properties.getProperty("oracle.net.socksProxyHost");
                properties2.put((Object)36, string2);
                properties2.put((Object)37, properties.getProperty("oracle.net.socksProxyPort"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.socksRemoteDNS")) {
                string2 = properties.getProperty("oracle.net.socksRemoteDNS");
                properties2.put((Object)39, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.TCP_KEEPIDLE")) {
                properties2.put((Object)33, properties.getProperty("oracle.net.TCP_KEEPIDLE"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.TCP_KEEPINTERVAL")) {
                properties2.put((Object)34, properties.getProperty("oracle.net.TCP_KEEPINTERVAL"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.TCP_KEEPCOUNT")) {
                properties2.put((Object)35, properties.getProperty("oracle.net.TCP_KEEPCOUNT"));
                continue;
            }
            if (!string.equalsIgnoreCase("oracle.net.ssl_context_protocol")) continue;
            properties2.put((Object)38, properties.getProperty("oracle.net.ssl_context_protocol"));
        }
        if (!bl2 && bl) {
            properties2.put((Object)0, "YES");
        }
    }

    public void addSocketOptions(boolean bl) {
        if (bl) {
            this.socketOptions.put((Object)1, "YES");
        } else if (!this.reuseOpt && !this.socketOptions.containsKey(1)) {
            this.socketOptions.put((Object)1, "NO");
        }
    }

    public void addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF() {
        this.socketOptions.put((Object)18, "true");
    }

    public boolean hasMoreOptions() {
        int n2 = 0;
        for (ConnectDescription connectDescription : this.descriptionList) {
            n2 += connectDescription.getConnectOptions().size();
        }
        return this.nextOptToTry < n2;
    }

    public ConnOption execute(boolean bl, DMSFactory.DMSNoun dMSNoun) throws NetException, InterruptedIOException {
        IOException iOException = null;
        for (int i2 = this.lastRetryConnectDescription; i2 < this.descriptionList.size(); ++i2) {
            ConnectDescription connectDescription = this.descriptionList.get(i2);
            ArrayList<ConnOption> arrayList = connectDescription.getConnectOptions();
            DownHostsCache.getInstance().reorderAddresses(arrayList);
            this.prepareForExecuteDescription(connectDescription);
            this.outboundConnectTimeout = this.getOutboundConnectTimeout(connectDescription);
            int n2 = connectDescription.getDelayInMillis();
            for (int i3 = this.lastRetryCounter; i3 <= this.retryCount; ++i3) {
                while (this.nextOptToTry < arrayList.size()) {
                    try {
                        this.copt = arrayList.get(this.nextOptToTry);
                        this.prepareForExecuteConnOption(this.copt);
                        this.executeConnOption(this.copt, dMSNoun, connectDescription.getTransportConnectTimeout(), bl, this.outboundConnectTimeout);
                        this.handleExecuteConnOptionCompletion(this.copt);
                        this.lastRetryCounter = i3;
                        this.lastRetryConnectDescription = i2;
                        return this.copt;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.handleExecuteConnOptionFailure(this.copt, interruptedIOException);
                        throw interruptedIOException;
                    }
                    catch (IOException iOException2) {
                        this.handleExecuteConnOptionFailure(this.copt, iOException2);
                        iOException = iOException2;
                    }
                }
                this.nextOptToTry = 0;
                if (n2 <= 0 || i3 >= this.retryCount) continue;
                try {
                    Thread.sleep(n2);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lastRetryCounter = 0;
        }
        if (iOException == null) {
            throw new NetException(20);
        }
        throw (NetException)new NetException(20).initCause(iOException);
    }

    public String getConnectionIdPrefix() {
        return this.connectionIdPrefix;
    }

    private void prepareForExecuteDescription(ConnectDescription connectDescription) {
        this.setSecurityOptions(connectDescription);
        if (connectDescription.getTransportConnectTimeout() >= 0) {
            this.socketOptions.put((Object)2, Integer.toString(connectDescription.getTransportConnectTimeout()));
        }
        this.sdu = connectDescription.getSdu();
        this.tdu = connectDescription.getTdu();
        this.retryCount = connectDescription.getRetryCount();
        if (this.retryCount < 0) {
            this.retryCount = 0;
        }
        this.socketOptions.put((Object)17, Integer.toString(this.retryCount));
        this.setExpireTimeSocketOption(connectDescription.getExpireTime(), this.socketOptions);
        this.connectionIdPrefix = this.userProp.getProperty("oracle.net.connectionIdPrefix", connectDescription.getConnectionIdPrefix());
    }

    private void setSecurityOptions(ConnectDescription connectDescription) {
        if (connectDescription.getEncryptionClient() != null) {
            this.userProp.setProperty("oracle.net.encryption_client", connectDescription.getEncryptionClient());
        }
        if (connectDescription.getEncryptionClientTypes() != null) {
            this.userProp.setProperty("oracle.net.encryption_types_client", connectDescription.getEncryptionClientTypes());
        }
        if (connectDescription.getChecksumClient() != null) {
            this.userProp.setProperty("oracle.net.crypto_checksum_client", connectDescription.getChecksumClient());
        }
        if (connectDescription.getChecksumClientTypes() != null) {
            this.userProp.setProperty("oracle.net.crypto_checksum_types_client", connectDescription.getChecksumClientTypes());
        }
        if (connectDescription.getAllowWeakCrypto() != null) {
            this.userProp.setProperty("oracle.net.allow_weak_crypto", connectDescription.getAllowWeakCrypto());
        }
    }

    private void prepareForExecuteConnOption(ConnOption connOption) {
        if (connOption.walletDirectory != null) {
            this.socketOptions.put((Object)5, EnvVariableResolver.resolveFilePath(connOption.walletDirectory, this.userProp));
        }
        if (connOption.sslServerCertDN == null) {
            connOption.sslServerCertDN = (String)this.socketOptions.get(28);
        }
        if (connOption.sslServerCertDN != null && this.socketOptions.get(4) == null) {
            this.socketOptions.put((Object)4, "TRUE");
        }
    }

    private void handleExecuteConnOptionCompletion(ConnOption connOption) {
        connOption.sdu = this.sdu;
        connOption.tdu = this.tdu;
        this.optFound = true;
        if (!connOption.nt.hasMoreInetAddresses()) {
            ++this.nextOptToTry;
        }
    }

    private void handleExecuteConnOptionFailure(ConnOption connOption, IOException iOException) {
        DownHostsCache.getInstance().markDownHost(connOption);
        if (connOption.nt == null || !connOption.nt.hasMoreInetAddresses()) {
            ++this.nextOptToTry;
        }
    }

    private void executeConnOption(ConnOption connOption, DMSFactory.DMSNoun dMSNoun, int n2, boolean bl, int n3) throws IOException, InterruptedIOException {
        if (n3 > 0 && bl) {
            TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, n3, Thread.currentThread());
        }
        connOption.connectTimeout = n3;
        connOption.transportConnectTimeout = n2;
        try {
            connOption.connect(this.socketOptions, dMSNoun, this.sslContext);
        }
        catch (InterruptedIOException interruptedIOException) {
            if (n3 > 0 && !this.cancelOutboundTimeout()) {
                throw new IOException("Outbound connect timeout expired", interruptedIOException);
            }
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (n3 > 0) {
                this.cancelOutboundTimeout();
            }
            throw iOException;
        }
    }

    private boolean cancelOutboundTimeout() {
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        return interruptTask != null && !interruptTask.isInterrupted();
    }

    private final int getOutboundConnectTimeout(ConnectDescription connectDescription) {
        if (connectDescription.getConnectTimeout() >= 0) {
            return connectDescription.getConnectTimeout();
        }
        String string = (String)this.socketOptions.get(25);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public CompletionStage<ConnOption> executeAsync(boolean bl, DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        if (this.lastRetryConnectDescription >= this.descriptionList.size()) {
            return CompletionStageUtil.completedStage(null);
        }
        return this.executeDescriptionAsync(this.lastRetryConnectDescription, dMSNoun, bl, asyncOutboundTimeoutHandler, executor).handle(CompletionStageUtil.completionHandler(connOption -> {
            if (connOption != null) {
                return connOption;
            }
            throw new NetException(20);
        }, IOException.class, iOException -> {
            throw (NetException)new NetException(20).initCause(iOException);
        }));
    }

    private final CompletionStage<ConnOption> executeDescriptionAsync(int n2, DMSFactory.DMSNoun dMSNoun, boolean bl, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        ConnectDescription connectDescription = this.descriptionList.get(n2);
        ArrayList<ConnOption> arrayList = connectDescription.getConnectOptions();
        DownHostsCache.getInstance().reorderAddresses(arrayList);
        this.prepareForExecuteDescription(connectDescription);
        this.outboundConnectTimeout = this.getOutboundConnectTimeout(connectDescription);
        int n3 = connectDescription.getDelayInMillis();
        CompletionStage<Object> completionStage = this.lastRetryCounter <= this.retryCount ? this.executeConnOptionListAsync(this.lastRetryCounter, arrayList, n3, connectDescription.getTransportConnectTimeout(), dMSNoun, bl, this.outboundConnectTimeout, asyncOutboundTimeoutHandler, executor) : CompletionStageUtil.completedStage(null);
        int n4 = n2 + 1;
        return completionStage.exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            if (n4 < this.descriptionList.size()) {
                return null;
            }
            throw iOException;
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(connOption -> {
            if (connOption != null) {
                this.lastRetryConnectDescription = n2;
                return CompletionStageUtil.completedStage(connOption);
            }
            this.lastRetryCounter = 0;
            return n4 < this.descriptionList.size() ? this.executeDescriptionAsync(n4, dMSNoun, bl, asyncOutboundTimeoutHandler, executor) : CompletionStageUtil.completedStage(null);
        }));
    }

    private CompletionStage<ConnOption> executeConnOptionListAsync(int n2, List<ConnOption> list, int n3, int n4, DMSFactory.DMSNoun dMSNoun, boolean bl, int n5, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        CompletionStage<Object> completionStage = this.nextOptToTry < list.size() ? this.executeNextConnOptionAsync(list, dMSNoun, n4, bl, n5, asyncOutboundTimeoutHandler, executor) : CompletionStageUtil.completedStage(null);
        return completionStage.exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            if (n2 < this.retryCount) {
                return null;
            }
            throw iOException;
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(connOption -> {
            if (connOption != null) {
                this.lastRetryCounter = n2;
                return CompletionStageUtil.completedStage(connOption);
            }
            this.nextOptToTry = 0;
            if (n2 < this.retryCount) {
                CompletableFuture completableFuture = new CompletableFuture();
                if (n3 <= 0) {
                    completableFuture.complete(null);
                } else {
                    TimeoutInterruptHandler.scheduleTask(() -> completableFuture.complete(null), n3);
                }
                return completableFuture.thenCompose(void_ -> this.executeConnOptionListAsync(n2 + 1, list, n3, n4, dMSNoun, bl, n5, asyncOutboundTimeoutHandler, executor));
            }
            return CompletionStageUtil.completedStage(null);
        }));
    }

    private final CompletionStage<ConnOption> executeNextConnOptionAsync(List<ConnOption> list, DMSFactory.DMSNoun dMSNoun, int n2, boolean bl, int n3, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        this.copt = list.get(this.nextOptToTry);
        this.prepareForExecuteConnOption(this.copt);
        CompletionStage<CompletionStage> completionStage = this.executeConnOptionAsync(this.copt, dMSNoun, bl, n3, asyncOutboundTimeoutHandler, n2, executor).handle(CompletionStageUtil.completionHandler(void_ -> {
            this.handleExecuteConnOptionCompletion(this.copt);
            return CompletionStageUtil.completedStage(this.copt);
        }, IOException.class, iOException -> {
            this.handleExecuteConnOptionFailure(this.copt, (IOException)iOException);
            return this.nextOptToTry < list.size() ? this.executeNextConnOptionAsync(list, dMSNoun, n2, bl, n3, asyncOutboundTimeoutHandler, executor) : CompletionStageUtil.failedStage(iOException);
        }));
        return completionStage.thenCompose(Function.identity());
    }

    private final CompletionStage<Void> executeConnOptionAsync(ConnOption connOption, DMSFactory.DMSNoun dMSNoun, boolean bl, int n2, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, int n3, Executor executor) {
        if (n2 > 0 && bl) {
            try {
                asyncOutboundTimeoutHandler.scheduleTimeout(Duration.ofMillis(n2));
            }
            catch (IOException iOException) {
                return CompletionStageUtil.failedStage(iOException);
            }
        }
        connOption.connectTimeout = n2;
        connOption.transportConnectTimeout = n3;
        CompletionStage<Void> completionStage = connOption.connectAsync(this.socketOptions, dMSNoun, this.sslContext, asyncOutboundTimeoutHandler, executor);
        if (n2 > 0) {
            return completionStage.whenComplete((void_, throwable) -> {
                if (throwable != null) {
                    asyncOutboundTimeoutHandler.cancelTimeout();
                }
            });
        }
        return completionStage;
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public void clearElements() {
        this.descriptionList = null;
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.copt.isConnectionSocketKeepAlive();
    }

    public ConnectDescription newConnectDescription() {
        this.currentDescription = new ConnectDescription();
        return this.currentDescription;
    }

    public ConnectDescription currentDescription() {
        return this.currentDescription;
    }

    public void closeDescription() {
        this.descriptionList.add(this.currentDescription);
        this.currentDescription = null;
    }

    public List<ConnectDescription> getAllDescriptions() {
        return this.descriptionList;
    }

    public int getOutboundConnectTimeout() {
        return this.outboundConnectTimeout;
    }

    private final void setExpireTimeSocketOption(int n2, @Blind(value=PropertiesBlinder.class) Properties properties) {
        if (n2 < 0) {
            return;
        }
        int n3 = n2 * 60;
        properties.putIfAbsent((Object)33, Integer.toString(n3));
    }

    static {
        try {
            $$$methodRef$$$45 = ConnStrategy.class.getDeclaredConstructor(Properties.class, SSLContext.class, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = ConnStrategy.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = ConnStrategy.class.getDeclaredMethod("lambda$executeAsync$0", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = ConnStrategy.class.getDeclaredMethod("lambda$executeAsync$1", IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = ConnStrategy.class.getDeclaredMethod("lambda$executeDescriptionAsync$2", Integer.TYPE, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = ConnStrategy.class.getDeclaredMethod("lambda$executeDescriptionAsync$3", Integer.TYPE, Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = ConnStrategy.class.getDeclaredMethod("lambda$executeConnOptionListAsync$4", Integer.TYPE, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = ConnStrategy.class.getDeclaredMethod("lambda$executeConnOptionListAsync$5", CompletableFuture.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = ConnStrategy.class.getDeclaredMethod("lambda$executeConnOptionListAsync$6", Integer.TYPE, List.class, Integer.TYPE, Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = ConnStrategy.class.getDeclaredMethod("lambda$executeConnOptionListAsync$7", Integer.TYPE, Integer.TYPE, List.class, Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = ConnStrategy.class.getDeclaredMethod("lambda$executeNextConnOptionAsync$8", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = ConnStrategy.class.getDeclaredMethod("lambda$executeNextConnOptionAsync$9", List.class, DMSFactory.DMSNoun.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = ConnStrategy.class.getDeclaredMethod("lambda$executeConnOptionAsync$10", AsyncOutboundTimeoutHandler.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = ConnStrategy.class.getDeclaredMethod("setExpireTimeSocketOption", Integer.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = ConnStrategy.class.getDeclaredMethod("getOutboundConnectTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = ConnStrategy.class.getDeclaredMethod("getAllDescriptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = ConnStrategy.class.getDeclaredMethod("closeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = ConnStrategy.class.getDeclaredMethod("currentDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = ConnStrategy.class.getDeclaredMethod("newConnectDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = ConnStrategy.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ConnStrategy.class.getDeclaredMethod("getOption", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ConnStrategy.class.getDeclaredMethod("clearElements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ConnStrategy.class.getDeclaredMethod("optAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ConnStrategy.class.getDeclaredMethod("executeConnOptionAsync", ConnOption.class, DMSFactory.DMSNoun.class, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Integer.TYPE, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ConnStrategy.class.getDeclaredMethod("executeNextConnOptionAsync", List.class, DMSFactory.DMSNoun.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ConnStrategy.class.getDeclaredMethod("executeConnOptionListAsync", Integer.TYPE, List.class, Integer.TYPE, Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ConnStrategy.class.getDeclaredMethod("executeDescriptionAsync", Integer.TYPE, DMSFactory.DMSNoun.class, Boolean.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ConnStrategy.class.getDeclaredMethod("executeAsync", Boolean.TYPE, DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ConnStrategy.class.getDeclaredMethod("getOutboundConnectTimeout", ConnectDescription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ConnStrategy.class.getDeclaredMethod("cancelOutboundTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ConnStrategy.class.getDeclaredMethod("executeConnOption", ConnOption.class, DMSFactory.DMSNoun.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ConnStrategy.class.getDeclaredMethod("handleExecuteConnOptionFailure", ConnOption.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ConnStrategy.class.getDeclaredMethod("handleExecuteConnOptionCompletion", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ConnStrategy.class.getDeclaredMethod("prepareForExecuteConnOption", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ConnStrategy.class.getDeclaredMethod("setSecurityOptions", ConnectDescription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ConnStrategy.class.getDeclaredMethod("prepareForExecuteDescription", ConnectDescription.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ConnStrategy.class.getDeclaredMethod("getConnectionIdPrefix", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ConnStrategy.class.getDeclaredMethod("execute", Boolean.TYPE, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ConnStrategy.class.getDeclaredMethod("hasMoreOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ConnStrategy.class.getDeclaredMethod("addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ConnStrategy.class.getDeclaredMethod("addSocketOptions", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ConnStrategy.class.getDeclaredMethod("createSocketOptions", Properties.class, Properties.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ConnStrategy.class.getDeclaredMethod("createSocketOptions", Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ConnStrategy.class.getDeclaredMethod("createSocketOptions", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ConnStrategy.class.getDeclaredMethod("getProgramName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ConnStrategy.class.getDeclaredMethod("getOSUsername", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

