/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.driver.CancelState;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class CancelLock {
    private CancelState state = null;
    private OracleStatement statement = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    CancelLock(OracleStatement oracleStatement) {
        this.statement = oracleStatement;
        this.state = new CancelState();
    }

    boolean isIdle() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            boolean bl = this.state.isIdle();
            return bl;
        }
    }

    boolean isCanceled() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            boolean bl = this.state.isCanceled();
            return bl;
        }
    }

    void enterExecuting() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            assert (this.state.isIdle());
            this.state.setExecuting();
        }
    }

    /*
     * Unable to fully structure code
     */
    void exitExecuting() {
        while (true) lbl-1000:
        // 5 sources

        {
            block13: {
                block12: {
                    var1_1 = this.state.acquireCloseableLock();
                    if (!this.state.isExecuting()) break block12;
                    this.state.setIdle();
                    if (var1_1 == null) break;
                    var1_1.close();
                    break;
                }
                if (!this.state.isCanceling()) break block13;
                try {
                    this.state.monitorWait();
                }
                finally {
                    if (var1_1 == null) ** GOTO lbl-1000
                    var1_1.close();
                }
            }
            try {
                if (!this.state.isCanceled()) continue;
                if (this.statement != null && this.statement.connection.cancelInProgressFlag) {
                }
                this.state.setIdle();
            }
            finally {
                if (var1_1 == null) continue;
                var1_1.close();
                continue;
            }
            break;
        }
    }

    boolean enterCanceling() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            if (this.state.isExecuting()) {
                this.state.setCanceling();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    void exitCanceling() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            assert (this.state.isCanceling());
            this.state.setCanceled();
            this.state.monitorNotify();
        }
    }

    static {
        try {
            $$$methodRef$$$6 = CancelLock.class.getDeclaredConstructor(OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CancelLock.class.getDeclaredMethod("exitCanceling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CancelLock.class.getDeclaredMethod("enterCanceling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CancelLock.class.getDeclaredMethod("exitExecuting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CancelLock.class.getDeclaredMethod("enterExecuting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CancelLock.class.getDeclaredMethod("isCanceled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CancelLock.class.getDeclaredMethod("isIdle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

