/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET})
abstract class Accessor
extends GeneratedAccessor
implements Cloneable {
    static final int FIXED_CHAR = 999;
    static final int CHAR = 96;
    static final int VARCHAR = 1;
    static final int VCS = 9;
    static final int LONG = 8;
    static final int NUMBER = 2;
    static final int VARNUM = 6;
    static final int BINARY_FLOAT = 100;
    static final int BINARY_DOUBLE = 101;
    static final int RAW = 23;
    static final int VBI = 15;
    static final int LONG_RAW = 24;
    static final int ROWID = 104;
    static final int RESULT_SET = 102;
    static final int RSET = 116;
    static final int DATE = 12;
    static final int BLOB = 113;
    static final int JSON = 119;
    static final int CLOB = 112;
    static final int BFILE = 114;
    static final int NAMED_TYPE = 109;
    static final int REF_TYPE = 111;
    static final int TIMESTAMP = 180;
    static final int TIMESTAMPTZ = 181;
    static final int TIMESTAMPLTZ = 231;
    static final int INTERVALYM = 182;
    static final int INTERVALDS = 183;
    static final int UROWID = 208;
    static final int PLSQL_BOOLEAN = 252;
    static final int PLSQL_INDEX_TABLE = 998;
    static final int T2S_OVERLONG_RAW = 997;
    static final int SET_CHAR_BYTES = 996;
    static final int NULL_TYPE = 995;
    static final int DML_RETURN_PARAM = 994;
    static final int XMLTYPE = 257;
    static final int ONLY_FORM_USABLE = 0;
    static final int NOT_USABLE = 1;
    static final int NO_NEED_TO_PREPARE = 2;
    static final int NEED_TO_PREPARE = 3;
    static final byte DATA_UNAUTHORIZED = 1;
    static final int NO_LOB_PREFETCH = -1;
    OracleStatement statement;
    boolean outBind;
    int internalType;
    boolean isStream = false;
    boolean isColumnNumberAware = false;
    short formOfUse = (short)2;
    OracleType internalOtype;
    int externalType;
    String internalTypeName;
    String columnName;
    int describeType;
    int describeMaxLength;
    int describeMaxLengthChars;
    short describeFormOfUse;
    long contflag;
    boolean nullable;
    int precision;
    int scale;
    int flags;
    int total_elems;
    OracleType describeOtype;
    String describeTypeName;
    int definedColumnType = 0;
    int definedColumnSize = 0;
    int oacmxl = 0;
    short udskpos = (short)-1;
    int lobPrefetchSizeForThisColumn = -1;
    OracleResultSetMetaData.SecurityAttribute securityAttribute;
    protected boolean columnInvisible = false;
    protected boolean columnJSON = false;
    short[] rowSpaceIndicator = null;
    int columnDataOffset = 0;
    int lengthIndex = 0;
    int indicatorIndex = 0;
    int byteLength = 0;
    int charLength = 0;
    int defineType;
    boolean isDMLReturnedParam = false;
    int lastRowProcessed = 0;
    boolean isUseLess = false;
    int physicalColumnIndex = -2;
    boolean isNullByDescribe = false;
    int lastCopyRow = -1;
    long lastCopyRowOffset = 0L;
    int lastCopyRowLength = 0;
    byte lastCopyRowMetaData = 0;
    boolean lastCopyRowIsNull = false;
    static final byte[] NULL_DATA_BYTES;
    static final int ROW_METADATA_LENGTH = 1;
    final Representation representation;
    final int representationMaxLength;
    ByteArray rowData;
    long[] rowOffset = null;
    int[] rowLength = null;
    boolean[] rowNull = null;
    byte[] rowMetadata = null;
    Object driverSpecificData;
    int previousRowProcessed = -1;
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;

    void setNoPrefetch() {
    }

    void setPrefetchLength(int n2) {
    }

    PlsqlIbtBindInfo plsqlIndexTableBindInfo() throws SQLException {
        return null;
    }

    void unimpl(String string) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, string + " not implemented for " + this.getClass()).fillInStackTrace();
    }

    long updateChecksum(long l2, int n2) throws SQLException {
        if (this.isNull(n2)) {
            return CRC64.updateChecksum(l2, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
        }
        return this.rowData.updateChecksum(this.getOffset(n2), this.getLength(n2), PhysicalConnection.CHECKSUM, l2);
    }

    void init(OracleStatement oracleStatement, int n2, int n3, short s2, boolean bl) throws SQLException {
        this.statement = oracleStatement;
        this.outBind = bl;
        this.internalType = n2;
        this.defineType = n3;
        this.formOfUse = s2;
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.byteLength = n3 > 0 && n3 < this.representationMaxLength ? n3 : this.representationMaxLength;
    }

    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2) throws SQLException {
        this.nullable = bl;
        this.precision = n5;
        this.scale = n6;
        this.flags = n4;
        this.contflag = l2;
        this.total_elems = n7;
        this.describeType = n2;
        this.describeMaxLength = n3;
        this.describeFormOfUse = s2;
        if (!this.statement.columnsDefinedByUser) {
            this.formOfUse = s2;
        }
    }

    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2, String string) throws SQLException {
        this.describeTypeName = string;
        this.describeOtype = null;
        this.initForDescribe(n2, n3, bl, n4, n5, n6, l2, n7, s2);
    }

    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2, String string, int n8) throws SQLException {
        this.initForDescribe(n2, n3, bl, n4, n5, n6, l2, n7, s2, string);
        this.describeMaxLengthChars = n8;
    }

    OracleInputStream initForNewRow() throws SQLException {
        this.unimpl("initForNewRow");
        return null;
    }

    int useForDataAccessIfPossible(int n2, int n3, int n4, String string) throws SQLException {
        int n5 = 3;
        int n6 = 0;
        int n7 = 0;
        if (this.internalType != 0) {
            if (this.internalType != n2) {
                n5 = 0;
            } else if (this.rowSpaceIndicator != null) {
                n6 = this.byteLength;
                n7 = this.charLength;
            }
        }
        if (n5 == 3) {
            this.initForDataAccess(n3, n4, string);
            if (!this.outBind && n6 >= this.byteLength && n7 >= this.charLength) {
                n5 = 2;
            }
        }
        return n5;
    }

    boolean useForDescribeIfPossible(int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2, String string) throws SQLException {
        if (!this.statement.columnsDefinedByUser && this.externalType == 0 && this.describeType == 0 && n2 != this.describeType) {
            return false;
        }
        this.initForDescribe(n2, n3, bl, n4, n5, n6, l2, n7, s2, string);
        return true;
    }

    void setFormOfUse(short s2) {
        this.formOfUse = s2;
    }

    void updateColumnNumber(int n2) {
    }

    @DisableTrace
    public String toString() {
        return super.toString() + ", statement=" + this.statement + ", outBind=" + this.outBind + ", internalType=" + this.internalType + ", isStream=" + this.isStream + ", formOfUse=" + this.formOfUse + ", internalOtype=" + this.internalOtype + ", externalType=" + this.externalType + ", internalTypeName=" + this.internalTypeName + ", columnName=" + this.columnName + ", describeType=" + this.describeType + ", describeMaxLength=" + this.describeMaxLength + ", nullable=" + this.nullable + ", precision=" + this.precision + ", scale=" + this.scale + ", flags=" + this.flags + ", contflag=" + this.contflag + ", total_elems=" + this.total_elems + ", describeOtype=" + this.describeOtype + ", describeTypeName=" + this.describeTypeName + ", rowData=" + this.rowData + ", rowOffset=" + this.rowOffset + ", rowLength=" + this.rowLength + ", rowNull=" + this.rowNull + ", rowMetadata=" + this.rowMetadata + ", driverSpecificData=" + this.driverSpecificData + ", describeMaxLengthChars=" + this.describeMaxLengthChars;
    }

    void fetchNextColumns() throws SQLException {
    }

    void calculateSizeTmpByteArray() {
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
    }

    void copyRow() throws SQLException, IOException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
    }

    int readStream(byte[] byArray, int n2) throws SQLException, IOException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
    }

    int getPreviousRowProcessed() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148).fillInStackTrace();
    }

    void initMetadata() throws SQLException {
    }

    CompletionStage<Void> initMetadataAsync() {
        return CompletionStageUtil.VOID_COMPLETED_FUTURE;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.statement.getConnectionDuringExceptionHandling();
    }

    protected Accessor(Representation representation, OracleStatement oracleStatement, int n2, boolean bl) {
        this.representation = representation;
        this.statement = oracleStatement;
        this.representationMaxLength = n2;
        this.rowData = bl ? this.statement.bindData : this.statement.rowData;
        this.statement.setDriverSpecificData(this);
    }

    protected final long getOffset(int n2) {
        return this.rowOffset[n2];
    }

    protected final void setOffset(int n2, long l2) {
        this.rowOffset[n2] = l2;
    }

    protected final void setOffset(int n2) {
        long l2 = this.rowData.getPosition();
        this.rowOffset[n2] = l2;
    }

    protected final int getLength(int n2) {
        return this.rowLength[n2];
    }

    protected final void setLength(int n2, int n3) {
        this.rowLength[n2] = n3;
    }

    protected final void setLengthAndNull(int n2, int n3) throws SQLException {
        if (n3 == 0) {
            this.setNull(n2, true);
        } else {
            this.setNull(n2, false);
            this.setLength(n2, n3);
        }
    }

    final byte getRowMetadata(int n2) {
        return this.rowMetadata[n2];
    }

    final void setRowMetadata(int n2, byte by) {
        this.rowMetadata[n2] = by;
    }

    @Override
    boolean isNull(int n2) throws SQLException {
        if (this.rowNull == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        return this.rowNull[n2];
    }

    void setNull(int n2, boolean bl) throws SQLException {
        if (this.rowNull == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        this.rowNull[n2] = bl;
        if (bl && this.statement.connection.protocolId != 3) {
            this.setOffset(n2, -1L);
            this.setLength(n2, -1);
        }
    }

    boolean isNullByDescribe() {
        return this.isNullByDescribe;
    }

    boolean isUseless() {
        return this.isUseLess;
    }

    boolean isUnexpected() {
        return this.rowNull == null;
    }

    void setColumnInvisible(boolean bl) {
        this.columnInvisible = bl;
    }

    boolean isColumnInvisible() {
        return this.columnInvisible;
    }

    void setColumnJSON(boolean bl) {
        this.columnJSON = bl;
    }

    boolean isColumnJSON() {
        return this.columnJSON;
    }

    void setCapacity(int n2) {
        if (this.rowNull == null) {
            this.rowLength = new int[n2];
            this.rowOffset = new long[n2];
            this.rowNull = new boolean[n2];
            this.rowMetadata = new byte[n2];
        } else if (this.rowNull.length < n2) {
            Object[] objectArray = new int[n2];
            System.arraycopy(this.rowLength, 0, objectArray, 0, this.rowLength.length);
            this.rowLength = objectArray;
            objectArray = new long[n2];
            System.arraycopy(this.rowOffset, 0, objectArray, 0, this.rowOffset.length);
            this.rowOffset = objectArray;
            objectArray = new boolean[n2];
            System.arraycopy(this.rowNull, 0, objectArray, 0, this.rowNull.length);
            this.rowNull = (boolean[])objectArray;
            objectArray = new byte[n2];
            System.arraycopy(this.rowMetadata, 0, objectArray, 0, this.rowMetadata.length);
            this.rowMetadata = (byte[])objectArray;
        }
    }

    void insertNull(int n2) throws SQLException {
        System.arraycopy(this.rowNull, n2, this.rowNull, n2 + 1, this.rowNull.length - n2 - 1);
        System.arraycopy(this.rowLength, n2, this.rowLength, n2 + 1, this.rowLength.length - n2 - 1);
        System.arraycopy(this.rowOffset, n2, this.rowOffset, n2 + 1, this.rowOffset.length - n2 - 1);
        System.arraycopy(this.rowMetadata, n2, this.rowMetadata, n2 + 1, this.rowMetadata.length - n2 - 1);
        this.setNull(n2, true);
    }

    Accessor copyForDefine(OracleStatement oracleStatement) {
        Accessor accessor = null;
        try {
            accessor = (Accessor)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        accessor.rowNull = null;
        accessor.rowLength = null;
        accessor.rowOffset = null;
        accessor.rowMetadata = null;
        accessor.statement = oracleStatement;
        accessor.rowData = oracleStatement.rowData;
        oracleStatement.setDriverSpecificData(accessor);
        return accessor;
    }

    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        byte by = this.getRowMetadata(n2);
        if ((by & 1) != 0) {
            return OracleResultSet.AuthorizationIndicator.UNAUTHORIZED;
        }
        if (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED || this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.NONE) {
            return OracleResultSet.AuthorizationIndicator.NONE;
        }
        return OracleResultSet.AuthorizationIndicator.UNKNOWN;
    }

    byte[] getBytesInternal(int n2) throws SQLException {
        assert (!this.isNull(n2));
        int n3 = this.getLength(n2);
        long l2 = this.getOffset(n2);
        return this.rowData.get(l2, n3);
    }

    final void getBytesInternal(int n2, byte[] byArray) throws SQLException {
        int n3 = this.getLength(n2);
        assert (byArray.length >= n3) : "data.length: " + byArray.length + " len: " + n3;
        long l2 = this.getOffset(n2);
        this.rowData.get(l2, byArray, 0, n3);
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        return this.getBytesInternal(n2);
    }

    @Override
    String getString(int n2) throws SQLException {
        return null;
    }

    <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        if (clazz == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 282).fillInStackTrace();
        }
        return this.representation.getObject(this, n2, clazz);
    }

    @Override
    Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        if (oracleDataFactory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 281).fillInStackTrace();
        }
        Object object = this.getObject(n2, (Map)null);
        return oracleDataFactory.create(object, 0);
    }

    @Override
    ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        if (oRADataFactory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 281).fillInStackTrace();
        }
        Datum datum = this.getOracleObject(n2);
        return oRADataFactory.create(datum, 0);
    }

    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOraclePlsqlIndexTable not implemented for " + this.getClass().getName()).fillInStackTrace();
    }

    @Override
    NClob getNClob(int n2) throws SQLException {
        if (this.formOfUse != 2) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
        return (NClob)((Object)this.getCLOB(n2));
    }

    @Override
    String getNString(int n2) throws SQLException {
        return this.getString(n2);
    }

    @Override
    Reader getNCharacterStream(int n2) throws SQLException {
        return this.getCharacterStream(n2);
    }

    int getBytes(int n2, byte[] byArray, int n3) throws SQLException {
        if (this.isNull(n2)) {
            return 0;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes not implemented for class " + this.getClass().getName()).fillInStackTrace();
    }

    final void copyFrom(Accessor accessor, int n2, int n3) throws SQLException {
        assert (this.getClass() == accessor.getClass()) : "srcAcc.class: " + accessor.getClass();
        assert (0 <= n2 && n2 < accessor.rowNull.length) : "srcRow: " + n2 + " srcAcc.capacity: " + accessor.rowNull.length;
        assert (0 <= n3 && n3 < this.rowNull.length) : "destRow: " + n3 + " capacity: " + this.rowNull.length;
        if (accessor.isNull(n2)) {
            this.setNull(n3, true);
        } else {
            this.copyFromInternal(accessor, n2, n3);
        }
    }

    protected void copyFromInternal(Accessor accessor, int n2, int n3) throws SQLException {
        boolean bl;
        boolean bl2 = bl = n3 > 0 && this.getOffset(n3 - 1) == this.getOffset(n3) || n3 + 1 < this.statement.storedRowCount && this.getOffset(n3 + 1) == this.getOffset(n3);
        if (bl && this.getLength(n3) == accessor.getLength(n2) && this.rowData.equalBytes(this.getOffset(n3), this.getLength(n3), accessor.rowData, accessor.getOffset(n2))) {
            this.setRowMetadata(n3, accessor.getRowMetadata(n2));
        } else {
            boolean bl3;
            boolean bl4 = bl3 = n3 + 1 == this.statement.storedRowCount;
            if (bl || accessor.getLength(n2) > this.getLength(n3) || bl3) {
                if (bl3) {
                    this.lastCopyRow = n3;
                    this.lastCopyRowOffset = this.getOffset(n3);
                    this.lastCopyRowLength = this.getLength(n3);
                    this.lastCopyRowMetaData = this.getRowMetadata(n3);
                    this.lastCopyRowIsNull = this.isNull(n3);
                }
                this.statement.locationToPutBytes(this, n3, accessor.getLength(n2));
            }
            this.rowData.put(this.getOffset(n3), accessor.rowData, accessor.getOffset(n2), accessor.getLength(n2));
            this.setLength(n3, accessor.getLength(n2));
            this.setRowMetadata(n3, accessor.getRowMetadata(n2));
        }
        this.setNull(n3, false);
    }

    void deleteRow(int n2) throws SQLException {
        this.rowData.freeSpace(this.getOffset(n2), this.getLength(n2));
        this.delete(this.rowNull, n2);
        this.delete(this.rowOffset, n2);
        this.delete(this.rowLength, n2);
        this.delete(this.rowMetadata, n2);
    }

    protected final void delete(Object object, int n2) {
        int n3 = Array.getLength(object);
        assert (n2 >= 0 && n2 < n3) : "row: " + n2 + " len: " + n3;
        System.arraycopy(object, n2 + 1, object, n2, n3 - n2 - 1);
    }

    AccessorPrototype newPrototype(int n2) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "newPrototype not overridden in " + this.getClass().getName()).fillInStackTrace();
    }

    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "reinitForResultSetCache not overridden in " + this.getClass().getName()).fillInStackTrace();
    }

    long previousOffset() {
        if (this.previousRowProcessed == -1) {
            return 0L;
        }
        return this.getOffset(this.previousRowProcessed);
    }

    boolean isLengthSemanticChar() {
        return 0L != (0x1000L & this.contflag);
    }

    static {
        try {
            $$$methodRef$$$65 = Accessor.class.getDeclaredConstructor(Representation.class, OracleStatement.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = Accessor.class.getDeclaredMethod("isLengthSemanticChar", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = Accessor.class.getDeclaredMethod("previousOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = Accessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = Accessor.class.getDeclaredMethod("newPrototype", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = Accessor.class.getDeclaredMethod("delete", Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = Accessor.class.getDeclaredMethod("deleteRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = Accessor.class.getDeclaredMethod("copyFromInternal", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = Accessor.class.getDeclaredMethod("copyFrom", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = Accessor.class.getDeclaredMethod("getBytes", Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = Accessor.class.getDeclaredMethod("getNCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = Accessor.class.getDeclaredMethod("getNString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = Accessor.class.getDeclaredMethod("getNClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = Accessor.class.getDeclaredMethod("getOraclePlsqlIndexTable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = Accessor.class.getDeclaredMethod("getORAData", Integer.TYPE, ORADataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = Accessor.class.getDeclaredMethod("getObject", Integer.TYPE, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = Accessor.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = Accessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = Accessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = Accessor.class.getDeclaredMethod("getBytesInternal", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = Accessor.class.getDeclaredMethod("getBytesInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = Accessor.class.getDeclaredMethod("getAuthorizationIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = Accessor.class.getDeclaredMethod("copyForDefine", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = Accessor.class.getDeclaredMethod("insertNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = Accessor.class.getDeclaredMethod("setCapacity", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = Accessor.class.getDeclaredMethod("isColumnJSON", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = Accessor.class.getDeclaredMethod("setColumnJSON", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = Accessor.class.getDeclaredMethod("isColumnInvisible", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = Accessor.class.getDeclaredMethod("setColumnInvisible", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = Accessor.class.getDeclaredMethod("isUnexpected", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = Accessor.class.getDeclaredMethod("isUseless", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = Accessor.class.getDeclaredMethod("isNullByDescribe", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = Accessor.class.getDeclaredMethod("setNull", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = Accessor.class.getDeclaredMethod("isNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = Accessor.class.getDeclaredMethod("setRowMetadata", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = Accessor.class.getDeclaredMethod("getRowMetadata", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = Accessor.class.getDeclaredMethod("setLengthAndNull", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = Accessor.class.getDeclaredMethod("setLength", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = Accessor.class.getDeclaredMethod("getLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = Accessor.class.getDeclaredMethod("setOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = Accessor.class.getDeclaredMethod("setOffset", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = Accessor.class.getDeclaredMethod("getOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = Accessor.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = Accessor.class.getDeclaredMethod("initMetadataAsync", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = Accessor.class.getDeclaredMethod("initMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = Accessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = Accessor.class.getDeclaredMethod("readStream", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = Accessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = Accessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = Accessor.class.getDeclaredMethod("calculateSizeTmpByteArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = Accessor.class.getDeclaredMethod("fetchNextColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = Accessor.class.getDeclaredMethod("updateColumnNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = Accessor.class.getDeclaredMethod("setFormOfUse", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = Accessor.class.getDeclaredMethod("useForDescribeIfPossible", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = Accessor.class.getDeclaredMethod("useForDataAccessIfPossible", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = Accessor.class.getDeclaredMethod("initForNewRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = Accessor.class.getDeclaredMethod("initForDescribe", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = Accessor.class.getDeclaredMethod("initForDescribe", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Accessor.class.getDeclaredMethod("initForDescribe", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Accessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Accessor.class.getDeclaredMethod("init", OracleStatement.class, Integer.TYPE, Integer.TYPE, Short.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Accessor.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Accessor.class.getDeclaredMethod("unimpl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Accessor.class.getDeclaredMethod("plsqlIndexTableBindInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Accessor.class.getDeclaredMethod("setPrefetchLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Accessor.class.getDeclaredMethod("setNoPrefetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NULL_DATA_BYTES = new byte[]{2, 3, 5, 7, 11, 13, 17, 19};
    }
}

