/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;

public final class OsonBuffer {
    final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    final ByteBuffer buffer;
    char[] charBuffer;
    public Map<Integer, String> cache = new HashMap<Integer, String>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    public OsonBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer = byteBuffer;
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public int position() {
        return this.buffer.position();
    }

    public void position(int n2) {
        this.buffer.position(n2);
    }

    public int getUB1() {
        return 0xFF & this.buffer.get();
    }

    public int getUB1(int n2) {
        return 0xFF & this.buffer.get(n2);
    }

    public int getUB2() {
        return 0xFFFF & this.buffer.getShort();
    }

    public int getUB2(int n2) {
        return 0xFFFF & this.buffer.getShort(n2);
    }

    public String readString(int n2) {
        byte[] byArray = this.buffer.array();
        if (this.charBuffer == null || this.charBuffer.length < n2) {
            this.charBuffer = new char[n2];
        }
        int n3 = this.buffer.position();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[i2 + n3];
            if (by < 0) {
                String string = new String(this.buffer.array(), this.buffer.position(), n2, StandardCharsets.UTF_8);
                this.buffer.position(n3 + n2);
                return string;
            }
            this.charBuffer[i2] = (char)by;
        }
        this.buffer.position(n3 + n2);
        return new String(this.charBuffer, 0, n2);
    }

    public int getUB4int() {
        int n2 = this.buffer.getInt();
        if (n2 < 0) {
            throw OracleJsonExceptions.OVERFLOW.create(null, n2);
        }
        return n2;
    }

    public int getUB4int(int n2) {
        int n3 = this.buffer.getInt(n2);
        if (n3 < 0) {
            throw OracleJsonExceptions.OVERFLOW.create(null, n3);
        }
        return n3;
    }

    public void get(byte[] byArray) {
        this.buffer.get(byArray);
    }

    public double readDtyDouble() {
        byte[] byArray = new byte[8];
        this.buffer.get(byArray);
        return OsonPrimitiveConversions.canonicalFormatBytesToDouble(byArray);
    }

    public float readDtyFloat() {
        byte[] byArray = new byte[4];
        this.buffer.get(byArray);
        return OsonPrimitiveConversions.canonicalFormatBytesToFloat(byArray);
    }

    int binarySearchUb1(int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3 - 1;
        byte[] byArray = this.buffer.array();
        while (n5 <= n6) {
            int n7 = n5 + n6 >>> 1;
            int n8 = byArray[n2 + n7] & 0xFF;
            if (n8 < n4) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > n4) {
                n6 = n7 - 1;
                continue;
            }
            return n7;
        }
        return -1;
    }

    int binarySearchUb2(int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3 - 1;
        while (n5 <= n6) {
            int n7 = n5 + n6 >>> 1;
            int n8 = this.getUB2(n2 + n7 * 2);
            if (n8 < n4) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > n4) {
                n6 = n7 - 1;
                continue;
            }
            return n7;
        }
        return -1;
    }

    int binarySearchUb4(int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3 - 1;
        while (n5 <= n6) {
            int n7 = n5 + n6 >>> 1;
            int n8 = this.getUB4int(n2 + n7 * 4);
            if (n8 < n4) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > n4) {
                n6 = n7 - 1;
                continue;
            }
            return n7;
        }
        return -1;
    }

    public int linearSearchUb1(int n2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.getUB1(i2) != n4) continue;
            return i2 - n2;
        }
        return -1;
    }

    int linearSearchUb2(int n2, int n3, int n4) {
        int n5 = n2 + n3 * 2;
        for (int i2 = n2; i2 < n5; i2 += 2) {
            if (this.getUB2(i2) != n4) continue;
            return (i2 - n2) / 2;
        }
        return -1;
    }

    public int linearSearchUb4(int n2, int n3, int n4) {
        int n5 = n2 + n3 * 4;
        for (int i2 = n2; i2 < n5; i2 += 4) {
            if (this.getUB4int(i2) != n4) continue;
            return (i2 - n2) / 4;
        }
        return -1;
    }

    static {
        try {
            $$$methodRef$$$20 = OsonBuffer.class.getDeclaredConstructor(ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OsonBuffer.class.getDeclaredMethod("linearSearchUb4", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OsonBuffer.class.getDeclaredMethod("linearSearchUb2", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonBuffer.class.getDeclaredMethod("linearSearchUb1", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonBuffer.class.getDeclaredMethod("binarySearchUb4", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonBuffer.class.getDeclaredMethod("binarySearchUb2", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonBuffer.class.getDeclaredMethod("binarySearchUb1", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonBuffer.class.getDeclaredMethod("readDtyFloat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonBuffer.class.getDeclaredMethod("readDtyDouble", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonBuffer.class.getDeclaredMethod("get", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonBuffer.class.getDeclaredMethod("getUB4int", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonBuffer.class.getDeclaredMethod("getUB4int", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonBuffer.class.getDeclaredMethod("readString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonBuffer.class.getDeclaredMethod("getUB2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonBuffer.class.getDeclaredMethod("getUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonBuffer.class.getDeclaredMethod("getUB1", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonBuffer.class.getDeclaredMethod("getUB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonBuffer.class.getDeclaredMethod("position", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonBuffer.class.getDeclaredMethod("position", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonBuffer.class.getDeclaredMethod("buffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonBuffer.class.getDeclaredMethod("getInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

