/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleNClob;
import oracle.jdbc.internal.OracleOpaque;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.UPDATEABLE_RESULT_SET})
public abstract class JavaToJavaConverter<S, T> {
    protected static final long MILLIS_IN_SECOND = 1000L;
    private static final TimeZone UTC_TIME_ZONE;
    private static final Calendar UTC_US_CALENDAR;
    protected Calendar cachedUTCUSCalendar = (Calendar)UTC_US_CALENDAR.clone();
    protected static final DateTimeFormatter DATE_TIME_FORMAT;
    protected static final DateTimeFormatter OFFSET_DATE_TIME_FORMAT;
    private static int INTYMYEAROFFSET;
    private static int INTYMMONTHOFFSET;
    private static int INTERVALDSOFFSET;
    private static int INTERVALDAYOFFSET;
    private static final Map<Key, JavaToJavaConverter> CONVERTERS;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S, T> T convert(S s2, Class<T> clazz, OracleConnection oracleConnection, Object object, Object object2) throws SQLException {
        if (s2 == null) {
            return clazz.cast(null);
        }
        if (clazz.isInstance(s2)) {
            return clazz.cast(s2);
        }
        Key key = new Key(s2.getClass(), clazz);
        JavaToJavaConverter javaToJavaConverter = CONVERTERS.get(key);
        if (javaToJavaConverter != null) {
            try {
                return javaToJavaConverter.convert(s2, oracleConnection, object, object2);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Throwable throwable) {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)oracleConnection, 132, s2.getClass().getName() + " to " + clazz.getName(), throwable).fillInStackTrace();
            }
        }
        Throwable throwable = null;
        for (Map.Entry<Key, JavaToJavaConverter> entry : CONVERTERS.entrySet()) {
            if (!entry.getKey().satisfies(key)) continue;
            try {
                javaToJavaConverter = entry.getValue();
                return javaToJavaConverter.convert(s2, oracleConnection, object, object2);
            }
            catch (Throwable throwable2) {
                try {
                    if (throwable == null) continue;
                    throwable2.initCause(throwable);
                }
                catch (IllegalStateException illegalStateException) {}
                continue;
                finally {
                    throwable = throwable2;
                }
            }
        }
        throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)oracleConnection, 132, s2.getClass().getName() + " to " + clazz.getName(), throwable).fillInStackTrace();
    }

    private JavaToJavaConverter() {
    }

    protected abstract T convert(S var1, OracleConnection var2, Object var3, Object var4) throws Exception;

    Calendar getSessionCalendar(OracleConnection oracleConnection) {
        Calendar calendar;
        String string = oracleConnection.getSessionTimeZone();
        if (string == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = TimeZone.getTimeZone(string);
            calendar = Calendar.getInstance(timeZone);
        }
        return calendar;
    }

    public static void main(String[] stringArray) throws Exception {
        int n2 = 0;
        String string = stringArray[n2++];
        System.out.println("\toriginal:\t" + string);
        while (n2 < stringArray.length) {
            Class<?> clazz = Class.forName(stringArray[n2++]);
            System.out.println("\t" + string.getClass().getName() + "\tto:\t" + clazz.getName());
            string = JavaToJavaConverter.convert(string, clazz, null, null, null);
            System.out.println("\tresult:\t" + string);
        }
    }

    static {
        try {
            $$$methodRef$$$8 = JavaToJavaConverter.class.getDeclaredConstructor(1.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JavaToJavaConverter.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JavaToJavaConverter.class.getDeclaredMethod("access$400", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JavaToJavaConverter.class.getDeclaredMethod("access$300", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JavaToJavaConverter.class.getDeclaredMethod("access$200", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JavaToJavaConverter.class.getDeclaredMethod("access$100", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JavaToJavaConverter.class.getDeclaredMethod("main", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JavaToJavaConverter.class.getDeclaredMethod("getSessionCalendar", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JavaToJavaConverter.class.getDeclaredMethod("convert", Object.class, Class.class, OracleConnection.class, Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
        UTC_US_CALENDAR = Calendar.getInstance(UTC_TIME_ZONE, Locale.US);
        DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        OFFSET_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZ");
        INTYMYEAROFFSET = Integer.MIN_VALUE;
        INTYMMONTHOFFSET = 60;
        INTERVALDSOFFSET = 60;
        INTERVALDAYOFFSET = Integer.MIN_VALUE;
        CONVERTERS = new HashMap<Key, JavaToJavaConverter>();
        CONVERTERS.put(new Key(BINARY_DOUBLE.class, Double.class), new JavaToJavaConverter<BINARY_DOUBLE, Double>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Double convert(BINARY_DOUBLE bINARY_DOUBLE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bINARY_DOUBLE.doubleValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("convert", BINARY_DOUBLE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(BINARY_DOUBLE.class, String.class), new JavaToJavaConverter<BINARY_DOUBLE, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(BINARY_DOUBLE bINARY_DOUBLE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bINARY_DOUBLE.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("convert", BINARY_DOUBLE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(BINARY_FLOAT.class, Float.class), new JavaToJavaConverter<BINARY_FLOAT, Float>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Float convert(BINARY_FLOAT bINARY_FLOAT, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Float.valueOf(bINARY_FLOAT.floatValue());
            }

            static {
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("convert", BINARY_FLOAT.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(BINARY_FLOAT.class, String.class), new JavaToJavaConverter<BINARY_FLOAT, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(BINARY_FLOAT bINARY_FLOAT, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bINARY_FLOAT.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("convert", BINARY_FLOAT.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, BigDecimal.class), new JavaToJavaConverter<Boolean, BigDecimal>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BigDecimal convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bl != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }

            static {
                try {
                    $$$methodRef$$$2 = 5.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Byte.class), new JavaToJavaConverter<Boolean, Byte>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Byte convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bl != false ? (byte)1 : 0;
            }

            static {
                try {
                    $$$methodRef$$$2 = 6.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 6.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 6.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Double.class), new JavaToJavaConverter<Boolean, Double>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Double convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bl != false ? 1.0 : 0.0;
            }

            static {
                try {
                    $$$methodRef$$$2 = 7.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 7.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 7.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Float.class), new JavaToJavaConverter<Boolean, Float>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Float convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Float.valueOf(bl != false ? 1.0f : 0.0f);
            }

            static {
                try {
                    $$$methodRef$$$2 = 8.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 8.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 8.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Integer.class), new JavaToJavaConverter<Boolean, Integer>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Integer convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bl != false ? 1 : 0;
            }

            static {
                try {
                    $$$methodRef$$$2 = 9.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 9.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 9.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Long.class), new JavaToJavaConverter<Boolean, Long>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Long convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bl != false ? 1L : 0L;
            }

            static {
                try {
                    $$$methodRef$$$2 = 10.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 10.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 10.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, NUMBER.class), new JavaToJavaConverter<Boolean, NUMBER>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected NUMBER convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bl != false ? new NUMBER(1) : new NUMBER(0);
            }

            static {
                try {
                    $$$methodRef$$$2 = 11.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 11.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 11.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Short.class), new JavaToJavaConverter<Boolean, Short>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Short convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bl != false ? (short)1 : 0;
            }

            static {
                try {
                    $$$methodRef$$$2 = 12.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 12.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 12.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Boolean.class, String.class), new JavaToJavaConverter<Boolean, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Boolean bl, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return bl != false ? "1" : "0";
            }

            static {
                try {
                    $$$methodRef$$$2 = 13.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 13.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 13.class.getDeclaredMethod("convert", Boolean.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(byte[].class, CHAR.class), new JavaToJavaConverter<byte[], CHAR>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected CHAR convert(byte[] byArray, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                CharacterSet characterSet = null;
                if (object2 != null && object2 instanceof CharacterSet) {
                    characterSet = (CharacterSet)object2;
                }
                if (characterSet == null) {
                    throw new IllegalArgumentException("Charset needs to be defined while making CHAR type");
                }
                return new CHAR(byArray, characterSet);
            }

            static {
                try {
                    $$$methodRef$$$2 = 14.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 14.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 14.class.getDeclaredMethod("convert", byte[].class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(byte[].class, DATE.class), new JavaToJavaConverter<byte[], DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(byte[] byArray, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 15.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 15.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 15.class.getDeclaredMethod("convert", byte[].class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(byte[].class, InputStream.class), new JavaToJavaConverter<byte[], InputStream>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected InputStream convert(byte[] byArray, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new ByteArrayInputStream(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 16.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 16.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 16.class.getDeclaredMethod("convert", byte[].class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(byte[].class, NUMBER.class), new JavaToJavaConverter<byte[], NUMBER>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected NUMBER convert(byte[] byArray, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new NUMBER(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 17.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 17.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 17.class.getDeclaredMethod("convert", byte[].class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(byte[].class, RAW.class), new JavaToJavaConverter<byte[], RAW>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected RAW convert(byte[] byArray, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return RAW.newRAW(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 18.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 18.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 18.class.getDeclaredMethod("convert", byte[].class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(byte[].class, String.class), new JavaToJavaConverter<byte[], String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(byte[] byArray, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new String(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 19.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 19.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 19.class.getDeclaredMethod("convert", byte[].class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(byte[].class, TIMESTAMP.class), new JavaToJavaConverter<byte[], TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(byte[] byArray, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 20.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 20.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 20.class.getDeclaredMethod("convert", byte[].class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(byte[].class, TIMESTAMPLTZ.class), new JavaToJavaConverter<byte[], TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(byte[] byArray, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPLTZ(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 21.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 21.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 21.class.getDeclaredMethod("convert", byte[].class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, java.sql.Date.class), new JavaToJavaConverter<Calendar, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new java.sql.Date(calendar.getTimeInMillis());
            }

            static {
                try {
                    $$$methodRef$$$2 = 22.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 22.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 22.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, Date.class), new JavaToJavaConverter<Calendar, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return calendar.getTime();
            }

            static {
                try {
                    $$$methodRef$$$2 = 23.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 23.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 23.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, DATE.class), new JavaToJavaConverter<Calendar, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(calendar);
            }

            static {
                try {
                    $$$methodRef$$$2 = 24.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 24.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 24.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, String.class), new JavaToJavaConverter<Calendar, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return calendar.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 25.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 25.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 25.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, Time.class), new JavaToJavaConverter<Calendar, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Time(calendar.getTimeInMillis());
            }

            static {
                try {
                    $$$methodRef$$$2 = 26.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 26.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 26.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, Timestamp.class), new JavaToJavaConverter<Calendar, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Timestamp(calendar.getTimeInMillis());
            }

            static {
                try {
                    $$$methodRef$$$2 = 27.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 27.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 27.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, TIMESTAMP.class), new JavaToJavaConverter<Calendar, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(new Timestamp(calendar.getTimeInMillis()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 28.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 28.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 28.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<Calendar, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPLTZ((Connection)oracleConnection, this.getSessionCalendar(oracleConnection), new java.sql.Date(calendar.getTimeInMillis()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 29.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 29.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 29.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Calendar.class, TIMESTAMPTZ.class), new JavaToJavaConverter<Calendar, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(Calendar calendar, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPTZ((Connection)oracleConnection, new java.sql.Date(calendar.getTimeInMillis()), calendar);
            }

            static {
                try {
                    $$$methodRef$$$2 = 30.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 30.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 30.class.getDeclaredMethod("convert", Calendar.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, BigDecimal.class), new JavaToJavaConverter<CHAR, BigDecimal>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BigDecimal convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new BigDecimal(cHAR.getString());
            }

            static {
                try {
                    $$$methodRef$$$2 = 31.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 31.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 31.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Boolean.class), new JavaToJavaConverter<CHAR, Boolean>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Boolean convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return cHAR.booleanValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 32.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 32.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 32.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Byte.class), new JavaToJavaConverter<CHAR, Byte>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Byte convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return cHAR.byteValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 33.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 33.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 33.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, java.sql.Date.class), new JavaToJavaConverter<CHAR, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new java.sql.Date(Date.parse(cHAR.getString()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 34.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 34.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 34.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, InputStream.class), new JavaToJavaConverter<CHAR, InputStream>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected InputStream convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new ByteArrayInputStream(cHAR.shareBytes());
            }

            static {
                try {
                    $$$methodRef$$$2 = 35.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 35.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 35.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Long.class), new JavaToJavaConverter<CHAR, Long>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Long convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Long(cHAR.getString());
            }

            static {
                try {
                    $$$methodRef$$$2 = 36.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 36.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 36.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Reader.class), new JavaToJavaConverter<CHAR, Reader>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Reader convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new StringReader(cHAR.getString());
            }

            static {
                try {
                    $$$methodRef$$$2 = 37.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 37.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 37.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, String.class), new JavaToJavaConverter<CHAR, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return cHAR.getString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 38.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 38.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 38.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Time.class), new JavaToJavaConverter<CHAR, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Time(Date.parse(cHAR.getString()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 39.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 39.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 39.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Timestamp.class), new JavaToJavaConverter<CHAR, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(CHAR cHAR, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Timestamp(Date.parse(cHAR.getString()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 40.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 40.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 40.class.getDeclaredMethod("convert", CHAR.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, Calendar.class), new JavaToJavaConverter<java.sql.Date, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(java.sql.Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 41.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 41.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 41.class.getDeclaredMethod("convert", java.sql.Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, Date.class), new JavaToJavaConverter<java.sql.Date, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(java.sql.Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(date.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 42.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 42.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 42.class.getDeclaredMethod("convert", java.sql.Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, DATE.class), new JavaToJavaConverter<java.sql.Date, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(java.sql.Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(date);
            }

            static {
                try {
                    $$$methodRef$$$2 = 43.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 43.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 43.class.getDeclaredMethod("convert", java.sql.Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, String.class), new JavaToJavaConverter<java.sql.Date, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(java.sql.Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return date.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 44.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 44.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 44.class.getDeclaredMethod("convert", java.sql.Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, Timestamp.class), new JavaToJavaConverter<java.sql.Date, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(java.sql.Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Timestamp(date.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 45.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 45.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 45.class.getDeclaredMethod("convert", java.sql.Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, TIMESTAMP.class), new JavaToJavaConverter<java.sql.Date, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(java.sql.Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(date);
            }

            static {
                try {
                    $$$methodRef$$$2 = 46.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 46.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 46.class.getDeclaredMethod("convert", java.sql.Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Date.class, Calendar.class), new JavaToJavaConverter<Date, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 47.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 47.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 47.class.getDeclaredMethod("convert", Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Date.class, Date.class), new JavaToJavaConverter<Date, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new java.sql.Date(date.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 48.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 48.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 48.class.getDeclaredMethod("convert", Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Date.class, DATE.class), new JavaToJavaConverter<Date, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(new java.sql.Date(date.getTime()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 49.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 49.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 49.class.getDeclaredMethod("convert", Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Date.class, String.class), new JavaToJavaConverter<Date, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return date.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 50.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 50.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 50.class.getDeclaredMethod("convert", Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Date.class, Timestamp.class), new JavaToJavaConverter<Date, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Timestamp(date.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 51.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 51.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 51.class.getDeclaredMethod("convert", Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Date.class, TIMESTAMP.class), new JavaToJavaConverter<Date, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(Date date, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(new Timestamp(date.getTime()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 52.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 52.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 52.class.getDeclaredMethod("convert", Date.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(DATE.class, Calendar.class), new JavaToJavaConverter<DATE, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(DATE dATE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dATE.dateValue());
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 53.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 53.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 53.class.getDeclaredMethod("convert", DATE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(DATE.class, Date.class), new JavaToJavaConverter<DATE, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(DATE dATE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(dATE.dateValue().getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 54.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 54.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 54.class.getDeclaredMethod("convert", DATE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(DATE.class, java.sql.Date.class), new JavaToJavaConverter<DATE, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(DATE dATE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new java.sql.Date(dATE.dateValue().getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 55.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 55.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 55.class.getDeclaredMethod("convert", DATE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(DATE.class, String.class), new JavaToJavaConverter<DATE, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(DATE dATE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return dATE.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 56.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 56.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 56.class.getDeclaredMethod("convert", DATE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(DATE.class, Time.class), new JavaToJavaConverter<DATE, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(DATE dATE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return dATE.timeValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 57.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 57.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 57.class.getDeclaredMethod("convert", DATE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(DATE.class, Timestamp.class), new JavaToJavaConverter<DATE, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(DATE dATE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return dATE.timestampValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 58.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 58.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 58.class.getDeclaredMethod("convert", DATE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(DATE.class, TIMESTAMP.class), new JavaToJavaConverter<DATE, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(DATE dATE, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(dATE);
            }

            static {
                try {
                    $$$methodRef$$$2 = 59.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 59.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 59.class.getDeclaredMethod("convert", DATE.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Duration.class, INTERVALDS.class), new JavaToJavaConverter<Duration, INTERVALDS>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected INTERVALDS convert(Duration duration, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                long l2 = duration.getSeconds();
                int n2 = (int)Math.signum(l2);
                l2 = Math.abs(l2);
                int n3 = Math.abs(duration.getNano());
                int n4 = n2 * (int)(l2 / 86400L);
                int n5 = n2 * (int)((l2 %= 86400L) / 3600L);
                int n6 = n2 * (int)((l2 %= 3600L) / 60L);
                l2 %= 60L;
                byte[] byArray = new byte[11];
                byArray[0] = (byte)((n4 += INTERVALDAYOFFSET) >> 24 & 0xFF);
                byArray[1] = (byte)(n4 >> 16 & 0xFF);
                byArray[2] = (byte)(n4 >> 8 & 0xFF);
                byArray[3] = (byte)(n4 & 0xFF);
                byArray[4] = (byte)(n5 + INTERVALDSOFFSET);
                byArray[5] = (byte)(n6 + INTERVALDSOFFSET);
                byArray[6] = (byte)(l2 + (long)INTERVALDSOFFSET);
                n3 = n2 * n3 + INTERVALDAYOFFSET;
                byArray[7] = (byte)(n3 >> 24 & 0xFF);
                byArray[8] = (byte)(n3 >> 16 & 0xFF);
                byArray[9] = (byte)(n3 >> 8 & 0xFF);
                byArray[10] = (byte)(n3 & 0xFF);
                return new INTERVALDS(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 60.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 60.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 60.class.getDeclaredMethod("convert", Duration.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Duration.class, String.class), new JavaToJavaConverter<Duration, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Duration duration, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return JavaToJavaConverter.convert(duration, INTERVALDS.class, oracleConnection, object, object2).toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 61.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 61.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 61.class.getDeclaredMethod("convert", Duration.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(InputStream.class, CLOB.class), new JavaToJavaConverter<InputStream, CLOB>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected CLOB convert(InputStream inputStream, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                int n2;
                CLOB cLOB = (CLOB)oracleConnection.createClob();
                OutputStream outputStream = cLOB.setAsciiStream(1L);
                long l2 = Long.MAX_VALUE;
                if (object != null && object instanceof Number) {
                    l2 = ((Number)object).longValue();
                }
                for (long i2 = 0L; i2 < l2 && (n2 = inputStream.read()) != -1; ++i2) {
                    outputStream.write(n2);
                }
                outputStream.close();
                return cLOB;
            }

            static {
                try {
                    $$$methodRef$$$2 = 62.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 62.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 62.class.getDeclaredMethod("convert", InputStream.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(InputStream.class, NCLOB.class), new JavaToJavaConverter<InputStream, CLOB>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected NCLOB convert(InputStream inputStream, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                int n2;
                NCLOB nCLOB = (NCLOB)oracleConnection.createNClob();
                OutputStream outputStream = nCLOB.setAsciiStream(1L);
                long l2 = Long.MAX_VALUE;
                if (object != null && object instanceof Number) {
                    l2 = ((Number)object).longValue();
                }
                for (long i2 = 0L; i2 < l2 && (n2 = inputStream.read()) != -1; ++i2) {
                    outputStream.write(n2);
                }
                outputStream.close();
                return nCLOB;
            }

            static {
                try {
                    $$$methodRef$$$2 = 63.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 63.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 63.class.getDeclaredMethod("convert", InputStream.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(InputStream.class, String.class), new JavaToJavaConverter<InputStream, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(InputStream inputStream, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                String string;
                block4: {
                    int n2;
                    long l2 = Long.MAX_VALUE;
                    if (object != null && object instanceof Number) {
                        l2 = ((Number)object).longValue();
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    for (long i2 = 0L; i2 < l2 && (n2 = inputStream.read()) != -1; ++i2) {
                        byteArrayOutputStream.write(n2);
                    }
                    string = null;
                    try {
                        string = byteArrayOutputStream.toString("US-ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError((Object)"can't happen");
                    }
                }
                return string;
            }

            static {
                try {
                    $$$methodRef$$$2 = 64.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 64.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 64.class.getDeclaredMethod("convert", InputStream.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(INTERVALDS.class, String.class), new JavaToJavaConverter<INTERVALDS, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(INTERVALDS iNTERVALDS, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return iNTERVALDS.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 65.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 65.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 65.class.getDeclaredMethod("convert", INTERVALDS.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(INTERVALYM.class, String.class), new JavaToJavaConverter<INTERVALYM, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(INTERVALYM iNTERVALYM, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return iNTERVALYM.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 66.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 66.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 66.class.getDeclaredMethod("convert", INTERVALYM.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, java.sql.Date.class), new JavaToJavaConverter<LocalDate, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(LocalDate localDate, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return java.sql.Date.valueOf(localDate);
            }

            static {
                try {
                    $$$methodRef$$$2 = 67.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 67.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 67.class.getDeclaredMethod("convert", LocalDate.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, DATE.class), new JavaToJavaConverter<LocalDate, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(LocalDate localDate, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createDATE(java.sql.Date.valueOf(localDate));
            }

            static {
                try {
                    $$$methodRef$$$2 = 68.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 68.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 68.class.getDeclaredMethod("convert", LocalDate.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, Date.class), new JavaToJavaConverter<LocalDate, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(LocalDate localDate, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Date.from(LocalDateTime.of(localDate, LocalTime.MIDNIGHT).toInstant(ZoneOffset.UTC));
            }

            static {
                try {
                    $$$methodRef$$$2 = 69.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 69.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 69.class.getDeclaredMethod("convert", LocalDate.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, String.class), new JavaToJavaConverter<LocalDate, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(LocalDate localDate, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
            }

            static {
                try {
                    $$$methodRef$$$2 = 70.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 70.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 70.class.getDeclaredMethod("convert", LocalDate.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, Timestamp.class), new JavaToJavaConverter<LocalDate, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(LocalDate localDate, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Timestamp.valueOf(LocalDateTime.of(localDate, LocalTime.MIDNIGHT));
            }

            static {
                try {
                    $$$methodRef$$$2 = 71.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 71.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 71.class.getDeclaredMethod("convert", LocalDate.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, TIMESTAMP.class), new JavaToJavaConverter<LocalDate, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(LocalDate localDate, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMP(Timestamp.valueOf(LocalDateTime.of(localDate, LocalTime.MIDNIGHT)));
            }

            static {
                try {
                    $$$methodRef$$$2 = 72.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 72.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 72.class.getDeclaredMethod("convert", LocalDate.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, java.sql.Date.class), new JavaToJavaConverter<LocalDateTime, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return java.sql.Date.valueOf(localDateTime.toLocalDate());
            }

            static {
                try {
                    $$$methodRef$$$2 = 73.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 73.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 73.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, DATE.class), new JavaToJavaConverter<LocalDateTime, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createDATE(Timestamp.valueOf(localDateTime));
            }

            static {
                try {
                    $$$methodRef$$$2 = 74.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 74.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 74.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, Date.class), new JavaToJavaConverter<LocalDateTime, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Date.from(localDateTime.toInstant(ZoneOffset.UTC));
            }

            static {
                try {
                    $$$methodRef$$$2 = 75.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 75.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 75.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, String.class), new JavaToJavaConverter<LocalDateTime, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return localDateTime.format(DATE_TIME_FORMAT);
            }

            static {
                try {
                    $$$methodRef$$$2 = 76.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 76.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 76.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, Time.class), new JavaToJavaConverter<LocalDateTime, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Time.valueOf(localDateTime.toLocalTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 77.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 77.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 77.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, Timestamp.class), new JavaToJavaConverter<LocalDateTime, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Timestamp.valueOf(localDateTime);
            }

            static {
                try {
                    $$$methodRef$$$2 = 78.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 78.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 78.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, TIMESTAMP.class), new JavaToJavaConverter<LocalDateTime, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMP(Timestamp.valueOf(localDateTime));
            }

            static {
                try {
                    $$$methodRef$$$2 = 79.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 79.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 79.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<LocalDateTime, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = object instanceof Calendar ? (Calendar)object : Calendar.getInstance();
                return oracleConnection.createTIMESTAMPLTZ(Timestamp.valueOf(localDateTime), calendar);
            }

            static {
                try {
                    $$$methodRef$$$2 = 80.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 80.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 80.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, TIMESTAMPTZ.class), new JavaToJavaConverter<LocalDateTime, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(LocalDateTime localDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMPTZ(Timestamp.valueOf(localDateTime));
            }

            static {
                try {
                    $$$methodRef$$$2 = 81.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 81.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 81.class.getDeclaredMethod("convert", LocalDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, DATE.class), new JavaToJavaConverter<LocalTime, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(LocalTime localTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createDATE(new Time(localTime.getLong(ChronoField.MILLI_OF_DAY)), this.cachedUTCUSCalendar);
            }

            static {
                try {
                    $$$methodRef$$$2 = 82.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 82.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 82.class.getDeclaredMethod("convert", LocalTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, Date.class), new JavaToJavaConverter<LocalTime, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(LocalTime localTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(localTime.getLong(ChronoField.MILLI_OF_DAY));
            }

            static {
                try {
                    $$$methodRef$$$2 = 83.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 83.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 83.class.getDeclaredMethod("convert", LocalTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, String.class), new JavaToJavaConverter<LocalTime, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(LocalTime localTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return localTime.format(DateTimeFormatter.ISO_LOCAL_TIME);
            }

            static {
                try {
                    $$$methodRef$$$2 = 84.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 84.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 84.class.getDeclaredMethod("convert", LocalTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, Time.class), new JavaToJavaConverter<LocalTime, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(LocalTime localTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Time.valueOf(localTime);
            }

            static {
                try {
                    $$$methodRef$$$2 = 85.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 85.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 85.class.getDeclaredMethod("convert", LocalTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, Timestamp.class), new JavaToJavaConverter<LocalTime, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(LocalTime localTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Timestamp timestamp = new Timestamp(localTime.getLong(ChronoField.MILLI_OF_DAY));
                timestamp.setNanos(localTime.get(ChronoField.NANO_OF_SECOND));
                return timestamp;
            }

            static {
                try {
                    $$$methodRef$$$2 = 86.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 86.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 86.class.getDeclaredMethod("convert", LocalTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, TIMESTAMP.class), new JavaToJavaConverter<LocalTime, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(LocalTime localTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Timestamp timestamp = new Timestamp(localTime.getLong(ChronoField.MILLI_OF_DAY));
                timestamp.setNanos(localTime.get(ChronoField.NANO_OF_SECOND));
                return oracleConnection.createTIMESTAMP(timestamp, this.cachedUTCUSCalendar);
            }

            static {
                try {
                    $$$methodRef$$$2 = 87.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 87.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 87.class.getDeclaredMethod("convert", LocalTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, BigDecimal.class), new JavaToJavaConverter<Number, BigDecimal>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BigDecimal convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new BigDecimal(number.toString());
            }

            static {
                try {
                    $$$methodRef$$$2 = 88.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 88.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 88.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, BINARY_DOUBLE.class), new JavaToJavaConverter<Number, BINARY_DOUBLE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BINARY_DOUBLE convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new BINARY_DOUBLE(number.doubleValue());
            }

            static {
                try {
                    $$$methodRef$$$2 = 89.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 89.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 89.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, BINARY_FLOAT.class), new JavaToJavaConverter<Number, BINARY_FLOAT>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BINARY_FLOAT convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new BINARY_FLOAT(number.floatValue());
            }

            static {
                try {
                    $$$methodRef$$$2 = 90.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 90.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 90.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, Boolean.class), new JavaToJavaConverter<Number, Boolean>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Boolean convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return !number.equals(0.0);
            }

            static {
                try {
                    $$$methodRef$$$2 = 91.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 91.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 91.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, Byte.class), new JavaToJavaConverter<Number, Byte>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Byte convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return number.byteValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 92.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 92.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 92.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, Double.class), new JavaToJavaConverter<Number, Double>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Double convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return number.doubleValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 93.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 93.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 93.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, Float.class), new JavaToJavaConverter<Number, Float>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Float convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Float.valueOf(number.floatValue());
            }

            static {
                try {
                    $$$methodRef$$$2 = 94.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 94.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 94.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, Integer.class), new JavaToJavaConverter<Number, Integer>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Integer convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return number.intValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 95.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 95.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 95.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, Long.class), new JavaToJavaConverter<Number, Long>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Long convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return number.longValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 96.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 96.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 96.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, NUMBER.class), new JavaToJavaConverter<Number, NUMBER>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected NUMBER convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new NUMBER(new BigDecimal(number.toString()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 97.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 97.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 97.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, Short.class), new JavaToJavaConverter<Number, Short>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Short convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return number.shortValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 98.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 98.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 98.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Number.class, String.class), new JavaToJavaConverter<Number, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Number number, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return number.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 99.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 99.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 99.class.getDeclaredMethod("convert", Number.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, BigDecimal.class), new JavaToJavaConverter<NUMBER, BigDecimal>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BigDecimal convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.bigDecimalValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 100.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 100.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 100.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, BigInteger.class), new JavaToJavaConverter<NUMBER, BigInteger>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BigInteger convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.bigIntegerValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 101.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 101.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 101.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Boolean.class), new JavaToJavaConverter<NUMBER, Boolean>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Boolean convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.booleanValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 102.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 102.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 102.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Byte.class), new JavaToJavaConverter<NUMBER, Byte>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Byte convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.byteValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 103.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 103.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 103.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Double.class), new JavaToJavaConverter<NUMBER, Double>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Double convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.doubleValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 104.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 104.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 104.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Float.class), new JavaToJavaConverter<NUMBER, Float>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Float convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Float.valueOf(nUMBER.floatValue());
            }

            static {
                try {
                    $$$methodRef$$$2 = 105.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 105.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 105.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Integer.class), new JavaToJavaConverter<NUMBER, Integer>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Integer convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.intValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 106.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 106.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 106.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Long.class), new JavaToJavaConverter<NUMBER, Long>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Long convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.longValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 107.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 107.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 107.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Short.class), new JavaToJavaConverter<NUMBER, Short>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Short convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.shortValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 108.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 108.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 108.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, String.class), new JavaToJavaConverter<NUMBER, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(NUMBER nUMBER, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return nUMBER.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 109.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 109.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 109.class.getDeclaredMethod("convert", NUMBER.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Object.class, CHAR.class), new JavaToJavaConverter<Object, CHAR>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected CHAR convert(Object object, OracleConnection oracleConnection, Object object2, Object object3) throws Exception {
                CharacterSet characterSet = null;
                if (object3 != null && object3 instanceof CharacterSet) {
                    characterSet = (CharacterSet)object3;
                }
                if (characterSet == null) {
                    throw new IllegalArgumentException("Charset needs to be defined while coverting to CHAR type");
                }
                return new CHAR(object, characterSet);
            }

            static {
                try {
                    $$$methodRef$$$2 = 110.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 110.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 110.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, java.sql.Date.class), new JavaToJavaConverter<OffsetDateTime, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return java.sql.Date.valueOf(offsetDateTime.toLocalDate());
            }

            static {
                try {
                    $$$methodRef$$$2 = 111.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 111.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 111.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, DATE.class), new JavaToJavaConverter<OffsetDateTime, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createDATE(java.sql.Date.valueOf(offsetDateTime.toLocalDate()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 112.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 112.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 112.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, Date.class), new JavaToJavaConverter<OffsetDateTime, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Date.from(offsetDateTime.toInstant());
            }

            static {
                try {
                    $$$methodRef$$$2 = 113.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 113.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 113.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, String.class), new JavaToJavaConverter<OffsetDateTime, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return offsetDateTime.format(OFFSET_DATE_TIME_FORMAT);
            }

            static {
                try {
                    $$$methodRef$$$2 = 114.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 114.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 114.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, Time.class), new JavaToJavaConverter<OffsetDateTime, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Time.valueOf(offsetDateTime.toLocalTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 115.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 115.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 115.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, Timestamp.class), new JavaToJavaConverter<OffsetDateTime, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Timestamp.valueOf(offsetDateTime.toLocalDateTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 116.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 116.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 116.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, TIMESTAMP.class), new JavaToJavaConverter<OffsetDateTime, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMP(Timestamp.valueOf(offsetDateTime.toLocalDateTime()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 117.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 117.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 117.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<OffsetDateTime, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMPLTZ(Timestamp.valueOf(offsetDateTime.toLocalDateTime()), Calendar.getInstance(TimeZone.getTimeZone(offsetDateTime.getOffset())));
            }

            static {
                try {
                    $$$methodRef$$$2 = 118.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 118.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 118.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, TIMESTAMPTZ.class), new JavaToJavaConverter<OffsetDateTime, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(OffsetDateTime offsetDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMPTZ(Timestamp.from(offsetDateTime.toInstant()), Calendar.getInstance(TimeZone.getTimeZone(offsetDateTime.getOffset())));
            }

            static {
                try {
                    $$$methodRef$$$2 = 119.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 119.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 119.class.getDeclaredMethod("convert", OffsetDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, DATE.class), new JavaToJavaConverter<OffsetTime, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(OffsetTime offsetTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createDATE(new Time(offsetTime.getLong(ChronoField.MILLI_OF_DAY)));
            }

            static {
                try {
                    $$$methodRef$$$2 = 120.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 120.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 120.class.getDeclaredMethod("convert", OffsetTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, Date.class), new JavaToJavaConverter<OffsetTime, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(OffsetTime offsetTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(offsetTime.getLong(ChronoField.MILLI_OF_DAY));
            }

            static {
                try {
                    $$$methodRef$$$2 = 121.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 121.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 121.class.getDeclaredMethod("convert", OffsetTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, String.class), new JavaToJavaConverter<OffsetTime, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(OffsetTime offsetTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return offsetTime.format(DateTimeFormatter.ISO_OFFSET_TIME);
            }

            static {
                try {
                    $$$methodRef$$$2 = 122.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 122.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 122.class.getDeclaredMethod("convert", OffsetTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, Time.class), new JavaToJavaConverter<OffsetTime, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(OffsetTime offsetTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Time.valueOf(offsetTime.toLocalTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 123.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 123.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 123.class.getDeclaredMethod("convert", OffsetTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, Timestamp.class), new JavaToJavaConverter<OffsetTime, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(OffsetTime offsetTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Timestamp timestamp = new Timestamp(offsetTime.getLong(ChronoField.MILLI_OF_DAY));
                timestamp.setNanos(offsetTime.get(ChronoField.NANO_OF_SECOND));
                return timestamp;
            }

            static {
                try {
                    $$$methodRef$$$2 = 124.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 124.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 124.class.getDeclaredMethod("convert", OffsetTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, TIMESTAMP.class), new JavaToJavaConverter<OffsetTime, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(OffsetTime offsetTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Timestamp timestamp = new Timestamp(offsetTime.getLong(ChronoField.MILLI_OF_DAY));
                timestamp.setNanos(offsetTime.get(ChronoField.NANO_OF_SECOND));
                return oracleConnection.createTIMESTAMP(timestamp);
            }

            static {
                try {
                    $$$methodRef$$$2 = 125.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 125.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 125.class.getDeclaredMethod("convert", OffsetTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<OffsetTime, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(OffsetTime offsetTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Timestamp timestamp = new Timestamp(offsetTime.getLong(ChronoField.MILLI_OF_DAY));
                timestamp.setNanos(offsetTime.get(ChronoField.NANO_OF_SECOND));
                return oracleConnection.createTIMESTAMPLTZ(timestamp, Calendar.getInstance(TimeZone.getTimeZone(offsetTime.getOffset())));
            }

            static {
                try {
                    $$$methodRef$$$2 = 126.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 126.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 126.class.getDeclaredMethod("convert", OffsetTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, TIMESTAMPTZ.class), new JavaToJavaConverter<OffsetTime, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(OffsetTime offsetTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Timestamp timestamp = new Timestamp(offsetTime.getLong(ChronoField.MILLI_OF_DAY));
                timestamp.setNanos(offsetTime.get(ChronoField.NANO_OF_SECOND));
                return oracleConnection.createTIMESTAMPTZ(timestamp, Calendar.getInstance(TimeZone.getTimeZone(offsetTime.getOffset())));
            }

            static {
                try {
                    $$$methodRef$$$2 = 127.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 127.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 127.class.getDeclaredMethod("convert", OffsetTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleBfile.class, InputStream.class), new JavaToJavaConverter<OracleBfile, InputStream>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected InputStream convert(OracleBfile oracleBfile, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleBfile.binaryStreamValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 128.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 128.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 128.class.getDeclaredMethod("convert", OracleBfile.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleBfile.class, Reader.class), new JavaToJavaConverter<OracleBfile, Reader>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Reader convert(OracleBfile oracleBfile, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleBfile.characterStreamValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 129.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 129.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 129.class.getDeclaredMethod("convert", OracleBfile.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleBlob.class, InputStream.class), new JavaToJavaConverter<OracleBlob, InputStream>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected InputStream convert(OracleBlob oracleBlob, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleBlob.getBinaryStream();
            }

            static {
                try {
                    $$$methodRef$$$2 = 130.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 130.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 130.class.getDeclaredMethod("convert", OracleBlob.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleBlob.class, Reader.class), new JavaToJavaConverter<OracleBlob, Reader>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Reader convert(OracleBlob oracleBlob, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return ((BLOB)oracleBlob).characterStreamValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 131.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 131.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 131.class.getDeclaredMethod("convert", OracleBlob.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleClob.class, InputStream.class), new JavaToJavaConverter<OracleClob, InputStream>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected InputStream convert(OracleClob oracleClob, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleClob.binaryStreamValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 132.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 132.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 132.class.getDeclaredMethod("convert", OracleClob.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleClob.class, Reader.class), new JavaToJavaConverter<OracleClob, Reader>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Reader convert(OracleClob oracleClob, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleClob.getCharacterStream();
            }

            static {
                try {
                    $$$methodRef$$$2 = 133.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 133.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 133.class.getDeclaredMethod("convert", OracleClob.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleClob.class, String.class), new JavaToJavaConverter<OracleClob, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(OracleClob oracleClob, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleClob.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 134.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 134.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 134.class.getDeclaredMethod("convert", OracleClob.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleNClob.class, InputStream.class), new JavaToJavaConverter<OracleNClob, InputStream>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected InputStream convert(OracleNClob oracleNClob, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleNClob.binaryStreamValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 135.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 135.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 135.class.getDeclaredMethod("convert", OracleNClob.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleNClob.class, Reader.class), new JavaToJavaConverter<OracleNClob, Reader>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Reader convert(OracleNClob oracleNClob, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleNClob.getCharacterStream();
            }

            static {
                try {
                    $$$methodRef$$$2 = 136.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 136.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 136.class.getDeclaredMethod("convert", OracleNClob.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleNClob.class, String.class), new JavaToJavaConverter<OracleNClob, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(OracleNClob oracleNClob, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleNClob.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 137.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 137.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 137.class.getDeclaredMethod("convert", OracleNClob.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(OracleOpaque.class, byte[].class), new JavaToJavaConverter<OracleOpaque, byte[]>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected byte[] convert(OracleOpaque oracleOpaque, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleOpaque.getBytes();
            }

            static {
                try {
                    $$$methodRef$$$2 = 138.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 138.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 138.class.getDeclaredMethod("convert", OracleOpaque.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Period.class, INTERVALYM.class), new JavaToJavaConverter<Period, INTERVALYM>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected INTERVALYM convert(Period period, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                if (period.getDays() > 0) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)oracleConnection, 132, period.getClass().getName() + " to " + Period.class.getName()).fillInStackTrace();
                }
                int n2 = period.getYears();
                int n3 = period.getMonths();
                byte[] byArray = new byte[]{(byte)((n2 += INTYMYEAROFFSET) >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 + INTYMMONTHOFFSET)};
                return new INTERVALYM(byArray);
            }

            static {
                try {
                    $$$methodRef$$$2 = 139.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 139.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 139.class.getDeclaredMethod("convert", Period.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Period.class, String.class), new JavaToJavaConverter<Period, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Period period, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                if (period.getDays() > 0) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)oracleConnection, 132, period.getClass().getName() + " to " + String.class.getName()).fillInStackTrace();
                }
                int n2 = period.getYears();
                int n3 = period.getMonths();
                if (Math.signum(n2) != Math.signum(n3)) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)oracleConnection, 132, period.getClass().getName() + " to " + String.class.getName()).fillInStackTrace();
                }
                String string = "";
                if (n2 < 0) {
                    n2 = Math.abs(n2);
                    n3 = Math.abs(n3);
                    string = "-";
                }
                return string + n2 + "-" + n3;
            }

            static {
                try {
                    $$$methodRef$$$2 = 140.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 140.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 140.class.getDeclaredMethod("convert", Period.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(RAW.class, byte[].class), new JavaToJavaConverter<RAW, byte[]>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected byte[] convert(RAW rAW, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return rAW.getBytes();
            }

            static {
                try {
                    $$$methodRef$$$2 = 141.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 141.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 141.class.getDeclaredMethod("convert", RAW.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(RAW.class, InputStream.class), new JavaToJavaConverter<RAW, InputStream>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected InputStream convert(RAW rAW, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return rAW.binaryStreamValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 142.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 142.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 142.class.getDeclaredMethod("convert", RAW.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(RAW.class, Reader.class), new JavaToJavaConverter<RAW, Reader>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Reader convert(RAW rAW, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return rAW.characterStreamValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 143.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 143.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 143.class.getDeclaredMethod("convert", RAW.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(RAW.class, String.class), new JavaToJavaConverter<RAW, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(RAW rAW, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return rAW.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 144.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 144.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 144.class.getDeclaredMethod("convert", RAW.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Reader.class, CLOB.class), new JavaToJavaConverter<Reader, CLOB>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected CLOB convert(Reader reader, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                int n2;
                CLOB cLOB = (CLOB)((Object)oracleConnection.createNClob());
                Writer writer = cLOB.setCharacterStream(1L);
                long l2 = Long.MAX_VALUE;
                if (object != null && object instanceof Number) {
                    l2 = ((Number)object).longValue();
                }
                for (long i2 = 0L; i2 < l2 && (n2 = reader.read()) != -1; ++i2) {
                    writer.write(n2);
                }
                writer.close();
                return cLOB;
            }

            static {
                try {
                    $$$methodRef$$$2 = 145.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 145.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 145.class.getDeclaredMethod("convert", Reader.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Reader.class, NCLOB.class), new JavaToJavaConverter<Reader, NCLOB>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected NCLOB convert(Reader reader, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                int n2;
                NCLOB nCLOB = (NCLOB)oracleConnection.createNClob();
                Writer writer = nCLOB.setCharacterStream(1L);
                long l2 = Long.MAX_VALUE;
                if (object != null && object instanceof Number) {
                    l2 = ((Number)object).longValue();
                }
                for (long i2 = 0L; i2 < l2 && (n2 = reader.read()) != -1; ++i2) {
                    writer.write(n2);
                }
                writer.close();
                return nCLOB;
            }

            static {
                try {
                    $$$methodRef$$$2 = 146.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 146.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 146.class.getDeclaredMethod("convert", Reader.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Reader.class, String.class), new JavaToJavaConverter<Reader, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Reader reader, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                long l2 = Long.MAX_VALUE;
                if (object != null && object instanceof Number) {
                    l2 = ((Number)object).longValue();
                }
                int n3 = 0;
                while ((long)n3 < l2 && (n2 = reader.read()) != -1) {
                    stringBuilder.appendCodePoint(n2);
                    ++n3;
                }
                return stringBuilder.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 147.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 147.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 147.class.getDeclaredMethod("convert", Reader.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(RowId.class, String.class), new JavaToJavaConverter<RowId, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(RowId rowId, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return rowId.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 148.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 148.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 148.class.getDeclaredMethod("convert", RowId.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(SQLXML.class, String.class), new JavaToJavaConverter<SQLXML, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(SQLXML sQLXML, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return sQLXML.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 149.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 149.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 149.class.getDeclaredMethod("convert", SQLXML.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, BigDecimal.class), new JavaToJavaConverter<String, BigDecimal>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BigDecimal convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new BigDecimal(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 150.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 150.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 150.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, BigInteger.class), new JavaToJavaConverter<String, BigInteger>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected BigInteger convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new BigInteger(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 151.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 151.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 151.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Byte.class), new JavaToJavaConverter<String, Byte>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Byte convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Byte(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 152.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 152.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 152.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Calendar.class), new JavaToJavaConverter<String, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateFormat.getInstance().parse(string));
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 153.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 153.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 153.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, java.sql.Date.class), new JavaToJavaConverter<String, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new java.sql.Date(DateFormat.getInstance().parse(string).getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 154.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 154.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 154.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Date.class), new JavaToJavaConverter<String, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return DateFormat.getInstance().parse(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 155.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 155.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 155.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, DATE.class), new JavaToJavaConverter<String, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 156.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 156.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 156.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Double.class), new JavaToJavaConverter<String, Double>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Double convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Double(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 157.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 157.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 157.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Float.class), new JavaToJavaConverter<String, Float>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Float convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Float(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 158.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 158.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 158.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, InputStream.class), new JavaToJavaConverter<String, InputStream>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected InputStream convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new ByteArrayInputStream(string.getBytes());
            }

            static {
                try {
                    $$$methodRef$$$2 = 159.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 159.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 159.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Integer.class), new JavaToJavaConverter<String, Integer>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Integer convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Integer(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 160.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 160.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 160.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Long.class), new JavaToJavaConverter<String, Long>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Long convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Long(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 161.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 161.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 161.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, NUMBER.class), new JavaToJavaConverter<String, NUMBER>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected NUMBER convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new NUMBER(new BigDecimal(string));
            }

            static {
                try {
                    $$$methodRef$$$2 = 162.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 162.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 162.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Reader.class), new JavaToJavaConverter<String, Reader>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Reader convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new StringReader(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 163.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 163.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 163.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Short.class), new JavaToJavaConverter<String, Short>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Short convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Short(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 164.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 164.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 164.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Time.class), new JavaToJavaConverter<String, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Time(DateFormat.getInstance().parse(string).getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 165.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 165.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 165.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, Timestamp.class), new JavaToJavaConverter<String, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Timestamp(DateFormat.getInstance().parse(string).getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 166.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 166.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 166.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, TIMESTAMP.class), new JavaToJavaConverter<String, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 167.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 167.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 167.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<String, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPLTZ((Connection)oracleConnection, string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 168.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 168.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 168.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, TIMESTAMPTZ.class), new JavaToJavaConverter<String, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPTZ((Connection)oracleConnection, string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 169.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 169.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 169.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(String.class, URL.class), new JavaToJavaConverter<String, URL>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected URL convert(String string, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new URL(string);
            }

            static {
                try {
                    $$$methodRef$$$2 = 170.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 170.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 170.class.getDeclaredMethod("convert", String.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, Calendar.class), new JavaToJavaConverter<Time, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new java.sql.Date(time.getTime()));
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 171.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 171.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 171.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, java.sql.Date.class), new JavaToJavaConverter<Time, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new java.sql.Date(time.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 172.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 172.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 172.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, Date.class), new JavaToJavaConverter<Time, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(time.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 173.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 173.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 173.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, DATE.class), new JavaToJavaConverter<Time, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(new java.sql.Date(time.getTime()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 174.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 174.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 174.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, String.class), new JavaToJavaConverter<Time, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return time.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 175.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 175.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 175.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, Timestamp.class), new JavaToJavaConverter<Time, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Timestamp(time.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 176.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 176.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 176.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, TIMESTAMP.class), new JavaToJavaConverter<Time, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(time);
            }

            static {
                try {
                    $$$methodRef$$$2 = 177.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 177.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 177.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<Time, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPLTZ((Connection)oracleConnection, time);
            }

            static {
                try {
                    $$$methodRef$$$2 = 178.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 178.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 178.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Time.class, TIMESTAMPTZ.class), new JavaToJavaConverter<Time, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(Time time, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPTZ((Connection)oracleConnection, time);
            }

            static {
                try {
                    $$$methodRef$$$2 = 179.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 179.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 179.class.getDeclaredMethod("convert", Time.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, Calendar.class), new JavaToJavaConverter<Timestamp, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Timestamp(timestamp.getTime()));
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 180.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 180.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 180.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, java.sql.Date.class), new JavaToJavaConverter<Timestamp, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new java.sql.Date(timestamp.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 181.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 181.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 181.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, Date.class), new JavaToJavaConverter<Timestamp, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(timestamp.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 182.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 182.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 182.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, DATE.class), new JavaToJavaConverter<Timestamp, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(timestamp);
            }

            static {
                try {
                    $$$methodRef$$$2 = 183.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 183.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 183.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, String.class), new JavaToJavaConverter<Timestamp, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return timestamp.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 184.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 184.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 184.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, Time.class), new JavaToJavaConverter<Timestamp, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Time(timestamp.getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 185.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 185.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 185.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, TIMESTAMP.class), new JavaToJavaConverter<Timestamp, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(timestamp);
            }

            static {
                try {
                    $$$methodRef$$$2 = 186.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 186.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 186.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<Timestamp, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPLTZ((Connection)oracleConnection, timestamp);
            }

            static {
                try {
                    $$$methodRef$$$2 = 187.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 187.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 187.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, TIMESTAMPTZ.class), new JavaToJavaConverter<Timestamp, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(Timestamp timestamp, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPTZ((Connection)oracleConnection, timestamp);
            }

            static {
                try {
                    $$$methodRef$$$2 = 188.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 188.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 188.class.getDeclaredMethod("convert", Timestamp.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, Calendar.class), new JavaToJavaConverter<TIMESTAMP, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(tIMESTAMP.timestampValue());
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 189.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 189.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 189.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, java.sql.Date.class), new JavaToJavaConverter<TIMESTAMP, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMP.dateValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 190.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 190.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 190.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, Date.class), new JavaToJavaConverter<TIMESTAMP, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(tIMESTAMP.timestampValue().getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 191.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 191.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 191.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, DATE.class), new JavaToJavaConverter<TIMESTAMP, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(tIMESTAMP.dateValue());
            }

            static {
                try {
                    $$$methodRef$$$2 = 192.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 192.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 192.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, String.class), new JavaToJavaConverter<TIMESTAMP, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMP.stringValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 193.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 193.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 193.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, Time.class), new JavaToJavaConverter<TIMESTAMP, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMP.timeValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 194.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 194.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 194.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, Timestamp.class), new JavaToJavaConverter<TIMESTAMP, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMP.timestampValue();
            }

            static {
                try {
                    $$$methodRef$$$2 = 195.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 195.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 195.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<TIMESTAMP, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPLTZ((Connection)oracleConnection, tIMESTAMP.timestampValue());
            }

            static {
                try {
                    $$$methodRef$$$2 = 196.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 196.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 196.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, TIMESTAMPTZ.class), new JavaToJavaConverter<TIMESTAMP, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(TIMESTAMP tIMESTAMP, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMPTZ((Connection)oracleConnection, tIMESTAMP.timestampValue());
            }

            static {
                try {
                    $$$methodRef$$$2 = 197.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 197.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 197.class.getDeclaredMethod("convert", TIMESTAMP.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, Calendar.class), new JavaToJavaConverter<TIMESTAMPLTZ, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = this.getSessionCalendar(oracleConnection);
                calendar.setTime(tIMESTAMPLTZ.timestampValue(oracleConnection));
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 198.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 198.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 198.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, java.sql.Date.class), new JavaToJavaConverter<TIMESTAMPLTZ, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPLTZ.dateValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 199.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 199.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 199.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, Date.class), new JavaToJavaConverter<TIMESTAMPLTZ, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(tIMESTAMPLTZ.timestampValue(oracleConnection).getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 200.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 200.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 200.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, DATE.class), new JavaToJavaConverter<TIMESTAMPLTZ, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(tIMESTAMPLTZ.timestampValue(oracleConnection));
            }

            static {
                try {
                    $$$methodRef$$$2 = 201.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 201.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 201.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, LocalDateTime.class), new JavaToJavaConverter<TIMESTAMPLTZ, LocalDateTime>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected LocalDateTime convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPLTZ.localDateTimeValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 202.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 202.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 202.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, OffsetDateTime.class), new JavaToJavaConverter<TIMESTAMPLTZ, OffsetDateTime>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected OffsetDateTime convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPLTZ.offsetDateTimeValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 203.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 203.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 203.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, String.class), new JavaToJavaConverter<TIMESTAMPLTZ, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPLTZ.stringValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 204.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 204.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 204.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, Time.class), new JavaToJavaConverter<TIMESTAMPLTZ, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPLTZ.timeValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 205.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 205.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 205.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, Timestamp.class), new JavaToJavaConverter<TIMESTAMPLTZ, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPLTZ.timestampValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 206.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 206.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 206.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, TIMESTAMP.class), new JavaToJavaConverter<TIMESTAMPLTZ, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(tIMESTAMPLTZ.timestampValue(oracleConnection));
            }

            static {
                try {
                    $$$methodRef$$$2 = 207.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 207.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 207.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, TIMESTAMPTZ.class), new JavaToJavaConverter<TIMESTAMPLTZ, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(TIMESTAMPLTZ tIMESTAMPLTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = this.getSessionCalendar(oracleConnection);
                return new TIMESTAMPTZ((Connection)oracleConnection, tIMESTAMPLTZ.timestampValue(oracleConnection), calendar);
            }

            static {
                try {
                    $$$methodRef$$$2 = 208.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 208.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 208.class.getDeclaredMethod("convert", TIMESTAMPLTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, Calendar.class), new JavaToJavaConverter<TIMESTAMPTZ, Calendar>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Calendar convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(tIMESTAMPTZ.timestampValue(oracleConnection));
                calendar.setTimeZone(tIMESTAMPTZ.getTimeZone());
                return calendar;
            }

            static {
                try {
                    $$$methodRef$$$2 = 209.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 209.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 209.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, java.sql.Date.class), new JavaToJavaConverter<TIMESTAMPTZ, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPTZ.dateValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 210.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 210.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 210.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, Date.class), new JavaToJavaConverter<TIMESTAMPTZ, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new Date(tIMESTAMPTZ.timestampValue(oracleConnection).getTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 211.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 211.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 211.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, DATE.class), new JavaToJavaConverter<TIMESTAMPTZ, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new DATE(tIMESTAMPTZ.timestampValue(oracleConnection));
            }

            static {
                try {
                    $$$methodRef$$$2 = 212.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 212.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 212.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, OffsetDateTime.class), new JavaToJavaConverter<TIMESTAMPTZ, OffsetDateTime>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected OffsetDateTime convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPTZ.offsetDateTimeValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 213.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 213.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 213.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, String.class), new JavaToJavaConverter<TIMESTAMPTZ, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPTZ.stringValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 214.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 214.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 214.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, Time.class), new JavaToJavaConverter<TIMESTAMPTZ, Time>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Time convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPTZ.timeValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 215.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 215.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 215.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, Timestamp.class), new JavaToJavaConverter<TIMESTAMPTZ, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return tIMESTAMPTZ.timestampValue(oracleConnection);
            }

            static {
                try {
                    $$$methodRef$$$2 = 216.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 216.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 216.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, TIMESTAMP.class), new JavaToJavaConverter<TIMESTAMPTZ, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return new TIMESTAMP(tIMESTAMPTZ.timestampValue(oracleConnection));
            }

            static {
                try {
                    $$$methodRef$$$2 = 217.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 217.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 217.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<TIMESTAMPTZ, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(TIMESTAMPTZ tIMESTAMPTZ, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                Calendar calendar = this.getSessionCalendar(oracleConnection);
                return new TIMESTAMPLTZ((Connection)oracleConnection, tIMESTAMPTZ.timestampValue(oracleConnection), calendar);
            }

            static {
                try {
                    $$$methodRef$$$2 = 218.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 218.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 218.class.getDeclaredMethod("convert", TIMESTAMPTZ.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(URL.class, String.class), new JavaToJavaConverter<URL, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(URL uRL, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return uRL.toString();
            }

            static {
                try {
                    $$$methodRef$$$2 = 219.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 219.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 219.class.getDeclaredMethod("convert", URL.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, java.sql.Date.class), new JavaToJavaConverter<ZonedDateTime, java.sql.Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected java.sql.Date convert(ZonedDateTime zonedDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return java.sql.Date.valueOf(zonedDateTime.toLocalDate());
            }

            static {
                try {
                    $$$methodRef$$$2 = 220.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 220.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 220.class.getDeclaredMethod("convert", ZonedDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, DATE.class), new JavaToJavaConverter<ZonedDateTime, DATE>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected DATE convert(ZonedDateTime zonedDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createDATE(Timestamp.valueOf(zonedDateTime.toLocalDateTime()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 221.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 221.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 221.class.getDeclaredMethod("convert", ZonedDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, Date.class), new JavaToJavaConverter<ZonedDateTime, Date>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Date convert(ZonedDateTime zonedDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Date.from(zonedDateTime.toInstant());
            }

            static {
                try {
                    $$$methodRef$$$2 = 222.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 222.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 222.class.getDeclaredMethod("convert", ZonedDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, String.class), new JavaToJavaConverter<ZonedDateTime, String>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected String convert(ZonedDateTime zonedDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return zonedDateTime.format(OFFSET_DATE_TIME_FORMAT);
            }

            static {
                try {
                    $$$methodRef$$$2 = 223.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 223.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 223.class.getDeclaredMethod("convert", ZonedDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, Timestamp.class), new JavaToJavaConverter<ZonedDateTime, Timestamp>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected Timestamp convert(ZonedDateTime zonedDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return Timestamp.valueOf(zonedDateTime.toLocalDateTime());
            }

            static {
                try {
                    $$$methodRef$$$2 = 224.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 224.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 224.class.getDeclaredMethod("convert", ZonedDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, TIMESTAMP.class), new JavaToJavaConverter<ZonedDateTime, TIMESTAMP>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMP convert(ZonedDateTime zonedDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMP(Timestamp.valueOf(zonedDateTime.toLocalDateTime()));
            }

            static {
                try {
                    $$$methodRef$$$2 = 225.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 225.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 225.class.getDeclaredMethod("convert", ZonedDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<ZonedDateTime, TIMESTAMPLTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPLTZ convert(ZonedDateTime zonedDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMPLTZ(Timestamp.valueOf(zonedDateTime.toLocalDateTime()), Calendar.getInstance(TimeZone.getTimeZone(zonedDateTime.getOffset())));
            }

            static {
                try {
                    $$$methodRef$$$2 = 226.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 226.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 226.class.getDeclaredMethod("convert", ZonedDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, TIMESTAMPTZ.class), new JavaToJavaConverter<ZonedDateTime, TIMESTAMPTZ>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected TIMESTAMPTZ convert(ZonedDateTime zonedDateTime, OracleConnection oracleConnection, Object object, Object object2) throws Exception {
                return oracleConnection.createTIMESTAMPTZ(Timestamp.from(zonedDateTime.toInstant()), zonedDateTime.getZone());
            }

            static {
                try {
                    $$$methodRef$$$2 = 227.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 227.class.getDeclaredMethod("convert", Object.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 227.class.getDeclaredMethod("convert", ZonedDateTime.class, OracleConnection.class, Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
    }

    private static final class Key {
        private final Class source;
        private final Class target;
        private final int hash;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        Key(Class clazz, Class clazz2) {
            this.source = clazz;
            this.target = clazz2;
            this.hash = clazz.hashCode() ^ Integer.rotateRight(clazz2.hashCode(), 1);
        }

        @DisableTrace
        public int hashCode() {
            return this.hash;
        }

        @DisableTrace
        public boolean equals(Object object) {
            Key key = (Key)object;
            return this.hash == key.hash && this.source == key.source && this.target == key.target;
        }

        public boolean satisfies(Key key) {
            return this.source.isAssignableFrom(key.source) && key.target.isAssignableFrom(this.target);
        }

        @DisableTrace
        public String toString() {
            return "[" + this.source.getName() + " to " + this.target.getName() + "]";
        }

        static {
            try {
                $$$methodRef$$$1 = Key.class.getDeclaredConstructor(Class.class, Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Key.class.getDeclaredMethod("satisfies", Key.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

