/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;

public class Util {
    static short lastCsId;
    static CharacterSet lastCS;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Fri_Feb_28_06:24:14_PST_2025";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    public static Object convertToObject(Datum datum, int n2, Object object) throws SQLException {
        Object object2 = Util._convertToObject(datum, n2, object);
        return object2;
    }

    public static Object _convertToObject(Datum datum, int n2, Object object) throws SQLException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof STRUCT) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2002);
            }
            return ((CustomDatumFactory)object).create(datum, 2002);
        }
        if (datum instanceof REF) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2006);
            }
            return ((CustomDatumFactory)object).create(datum, 2006);
        }
        if (datum instanceof ARRAY) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2003);
            }
            return ((CustomDatumFactory)object).create(datum, 2003);
        }
        if (datum instanceof OPAQUE) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, 2007);
            }
            return ((CustomDatumFactory)object).create(datum, 2007);
        }
        if (object != null) {
            if (object instanceof ORADataFactory) {
                return ((ORADataFactory)object).create(datum, n2);
            }
            return ((CustomDatumFactory)object).create(datum, n2);
        }
        if (datum instanceof NUMBER) {
            if (n2 == 2 || n2 == 3) {
                return ((NUMBER)datum).bigDecimalValue();
            }
            if (n2 == 8 || n2 == 6) {
                return ((NUMBER)datum).doubleValue();
            }
            if (n2 == 4 || n2 == 5) {
                return ((NUMBER)datum).intValue();
            }
            if (n2 == 7) {
                return Float.valueOf(((NUMBER)datum).floatValue());
            }
            if (n2 == 16) {
                return ((NUMBER)datum).booleanValue();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.SEVERE, "         Throwing SQLException: 48 type: " + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 48, " type: " + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return datum.toJdbc();
    }

    public static Datum convertToOracle(Object object, Connection connection) throws SQLException {
        return Util.convertToOracle(object, connection, false);
    }

    public static Datum convertToOracle(Object object, Connection connection, boolean bl) throws SQLException {
        Datum datum = Util._convertToOracle(object, connection, bl);
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Datum _convertToOracle(Object object, Connection connection, boolean bl) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof ORAData) {
            return ((ORAData)object).toDatum(connection);
        }
        if (object instanceof CustomDatum) {
            return ((CustomDatum)object).toDatum((OracleConnection)connection);
        }
        if (object instanceof String) {
            short s2;
            short s3 = connection == null || !(connection instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (s2 = bl ? ((oracle.jdbc.internal.OracleConnection)connection).getNCharSet() : ((oracle.jdbc.internal.OracleConnection)connection).getDbCsId());
            if (s2 != lastCsId) {
                lastCsId = s2;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)object, lastCS);
        }
        if (object instanceof Character) {
            short s4;
            short s5 = s4 = connection == null || !(connection instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (short)((oracle.jdbc.internal.OracleConnection)connection).getDbCsId();
            if (s4 != lastCsId) {
                lastCsId = s4;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR(((Character)object).toString(), lastCS);
        }
        if (object instanceof BigDecimal) {
            return new NUMBER((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return new NUMBER((BigInteger)object);
        }
        if (object instanceof Double) {
            return new NUMBER((Double)object);
        }
        if (object instanceof Float) {
            return new NUMBER(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return new NUMBER((Integer)object);
        }
        if (object instanceof Boolean) {
            return new NUMBER((Boolean)object);
        }
        if (object instanceof Short) {
            return new NUMBER((Short)object);
        }
        if (object instanceof Byte) {
            return new NUMBER((Byte)object);
        }
        if (object instanceof Long) {
            return new NUMBER((Long)object);
        }
        if (object instanceof Timestamp) {
            return new TIMESTAMP((Timestamp)object);
        }
        if (object instanceof Date) {
            return new DATE((Date)object);
        }
        if (object instanceof java.util.Date) {
            return new DATE(new Date(((java.util.Date)object).getTime()));
        }
        if (object instanceof byte[]) {
            return new RAW((byte[])object);
        }
        if (object instanceof Datum) {
            return (Datum)object;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                Util.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 48");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(null, 48);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static boolean isMutable(Datum datum, ORADataFactory oRADataFactory) {
        if (datum == null) {
            return false;
        }
        return datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || oRADataFactory != null && (datum instanceof STRUCT || datum instanceof OPAQUE || datum instanceof ARRAY);
    }

    static boolean isMutable(Datum datum, CustomDatumFactory customDatumFactory) {
        if (datum == null) {
            return false;
        }
        return datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || customDatumFactory != null && (datum instanceof STRUCT || datum instanceof OPAQUE || datum instanceof ARRAY);
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jpub.runtime");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$9 = Util.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = Util.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Util.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Util.class.getDeclaredMethod("isMutable", Datum.class, CustomDatumFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Util.class.getDeclaredMethod("isMutable", Datum.class, ORADataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Util.class.getDeclaredMethod("_convertToOracle", Object.class, Connection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Util.class.getDeclaredMethod("convertToOracle", Object.class, Connection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Util.class.getDeclaredMethod("convertToOracle", Object.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Util.class.getDeclaredMethod("_convertToObject", Datum.class, Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Util.class.getDeclaredMethod("convertToObject", Datum.class, Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        lastCsId = (short)870;
        lastCS = CharacterSet.make(870);
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jpub.runtime.Util"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

