/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;
import oracle.sql.converter.CharacterSetMetaData;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class ClobAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;
    int[] prefetchedDataCharset;
    int[] prefetchedDataFormOfUse;
    private CharacterSet cachedCharSet = null;
    private CharacterSet ucs2CompatibleCharSet = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    ClobAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(s2 == 2 ? Representation.NCLOB : Representation.CLOB, oracleStatement, 4000, bl);
        this.init(oracleStatement, 112, 112, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    ClobAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(s2 == 2 ? Representation.NCLOB : Representation.CLOB, oracleStatement, 4000, false);
        this.init(oracleStatement, 112, 112, s2, false);
        this.initForDescribe(112, n2, bl, n3, n4, n5, l2, n6, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void setCapacity(int n2) {
        super.setCapacity(n2);
        if (this.prefetchedDataCharset == null) {
            this.prefetchedDataCharset = new int[n2];
            this.prefetchedDataFormOfUse = new int[n2];
        } else if (n2 > this.prefetchedDataCharset.length) {
            int[] nArray = new int[n2];
            System.arraycopy(this.prefetchedDataCharset, 0, nArray, 0, this.prefetchedDataCharset.length);
            this.prefetchedDataCharset = nArray;
            nArray = new int[n2];
            System.arraycopy(this.prefetchedDataFormOfUse, 0, nArray, 0, this.prefetchedDataFormOfUse.length);
            this.prefetchedDataFormOfUse = nArray;
        }
    }

    @Override
    void insertNull(int n2) throws SQLException {
        System.arraycopy(this.prefetchedDataCharset, n2, this.prefetchedDataCharset, n2 + 1, this.prefetchedDataCharset.length - n2 - 1);
        System.arraycopy(this.prefetchedDataFormOfUse, n2, this.prefetchedDataFormOfUse, n2 + 1, this.prefetchedDataFormOfUse.length - n2 - 1);
        super.insertNull(n2);
    }

    @Override
    Accessor copyForDefine(OracleStatement oracleStatement) {
        ClobAccessor clobAccessor = (ClobAccessor)super.copyForDefine(oracleStatement);
        clobAccessor.prefetchedDataCharset = null;
        clobAccessor.prefetchedDataFormOfUse = null;
        return clobAccessor;
    }

    @Override
    protected void copyFromInternal(Accessor accessor, int n2, int n3) throws SQLException {
        super.copyFromInternal(accessor, n2, n3);
        if (this.isPrefetched()) {
            ClobAccessor clobAccessor = (ClobAccessor)accessor;
            this.setPrefetchedDataCharset(n3, clobAccessor.getPrefetchedDataCharset(n2));
            this.setPrefetchedDataFormOfUse(n3, clobAccessor.getPrefetchedDataFormOfUse(n2));
        }
    }

    @Override
    void deleteRow(int n2) throws SQLException {
        super.deleteRow(n2);
        if (this.isPrefetched()) {
            this.delete(this.prefetchedDataCharset, n2);
            this.delete(this.prefetchedDataFormOfUse, n2);
        }
    }

    final int getPrefetchedDataCharset(int n2) {
        return this.prefetchedDataCharset[n2];
    }

    final void setPrefetchedDataCharset(int n2, int n3) {
        this.prefetchedDataCharset[n2] = n3;
    }

    final int getPrefetchedDataFormOfUse(int n2) {
        return this.prefetchedDataFormOfUse[n2];
    }

    final void setPrefetchedDataFormOfUse(int n2, int n3) {
        this.prefetchedDataFormOfUse[n2] = n3;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getCLOB(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    protected void normalizeFormOfUse(byte[] byArray) {
        short s2 = oracle.sql.CLOB.getFormOfUseFromLocator(byArray);
        if (s2 != -1) {
            this.formOfUse = s2;
        }
    }

    private CLOB getCLOB_(int n2, byte[] byArray) throws SQLException {
        CLOB cLOB = this.formOfUse == 1 ? new CLOB((OracleConnection)this.statement.connection, byArray, this.formOfUse) : new NCLOB(this.statement.connection, byArray);
        if (this.isPrefetched()) {
            cLOB.setActivePrefetch(true);
            cLOB.setLength(this.getPrefetchedLength(n2));
            cLOB.setChunkSize(this.getPrefetchedChunkSize(n2));
            if (this.getPrefetchLength() > -1 && this.getPrefetchedDataLength(n2) != 0) {
                int n3;
                boolean bl;
                CharacterSet characterSet = this.getPrefetchedDataCharacterSet(n2);
                if (characterSet.getOracleId() == 2000 || characterSet.getOracleId() == 2002) {
                    bl = true;
                    n3 = 2;
                } else {
                    bl = CharacterSetMetaData.isFixedWidth(characterSet.getOracleId());
                    n3 = CharacterSetMetaData.getRatio(characterSet.getOracleId(), 1);
                }
                if (this.getPrefetchedDataLength(n2) < 0) {
                    cLOB.setPrefetchData(OracleLargeObject.PrefetchData.wrapArray(new char[0], 0));
                } else if (bl || n3 == 1) {
                    cLOB.setPrefetchData(new PrefetchCharData(this.rowData, this.getPrefetchedDataOffset(n2), this.getPrefetchedDataLength(n2), characterSet, n3));
                    this.addPrefetchedLargeObject(n2, cLOB);
                } else {
                    int[] nArray = new int[1];
                    cLOB.setPrefetchData(OracleLargeObject.PrefetchData.wrapArray(this.getPrefetchedCharData(n2, nArray), nArray[0]));
                }
            } else {
                cLOB.setPrefetchData((OracleLargeObject.PrefetchData<char[]>)null);
            }
        }
        if (cLOB.isTemporary()) {
            this.statement.connection.addTemporaryLob(cLOB);
        }
        return cLOB;
    }

    @Override
    CLOB getCLOB(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        byte[] byArray = this.getBytesInternal(n2);
        this.normalizeFormOfUse(byArray);
        CLOB cLOB = this.getCLOB_(n2, byArray);
        return cLOB;
    }

    @Override
    NCLOB getNCLOB(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        byte[] byArray = this.getBytesInternal(n2);
        this.normalizeFormOfUse(byArray);
        if (this.formOfUse != 2) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
        }
        return (NCLOB)this.getCLOB_(n2, byArray);
    }

    final char[] XgetPrefetchedCharData(int n2, int[] nArray) throws SQLException {
        if (this.getPrefetchLength() == -1) {
            return null;
        }
        int n3 = -1;
        int n4 = this.getPrefetchedDataLength(n2);
        char[] cArray = new char[this.getPrefetchedDataLength(n2)];
        byte[] byArray = this.rowData.get(this.getPrefetchedDataOffset(n2), this.getPrefetchedDataLength(n2));
        if (this.getPrefetchedDataCharset(n2) != 0) {
            n3 = this.getPrefetchedDataCharset(n2) == 2000 ? CharacterSet.convertAL16UTF16BytesToJavaChars(byArray, 0, cArray, 0, n4, true) : CharacterSet.convertAL16UTF16LEBytesToJavaChars(byArray, 0, cArray, 0, n4, true);
        } else {
            int[] nArray2 = new int[]{n4};
            n3 = this.formOfUse == 1 ? this.statement.connection.conversion.CHARBytesToJavaChars(byArray, 0, cArray, 0, nArray2, cArray.length) : this.statement.connection.conversion.NCHARBytesToJavaChars(byArray, 0, cArray, 0, nArray2, cArray.length);
        }
        nArray[0] = n3;
        return cArray;
    }

    final CharacterSet getPrefetchedDataCharacterSet(int n2) {
        int n3 = this.getPrefetchedDataCharset(n2);
        if (n3 == 0) {
            return this.statement.connection.conversion.getCharacterSet((short)this.getPrefetchedDataFormOfUse(n2));
        }
        if (this.cachedCharSet == null || this.cachedCharSet.getOracleId() != n3) {
            this.cachedCharSet = CharacterSet.make(n3);
        }
        return this.cachedCharSet;
    }

    final char[] getPrefetchedCharData(int n2, int[] nArray) throws SQLException {
        if (this.getPrefetchLength() == -1) {
            return null;
        }
        return this.rowData.getChars(this.getPrefetchedDataOffset(n2), this.getPrefetchedDataLength(n2), this.getPrefetchedDataCharacterSet(n2), nArray);
    }

    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getAsciiStream(true);
    }

    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getCharacterStream();
    }

    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getAsciiStream();
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        if (this.isPrefetched() && this.getPrefetchedLength(n2) > Integer.MAX_VALUE) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        if (cLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(cLOB);
        }
        if (this.isPrefetched()) {
            if (this.statement.definedColumnSize != null && this.statement.definedColumnSize.length > n2 && this.getPrefetchedLength(n2) <= (long)this.statement.definedColumnSize[n2] && this.getPrefetchedDataCharset(n2) != 0) {
                if (this.ucs2CompatibleCharSet == null || this.ucs2CompatibleCharSet.getOracleId() != this.getPrefetchedDataCharset(n2)) {
                    this.ucs2CompatibleCharSet = this.getPrefetchedDataCharset(n2) == 2000 ? CharacterSet.make(2000) : CharacterSet.make(2002);
                }
                return this.rowData.getString(this.getPrefetchedDataOffset(n2), this.getPrefetchedDataLength(n2), this.ucs2CompatibleCharSet);
            }
            return cLOB.getSubString(1L, (int)this.getPrefetchedLength(n2));
        }
        return this.getStringNoPrefetch(n2);
    }

    String getStringNoPrefetch(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        Reader reader = cLOB.getCharacterStream();
        int n3 = cLOB.getBufferSize();
        int n4 = 0;
        StringWriter stringWriter = new StringWriter(n3);
        char[] cArray = new char[n3];
        try {
            while ((n4 = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n4);
            }
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        if (cLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(cLOB);
        }
        return stringWriter.getBuffer().substring(0);
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getBytes").fillInStackTrace();
    }

    @Override
    long updateChecksum(long l2, int n2) throws SQLException {
        this.unimpl("updateChecksum");
        return -1L;
    }

    static {
        try {
            $$$methodRef$$$27 = ClobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = ClobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ClobAccessor.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ClobAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ClobAccessor.class.getDeclaredMethod("getStringNoPrefetch", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ClobAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ClobAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ClobAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ClobAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ClobAccessor.class.getDeclaredMethod("getPrefetchedCharData", Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ClobAccessor.class.getDeclaredMethod("getPrefetchedDataCharacterSet", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ClobAccessor.class.getDeclaredMethod("XgetPrefetchedCharData", Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ClobAccessor.class.getDeclaredMethod("getNCLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ClobAccessor.class.getDeclaredMethod("getCLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ClobAccessor.class.getDeclaredMethod("getCLOB_", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ClobAccessor.class.getDeclaredMethod("normalizeFormOfUse", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ClobAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ClobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ClobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ClobAccessor.class.getDeclaredMethod("setPrefetchedDataFormOfUse", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ClobAccessor.class.getDeclaredMethod("getPrefetchedDataFormOfUse", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ClobAccessor.class.getDeclaredMethod("setPrefetchedDataCharset", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ClobAccessor.class.getDeclaredMethod("getPrefetchedDataCharset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ClobAccessor.class.getDeclaredMethod("deleteRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ClobAccessor.class.getDeclaredMethod("copyFromInternal", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ClobAccessor.class.getDeclaredMethod("copyForDefine", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ClobAccessor.class.getDeclaredMethod("insertNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ClobAccessor.class.getDeclaredMethod("setCapacity", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static final class PrefetchCharData
    implements OracleLargeObject.PrefetchData<char[]> {
        private final ByteArray byteArray;
        private final long offset;
        private final int length;
        private final CharacterSet characterSet;
        private final int characterWidth;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        private PrefetchCharData(ByteArray byteArray, long l2, int n2, CharacterSet characterSet, int n3) {
            this.byteArray = byteArray;
            this.offset = l2;
            this.length = n2;
            this.characterSet = characterSet;
            this.characterWidth = n3;
        }

        @Override
        public int copy(int n2, char[] cArray, int n3, int n4) {
            int n5 = Math.min(n4, this.length() - n2);
            if (n5 < 1) {
                return 0;
            }
            try {
                return this.byteArray.getChars(this.offset + (long)(n2 * this.characterWidth), n5 * this.characterWidth, this.characterSet, cArray, n3);
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException(sQLException);
            }
        }

        @Override
        public int length() {
            return this.length / this.characterWidth;
        }

        @Override
        public char[] share() {
            try {
                return this.byteArray.getChars(this.offset, this.length, this.characterSet);
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException(sQLException);
            }
        }

        static {
            try {
                $$$methodRef$$$6 = PrefetchCharData.class.getDeclaredConstructor(ByteArray.class, Long.TYPE, Integer.TYPE, CharacterSet.class, Integer.TYPE, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = PrefetchCharData.class.getDeclaredConstructor(ByteArray.class, Long.TYPE, Integer.TYPE, CharacterSet.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = PrefetchCharData.class.getDeclaredMethod("copy", Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = PrefetchCharData.class.getDeclaredMethod("share", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = PrefetchCharData.class.getDeclaredMethod("share", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = PrefetchCharData.class.getDeclaredMethod("length", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = PrefetchCharData.class.getDeclaredMethod("copy", Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

