/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import com.oracle.common.internal.net.ipclw.mql.LocalQueue;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.NetException;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
public class NTMQProtocolHandler {
    private ByteBuffer remoteQueueNameBuffer;
    private byte ntmqVersion;
    private byte msgqltProtocolType;
    private byte packetType = (byte)-1;
    private byte packetFlag = (byte)-1;
    private byte[] sessionIdentifier;
    private int tduMTUSize;
    private int headerPacketSize = 2;
    private short connectFlag;
    private short endianess;
    private short messageQueueLength;
    private boolean sendSessionIdentifier;
    private boolean sendSessionIdentifierIMD;
    private boolean rcvSessionIdentifier;
    private boolean rcvSessionIdentifierIMD;
    private boolean fcEnabled;
    private short fcInitialPostCount;
    private long remoteFcbAddr;
    private ByteBuffer remoteFcbKey;
    protected static final byte NTMQHTCN = 1;
    protected static final byte NTMQHTDC = 2;
    protected static final byte NTMQHTRF = 3;
    protected static final byte NTMQHTDA = 4;
    protected static final byte NTMQHTEO = 5;
    protected static final byte NTMQHTIR = 6;
    protected static final byte NTMQHTDI = 7;
    protected static final byte NTMQHFARQ = 1;
    protected static final byte NTMQHFARS = 2;
    protected static final byte NTMQHFSID = 4;
    protected static final byte NTMQHFPAD = 8;
    private static final short NTMQCFSI = 1;
    private static final short NTMQCFSIIMD = 2;
    private static final short NTMQ_BIG_ENDIAN = 1;
    private static final short NTMQ_LITTLE_ENDIAN = 256;
    protected static final byte NO_SID_HEADER_SIZE = 2;
    protected static final int SESSION_IDENTIFIER_SIZE = 16;
    protected static final byte WITH_SID_HEADER_SIZE = 18;
    protected static final int MIN_CONNECT_PACKET_SIZE = 28;
    protected static final int MIN_FLOW_CONTROL_PACKET_SIZE = 12;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;

    NTMQProtocolHandler(byte by, boolean bl, boolean bl2) {
        this.msgqltProtocolType = by;
        this.rcvSessionIdentifier = bl;
        this.rcvSessionIdentifierIMD = bl2;
    }

    protected byte getPacketType() {
        return this.packetType;
    }

    public void processNTMQPacket(ByteBuffer byteBuffer) throws NetException {
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.parseHeaderPacket(byteBuffer);
        if (this.packetType == 1) {
            this.parseConnectPacket(byteBuffer);
        } else if (this.packetType < 1 || this.packetType > 7) {
            throw new NetException(26);
        }
        byteBuffer.order(byteOrder);
    }

    protected void parseHeaderPacket(ByteBuffer byteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.packetType = byteBuffer.get();
        this.packetFlag = byteBuffer.get();
        byteBuffer.order(byteOrder);
    }

    protected void parseConnectPacket(ByteBuffer byteBuffer) {
        this.ntmqVersion = byteBuffer.get();
        this.msgqltProtocolType = byteBuffer.get();
        this.connectFlag = byteBuffer.getShort();
        if ((this.connectFlag & 1) != 0) {
            this.sendSessionIdentifier = true;
            this.headerPacketSize = 18;
        } else {
            this.sendSessionIdentifier = false;
            this.headerPacketSize = 2;
        }
        if ((this.connectFlag & 2) != 0) {
            this.sendSessionIdentifierIMD = true;
        }
        this.sessionIdentifier = new byte[16];
        byteBuffer.get(this.sessionIdentifier, 0, 16);
        this.tduMTUSize = byteBuffer.getInt();
        this.endianess = byteBuffer.getShort();
        this.messageQueueLength = byteBuffer.getShort();
        this.remoteQueueNameBuffer = ByteBuffer.allocate(this.messageQueueLength);
        byte[] byArray = new byte[this.messageQueueLength];
        this.remoteQueueNameBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.get(byArray, 0, this.messageQueueLength);
        this.remoteQueueNameBuffer.put(byArray);
        this.remoteQueueNameBuffer.flip();
        this.parseFlowControlPacket(byteBuffer);
    }

    protected void parseFlowControlPacket(ByteBuffer byteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte by = byteBuffer.get();
        boolean bl = this.fcEnabled = by != 0;
        if (this.fcEnabled) {
            int n2 = byteBuffer.get() & 0xFF;
            this.fcInitialPostCount = byteBuffer.getShort();
            this.remoteFcbAddr = byteBuffer.getLong();
            this.remoteFcbKey = ByteBuffer.allocateDirect(n2);
            this.remoteFcbKey.put(byteBuffer).flip();
        }
        byteBuffer.order(byteOrder);
    }

    protected void prepareConnectPacket(ByteBuffer byteBuffer, byte[] byArray, int n2, ByteOrder byteOrder, LocalQueue localQueue) {
        ByteBuffer byteBuffer2 = localQueue.getName().getBuffer();
        byteBuffer2.rewind();
        byteBuffer2.position(0);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put((byte)localQueue.getContext().getMajorVersion());
        byteBuffer.put(this.msgqltProtocolType);
        short s2 = 0;
        if (this.rcvSessionIdentifier) {
            s2 = (short)(s2 | 1);
        }
        if (this.rcvSessionIdentifierIMD) {
            s2 = (short)(s2 | 2);
        }
        byteBuffer.putShort(s2);
        if (byArray == null || byArray.length != 16) {
            if (this.rcvSessionIdentifier | this.rcvSessionIdentifierIMD) {
            }
            byArray = new byte[16];
            for (int i2 = 0; i2 < 16; ++i2) {
                byArray[i2] = 0;
            }
        }
        byteBuffer.put(byArray);
        byteBuffer.putInt(n2);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)byteBuffer2.limit());
        byteBuffer.put(byteBuffer2);
    }

    protected void appendFlowControlPacket(ByteBuffer byteBuffer, boolean bl, short s2, long l2, ByteBuffer byteBuffer2) {
        if (bl) {
            byteBuffer.put((byte)1);
            byteBuffer.put((byte)byteBuffer2.remaining());
            byteBuffer.putShort(s2);
            byteBuffer.putLong(l2);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(byteBuffer2);
        } else {
            int n2 = byteBuffer.remaining();
            byte[] byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = 0;
            }
            byteBuffer.put(byArray);
        }
        byteBuffer.flip();
    }

    protected int prepareHeaderPacket(ByteBuffer byteBuffer, byte by, byte by2, byte[] byArray, boolean bl) {
        boolean bl2;
        byteBuffer.rewind();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(by);
        boolean bl3 = bl2 = this.sendSessionIdentifier || bl && this.sendSessionIdentifierIMD;
        if (bl2) {
            by2 = (byte)(by2 | 4);
        }
        byteBuffer.put(by2);
        if (bl2 && byArray != null) {
            if (byArray.length != 16) {
            } else {
                byteBuffer.put(byArray);
            }
        }
        byteBuffer.flip();
        return byteBuffer.limit();
    }

    protected int getHeaderPacketSize() {
        return this.headerPacketSize;
    }

    protected boolean isConnectPacket() {
        return this.packetType == 1;
    }

    protected boolean isDataPacket() {
        return this.packetType == 4 || this.packetType == 7;
    }

    protected boolean isDisconnectPacket() {
        return this.packetType == 2;
    }

    public boolean isDataIRPacket() {
        return this.packetType == 7;
    }

    protected byte getPacketFlag() {
        return this.packetFlag;
    }

    protected ByteBuffer getRemoteQueueNameBuffer() {
        return this.remoteQueueNameBuffer;
    }

    protected int getTduMtu() {
        return this.tduMTUSize;
    }

    protected byte[] getSID() {
        return this.sessionIdentifier;
    }

    protected boolean isSIDRequiredForRqMsg() {
        return this.sendSessionIdentifier;
    }

    protected boolean isSIDRequiredForRdmaMsg() {
        return this.sendSessionIdentifierIMD;
    }

    protected boolean isFlowControlEnabled() {
        return this.fcEnabled;
    }

    protected short getFcPostCount() {
        return this.fcInitialPostCount;
    }

    protected long getFcAddr() {
        return this.remoteFcbAddr;
    }

    protected ByteBuffer getFcKey() {
        return this.remoteFcbKey;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$23 = NTMQProtocolHandler.class.getDeclaredConstructor(Byte.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$22 = NTMQProtocolHandler.class.getDeclaredMethod("getFcKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$21 = NTMQProtocolHandler.class.getDeclaredMethod("getFcAddr", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$20 = NTMQProtocolHandler.class.getDeclaredMethod("getFcPostCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$19 = NTMQProtocolHandler.class.getDeclaredMethod("isFlowControlEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$18 = NTMQProtocolHandler.class.getDeclaredMethod("isSIDRequiredForRdmaMsg", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$17 = NTMQProtocolHandler.class.getDeclaredMethod("isSIDRequiredForRqMsg", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$16 = NTMQProtocolHandler.class.getDeclaredMethod("getSID", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$15 = NTMQProtocolHandler.class.getDeclaredMethod("getTduMtu", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$14 = NTMQProtocolHandler.class.getDeclaredMethod("getRemoteQueueNameBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$13 = NTMQProtocolHandler.class.getDeclaredMethod("getPacketFlag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$12 = NTMQProtocolHandler.class.getDeclaredMethod("isDataIRPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$11 = NTMQProtocolHandler.class.getDeclaredMethod("isDisconnectPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$10 = NTMQProtocolHandler.class.getDeclaredMethod("isDataPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$9 = NTMQProtocolHandler.class.getDeclaredMethod("isConnectPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$8 = NTMQProtocolHandler.class.getDeclaredMethod("getHeaderPacketSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$7 = NTMQProtocolHandler.class.getDeclaredMethod("prepareHeaderPacket", ByteBuffer.class, Byte.TYPE, Byte.TYPE, byte[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$6 = NTMQProtocolHandler.class.getDeclaredMethod("appendFlowControlPacket", ByteBuffer.class, Boolean.TYPE, Short.TYPE, Long.TYPE, ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$5 = NTMQProtocolHandler.class.getDeclaredMethod("prepareConnectPacket", ByteBuffer.class, byte[].class, Integer.TYPE, ByteOrder.class, LocalQueue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$4 = NTMQProtocolHandler.class.getDeclaredMethod("parseFlowControlPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$3 = NTMQProtocolHandler.class.getDeclaredMethod("parseConnectPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$2 = NTMQProtocolHandler.class.getDeclaredMethod("parseHeaderPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$1 = NTMQProtocolHandler.class.getDeclaredMethod("processNTMQPacket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
        try {
            $$$methodRef$$$0 = NTMQProtocolHandler.class.getDeclaredMethod("getPacketType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net");
    }
}

