/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OsonBuffer;

public class OsonHeader {
    private static byte[][] UTF8_MAPPING;
    int version;
    int flags;
    int[] fieldNameOffsets;
    int[] hashIdArray;
    String[] fieldNames;
    int ubHash;
    int ubFieldId;
    int fieldHeapSize;
    int treeSegmentSize;
    int treeSegmentOffset;
    int tinyNodeCount;
    int updateFlags;
    int extendedTreeSegmentOffset;
    Map<Integer, Integer> forwardingAddress;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public OsonHeader(OsonBuffer osonBuffer, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        int n2;
        this.readHeader(osonBuffer, exceptionFactory);
        if (this.isScalar()) {
            this.treeSegmentOffset = osonBuffer.position();
            return;
        }
        this.readHashIds(osonBuffer, exceptionFactory);
        if (this.isSet(2048)) {
            this.ub4int(osonBuffer, this.fieldNameOffsets);
        } else {
            this.ub2(osonBuffer, this.fieldNameOffsets);
        }
        int n3 = osonBuffer.position();
        if (this.fieldNameOffsets.length > 0) {
            this.treeSegmentOffset = -1;
            for (n2 = 0; n2 < this.fieldNameOffsets.length; ++n2) {
                osonBuffer.position(this.fieldNameOffsets[n2] + n3);
                int n4 = osonBuffer.getUB1();
                this.fieldNames[n2] = osonBuffer.readString(n4);
                if (osonBuffer.position() <= this.treeSegmentOffset) continue;
                this.treeSegmentOffset = osonBuffer.position();
            }
        } else {
            this.treeSegmentOffset = osonBuffer.position();
        }
        if (!this.isSet(4) || !this.isSet(2) || this.isSet(1)) {
            throw new UnsupportedOperationException();
        }
        n2 = this.treeSegmentOffset + this.treeSegmentSize;
        if (n2 < osonBuffer.buffer().limit()) {
            osonBuffer.position(n2);
            this.readUpdateHeader(osonBuffer, exceptionFactory);
        }
    }

    public void readHeader(OsonBuffer osonBuffer, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        if (osonBuffer.buffer().remaining() <= 6) {
            throw OracleJsonExceptions.CORRUPT2.create(exceptionFactory, osonBuffer.buffer().remaining());
        }
        int n2 = osonBuffer.getInt();
        if ((n2 & 0xFFFFFF00) != -11904512) {
            throw OracleJsonExceptions.CORRUPT.create(exceptionFactory, new Object[0]);
        }
        this.version = n2 & 0xFF;
        if (this.version < 1 || this.version > 2) {
            throw OracleJsonExceptions.UNSUPPORTED_VERSION.create(exceptionFactory, this.version);
        }
        this.flags = osonBuffer.getUB2();
        if (!this.isSet(16)) {
            int n3;
            if (this.isSet(8)) {
                this.ubFieldId = 4;
                n3 = osonBuffer.getUB4int();
            } else if (this.isSet(1024)) {
                this.ubFieldId = 2;
                n3 = osonBuffer.getUB2();
            } else {
                this.ubFieldId = 1;
                n3 = osonBuffer.getUB1();
            }
            this.fieldNameOffsets = new int[n3];
            this.hashIdArray = new int[n3];
            this.fieldNames = new String[n3];
            this.fieldHeapSize = this.isSet(2048) ? osonBuffer.getUB4int() : osonBuffer.getUB2();
            this.treeSegmentSize = this.isSet(4096) ? osonBuffer.getUB4int() : osonBuffer.getUB2();
            this.tinyNodeCount = osonBuffer.getUB2();
        } else {
            this.treeSegmentSize = this.isSet(4096) ? osonBuffer.getUB4int() : osonBuffer.getUB2();
        }
    }

    private void readUpdateHeader(OsonBuffer osonBuffer, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        this.updateFlags = osonBuffer.getUB2();
        int n2 = osonBuffer.getUB2();
        osonBuffer.getUB4int();
        int n3 = osonBuffer.getUB4int();
        osonBuffer.getUB4int();
        this.extendedTreeSegmentOffset = osonBuffer.position() + n3;
        this.forwardingAddress = new HashMap<Integer, Integer>();
        if (this.isSetUpd(256)) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.forwardingAddress.put(osonBuffer.getUB2(), osonBuffer.getUB2());
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                this.forwardingAddress.put(osonBuffer.getUB4int(), osonBuffer.getUB4int());
            }
        }
    }

    public boolean isScalar() {
        return this.isSet(16);
    }

    public boolean isTinyNodeCount() {
        return this.isSet(8192);
    }

    public void readHashIds(OsonBuffer osonBuffer, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        if (this.isSet(256)) {
            this.ubHash = 1;
            this.ub1(osonBuffer, this.hashIdArray);
        } else {
            if (this.hashIdArray.length != 0) {
                throw OracleJsonExceptions.NOT_IMPLEMENTED.create(exceptionFactory, new Object[0]);
            }
            this.ubHash = 1;
        }
    }

    private void ub1(OsonBuffer osonBuffer, int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = osonBuffer.getUB1();
        }
    }

    private void ub2(OsonBuffer osonBuffer, int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = osonBuffer.getUB2();
        }
    }

    private void ub4int(OsonBuffer osonBuffer, int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = osonBuffer.getUB4int();
        }
    }

    public int getTreeSegmentOffset() {
        return this.treeSegmentOffset;
    }

    public int getFieldHeapSize() {
        return this.fieldHeapSize;
    }

    public String[] getFields() {
        return this.fieldNames;
    }

    public int[] hashIds() {
        return this.hashIdArray;
    }

    private boolean isSet(int n2) {
        return (this.flags & n2) != 0;
    }

    private boolean isSetUpd(int n2) {
        return (this.updateFlags & n2) != 0;
    }

    public boolean fieldsSorted() {
        return !this.isSet(32768);
    }

    public int getFieldId(String string) {
        int n2 = this.ohash(string);
        int n3 = Arrays.binarySearch(this.hashIdArray, n2);
        if (n3 < 0) {
            return -1;
        }
        while (n3 > 0 && this.hashIdArray[n3 - 1] == n2) {
            --n3;
        }
        do {
            if (!this.fieldNames[n3].equals(string)) continue;
            return n3 + 1;
        } while (++n3 < this.hashIdArray.length && this.hashIdArray[n3] == n2);
        return -1;
    }

    public int ohash(String string) {
        if (this.ubHash == 1) {
            return OsonHeader.ub1hash(string);
        }
        throw new IllegalStateException(OracleJsonExceptions.NOT_IMPLEMENTED.getMessage(new Object[0]));
    }

    public static int ub1hash(String string) {
        long l2 = 2166136261L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                l2 = (l2 ^ (long)UTF8_MAPPING[c2][0]) * 16777619L;
                continue;
            }
            if (c2 < '\u0100') {
                l2 = (l2 ^ (long)UTF8_MAPPING[c2][0]) * 16777619L;
                l2 = (l2 ^ (long)UTF8_MAPPING[c2][1]) * 16777619L;
                continue;
            }
            int n2 = string.codePointAt(i2);
            if (Character.charCount(n2) == 2) {
                ++i2;
            }
            String string2 = new String(Character.toChars(n2));
            byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                l2 = (l2 ^ (long)byArray[i3]) * 16777619L;
            }
        }
        long l3 = l2 << 24 & 0xFF000000L | l2 << 8 & 0xFF0000L | l2 >> 8 & 0xFF00L | l2 >> 24 & 0xFFL;
        return (int)((0xFFFFFFFFFF000000L & l3) >> 24);
    }

    public int numFieldIdBytes() {
        return this.ubFieldId;
    }

    static {
        try {
            $$$methodRef$$$19 = OsonHeader.class.getDeclaredConstructor(OsonBuffer.class, OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OsonHeader.class.getDeclaredMethod("numFieldIdBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonHeader.class.getDeclaredMethod("ub1hash", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonHeader.class.getDeclaredMethod("ohash", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonHeader.class.getDeclaredMethod("getFieldId", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonHeader.class.getDeclaredMethod("fieldsSorted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonHeader.class.getDeclaredMethod("isSetUpd", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonHeader.class.getDeclaredMethod("isSet", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonHeader.class.getDeclaredMethod("hashIds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonHeader.class.getDeclaredMethod("getFields", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonHeader.class.getDeclaredMethod("getFieldHeapSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonHeader.class.getDeclaredMethod("getTreeSegmentOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonHeader.class.getDeclaredMethod("ub4int", OsonBuffer.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonHeader.class.getDeclaredMethod("ub2", OsonBuffer.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonHeader.class.getDeclaredMethod("ub1", OsonBuffer.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonHeader.class.getDeclaredMethod("readHashIds", OsonBuffer.class, OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonHeader.class.getDeclaredMethod("isTinyNodeCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonHeader.class.getDeclaredMethod("isScalar", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonHeader.class.getDeclaredMethod("readUpdateHeader", OsonBuffer.class, OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonHeader.class.getDeclaredMethod("readHeader", OsonBuffer.class, OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        UTF8_MAPPING = new byte[256][];
        for (int i2 = 0; i2 < UTF8_MAPPING.length; ++i2) {
            OsonHeader.UTF8_MAPPING[i2] = new String(new char[]{(char)i2}).getBytes(StandardCharsets.UTF_8);
        }
    }
}

