/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.cam.metrics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.cam.metrics.DmsChannel;
import oracle.dms.util.CommandInfo;
import weblogic.nodemanager.plugin.InvocationPlugin;
import weblogic.nodemanager.plugin.Provider;

public class DmsMetricPlugin
implements InvocationPlugin {
    private Provider m_provider;
    private DmsChannel m_channel;
    private String m_componentType;
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.cam");

    public DmsMetricPlugin(String serverType, DmsChannel channel) {
        if (serverType == null || serverType.length() == 0) {
            throw new IllegalArgumentException("Empty serverType");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Null DmsChannel");
        }
        this.m_channel = channel;
        this.m_componentType = serverType;
    }

    public void init(Provider provider) {
        if (provider != null) {
            this.m_provider = provider;
            this.m_channel.setProvider(provider);
        }
    }

    public void invocationRequest(String[] commands, OutputStream out) throws IOException {
        String METHOD_NAME = "invocationRequest";
        if (out == null) {
            return;
        }
        CommandInfo command = CommandInfo.parseCommand(commands);
        if (command == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, this.getClass().getName(), "invocationRequest", "Invalid request: " + commands == null ? "null" : Arrays.asList(commands).toString());
            }
            return;
        }
        String queryString = command.getQueryString();
        String serverName = command.getServerName();
        InputStream inst = null;
        try {
            inst = this.m_channel.getInputStream(serverName, queryString);
            int debugBufLen = 0;
            byte[] debugBuf = null;
            int buflen = 4096;
            if (LOGGER.isLoggable(Level.FINEST)) {
                debugBuf = new byte[4096];
            }
            byte[] buf = new byte[4096];
            int len = -1;
            do {
                len = inst.read(buf, 0, 4096);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    if (debugBufLen + len > debugBuf.length) {
                        byte[] newBuf = new byte[debugBuf.length * 2];
                        System.arraycopy(debugBuf, 0, newBuf, 0, len);
                        debugBuf = newBuf;
                    }
                    System.arraycopy(buf, 0, debugBuf, debugBufLen, len);
                    debugBufLen += len;
                }
                if (len <= 0) continue;
                out.write(buf, 0, len);
            } while (len != -1);
            out.flush();
            if (LOGGER.isLoggable(Level.FINEST) && debugBuf.length > 0) {
                LOGGER.logp(Level.FINEST, this.getClass().getName(), "invocationRequest", new String(debugBuf, 0, debugBufLen));
            }
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, this.getClass().getName(), "invocationRequest", "Exception when processing request: " + command + " serverName=" + serverName, ioe);
            }
            throw ioe;
        }
        finally {
            block20: {
                if (inst != null) {
                    try {
                        inst.close();
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block20;
                        LOGGER.logp(Level.FINE, this.getClass().getName(), "invocationRequest", "Exception closing metric dump stream", ioe);
                    }
                }
            }
        }
    }
}

