/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.instrument.Bucket;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.StateIntf;
import oracle.dms.instrument.state.AnyValue;
import oracle.dms.instrument.state.DoubleValue;
import oracle.dms.instrument.state.IntegerValue;
import oracle.dms.instrument.state.LongValue;
import oracle.dms.instrument.state.ObjectValue;
import oracle.dms.instrument.state.Value;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;

public class State
extends Sensor
implements StateIntf {
    private int _updateCount;
    private Value _value;
    private String _units;
    private static final byte ANY = 0;
    public static final byte DOUBLE = 1;
    public static final byte LONG = 2;
    public static final byte INTEGER = 3;
    public static final byte OBJECT = 5;
    private static final byte _minType = 1;
    private static final byte _maxType = 5;
    private byte _type = 0;
    private boolean _initialized = false;
    private boolean _isBucketed = false;
    private static final String JDBC_STATEMENT = "JDBC_Statement";

    private State(boolean sanitizedName, Noun parent, String name, byte valueType, String units, String desc) {
        super(sanitizedName, parent, name, desc);
        this._units = DMSUtil.sanitize(units, 99, true, false);
        this._type = valueType;
        switch (valueType) {
            case 3: {
                this._value = new IntegerValue();
                break;
            }
            case 2: {
                this._value = new LongValue();
                break;
            }
            case 1: {
                this._value = new DoubleValue();
                break;
            }
            case 5: {
                this._value = new ObjectValue();
                break;
            }
            case 0: {
                this._value = new AnyValue();
                this._type = 0;
            }
        }
        this.setUpdateTime(0L);
        this._isBucketed = Bucket.isBucketed(this);
        if (this._type != 0) {
            this._metrics[0] = Metric.create(this._name + ".value", this._description, this._units, this, false, this._type, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static State makeState(Noun parent, String name, byte valueType, String units, String desc) {
        EventReportingManager eMgr;
        State st = null;
        String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
        if (valueType < 1 || valueType > 5) {
            valueType = 0;
        }
        boolean newState = false;
        Noun noun = parent;
        synchronized (noun) {
            st = (State)parent.getSensor(sanitizedName);
            if (st == null) {
                st = new State(false, parent, sanitizedName, valueType, units, desc);
                newState = true;
            }
        }
        if (newState && (eMgr = EventSystem.getEventReportingManager()) != null && parent.getDescriptor() != null && parent.getDescriptor().getEventable(EventActionType.CREATE)) {
            eMgr.reportEvent(st, EventSourceType.STATE_SENSOR, EventActionType.CREATE, st.mCreateTime, null, new Object[0]);
        }
        return st;
    }

    private static State getState(String pathname, byte valueType, String units, String desc) {
        State st = (State)Sensor.lookupCache(pathname);
        if (st != null) {
            return st;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        st = State.makeState(parent, name, valueType, units, desc);
        st.addToCache(pathname);
        return st;
    }

    public static State create(Noun parent, String name, byte valueType, String units, String desc) {
        if (name == null || name.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + name + ":" + units + ":" + desc);
        }
        if (valueType < 1 || valueType > 5) {
            throw new InstrumentationException("DMS-50753");
        }
        return State.makeState(parent, name, valueType, units, desc);
    }

    public static State create(String pathname, byte valueType, String units, String desc) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + pathname + ":" + units + ":" + desc);
        }
        if (valueType < 1 || valueType > 5) {
            throw new InstrumentationException("DMS-50753");
        }
        return State.getState(pathname, valueType, units, desc);
    }

    @Deprecated
    public static State create(String pathname, String units, String desc, int init) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + pathname + ":" + units + ":" + desc);
        }
        State st = State.getState(pathname, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)3, init);
        }
        return st;
    }

    @Deprecated
    public static State create(String pathname, String units, String desc, long init) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + pathname + ":" + units + ":" + desc);
        }
        State st = State.getState(pathname, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)2, init);
        }
        return st;
    }

    @Deprecated
    public static State create(String pathname, String units, String desc, double init) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + pathname + ":" + units + ":" + desc);
        }
        State st = State.getState(pathname, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)1, init);
        }
        return st;
    }

    @Deprecated
    public static State create(String pathname, String units, String desc, Object init) {
        if (pathname == null || pathname.length() == 0 || desc == null || units == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + pathname + ":" + units + ":" + desc);
        }
        State st = State.getState(pathname, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)5, init);
        }
        return st;
    }

    @Deprecated
    public static State create(Noun parent, String name, String units, String desc, int init) {
        if (parent == null || name == null || units == null || desc == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + parent + ":" + name + ":" + units + ":" + desc);
        }
        State st = State.makeState(parent, name, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)3, init);
        }
        return st;
    }

    @Deprecated
    public static State create(Noun parent, String name, String units, String desc, long init) {
        if (parent == null || name == null || units == null || desc == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + parent + ":" + name + ":" + units + ":" + desc);
        }
        State st = State.makeState(parent, name, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)2, init);
        }
        return st;
    }

    @Deprecated
    public static State create(Noun parent, String name, String units, String desc, double init) {
        if (parent == null || name == null || units == null || desc == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + parent + ":" + name + ":" + units + ":" + desc);
        }
        State st = State.makeState(parent, name, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)1, init);
        }
        return st;
    }

    @Deprecated
    public static State create(Noun parent, String name, String units, String desc, Object init) {
        if (parent == null || name == null || units == null || desc == null) {
            throw new InstrumentationException("DMS-50752", "State.create()", "" + parent + ":" + name + ":" + units + ":" + desc);
        }
        State st = State.makeState(parent, name, (byte)0, units, desc);
        if (!st.isInitialized()) {
            st.initialize((byte)5, init);
        }
        return st;
    }

    @Deprecated
    public State(Noun parent, String name, String units, String desc, int init) {
        this(true, parent, name, 0, units, desc);
        this.initialize((byte)3, init);
    }

    @Deprecated
    public State(Noun parent, String name, String units, String desc, long init) {
        this(true, parent, name, 0, units, desc);
        this.initialize((byte)2, init);
    }

    @Deprecated
    public State(Noun parent, String name, String units, String desc, double init) {
        this(true, parent, name, 0, units, desc);
        this.initialize((byte)1, init);
    }

    @Deprecated
    public State(Noun parent, String name, String units, String desc, Object init) {
        this(true, parent, name, 0, units, desc);
        this.initialize((byte)5, init);
    }

    private void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.setInitialized(true);
        if (this._metrics[0] != null) {
            return;
        }
        switch (this._type) {
            case 1: 
            case 2: 
            case 3: {
                this._metrics[0] = Metric.create(this._name + ".value", this._description, this._units, this, false, this._type, (byte)0);
                break;
            }
            case 5: {
                this._metrics[0] = Metric.create(this._name + ".value", this._description, this._units, this, false, (byte)4, (byte)0);
            }
        }
    }

    private void initialize(byte valueType, Object init) {
        if (this.isInitialized() || this._type != 0) {
            return;
        }
        this.setInitialized(true);
        this.setUpdateTime();
        this._value = new AnyValue();
        switch (valueType) {
            case 3: {
                this._value.update((Integer)init);
                this._metrics[0] = Metric.create(this._name + ".value", this._description, this._units, this, false, (byte)3, (byte)0);
                break;
            }
            case 2: {
                this._value.update((Long)init);
                this._metrics[0] = Metric.create(this._name + ".value", this._description, this._units, this, false, (byte)2, (byte)0);
                break;
            }
            case 1: {
                this._value.update((Double)init);
                this._metrics[0] = Metric.create(this._name + ".value", this._description, this._units, this, false, (byte)1, (byte)0);
                break;
            }
            default: {
                if (init instanceof String && JDBC_STATEMENT.equals(this.getParent().getType()) && init.equals("null")) {
                    init = "";
                }
                this._value.update(init);
                this._metrics[0] = Metric.create(this._name + ".value", this._description, this._units, this, false, (byte)4, (byte)0);
            }
        }
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null && this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.CREATE)) {
            eMgr.reportEvent(this, EventSourceType.STATE_SENSOR, EventActionType.CREATE, this.mCreateTime, null, new Object[]{init});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deriveMetric(int metric) {
        EventReportingManager eMgr;
        boolean derived = false;
        State state = this;
        synchronized (state) {
            if (!this.isAlive()) {
                return;
            }
            this._value.deriveMetric(metric);
            if ((metric & 2) > 0 && this._metrics[1] == null) {
                this._metrics[1] = Metric.create(this._name + ".count", this._description, "ops", this, false, (byte)3, (byte)1);
                derived = true;
            }
            byte valueType = this._type;
            switch (this._type) {
                case 0: {
                    Object val = this._value.getValue();
                    if (!(val instanceof Number)) break;
                    valueType = 1;
                }
                case 1: 
                case 2: 
                case 3: {
                    if ((metric & 8) > 0 && this._metrics[3] == null) {
                        this._metrics[3] = Metric.create(this._name + ".maxValue", this._description, this._units, this, false, valueType, (byte)3);
                        derived = true;
                    }
                    if ((metric & 4) <= 0 || this._metrics[2] != null) break;
                    this._metrics[2] = Metric.create(this._name + ".minValue", this._description, this._units, this, false, valueType, (byte)2);
                    derived = true;
                }
            }
            if (derived && this.isInitialized()) {
                this.setUpdateTime();
            }
        }
        if (derived && this.isInitialized()) {
            this.setUpdateTime();
        }
        if (derived && (eMgr = EventSystem.getEventReportingManager()) != null && this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.METRIC_SELECTION_CHANGED)) {
            eMgr.reportEvent(this, EventSourceType.STATE_SENSOR, EventActionType.METRIC_SELECTION_CHANGED, this._lastUpdate, null, null);
        }
    }

    public static void update(String name, int newval) {
        State state = (State)Sensor.get(name);
        if (state != null) {
            state.update(newval);
        }
    }

    public static void update(String name, long newval) {
        State state = (State)Sensor.get(name);
        if (state != null) {
            state.update(newval);
        }
    }

    public static void update(String name, double newval) {
        State state = (State)Sensor.get(name);
        if (state != null) {
            state.update(newval);
        }
    }

    public static void update(String name, Object newval) {
        State state = (State)Sensor.get(name);
        if (state != null) {
            state.update(newval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int newval) {
        if (!this._alive) {
            return;
        }
        long time = Time.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(newval);
            this.updateAdmin(time);
        }
        this.updateAdmin2(newval, 0L, 0.0, null);
        if (this.isLoggable()) {
            this.logActivation(newval + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(long newval) {
        if (!this._alive) {
            return;
        }
        long time = Time.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(newval);
            this.updateAdmin(time);
        }
        this.updateAdmin2(0, newval, 0.0, null);
        if (this.isLoggable()) {
            this.logActivation(newval + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(double newval) {
        if (!this._alive) {
            return;
        }
        long time = Time.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(newval);
            this.updateAdmin(time);
        }
        this.updateAdmin2(0, 0L, newval, null);
        if (this.isLoggable()) {
            this.logActivation(newval + " " + this._units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Object newval) {
        if (!this._alive) {
            return;
        }
        long time = Time.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.update(newval);
            this.updateAdmin(time);
        }
        this.updateAdmin2(0, 0L, 0.0, newval);
        if (this.isLoggable()) {
            this.logActivation(newval + " " + this._units);
        }
    }

    private void updateAdmin(long time) {
        if (!this.isInitialized() && this._type != 0) {
            this.initialize();
        }
        this.setUpdateTime(time);
        ++this._updateCount;
    }

    private void updateAdmin2(int intValue, long longValue, double doubleValue, Object objectValue) {
        EventReportingManager eMgr;
        if (this._refresh == null && (eMgr = EventSystem.getEventReportingManager()) != null && this.getParent().getDescriptor() != null && this.getParent().getDescriptor().getEventable(EventActionType.UPDATE)) {
            Object[] objectArray;
            Object value = null;
            if (objectValue != null) {
                value = objectValue;
            } else {
                switch (this._type) {
                    case 1: {
                        value = doubleValue;
                        break;
                    }
                    case 3: {
                        value = intValue;
                        break;
                    }
                    case 2: {
                        value = longValue;
                        break;
                    }
                    default: {
                        value = objectValue;
                    }
                }
            }
            if (value == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            }
            eMgr.reportEvent(this, EventSourceType.STATE_SENSOR, EventActionType.UPDATE, this.mCreateTime, null, objectArray);
        }
    }

    @Override
    EventSourceType getSourceType() {
        return EventSourceType.STATE_SENSOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(int inc) {
        Object valueAfterThisUpdate = null;
        if (!this._alive) {
            return;
        }
        long time = Time.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(inc);
            valueAfterThisUpdate = this._value.getValue();
            this.updateAdmin(time);
        }
        this.updateAdmin2(0, 0L, 0.0, valueAfterThisUpdate);
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
        Bucket.drop((Sensor)this, inc, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(long inc) {
        Object valueAfterThisUpdate = null;
        if (!this._alive) {
            return;
        }
        long time = Time.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(inc);
            valueAfterThisUpdate = this._value.getValue();
            this.updateAdmin(time);
        }
        this.updateAdmin2(0, 0L, 0.0, valueAfterThisUpdate);
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
        if (this._isBucketed) {
            Bucket.drop((Sensor)this, inc, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(double inc) {
        Object valueAfterThisUpdate = null;
        if (!this._alive) {
            return;
        }
        long time = Time.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._value.increment(inc);
            valueAfterThisUpdate = this._value.getValue();
            this.updateAdmin(time);
        }
        this.updateAdmin2(0, 0L, 0.0, valueAfterThisUpdate);
        if (this.isLoggable()) {
            this.logActivation(this._value.getValue() + " " + this._units);
        }
        Bucket.drop((Sensor)this, inc, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Metric m) {
        if (m == null) {
            throw new InstrumentationException("DMS-50750");
        }
        if (!m.isAlive()) {
            return new ErrorObject();
        }
        byte index = m.getIndex();
        if (this._metrics[index] != m) {
            throw new InstrumentationException("DMS-50751", m.toString(), this.toString());
        }
        State state = this;
        synchronized (state) {
            if (!this.isAlive()) {
                return new ErrorObject();
            }
            switch (index) {
                case 1: {
                    return this._updateCount;
                }
                case 2: {
                    return this._value.getMin();
                }
                case 3: {
                    return this._value.getMax();
                }
                case 0: {
                    return this._value.getValue();
                }
            }
        }
        throw new InstrumentationException("DMS-50751", m.toString(), this.toString());
    }

    public Value getClonedValue() {
        return this._value != null ? (Value)this._value.clone() : this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (!this._alive) {
            return;
        }
        long timeStamp = Time.currentTimeMillis();
        State state = this;
        synchronized (state) {
            this._updateCount = 0;
            this._value.reset();
            this.setUpdateTime(timeStamp);
            this.setResetTime(timeStamp);
            this.setInitialized(false);
        }
    }

    public State getCousin(Noun pre) {
        if (!this._alive) {
            return null;
        }
        State retval = null;
        Noun cousinNoun = this.getParent().getCousin(pre);
        if (cousinNoun != null) {
            retval = State.create(cousinNoun, this._name, this._units, "cousin", this._value);
        }
        return retval;
    }

    @Override
    public void setCopy(boolean copy) {
        this._value.setCopy(copy);
    }

    @Override
    public byte getValueType() {
        return this._type;
    }

    synchronized void setInitialized(boolean init) {
        this._initialized = init;
    }

    @Override
    public boolean isInitialized() {
        return this._initialized;
    }

    @Override
    public String getValueTypeString() {
        switch (this._type) {
            case 1: {
                return "State.DOUBLE";
            }
            case 3: {
                return "State.INTEGER";
            }
            case 2: {
                return "State.LONG";
            }
            case 5: {
                return "State.OBJECT";
            }
        }
        return "State.ANY";
    }
}

