/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal;

import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.dms.context.ContextComponentsFactory;
import oracle.dms.context.ExecutionContextComponents;

public class ContextComponentsFactoryImpl
implements ContextComponentsFactory {
    @Override
    public ExecutionContextComponents buildExecutionContextComponents(String ECID, String RIDasString, Map<String, String> globalValues, Map<String, String> localValues, Map<Integer, Set<String>> keys, Level logLevel) {
        if (ECID == null) {
            throw new IllegalArgumentException("Can not create instance of ExecutionContextComponents if provided ECID is null.");
        }
        return new ExecutionContextComponentsImpl(ECID, RIDasString, globalValues, localValues, keys, logLevel);
    }

    private static class ExecutionContextComponentsImpl
    implements ExecutionContextComponents {
        String mECID;
        String mRIDasString;
        Set<String> mLogKeys;
        Level mLogLevel;
        Map<Integer, Set<String>> mKeys;
        Map<String, String> mGlobalMap;
        Map<String, String> mLocalMap;

        private ExecutionContextComponentsImpl(String ECID, String RIDasString, Map<String, String> globalValues, Map<String, String> localValues, Map<Integer, Set<String>> keys, Level logLevel) {
            this.mECID = ECID;
            this.mRIDasString = RIDasString;
            this.mGlobalMap = globalValues;
            this.mLocalMap = localValues;
            this.mKeys = keys;
            this.mLogLevel = logLevel;
        }

        @Override
        public String getECID() {
            return this.mECID;
        }

        @Override
        public String getRIDasString() {
            return this.mRIDasString;
        }

        public Set<String> getLogKeys() {
            return this.mLogKeys;
        }

        @Override
        public Level getLogLevel() {
            return this.mLogLevel;
        }

        @Override
        public Set<String> getKeys(int keyProperty) {
            Set<String> retVal = this.mKeys == null ? null : this.mKeys.get(keyProperty);
            return retVal;
        }

        @Override
        public Map<String, String> getGlobalMap() {
            return this.mGlobalMap;
        }

        @Override
        public Map<String, String> getLocalMap() {
            return this.mLocalMap;
        }
    }
}

