/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.DMSFileUtil;
import oracle.dms.instrument.DumpFilenameFilter;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDumpListener;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.State;
import oracle.dms.util.Time;

class NounDumperThread
extends Thread {
    static final String DUMP_INFO_NOUN_NAME = "/DMS-Internal/Trace/NounDumpInfo";
    static final String NEXT_DUMP_TIME_SENSOR_NAME = "nextDumpTime";
    static final String DMSDUMP_PREFIX = "dmsDump_";
    static final String DMSDUMP_SUFFIX = ".xml";
    private Noun _noun = null;
    private long _interval = 0L;
    private String _dest = null;
    private int _maxDumps = 0;
    private NounDumpListener _lsnr = null;
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.instrument", "oracle.dms.util.dms");
    private PhaseEvent _dumpPhase = null;
    private State _prevDumpState = null;
    private State _nextDumpState = null;
    private State _destState = null;
    private State _intervalState = null;
    private State _maxDumpsState = null;

    NounDumperThread(Noun n, int interval, String dest, int max, NounDumpListener lsnr) {
        this._noun = n;
        this._interval = interval * 1000;
        this._dest = dest;
        this._maxDumps = max;
        this._lsnr = lsnr;
        Noun diNoun = Noun.create(DUMP_INFO_NOUN_NAME, "dms_dumpInfo");
        this._dumpPhase = PhaseEvent.create(diNoun, "dump", "metric data was dumped to file");
        this._dumpPhase.deriveMetric(46);
        this._prevDumpState = State.create(diNoun, "lastDumpTime", "", "timestamp of previous dump", (Object)"no dump yet");
        this._nextDumpState = State.create(diNoun, NEXT_DUMP_TIME_SENSOR_NAME, "", "timestamp of next dump", (Object)"n/a");
        this._destState = State.create(diNoun, "location", "", "dump location", (Object)this._dest);
        this._intervalState = State.create(diNoun, "sleepInterval", "secs", "sleep interval between dumps", this._interval / 1000L);
        this._maxDumpsState = State.create(diNoun, "maxDumps", "files", "maximum number of dumps", this._maxDumps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String METHOD_NAME = "run";
        try {
            while (this._noun.isAlive()) {
                long tstamp = this.doSleep();
                long tok = this._dumpPhase.start();
                this.evictOldDumps();
                try {
                    String fname;
                    block13: {
                        fname = this.dumpFileName(tstamp);
                        if (this._lsnr != null) {
                            try {
                                this._lsnr.preNounDump(this._noun);
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block13;
                                LOGGER.logp(Level.FINE, this.getClass().getName(), "run", e.getMessage(), e);
                            }
                        }
                    }
                    this._noun.dump(fname, "pdml", false);
                    if (this._lsnr == null) continue;
                    try {
                        this._lsnr.postNounDump(this._noun);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.logp(Level.FINE, this.getClass().getName(), "run", e.getMessage(), e);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.logp(Level.FINE, this.getClass().getName(), "run", e.getMessage(), e);
                }
                finally {
                    this._dumpPhase.stop(tok);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void evictOldDumps() {
        block8: {
            String METHOD_NAME = "evictOldDumps";
            try {
                String fname;
                int i;
                File dir = new File(this._dest);
                if (!DMSFileUtil.isDirectory(dir)) {
                    return;
                }
                String[] fileNameList = DMSFileUtil.list(dir, new DumpFilenameFilter());
                if (fileNameList.length < this._maxDumps) {
                    return;
                }
                long[] tstampList = new long[fileNameList.length];
                for (i = 0; i < fileNameList.length; ++i) {
                    int j;
                    fname = fileNameList[i];
                    String tstampStr = fname.substring(DMSDUMP_PREFIX.length(), fname.length() - DMSDUMP_SUFFIX.length());
                    Long tstampL = new Long(tstampStr);
                    long tstamp = tstampL;
                    for (j = 0; j < i && tstamp <= tstampList[j]; ++j) {
                    }
                    for (int k = i; k > j; --k) {
                        tstampList[k] = tstampList[k - 1];
                    }
                    tstampList[j] = tstamp;
                }
                for (i = this._maxDumps - 1; i < fileNameList.length; ++i) {
                    fname = this.dumpFileName(tstampList[i]);
                    File f = new File(fname);
                    f.delete();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block8;
                LOGGER.logp(Level.FINE, this.getClass().getName(), "evictOldDumps", e.getMessage(), e);
            }
        }
    }

    private String dumpFileName(long tstamp) {
        StringBuffer fnameBuf = new StringBuffer();
        fnameBuf.append(this._dest);
        fnameBuf.append(File.separator);
        fnameBuf.append(DMSDUMP_PREFIX);
        fnameBuf.append(tstamp);
        fnameBuf.append(DMSDUMP_SUFFIX);
        return fnameBuf.toString();
    }

    private long doSleep() throws InterruptedException {
        long now = Time.currentTimeMillis();
        long wakeUp = (now + this._interval) / this._interval * this._interval;
        long wakeUpSecs = wakeUp / 1000L;
        long sleepTime = wakeUp - now;
        this._nextDumpState.update(new Long(wakeUpSecs));
        Thread.currentThread();
        Thread.sleep(sleepTime);
        this._prevDumpState.update(new Long(wakeUpSecs));
        return wakeUpSecs;
    }
}

