/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.jmx;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import oracle.dfw.common.ArgumentDescriptor;
import oracle.dfw.common.ArgumentDescriptorMap;
import oracle.dfw.dump.DiagnosticDump;

public class DiagnosticDumpInfo {
    private String m_dumpName;
    private String m_description;
    private String m_runMode;
    private List<Map<String, String>> m_mandatoryArgs;
    private List<Map<String, String>> m_optionalArgs;
    public static final String ARG_NAME = "ARG_NAME";
    public static final String ARG_TYPE = "ARG_TYPE";
    public static final String ARG_DESCRIPTION = "ARG_DESCRIPTION";
    private static CompositeType s_argRowsType;
    private static TabularType s_argMapType;
    private static String[] s_argItems;
    private static CompositeType s_compositeType;
    private static String[] s_itemNames;

    public DiagnosticDumpInfo(DiagnosticDump dump, Locale locale) {
        this.m_dumpName = dump.getFullDumpName();
        this.m_description = dump.getDumpDescription(locale);
        this.m_runMode = dump.getRunMode().toString();
        final Class<?> clazz = dump.getClass();
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
        if (dump.getMandatoryArguments() != null && dump.getMandatoryArguments().size() > 0) {
            this.m_mandatoryArgs = new ArrayList<Map<String, String>>();
            this.updateArgumentList(dump.getMandatoryArguments(), this.m_mandatoryArgs, locale, loader);
        }
        if (dump.getOptionalArguments() != null && dump.getOptionalArguments().size() > 0) {
            this.m_optionalArgs = new ArrayList<Map<String, String>>();
            this.updateArgumentList(dump.getOptionalArguments(), this.m_optionalArgs, locale, loader);
        }
    }

    public DiagnosticDumpInfo(String dumpName, String dumpDescription, String runMode, List<Map<String, String>> mandatoryArguments, List<Map<String, String>> optionalArguments) {
        this.m_dumpName = dumpName;
        this.m_description = dumpDescription;
        this.m_runMode = runMode;
        this.m_mandatoryArgs = mandatoryArguments;
        this.m_optionalArgs = optionalArguments;
    }

    @Deprecated
    public DiagnosticDumpInfo(String dumpName, String dumpDescription, List<Map<String, String>> mandatoryArguments, List<Map<String, String>> optionalArguments) {
        this(dumpName, dumpDescription, null, mandatoryArguments, optionalArguments);
    }

    public String getName() {
        return this.m_dumpName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<Map<String, String>> getMandatoryArguments() {
        return this.m_mandatoryArgs;
    }

    public List<Map<String, String>> getOptionalArguments() {
        return this.m_optionalArgs;
    }

    private void updateArgumentList(ArgumentDescriptorMap srcDumpArgs, List<Map<String, String>> destDumpArgs, Locale locale, ClassLoader loader) {
        Enumeration<String> keys = srcDumpArgs.enumerateKeys();
        while (keys.hasMoreElements()) {
            String keyName = keys.nextElement();
            ArgumentDescriptor ad = srcDumpArgs.get(keyName);
            LinkedHashMap<String, String> argMap = new LinkedHashMap<String, String>();
            argMap.put(ARG_NAME, keyName);
            argMap.put(ARG_TYPE, ad.getType().toString());
            argMap.put(ARG_DESCRIPTION, ad.getDescription(locale, loader));
            destDumpArgs.add(argMap);
        }
    }

    public static CompositeType toCompositeType() throws OpenDataException {
        if (s_compositeType == null) {
            String typeName = "java.util.Map<java.lang.String,java.lang.String>";
            s_argRowsType = new CompositeType(typeName, typeName, s_argItems, s_argItems, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            s_argMapType = new TabularType(typeName, typeName, s_argRowsType, new String[]{s_argItems[0]});
            ArrayType argumentType = new ArrayType(1, s_argMapType);
            s_compositeType = new CompositeType("oracle.dfw.jmx.DiagnosticDumpInfo", "oracle.dfw.jmx.DiagnosticDumpInfo", s_itemNames, s_itemNames, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, argumentType, argumentType});
        }
        return s_compositeType;
    }

    public CompositeData toCompositeData(CompositeType ct) throws OpenDataException {
        if (ct != null && !DiagnosticDumpInfo.toCompositeType().equals(ct)) {
            throw new IllegalArgumentException();
        }
        CompositeDataSupport data = new CompositeDataSupport(DiagnosticDumpInfo.toCompositeType(), s_itemNames, new Object[]{this.m_dumpName, this.m_description, this.m_runMode, DiagnosticDumpInfo.convertArguments(this.m_mandatoryArgs), DiagnosticDumpInfo.convertArguments(this.m_optionalArgs)});
        return data;
    }

    private static TabularData[] convertArguments(List<Map<String, String>> args) throws OpenDataException {
        TabularData[] tda = null;
        int i = 0;
        if (args != null && args.size() > 0) {
            tda = new TabularData[args.size()];
            for (Map<String, String> argDefinition : args) {
                TabularDataSupport tds = new TabularDataSupport(s_argMapType, 3, 1.0f);
                tda[i] = tds;
                for (Map.Entry<String, String> entry : argDefinition.entrySet()) {
                    tds.put(new CompositeDataSupport(s_argRowsType, s_argItems, new Object[]{entry.getKey(), entry.getValue()}));
                }
                ++i;
            }
        }
        return tda;
    }

    public static DiagnosticDumpInfo from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        return new DiagnosticDumpInfo((String)cd.get(s_itemNames[0]), (String)cd.get(s_itemNames[1]), (String)cd.get(s_itemNames[2]), DiagnosticDumpInfo.convertTabularArguments((TabularData[])cd.get(s_itemNames[3])), DiagnosticDumpInfo.convertTabularArguments((TabularData[])cd.get(s_itemNames[4])));
    }

    private static List<Map<String, String>> convertTabularArguments(TabularData[] tda) {
        ArrayList arguments = null;
        if (tda != null && tda.length > 0) {
            int rowCount = tda.length;
            arguments = new ArrayList(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                HashMap<String, String> argDetails = new HashMap<String, String>(3);
                TabularData td = tda[i];
                for (Object cdo : td.values()) {
                    CompositeData cd = (CompositeData)cdo;
                    argDetails.put((String)cd.get(s_argItems[0]), (String)cd.get(s_argItems[1]));
                }
                arguments.add(argDetails);
            }
        }
        return arguments;
    }

    static {
        s_argItems = new String[]{"key", "value"};
        s_itemNames = new String[]{"name", "description", "runMode", "mandatoryArguments", "optionalArguments"};
    }
}

