/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.dms.ParameterDescriptor;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.MetricDescriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.NounRefresh;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.internal.ParamScopedMetricsRuntimeManager;
import oracle.dms.instrument.internal.ParamScopedMetricsSystem;
import oracle.dms.instrument.internal.SensorCoreData;
import oracle.dms.spy.Metric;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.ColumnGroupSupport;
import oracle.dms.table.RowSupport;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.Table;
import oracle.dms.table.TableName;
import oracle.dms.table.TableSource;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.util.QueryOptions;

public class SpyTableSource
extends TableSource {
    private static TableSource s_tableSource = null;
    private static final Set<String> EMPTY_SET = Collections.emptySet();
    private static String SCOPING_PARAM_TYPE_COLUMN_NAME = "scopingParamType";
    private static String SCOPING_PARAM_NAME_COLUMN_NAME = "scopingParamName";
    private static String SCOPING_PARAM_VALUE_COLUMN_NAME = "scopingParamValue";

    private SpyTableSource() {
    }

    public static synchronized TableSource getTableSource() {
        if (s_tableSource != null) {
            return s_tableSource;
        }
        s_tableSource = new SpyTableSource();
        return s_tableSource;
    }

    @Override
    public String[] getTableNames(QueryOptions options) {
        String[] retVal = null;
        if (options.isIncludeParamScopedMetricTables()) {
            LinkedList<String> c = new LinkedList<String>();
            this.getTableNames(c, options);
            retVal = new String[c.size()];
            c.toArray(retVal);
        } else {
            retVal = Noun.getAllTypes();
        }
        return retVal;
    }

    @Override
    public void getTableNames(Collection<String> list, QueryOptions options) {
        if (list == null) {
            return;
        }
        String[] allTypes = Noun.getAllTypes();
        if (allTypes != null) {
            list.addAll(Arrays.asList(allTypes));
            if (options.isIncludeParamScopedMetricTables()) {
                this._addParameterScopedMetricTableNames(allTypes, list);
            }
        }
    }

    private boolean _paramScopedMetricTableExists(String nounType, Class<? extends ParameterDescriptor> descriptorClass, String parameterName, String parameterValue) {
        Set<ParameterDescriptor> paramDescriptors;
        boolean retVal = false;
        ParamScopedMetricsRuntimeManager psmrm = ParamScopedMetricsSystem.getRuntimeManager();
        if (psmrm != null && (paramDescriptors = psmrm.getParameterDescriptors(nounType)) != null) {
            for (ParameterDescriptor pd : paramDescriptors) {
                if (!parameterName.equals(pd.getName()) || !descriptorClass.isInstance(pd)) continue;
                if (parameterValue == null) {
                    retVal = true;
                    break;
                }
                Set<String> paramValues = psmrm.getParameterValues(nounType, parameterName, descriptorClass);
                if (paramValues == null || !paramValues.contains(parameterValue)) break;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private void _addParameterScopedMetricTableNames(String[] allTypes, Collection<String> list) {
        ParamScopedMetricsRuntimeManager psmrm = ParamScopedMetricsSystem.getRuntimeManager();
        if (psmrm != null) {
            HashMap<String, String> queryStringParams = null;
            for (String nounType : allTypes) {
                Set<ParameterDescriptor> paramDescriptors = psmrm.getParameterDescriptors(nounType);
                if (paramDescriptors == null || paramDescriptors.size() <= 0) continue;
                for (ParameterDescriptor pd : paramDescriptors) {
                    queryStringParams = new HashMap<String, String>(2);
                    Class descriptorClass = null;
                    if (pd instanceof ContextParameterDescriptor) {
                        descriptorClass = ContextParameterDescriptor.class;
                        queryStringParams.put("scopingParamType", "ctx");
                        queryStringParams.put("scopingParamName", pd.getName());
                    } else if (pd instanceof ActivationParameterDescriptor) {
                        descriptorClass = ActivationParameterDescriptor.class;
                        queryStringParams.put("scopingParamType", "act");
                        queryStringParams.put("scopingParamName", pd.getName());
                    }
                    TableName tableName = TableName.createName(nounType, queryStringParams);
                    list.add(tableName.getNormalName());
                    Set<String> paramValues = psmrm.getParameterValues(nounType, pd.getName(), descriptorClass);
                    if (paramValues == null || paramValues.size() <= 0) continue;
                    for (String paramValue : paramValues) {
                        queryStringParams.put("scopingParamValue", paramValue);
                        tableName = TableName.createName(nounType, queryStringParams);
                        list.add(tableName.getNormalName());
                    }
                }
            }
        }
    }

    @Override
    public int tableCount(QueryOptions options) {
        return Noun.getTypeCount();
    }

    @Override
    public Table getTable(String tableName, QueryOptions options) {
        int size;
        int i;
        long valueRefreshTime;
        Noun[] nouns;
        boolean pmsTableExists;
        NounDescriptor ndesc;
        if (tableName == null || tableName.trim().length() == 0) {
            return null;
        }
        TableName parsedName = TableName.parseName(tableName);
        if (!tableName.equals(parsedName.getNormalName())) {
            throw new IllegalArgumentException("tableName should be supplied in normalized form.");
        }
        boolean includeRows = true;
        if (options != null) {
            includeRows = options.includeRows();
        }
        String requestedParamType = null;
        String requestedParamName = null;
        String requestedParamValue = null;
        Class descriptorClass = null;
        if (parsedName.isParamScopedMetrics()) {
            requestedParamType = parsedName.getParameters().get("scopingParamType");
            requestedParamName = parsedName.getParameters().get("scopingParamName");
            requestedParamValue = parsedName.getParameters().get("scopingParamValue");
            if ("ctx".equals(requestedParamType)) {
                descriptorClass = ContextParameterDescriptor.class;
            } else if ("act".equals(requestedParamType)) {
                descriptorClass = ActivationParameterDescriptor.class;
            } else {
                throw new IllegalArgumentException("The requested parameter type is not supported.");
            }
        }
        if ((ndesc = Noun.getDescriptorByType(parsedName.getNounTypeName())) == null) {
            return null;
        }
        if (parsedName.isParamScopedMetrics() && !(pmsTableExists = this._paramScopedMetricTableExists(parsedName.getNounTypeName(), descriptorClass, requestedParamName, requestedParamValue))) {
            return null;
        }
        TableSupport table = new TableSupport();
        table.setName(parsedName.getNormalName());
        table.setKeys(TableSupport.getDefaultKeys());
        if (parsedName.isParamScopedMetrics()) {
            table.setFamily(Table.TableFamily.PARAMETER_SCOPED_METRICS_TABLES);
            table.setCacheable(false);
            table.addKey(SCOPING_PARAM_TYPE_COLUMN_NAME);
            table.addKey(SCOPING_PARAM_NAME_COLUMN_NAME);
            table.addKey(SCOPING_PARAM_VALUE_COLUMN_NAME);
        }
        this._parseNounDescriptor(table, ndesc, parsedName.isParamScopedMetrics(), options);
        if (!includeRows) {
            return table;
        }
        NounRefresh refresh = Noun.getNounRefresh(parsedName.getNounTypeName());
        if (refresh != null) {
            refresh.refresh(EMPTY_SET);
        }
        if ((nouns = Noun.getNounsByType(parsedName.getNounTypeName())) == null || nouns.length == 0) {
            return null;
        }
        HashSet<GroupRefresh> gRefresh = new HashSet<GroupRefresh>();
        ArrayList<Metric> metricList = new ArrayList<Metric>();
        HashMap<Metric, RowSupport> rowMap = new HashMap<Metric, RowSupport>();
        long l = valueRefreshTime = options == null ? 0L : options.valueRefreshTime(parsedName.getNounTypeName());
        if (parsedName.isParamScopedMetrics()) {
            for (i = nouns.length - 1; i >= 0; --i) {
                try {
                    this._addParamScopedMetricRows(table, nouns[i], descriptorClass, requestedParamType, requestedParamName, requestedParamValue, rowMap, valueRefreshTime);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (i = nouns.length - 1; i >= 0; --i) {
                RowSupport row = new RowSupport(table);
                this._updateRow(nouns[i], row, metricList, rowMap, valueRefreshTime);
                table.addRow(row);
            }
        }
        if ((size = metricList.size()) > 0) {
            Metric[] metrics = new Metric[size];
            metricList.toArray(metrics);
            Serializable[] values = Metric.getSerializableValues(metrics, gRefresh);
            for (int i2 = 0; i2 < size; ++i2) {
                RowSupport row = rowMap.get(metrics[i2]);
                row.updateValue(metrics[i2].getName(), values[i2]);
            }
        }
        metricList.clear();
        rowMap.clear();
        gRefresh.clear();
        return table;
    }

    private void _parseNounDescriptor(TableSupport table, NounDescriptor ndesc, boolean isForParamScopedMetrics, QueryOptions options) {
        String serverName;
        String[] ancestorTypes;
        String description;
        String[] sensorNames;
        boolean includeSchema = true;
        if (options != null) {
            includeSchema = options.includeSchema();
        }
        boolean includeDescriptions = false;
        if (options != null) {
            includeDescriptions = options.includeDescriptions();
        }
        SchemaSupport schema = null;
        if (includeSchema) {
            String tnlsId = "QU_" + table.getName();
            schema = new SchemaSupport(DMSNLSupport.getString(tnlsId), table);
            schema.addProperty("SpyCategory", "DMS");
        }
        if (includeDescriptions) {
            table.setCacheable(false);
        }
        if ((sensorNames = ndesc.getSensorNames()) != null) {
            for (int i = sensorNames.length - 1; i >= 0; --i) {
                String[] metricNames = null;
                description = null;
                String sensorType = null;
                SensorDescriptor sdesc = ndesc.getSensorDescriptor(sensorNames[i]);
                if (sdesc != null) {
                    if (isForParamScopedMetrics && ("Event".equals(sdesc.getType()) || "PhaseEvent".equals(sdesc.getType()))) {
                        metricNames = sdesc.getMetricNames();
                        if (includeSchema) {
                            sensorType = sdesc.getType();
                        }
                        if (includeDescriptions) {
                            description = sdesc.getDescription();
                        }
                    } else {
                        metricNames = sdesc.getMetricNames();
                        if (includeSchema) {
                            sensorType = sdesc.getType();
                        }
                        if (includeDescriptions) {
                            description = sdesc.getDescription();
                        }
                    }
                }
                if (metricNames == null || metricNames.length == 0) continue;
                ColumnGroupSupport group = null;
                if (includeSchema) {
                    group = new ColumnGroupSupport(sensorNames[i], sensorType, description);
                }
                for (int j = metricNames.length - 1; j >= 0; --j) {
                    MetricDescriptor mdesc = sdesc.getMetricDescriptor(metricNames[j]);
                    if (mdesc == null) continue;
                    ValueType valuetype = ColumnDefinitionSupport.getValueTypeCode(mdesc.getValueType());
                    table.setColumnType(metricNames[j], valuetype);
                    if (!includeSchema) continue;
                    new ColumnDefinitionSupport(schema, metricNames[j], description, mdesc.getUnit());
                    group.addMember(metricNames[j]);
                }
                if (!includeSchema || group.memberCount() <= 0) continue;
                schema.addColumnGroup(group);
            }
        }
        if ((ancestorTypes = ndesc.getAncestorTypes()) != null) {
            for (int i = ancestorTypes.length - 1; i >= 0; --i) {
                table.setColumnType(ancestorTypes[i], ValueType.STRING);
                if (!includeSchema) continue;
                description = null;
                if (includeDescriptions) {
                    String nlsId = "QU_" + table.getName() + '_' + ancestorTypes[i];
                    description = DMSNLSupport.getString(nlsId);
                }
                new ColumnDefinitionSupport(schema, ancestorTypes[i], description, null);
            }
        }
        for (String key : TableSupport.getDefaultKeys()) {
            table.setColumnType(key, ValueType.STRING);
            if (!includeSchema) continue;
            String description2 = null;
            if (includeDescriptions) {
                String nlsId = "QU_" + key;
                description2 = DMSNLSupport.getString(nlsId);
            }
            new ColumnDefinitionSupport(schema, key, description2, null);
        }
        if (isForParamScopedMetrics) {
            table.setColumnType(SCOPING_PARAM_TYPE_COLUMN_NAME, ValueType.STRING);
            table.setColumnType(SCOPING_PARAM_NAME_COLUMN_NAME, ValueType.STRING);
            table.setColumnType(SCOPING_PARAM_VALUE_COLUMN_NAME, ValueType.STRING);
            if (includeSchema) {
                String paramTypeDescription = null;
                String paramNameDescription = null;
                String paramValueDescription = null;
                if (includeDescriptions) {
                    paramTypeDescription = DMSNLSupport.getString("QU_" + SCOPING_PARAM_TYPE_COLUMN_NAME);
                    paramNameDescription = DMSNLSupport.getString("QU_" + SCOPING_PARAM_NAME_COLUMN_NAME);
                    paramValueDescription = DMSNLSupport.getString("QU_" + SCOPING_PARAM_VALUE_COLUMN_NAME);
                }
                new ColumnDefinitionSupport(schema, SCOPING_PARAM_TYPE_COLUMN_NAME, paramTypeDescription, null);
                new ColumnDefinitionSupport(schema, SCOPING_PARAM_NAME_COLUMN_NAME, paramNameDescription, null);
                new ColumnDefinitionSupport(schema, SCOPING_PARAM_VALUE_COLUMN_NAME, paramValueDescription, null);
            }
        }
        if ((serverName = PlatformSupportFactory.getPlatformSupport().getServerName()) != null && serverName.trim().length() > 0) {
            table.setColumnType("ServerName", ValueType.STRING);
            if (includeSchema) {
                String description3 = null;
                if (includeDescriptions) {
                    description3 = DMSNLSupport.getString("QU_ServerName");
                }
                new ColumnDefinitionSupport(schema, "ServerName", description3, null);
            }
        }
    }

    private void _addParamScopedMetricRows(TableSupport table, Noun noun, Class<? extends ParameterDescriptor> descriptorClass, String requestedParamType, String requestedParamName, String requestedParamValue, Map<Metric, RowSupport> rowMap, long valueRefreshTime) {
        ParamScopedMetricsRuntimeManager pscMgr = ParamScopedMetricsSystem.getRuntimeManager();
        if (pscMgr == null) {
            return;
        }
        Sensor[] sensors = noun.getSensors();
        Object[] psmDataSensorArray = null;
        Object[] metricTemplateArray = null;
        HashMap paramDescriptorAndValues = new HashMap();
        if (sensors != null) {
            int i;
            psmDataSensorArray = new Object[sensors.length];
            for (i = 0; i < sensors.length; ++i) {
                Map<ParameterDescriptor, Map<String, SensorCoreData>> psmData;
                Sensor s = sensors[i];
                if (!(s instanceof PhaseEvent) && !(s instanceof Event) || (psmData = pscMgr.getAllParameterScopedDataForSensor(s)) == null) continue;
                psmDataSensorArray[i] = psmData;
                for (ParameterDescriptor pd : psmData.keySet()) {
                    if (!descriptorClass.isInstance(pd)) continue;
                    boolean descriptorOfNote = false;
                    if (requestedParamName == null) {
                        descriptorOfNote = true;
                    } else if (requestedParamName.equals(pd.getName())) {
                        descriptorOfNote = true;
                    }
                    if (descriptorOfNote) {
                        if (paramDescriptorAndValues.get(pd) == null) {
                            paramDescriptorAndValues.put(pd, new HashSet());
                        }
                        for (String value : psmData.get(pd).keySet()) {
                            boolean valueOfNote = false;
                            if (requestedParamValue == null) {
                                valueOfNote = true;
                            } else if (requestedParamValue.equals(value)) {
                                valueOfNote = true;
                            }
                            if (!valueOfNote) continue;
                            ((Set)paramDescriptorAndValues.get(pd)).add(value);
                        }
                    }
                    if (paramDescriptorAndValues.get(pd) == null || !((Set)paramDescriptorAndValues.get(pd)).isEmpty()) continue;
                    paramDescriptorAndValues.remove(pd);
                }
            }
            metricTemplateArray = new Object[sensors.length];
            for (i = 0; i < sensors.length; ++i) {
                Vector<Metric> metricVect = new Vector<Metric>();
                sensors[i].getMetrics(metricVect);
                metricTemplateArray[i] = metricVect;
            }
        }
        if (!paramDescriptorAndValues.isEmpty()) {
            for (ParameterDescriptor pd : paramDescriptorAndValues.keySet()) {
                for (String value : (Set)paramDescriptorAndValues.get(pd)) {
                    boolean rowUseful = false;
                    RowSupport row = new RowSupport(table);
                    row.updateValue(SCOPING_PARAM_TYPE_COLUMN_NAME, (Serializable)((Object)requestedParamType));
                    row.updateValue(SCOPING_PARAM_NAME_COLUMN_NAME, (Serializable)((Object)pd.getName()));
                    row.updateValue(SCOPING_PARAM_VALUE_COLUMN_NAME, (Serializable)((Object)value));
                    if (sensors == null) continue;
                    for (int i = sensors.length - 1; i >= 0; --i) {
                        int j;
                        Map psmData;
                        long lastSensorUpdate;
                        if (!(sensors[i] instanceof PhaseEvent) && !(sensors[i] instanceof Event) || valueRefreshTime > (lastSensorUpdate = sensors[i].getUpdateTime()) && lastSensorUpdate != 0L || (psmData = (Map)psmDataSensorArray[i]) == null || psmData.get(pd) == null || ((Map)psmData.get(pd)).get(value) == null) continue;
                        rowUseful = true;
                        SensorCoreData scd = (SensorCoreData)((Map)psmData.get(pd)).get(value);
                        Vector metricVect = (Vector)metricTemplateArray[i];
                        MetricAdapter[] metrics = new MetricAdapter[metricVect.size()];
                        for (j = 0; j < metricVect.size(); ++j) {
                            Metric metricTemplate = (Metric)metricVect.get(j);
                            metrics[j] = new MetricAdapter(scd, metricTemplate);
                            rowMap.put(metrics[j], row);
                        }
                        for (j = 0; j < metricVect.size(); ++j) {
                            row.updateValue(metrics[j].getName(), metrics[j].getSerializableValue());
                        }
                    }
                    if (!rowUseful) continue;
                    Noun parent = noun.getParent();
                    row.updateValue("Name", (Serializable)((Object)noun.getName()));
                    row.updateValue("Parent", (Serializable)((Object)parent.toString()));
                    row.updateValue("Host", (Serializable)((Object)DMSUtil.getLocalHostname()));
                    row.updateValue("Process", (Serializable)((Object)DMSUtil.getProcessName()));
                    long lastNounUpdate = noun.getCreateTime();
                    if (valueRefreshTime > lastNounUpdate) {
                        return;
                    }
                    while (parent.getParent() != null) {
                        String type = parent.getType();
                        if (type.trim().length() != 0 && !"n/a".equals(type)) {
                            row.updateValue(type, (Serializable)((Object)parent.getName()));
                        }
                        parent = parent.getParent();
                    }
                    String serverName = PlatformSupportFactory.getPlatformSupport().getServerName();
                    if (serverName != null && serverName.trim().length() > 0) {
                        row.updateValue("ServerName", (Serializable)((Object)serverName));
                    }
                    table.addRow(row);
                }
            }
        }
    }

    private void _updateRow(Noun noun, RowSupport row, List<Metric> metrics, Map<Metric, RowSupport> rowMap, long valueRefreshTime) {
        Sensor[] sensors = noun.getSensors();
        if (sensors != null) {
            for (int i = sensors.length - 1; i >= 0; --i) {
                long lastSensorUpdate = sensors[i].getUpdateTime();
                if (valueRefreshTime > lastSensorUpdate && lastSensorUpdate != 0L) continue;
                Vector<Metric> metricVect = new Vector<Metric>();
                sensors[i].getMetrics(metricVect);
                Enumeration<Metric> iter = metricVect.elements();
                while (iter.hasMoreElements()) {
                    Metric metric = iter.nextElement();
                    metrics.add(metric);
                    rowMap.put(metric, row);
                }
            }
        }
        Noun parent = noun.getParent();
        row.updateValue("Name", (Serializable)((Object)noun.getName()));
        row.updateValue("Parent", (Serializable)((Object)parent.toString()));
        row.updateValue("Host", (Serializable)((Object)DMSUtil.getLocalHostname()));
        row.updateValue("Process", (Serializable)((Object)DMSUtil.getProcessName()));
        long lastNounUpdate = noun.getCreateTime();
        if (valueRefreshTime > lastNounUpdate) {
            return;
        }
        while (parent.getParent() != null) {
            String type = parent.getType();
            if (type.trim().length() != 0 && !"n/a".equals(type)) {
                row.updateValue(type, (Serializable)((Object)parent.getName()));
            }
            parent = parent.getParent();
        }
        String serverName = PlatformSupportFactory.getPlatformSupport().getServerName();
        if (serverName != null && serverName.trim().length() > 0) {
            row.updateValue("ServerName", (Serializable)((Object)serverName));
        }
    }

    @Override
    public boolean containsTable(String name, QueryOptions options) {
        return Noun.getDescriptorByType(name) != null;
    }

    private class MetricAdapter
    extends Metric {
        SensorCoreData mSensorCoreData;
        Metric mMetricTemplate;

        public MetricAdapter(SensorCoreData scd, Metric metricTemplate) {
            super(metricTemplate.getName(), metricTemplate.getDescription(), metricTemplate.getUnits(), metricTemplate.getSensor(), false, metricTemplate.getDescriptor().getValueTypeID(), metricTemplate.getIndex());
            this.mSensorCoreData = scd;
        }

        public Serializable getSerializableValue() {
            Object retVal = null;
            Object rawVal = this.mSensorCoreData.getValues()[this.getIndex()];
            retVal = rawVal == null ? null : (rawVal instanceof Serializable ? (Serializable)rawVal : rawVal.toString());
            return retVal;
        }
    }
}

