/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.reporter.BranchTreeletNode;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.TreeletGenerator;
import oracle.dms.reporter.TreeletNode;
import oracle.dms.reporter.TreeletOptions;
import oracle.dms.spy.Metric;

public class DMSTreeletGenerator
extends TreeletGenerator {
    private HashMap<Metric, Serializable> m_metricValueTable = new HashMap();
    private ArrayList<Metric> m_metricList = new ArrayList();
    private ArrayList<Sensor> m_sensors = new ArrayList();
    private static final String[] ROOT_NAME = new String[]{"/"};

    @Override
    protected BranchTreeletNode createRootNode() {
        return new NounTreeletNode(Noun.getRoot());
    }

    @Override
    public void clear() {
        super.clear();
        this.m_metricValueTable.clear();
        this.m_metricList.clear();
        this.m_sensors.clear();
    }

    @Override
    public void getTreeletNodes(String[] tables, String[] names, Collection<String> badNames, Collection<String> badTables) {
        this.getTreeletNodeByTables(tables, badTables);
        if (names == null || names.length == 0) {
            if (tables == null || tables.length == 0) {
                names = ROOT_NAME;
            } else {
                return;
            }
        }
        for (String name : names) {
            if (name.trim().length() == 0) continue;
            if (name.charAt(0) != '/') {
                badNames.add(name);
                continue;
            }
            TreeletNode node = this.getDescendant((NounTreeletNode)this.m_root, name.substring(1), name.charAt(0));
            if (node != null) continue;
            badNames.add(name);
        }
    }

    @Override
    public void resetMetrics() {
        for (Sensor sensor : this.m_sensors) {
            sensor.reset();
        }
    }

    @Override
    protected void getTreeletNodeByTables(String[] tables, Collection<String> badTables) {
        if (tables == null || tables.length == 0) {
            return;
        }
        ArrayList<Noun[]> nounList = this._getNounsByTables(tables, badTables);
        if (nounList == null) {
            return;
        }
        for (Noun[] nounArray : nounList) {
            if (nounArray == null || nounArray.length == 0) continue;
            for (Noun noun : nounArray) {
                this._getTreeletNodeByNoun(noun);
            }
        }
    }

    private ArrayList<Noun[]> _getNounsByTables(String[] tables, Collection<String> badTables) {
        ArrayList<Noun[]> list = new ArrayList<Noun[]>();
        if (tables == null || tables.length == 0) {
            return list;
        }
        for (String table : tables) {
            Noun[] nouns = Noun.getNounsByType(table);
            if (nouns == null || nouns.length == 0) {
                badTables.add(table);
                continue;
            }
            list.add(nouns);
        }
        return list;
    }

    private void _getTreeletNodeByNoun(Noun noun) {
        Stack<Noun> ancestors = new Stack<Noun>();
        Noun root = Noun.getRoot();
        for (Noun anoun = noun; anoun != root; anoun = anoun.getParent()) {
            ancestors.push(anoun);
        }
        NounTreeletNode tln = (NounTreeletNode)this.m_root;
        NounTreeletNode parent = (NounTreeletNode)this.m_root;
        while (!ancestors.isEmpty()) {
            Noun anoun = (Noun)ancestors.pop();
            String name = anoun.getName();
            tln = (NounTreeletNode)parent.findBranch(name);
            if (tln == null) {
                tln = new NounTreeletNode(name, parent, anoun);
            }
            parent = tln;
        }
        ancestors.clear();
        if (this.m_treeletOptions.includeDescendant() == TreeletOptions.IncludeDescendant.ALL_DESCENDANTS || this.m_treeletOptions.includeDescendant() == TreeletOptions.IncludeDescendant.CHILDREN) {
            this._getDescendants(tln);
        }
    }

    @Override
    protected TreeletNode getDescendant(BranchTreeletNode parent, String name, char delim) {
        Noun noun;
        String tok;
        if (parent == null || name == null) {
            return null;
        }
        NounTreeletNode parentNounNode = (NounTreeletNode)parent;
        if (name.trim().length() == 0) {
            this._getDescendants(parentNounNode);
            return parentNounNode;
        }
        int index = name.indexOf(delim);
        String rest = null;
        if (index == 0) {
            return null;
        }
        if (index > 0) {
            tok = name.substring(0, index);
            rest = name.substring(index + 1);
        } else {
            tok = name;
        }
        Noun parentNoun = (Noun)parentNounNode.getNode();
        TreeletNode node = parentNounNode.findBranch(tok);
        if (node == null && (noun = parentNoun.getChild(tok)) != null) {
            node = new NounTreeletNode(tok, parentNounNode, noun);
        }
        if (node == null) {
            if (rest != null && rest.trim().length() > 0) {
                return null;
            }
            node = parentNounNode.findLeaf(tok);
            if (node != null) {
                return node;
            }
            index = tok.lastIndexOf(46);
            if (index <= 0) {
                return null;
            }
            Sensor sensor = parentNoun.getSensor(tok.substring(0, index));
            if (sensor == null) {
                return null;
            }
            Metric metric = sensor.getMetric(tok);
            if (metric != null) {
                this.m_metricList.add(metric);
                node = new MetricTreeletNode(tok, parentNounNode, metric, this);
            }
            if (this.m_treeletOptions.isSetMetrics()) {
                this.m_sensors.add(sensor);
            }
            return node;
        }
        if (node instanceof MetricTreeletNode) {
            return node;
        }
        if (rest != null && rest.trim().length() > 0) {
            return this.getDescendant((NounTreeletNode)node, rest, delim);
        }
        this._getDescendants((NounTreeletNode)node);
        return node;
    }

    private void _getDescendants(NounTreeletNode parent) {
        Vector<Noun> nouns;
        Noun pnoun = (Noun)parent.getNode();
        Sensor[] sens = pnoun.getSensors();
        if (sens != null && (this.m_treeletOptions.includeDescendant() == TreeletOptions.IncludeDescendant.ALL_DESCENDANTS || this.m_treeletOptions.includeDescendant() == TreeletOptions.IncludeDescendant.CHILDREN)) {
            for (Sensor sensor : sens) {
                if (this.m_treeletOptions.isSetMetrics()) {
                    this.m_sensors.add(sensor);
                }
                Vector<Metric> metrics = new Vector<Metric>();
                sensor.getMetrics(metrics);
                for (Metric metric : metrics) {
                    String name = metric.getName();
                    MetricTreeletNode metricNode = (MetricTreeletNode)parent.findLeaf(name);
                    if (metricNode != null) continue;
                    this.m_metricList.add(metric);
                    new MetricTreeletNode(metric.getName(), parent, metric, this);
                }
            }
        }
        if (this.m_treeletOptions.includeDescendant() == TreeletOptions.IncludeDescendant.ALL_DESCENDANTS && (nouns = pnoun.getNouns()) != null) {
            for (Noun noun : nouns) {
                String nounName = noun.getName();
                NounTreeletNode nounNode = (NounTreeletNode)parent.findBranch(nounName);
                if (nounNode == null) {
                    nounNode = new NounTreeletNode(nounName, parent, noun);
                }
                this._getDescendants(nounNode);
            }
        }
    }

    final Serializable getMetricValue(MetricTreeletNode metricNode) {
        Metric metric = (Metric)metricNode.getNode();
        return this.m_metricValueTable.get(metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queryMetricValues() {
        Metric[] metrics = null;
        ArrayList<Metric> arrayList = this.m_metricList;
        synchronized (arrayList) {
            metrics = new Metric[this.m_metricList.size()];
            this.m_metricList.toArray(metrics);
        }
        HashSet<GroupRefresh> gRefresh = new HashSet<GroupRefresh>();
        Serializable[] metricValues = Metric.getSerializableValues(metrics, gRefresh);
        for (int i = 0; i < metrics.length; ++i) {
            this.m_metricValueTable.put(metrics[i], metricValues[i]);
        }
    }
}

