/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.config.CollectorConfig;
import oracle.dms.config.ConfigChild;
import oracle.dms.config.ConfigResourceBundle;
import oracle.dms.config.DMSConfigurationException;
import oracle.dms.config.DumpConfig;
import oracle.dms.config.parameter.ParameterConfig;
import oracle.dms.config.paramscopedmetrics.ParamScopedMetricsConfig;
import oracle.dms.event.config.Destination;
import oracle.dms.event.config.EventConfig;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;
import oracle.dms.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class Config {
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String SCHEMA_NAME_SPACE = "http://xmlns.oracle.com/dms/DMSConfiguration/V2";
    private static final String SCHEMA_NAME_SPACE_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_LOCATION = "http://xmlns.oracle.com/dms/DMSConfiguration/V2";
    private String m_DMSConfigXSDFile = null;
    private DocumentBuilderFactory m_factory = DocumentBuilderFactory.newInstance();
    private String m_filename;
    private static final String EVENT_ELEMENT_NAME = "eventConfiguration";
    private static final String DMS_ELEMENT_NAME = "dms";
    private static final String NAME_ELEMENT_NAME = "name";
    private static final String VALUE_ELEMENT_NAME = "value";
    private static final String PROPERTIES_ELEMENT_NAME = "properties";
    private static final String PROPERTY_ELEMENT_NAME = "property";
    private static String LOGGER_NAME = "oracle.dms.config";
    private static final String CLASS_NAME = Config.class.getName();
    private ODLLogger m_logger;
    private Exception m_parsingException;
    private EventConfig m_eventConfig = null;
    private boolean m_isRuntime;
    private boolean m_V1 = true;
    private CollectorConfig m_collectorConfig = null;
    private DumpConfig m_dumpConfig = null;
    private ParameterConfig m_parameterConfig;
    private ParamScopedMetricsConfig m_paramScopedMetricsConfig;
    private Set<String> m_propertyKeys = new HashSet<String>();
    private List<ConfigChild> m_childConfigs = new ArrayList<ConfigChild>(5);

    public Config(String filename, InputStream inputStream) throws DMSConfigurationException {
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("invalid argument to DMS configuration; filename=" + filename);
        }
        this.m_logger = ODLLogger.getODLLogger((String)LOGGER_NAME, (String)ConfigResourceBundle.class.getName());
        this.m_filename = filename;
        this.m_factory.setNamespaceAware(true);
        this.m_factory.setValidating(true);
        this.m_factory.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        this.load(inputStream);
    }

    public synchronized void load(InputStream inputStream) throws DMSConfigurationException {
        Document configDocument = this.getConfigDocument(inputStream);
        this.m_eventConfig = new EventConfig();
        this.m_childConfigs.add(this.m_eventConfig);
        this.m_collectorConfig = new CollectorConfig();
        this.m_childConfigs.add(this.m_collectorConfig);
        this.m_dumpConfig = new DumpConfig();
        this.m_childConfigs.add(this.m_dumpConfig);
        this.m_parameterConfig = new ParameterConfig();
        this.m_childConfigs.add(this.m_parameterConfig);
        this.m_paramScopedMetricsConfig = new ParamScopedMetricsConfig();
        this.m_childConfigs.add(this.m_paramScopedMetricsConfig);
        if (configDocument != null) {
            Element xdms = configDocument.getDocumentElement();
            for (ConfigChild child : this.m_childConfigs) {
                try {
                    child.parseConfigDocument(xdms);
                }
                catch (Exception e) {
                    throw new DMSConfigurationException("There was a problem loading the configuration", e);
                }
            }
            if (this.m_V1) {
                this.addAdditionalV2Objects();
            }
            this._getProperties(xdms);
        }
    }

    private void addAdditionalV2Objects() throws DMSConfigurationException {
        String METHOD_NAME = "addAdditionalV2Objects";
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.logp(Level.FINE, CLASS_NAME, "addAdditionalV2Objects", "DMS Config file version 1 detected. Creating additional version 2 objects. These changes will be made to the DMS config file on the next update");
        }
        String condition = "context ODL_TRACE_ID isNotNull";
        String traceFilterID = "traceFilter";
        String eventTypes = "EXECUTION_CONTEXT, HTTP_REQUEST, SENSOR";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("condition", condition);
        String traceDestinationID = "traceDestination";
        String destinationClass = "oracle.dms.trace2.runtime.LoggerDestination";
        Destination traceDestination = new Destination(traceDestinationID, destinationClass);
        String propName = "loggerName";
        String propValue = "oracle.dms.event.tracing";
        traceDestination.setProperty(propName, propValue);
        try {
            this.m_eventConfig.addFilter(traceFilterID, null, eventTypes, props);
            this.m_eventConfig.addDestination(traceDestination);
            this.m_eventConfig.addEventRoute(traceFilterID, traceDestinationID);
        }
        catch (DMSConfigurationException e) {
            if (this.m_logger.isLoggable(Level.WARNING)) {
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "addAdditionalV2Objects", "DMS_59002");
            }
            throw e;
        }
    }

    public synchronized void sync(Config pendingConfig) throws Exception {
        for (ConfigChild child : this.m_childConfigs) {
            child.sync(pendingConfig);
        }
    }

    public synchronized void close() {
    }

    private Document getConfigDocument(InputStream inputStream) throws DMSConfigurationException {
        String METHOD_NAME = "getConfigDocument";
        DocumentBuilder builder = null;
        Document document = null;
        if (this.m_filename == null) {
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "getConfigDocument", "DMS configuration file is missing or unreadable: " + this.m_filename);
            }
        } else {
            File configFile = new File(this.m_filename);
            if (configFile.canRead()) {
                this.setupDefaultSchema(configFile);
                try {
                    builder = this.m_factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    if (this.m_logger.isLoggable(Level.WARNING)) {
                        this.m_logger.logp(Level.WARNING, CLASS_NAME, "getConfigDocument", "DMS-58021", (Object[])new String[]{this.m_filename}, (Throwable)e);
                    }
                    throw new DMSConfigurationException("failed to read the DMS configuration XML file " + this.m_filename, e);
                }
                builder.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) {
                    }

                    @Override
                    public void error(SAXParseException exception) {
                        Config.this.m_parsingException = exception;
                        if (Config.this.m_logger.isLoggable(Level.WARNING)) {
                            Config.this.m_logger.logp(Level.WARNING, CLASS_NAME, "getConfigDocument", "DMS-58021", (Object[])new String[]{Config.this.m_filename}, (Throwable)exception);
                        }
                    }

                    @Override
                    public void fatalError(SAXParseException exception) {
                        Config.this.m_parsingException = exception;
                        if (Config.this.m_logger.isLoggable(Level.WARNING)) {
                            Config.this.m_logger.logp(Level.WARNING, CLASS_NAME, "getConfigDocument", "DMS-58021", (Object[])new String[]{Config.this.m_filename}, (Throwable)exception);
                        }
                    }
                });
                InputStream configInputStream = inputStream;
                String message = "failed to parse the DMS configuration XML file " + this.m_filename;
                try {
                    if (configInputStream == null) {
                        configInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                            @Override
                            public FileInputStream run() throws FileNotFoundException {
                                return new FileInputStream(Config.this.m_filename);
                            }
                        });
                        if (this.m_logger.isLoggable(Level.FINEST)) {
                            configInputStream = DMSUtil.logInputStream(configInputStream, (Logger)this.m_logger);
                        }
                    }
                    document = builder.parse(configInputStream);
                }
                catch (PrivilegedActionException e) {
                    throw new DMSConfigurationException(message, e.getException());
                }
                catch (Exception e) {
                    throw new DMSConfigurationException(message, e);
                }
                finally {
                    block22: {
                        if (configInputStream != null) {
                            try {
                                configInputStream.close();
                            }
                            catch (Exception e) {
                                if (!this.m_logger.isLoggable(Level.FINE)) break block22;
                                this.m_logger.logp(Level.FINE, CLASS_NAME, "getConfigDocument", "Failed to close the stream on the DMS configuration file " + this.m_filename + ". ", (Throwable)e);
                            }
                        }
                    }
                }
                if (this.m_parsingException != null) {
                    throw new DMSConfigurationException("error parsing file " + this.m_filename, this.m_parsingException);
                }
            }
        }
        return document;
    }

    public synchronized void save(OutputStream outputStream) throws DMSConfigurationException {
        DocumentBuilder builder;
        String METHOD_NAME = "save";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, CLASS_NAME, "save", "START: " + CLASS_NAME + "." + "save" + " id: " + this + " : time (m/s): " + Time.currentTimeMillis());
        }
        try {
            builder = this.m_factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DMSConfigurationException("A configuration error has occured", e);
        }
        Document document = builder.getDOMImplementation().createDocument("http://xmlns.oracle.com/dms/DMSConfiguration/V2", DMS_ELEMENT_NAME, null);
        Element config = document.getDocumentElement();
        config.setAttribute("xmlns:xsi", SCHEMA_NAME_SPACE_INSTANCE);
        config.setAttribute("xsi:schemaLocation", "http://xmlns.oracle.com/dms/DMSConfiguration/V2");
        Element xproperties = this._buildPropertyElement(document);
        if (xproperties != null) {
            config.appendChild(xproperties);
        }
        for (ConfigChild child : this.m_childConfigs) {
            Element childElement;
            try {
                childElement = child.buildElement(document);
            }
            catch (Exception e) {
                throw new DMSConfigurationException("There was a problem building the XML element", e);
            }
            if (childElement == null) continue;
            config.appendChild(childElement);
        }
        DOMSource input = new DOMSource(document);
        OutputStream configOutputStream = outputStream;
        boolean methodFileOutputStream = false;
        try {
            Transformer transformer;
            StreamResult output;
            block29: {
                output = null;
                if (configOutputStream == null) {
                    if (this.m_logger.isLoggable(Level.FINER)) {
                        this.m_logger.logp(Level.FINER, CLASS_NAME, "save", "Using FileOutputStream " + CLASS_NAME + "." + "save" + " id: " + this + " : time (m/s): " + Time.currentTimeMillis());
                    }
                    configOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                        @Override
                        public FileOutputStream run() throws FileNotFoundException {
                            return new FileOutputStream(Config.this.m_filename);
                        }
                    });
                    methodFileOutputStream = true;
                }
                output = new StreamResult(configOutputStream);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                transformer = null;
                try {
                    transformer = tFactory.newTransformer();
                }
                catch (TransformerConfigurationException e) {
                    throw new DMSConfigurationException("A configuration error has occured which prevented the DMS configuration from being saved to disc", e);
                }
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                }
                catch (IllegalArgumentException e) {
                    String message = "XML parser does not support 'indent-amount'. It is ignored.";
                    if (!this.m_logger.isLoggable(Level.FINER)) break block29;
                    this.m_logger.logp(Level.FINER, CLASS_NAME, "save", message, (Throwable)e);
                }
            }
            transformer.transform(input, output);
        }
        catch (PrivilegedActionException e) {
            throw new DMSConfigurationException("Insufficient permissions to write to the DMS configuration XML file " + this.m_filename + ". The configuration has not been saved.", e.getException());
        }
        catch (TransformerConfigurationException tce) {
            String message = "failure parsing the DMS configuration file " + tce.getMessage() + ". The configuration has not been saved.";
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "save", message, (Throwable)tce);
            }
            throw new DMSConfigurationException(message, tce);
        }
        catch (TransformerException te) {
            String message = "failure to write to the event configuration file " + te.getMessage() + ". The configuration has not been saved.";
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "save", message, (Throwable)te);
            }
            throw new DMSConfigurationException(message, te);
        }
        finally {
            block31: {
                if (configOutputStream != null && methodFileOutputStream) {
                    if (this.m_logger.isLoggable(Level.FINE)) {
                        this.m_logger.logp(Level.FINE, CLASS_NAME, "save", "attempting to close the FileOutputStream ");
                    }
                    try {
                        configOutputStream.close();
                    }
                    catch (Exception e) {
                        if (!this.m_logger.isLoggable(Level.FINE)) break block31;
                        this.m_logger.logp(Level.FINE, CLASS_NAME, "save", "failed to close the stream on the DMS configuration file " + this.m_filename + ". ", (Throwable)e);
                    }
                }
            }
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, CLASS_NAME, "save", "END: " + CLASS_NAME + "." + "save" + " id: " + this + " : time (m/s): " + Time.currentTimeMillis());
        }
    }

    public synchronized EventConfig getEventConfig() {
        return this.m_eventConfig;
    }

    public synchronized void setEventConfig(EventConfig eventConfig) {
        this.m_eventConfig = eventConfig;
    }

    public synchronized CollectorConfig getCollectorConfig() {
        return this.m_collectorConfig;
    }

    public synchronized void setCollectorConfig(CollectorConfig collectorConfig) {
        this.m_collectorConfig = collectorConfig;
    }

    public synchronized DumpConfig getDumpConfig() {
        return this.m_dumpConfig;
    }

    public synchronized void setDumpConfig(DumpConfig dumpConfig) {
        this.m_dumpConfig = dumpConfig;
    }

    public synchronized ParameterConfig getParamConfig() {
        return this.m_parameterConfig;
    }

    public synchronized void setParamConfig(ParameterConfig parameterConfig) {
        this.m_parameterConfig = parameterConfig;
    }

    public synchronized ParamScopedMetricsConfig getParamScopedMetricsConfig() {
        return this.m_paramScopedMetricsConfig;
    }

    public synchronized void setParamScopedMetricsConfig(ParamScopedMetricsConfig paramScopedMetricsConfig) {
        this.m_paramScopedMetricsConfig = paramScopedMetricsConfig;
    }

    public String getProperty(String key) {
        if (key == null) {
            return null;
        }
        return DMSProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        return DMSProperties.getProperty(key, defaultValue);
    }

    public Set<String> getPropertKeys() {
        return new HashSet<String>(this.m_propertyKeys);
    }

    public boolean containsProperty(String key) {
        if (key == null) {
            return false;
        }
        return this.m_propertyKeys.contains(key);
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            return;
        }
        this.m_propertyKeys.add(key);
        DMSProperties.setProperty(key, value);
    }

    private void _getProperties(Element xdms) {
        Element properties = XmlUtil.getChildByName(xdms, PROPERTIES_ELEMENT_NAME);
        if (properties == null) {
            return;
        }
        NodeList propertyList = properties.getElementsByTagName(PROPERTY_ELEMENT_NAME);
        if (propertyList == null || propertyList.getLength() == 0) {
            return;
        }
        for (int i = propertyList.getLength() - 1; i >= 0; --i) {
            Element property = (Element)propertyList.item(i);
            String name = property.getAttribute(NAME_ELEMENT_NAME);
            if (name == null) continue;
            String value = property.getAttribute(VALUE_ELEMENT_NAME);
            this.addProperty(name, value);
        }
    }

    private Element _buildPropertyElement(Document document) {
        if (this.m_propertyKeys.size() == 0) {
            return null;
        }
        Element xproperties = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", PROPERTIES_ELEMENT_NAME);
        boolean hasChild = false;
        for (String key : this.m_propertyKeys) {
            String value = DMSProperties.getProperty(key);
            if (value == null) continue;
            Element xproperty = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", PROPERTY_ELEMENT_NAME);
            xproperty.setAttribute(NAME_ELEMENT_NAME, key);
            xproperty.setAttribute(VALUE_ELEMENT_NAME, value);
            xproperties.appendChild(xproperty);
            hasChild = true;
        }
        if (hasChild) {
            return xproperties;
        }
        return null;
    }

    public void setRuntime(boolean isRuntime) {
        this.m_isRuntime = isRuntime;
        this.m_eventConfig.setRuntime(isRuntime);
        this.m_parameterConfig.setRuntime(isRuntime);
        this.m_dumpConfig.setRuntime(isRuntime);
        this.m_collectorConfig.setRuntime(isRuntime);
    }

    private void setupDefaultSchema(File configFile) throws DMSConfigurationException {
        String METHOD_NAME = "setupDefaultSchema";
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(configFile);
            reader = new BufferedReader(fileReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("http://xmlns.oracle.com/dms/DMSConfiguration/V2")) continue;
                this.m_V1 = false;
                break;
            }
        }
        catch (Exception ex) {
            throw new DMSConfigurationException("failed to read the DMS configuration XML file. Couldn't determine the XML schema version." + this.m_filename, ex);
        }
        finally {
            block19: {
                block18: {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            if (!this.m_logger.isLoggable(Level.FINE)) break block18;
                            this.m_logger.logp(Level.FINE, CLASS_NAME, "setupDefaultSchema", "Failed to close the stream on the DMS configuration file " + this.m_filename + ". ", (Throwable)e);
                        }
                    }
                }
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Exception e) {
                        if (!this.m_logger.isLoggable(Level.FINE)) break block19;
                        this.m_logger.logp(Level.FINE, CLASS_NAME, "setupDefaultSchema", "Failed to close the stream on the DMS configuration file " + this.m_filename + ". ", (Throwable)e);
                    }
                }
            }
        }
        this.m_DMSConfigXSDFile = this.m_V1 ? "dms_config1.xsd" : "dms_config2.xsd";
        URL defaultSchema = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return this.getClass().getResource(Config.this.m_DMSConfigXSDFile);
            }
        });
        this.m_factory.setAttribute(JAXP_SCHEMA_SOURCE, defaultSchema.toString());
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, CLASS_NAME, "setupDefaultSchema", "Schema version V1=" + this.m_V1 + " defaultSchema=" + defaultSchema.toString());
        }
    }
}

