/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.portable;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.as.config.notification.DocumentChangeListener;
import oracle.as.config.notification.DocumentChangeNotifierFactory;
import oracle.as.config.notification.DocumentChangedEvent;
import oracle.as.jmx.framework.util.ConfigMBeanSupport;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationException;
import oracle.dfw.config.DumpSampleInfo;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.jmx.DiagnosticsConfigMBean;
import oracle.dfw.sampling.DumpSamplingArchive;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public class JMXDiagnosticsConfig
extends ConfigMBeanSupport
implements DiagnosticsConfigMBean,
DocumentChangeListener {
    private DiagnosticsConfiguration m_config;
    private Logger m_logger = LoggerFactory.getFrameworkLogger();
    private boolean m_isWebSphereAS = false;
    private boolean m_sendEvents = true;
    private volatile boolean m_pendingChanges = false;

    public JMXDiagnosticsConfig() {
        try {
            ServerPlatformSupport helper = ServerPlatformSupportFactory.getInstance();
            this.m_isWebSphereAS = helper.isWebSphereAS();
        }
        catch (Exception e) {
            this.m_isWebSphereAS = false;
        }
    }

    public void load() throws IOException {
        if (this.getJMXSupport().isReadOnly()) {
            if (this.m_config == null) {
                try {
                    DiagnosticsFramework df = new DiagnosticsFramework();
                    this.m_config = df.getConfiguration();
                }
                catch (Exception e) {
                    this.m_logger.log(Level.WARNING, "failure loading diagnsotics configuration", e);
                }
            }
        } else {
            this.m_sendEvents = false;
            InputStream is = null;
            try {
                is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return JMXDiagnosticsConfig.this.getDataSource().getInputStream();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            try {
                if (this.m_config == null) {
                    this.m_config = new DiagnosticsConfiguration();
                    this.m_config.parseDiagnosticsConfiguration(is);
                } else if (!this.m_pendingChanges) {
                    DiagnosticsConfiguration loadedConfig = new DiagnosticsConfiguration();
                    loadedConfig.parseDiagnosticsConfiguration(is);
                    this.m_config.sync(loadedConfig);
                }
            }
            catch (Exception e) {
                IOException ioe = new IOException("failure reading diagnostics configuration");
                ioe.initCause(e);
                throw ioe;
            }
            finally {
                is.close();
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.getJMXSupport().isReadOnly() || this.m_isWebSphereAS) {
            DocumentChangeNotifierFactory.getInstance().getNotifier().addDocumentChangeListener(this.getConfigURL().toURI(), (DocumentChangeListener)this);
        }
        return super.preRegister(server, name);
    }

    protected void doSave() throws IOException {
        OutputStream os = null;
        try {
            os = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return JMXDiagnosticsConfig.this.getDataSource().getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        try {
            this.m_config.createDiagnosticsConfiguration(os);
            this.m_pendingChanges = false;
        }
        catch (Exception e) {
            IOException ioe = new IOException("failure saving diagnostics configuration");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            os.close();
        }
    }

    public boolean documentAdded(DocumentChangedEvent event) throws Exception {
        return this.documentChanged(event);
    }

    public boolean documentChanged(DocumentChangedEvent event) throws Exception {
        InputStream is = null;
        try {
            is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return JMXDiagnosticsConfig.this.getDataSource().getInputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        DiagnosticsConfiguration loadedConfig = null;
        try {
            loadedConfig = new DiagnosticsConfiguration();
            loadedConfig.parseDiagnosticsConfiguration(is);
            this.m_config.sync(loadedConfig);
        }
        catch (Exception e) {
            IOException ioe = new IOException("failure reading diagnostics configuration");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            is.close();
        }
        return true;
    }

    public boolean documentRemoved(DocumentChangedEvent event) {
        return true;
    }

    @Override
    public boolean isIncidentCreationEnabled() {
        return this.m_config.isIncidentCreationEnabled();
    }

    @Override
    public void setIncidentCreationEnabled(boolean enable) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("incidentCreationEnabled", enable);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public boolean isLogDetectionEnabled() {
        return this.m_config.isLogDetectionEnabled();
    }

    @Override
    public void setLogDetectionEnabled(boolean enable) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("logDetectionEnabled", enable);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public int getMaxTotalIncidentSize() {
        return this.m_config.getMaxTotalIncidentSize();
    }

    @Override
    public void setMaxTotalIncidentSize(int size) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("maxTotalIncidentSize", size);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public boolean isFloodControlEnabled() {
        return this.m_config.isFloodControlEnabled();
    }

    @Override
    public void setFloodControlEnabled(boolean enable) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("floodControlEnabled", enable);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public int getFloodControlIncidentCount() {
        return this.m_config.getFloodControlIncidentCount();
    }

    @Override
    public void setFloodControlIncidentCount(int count) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("floodControlIncidentCount", count);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public int getFloodControlIncidentTimePeriod() {
        return this.m_config.getFloodControlIncidentTimePeriod();
    }

    @Override
    public void setFloodControlIncidentTimePeriod(int timePeriod) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("floodControlIncidentTimePeriod", timePeriod);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public long getMaxTotalTempSize() {
        return this.m_config.getTempDirMaxSize();
    }

    @Override
    public void setMaxTotalTempSize(long size) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("maxSize", size);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public long getTempCleanupInterval() {
        return this.m_config.getTempDirInterval();
    }

    @Override
    public void setTempCleanupInterval(long interval) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("interval", interval);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public int getReservedMemoryKB() {
        return this.m_config.getReservedMemoryKB();
    }

    @Override
    public void setReservedMemoryKB(int size) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("reservedMemoryKB", size);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public boolean isUseExternalThreadDumpCommand() {
        return this.m_config.useThreadDumpExternalCommands();
    }

    @Override
    public void setUseExternalThreadDumpCommand(boolean useExternalCommands) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("useExternalCommands", useExternalCommands);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public boolean isUncaughtExceptionDetectionEnabled() {
        return this.m_config.isUncaughtExceptionDetectionEnabled();
    }

    @Override
    public void setUncaughtExceptionDetectionEnabled(boolean enable) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("uncaughtExceptionDetectionEnabled", enable);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public boolean isDumpSamplingEnabled() {
        return this.m_config.isDumpSamplingEnabled();
    }

    @Override
    public void enableDumpSampling(boolean enable) throws IOException {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("enabled", enable);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public boolean isDumpSamplingIdleWhenHealthy() {
        return this.m_config.isDumpSamplingIdleWhenHealthy();
    }

    @Override
    public void setDumpSamplingIdleWhenHealthy(boolean idleWhenHealthy) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("idleWhenHealthy", idleWhenHealthy);
        this.m_config.setAttributes(valueUpdate);
    }

    @Override
    public long getDumpSamplingMinimumHealthyPeriod() {
        return this.m_config.getDumpSamplingMinimumHealthyPeriodInMillis();
    }

    @Override
    public void setDumpSamplingMinimumHealthyPeriod(long period) {
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("minHealthyPeriod", period);
        this.m_config.setAttributes(valueUpdate);
    }

    @Override
    public DumpSampleInfo listDumpSampleInfo(String sampleNAme) {
        Map<String, DumpSampleInfo> m = this.m_config.getDumpSamples();
        if (m != null && m.size() > 0) {
            return m.get(sampleNAme);
        }
        return null;
    }

    @Override
    public DumpSampleInfo[] listDumpSampleInfo() {
        DumpSampleInfo[] info = null;
        Map<String, DumpSampleInfo> m = this.m_config.getDumpSamples();
        info = m != null && m.size() > 0 ? m.values().toArray(new DumpSampleInfo[m.size()]) : new DumpSampleInfo[]{};
        return info;
    }

    @Override
    public void addDumpSample(String sampleName, String diagnosticDumpName, String appName, long samplingInterval, long rotationCount, boolean dumpedImplicitly, boolean toAppend, Map<String, String> dumpArguments) throws Exception {
        if (diagnosticDumpName != null && diagnosticDumpName.equals(DumpSamplingArchive.getDiagnosticDumpName())) {
            throw new DiagnosticsConfigurationException("DFW-40210", diagnosticDumpName);
        }
        DumpSampleInfo dumpSampleInfo = new DumpSampleInfo(sampleName, diagnosticDumpName, appName, samplingInterval, rotationCount, dumpedImplicitly, toAppend, dumpArguments);
        Map<String, DumpSampleInfo> m = this.m_config.getDumpSamples();
        if (m == null) {
            m = new HashMap<String, DumpSampleInfo>(1);
        }
        if (m.containsKey(dumpSampleInfo.getSampleName())) {
            throw new Exception("DumpSample \"" + sampleName + "\" already exists");
        }
        m.put(dumpSampleInfo.getSampleName(), dumpSampleInfo);
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("dumpSampling", m);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public void updateDumpSample(String sampleName, String appName, long samplingInterval, long rotationCount, boolean dumpedImplicitly, boolean toAppend, Map<String, String> dumpArguments, boolean updateAppName, boolean updateSamplingInterval, boolean updateRotationCount, boolean updateDumpedImplicitly, boolean updateToAppend, boolean updateDumpArguments) throws Exception {
        DumpSampleInfo dumpSampleInfo = null;
        Map<String, DumpSampleInfo> m = this.m_config.getDumpSamples();
        if (m == null || !m.containsKey(sampleName)) {
            throw new Exception("dump sample \"" + sampleName + "\" does not exist");
        }
        DumpSampleInfo old = m.remove(sampleName);
        Map<String, String> oldMap = old.getDumpArguments();
        if (oldMap != null && oldMap.size() == 0) {
            oldMap = null;
        }
        dumpSampleInfo = new DumpSampleInfo(old.getSampleName(), old.getDiagnosticDumpName(), old.getAppName(), old.getSamplingInterval(), old.getRotationCount(), old.canBeDumpedImplicitly(), old.isAppending(), oldMap);
        m.put(sampleName, dumpSampleInfo);
        if (updateAppName) {
            dumpSampleInfo.setAppName(appName);
        }
        if (updateSamplingInterval) {
            dumpSampleInfo.setSamplingInterval(samplingInterval);
        }
        if (updateRotationCount) {
            dumpSampleInfo.setRotationCount(rotationCount);
        }
        if (updateDumpedImplicitly) {
            dumpSampleInfo.setToBeDumpedImplicitly(dumpedImplicitly);
        }
        if (updateToAppend) {
            dumpSampleInfo.setToAppend(toAppend);
        }
        if (updateDumpArguments) {
            dumpSampleInfo.setDumpArguments(dumpArguments);
        }
        this.m_pendingChanges = true;
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("dumpSampling", m);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
    }

    @Override
    public void removeDumpSample(String sampleName) throws Exception {
        boolean removed;
        Map<String, DumpSampleInfo> m = this.m_config.getDumpSamples();
        if (m == null || !m.containsKey(sampleName)) {
            throw new Exception("dump sample \"" + sampleName + "\" does not exist");
        }
        boolean bl = removed = m.remove(sampleName) != null;
        if (removed) {
            this.m_pendingChanges = true;
            HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
            valueUpdate.put("dumpSampling", m);
            this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
        }
    }

    @Override
    public Map<String, String> getProblemKeyFilters() {
        return this.m_config.getProblemKeyFilters();
    }

    @Override
    public String getProblemKeyFilter(String filterId) {
        return this.m_config.getProblemKeyFilters().get(filterId);
    }

    @Override
    public boolean removeProblemKeyFilter(String filterId) {
        boolean removed;
        HashMap<String, String> filters = new HashMap<String, String>(this.m_config.getProblemKeyFilters());
        boolean bl = removed = filters.remove(filterId) != null;
        if (removed) {
            this.m_pendingChanges = true;
            HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
            valueUpdate.put("problemKeyFilters", filters);
            this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
        }
        return removed;
    }

    @Override
    public String addProblemKeyFilter(String filterPattern) {
        if (filterPattern == null || filterPattern.length() == 0) {
            throw new IllegalArgumentException("filterPattern should not be null or zero length");
        }
        this.m_pendingChanges = true;
        HashMap<String, String> filters = new HashMap<String, String>(this.m_config.getProblemKeyFilters());
        int i = 1;
        String id = null;
        while (filters.containsKey(id = String.valueOf(i++))) {
        }
        filters.put(id, filterPattern);
        HashMap<String, Object> valueUpdate = new HashMap<String, Object>();
        valueUpdate.put("problemKeyFilters", filters);
        this.m_config.setAttributes(valueUpdate, this.m_sendEvents);
        return id;
    }
}

