/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.common;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.dfw.resource.DiagnosticTranslation;

public enum DiagnosticsCategory {
    MEMORY,
    PERFORMANCE,
    CONFIGURATION,
    LOGGING,
    NETWORK,
    PROCESS,
    PORTS,
    THREADS,
    TIMEOUT,
    TOPOLOGY,
    SESSION,
    HTTP_REQUESTS,
    OTHER;

    private static ResourceBundle RBL;
    private static final long serialVersionUID = 0L;

    public static DiagnosticsCategory getDiagnosticsCategory(String category) {
        try {
            return DiagnosticsCategory.valueOf(category.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCategoryName() {
        String str = this.toString();
        String res = RBL.getString(str);
        if (res == null) {
            res = str;
        }
        return res;
    }

    static {
        RBL = new DiagnosticTranslation();
        try {
            RBL = ResourceBundle.getBundle(DiagnosticTranslation.class.getName());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

