/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.servlet;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.ContextParameterFactory;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.DMSCtxParamDescriptor;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.ContextParameterFactoryImpl;
import oracle.dms.context.internal.ContextParameterListener;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.WrapUtils;
import oracle.dms.servlet.DMSServletRequestInspector;
import oracle.dms.util.LogFloodController;
import oracle.dms.util.ServletUtils;

public class DMSServletFilter
implements Filter {
    private static final String CLASS_NAME = DMSServletFilter.class.getName();
    private static volatile boolean sEagerlySetContextValues = false;
    private static Logger sLogger = Logger.getLogger("oracle.dms.context", "oracle.dms.context.ContextResourceBundle");
    protected FilterConfig mFilterConfig;
    private LogFloodController mLogFloodCtlr;
    private DMSServletRequestInspector mRequestInspector;
    private ContextParameterListener mContextParameterListener;
    private Map<String, WeakReference<ContextParameterDescriptorInternal>> mValueHolderParamDescriptorsMap;
    private static final String FILTER_METHOD_NAME = "doFilter";
    private static final String COMPARE_METHOD_NAME = "compareStartAndEndContexts";

    public void init(FilterConfig filterConfig) {
        this.mFilterConfig = filterConfig;
        this.mLogFloodCtlr = new LogFloodController(sLogger);
        this.mLogFloodCtlr.addSimpleDecimationPolicy(CLASS_NAME, FILTER_METHOD_NAME, "DMS-57006", 50);
        this.mLogFloodCtlr.addSimpleDecimationPolicy(CLASS_NAME, COMPARE_METHOD_NAME, "DMS-57008", 50);
        this.mRequestInspector = this.getRequestInsepctor();
        this.mValueHolderParamDescriptorsMap = new ConcurrentHashMap<String, WeakReference<ContextParameterDescriptorInternal>>();
        ContextParameterFactory factory = DMSContextManager.getContextParameterFactory();
        if (factory instanceof ContextParameterFactoryImpl) {
            this.mContextParameterListener = new CtxParamListener();
            ((ContextParameterFactoryImpl)factory).registerListener(this.mContextParameterListener, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block15: {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            ExecutionContext startContext = null;
            boolean skipFiltering = DomainContextManager.WEB_REQUEST_CONTEXT_ATTRIBUTE_VALUE_TRUE.equals(httpServletRequest.getAttribute("oracle.dms.context.http.WebRequestContextProcessed"));
            if (skipFiltering) {
                sLogger.logp(Level.FINE, CLASS_NAME, FILTER_METHOD_NAME, "The request attribute used to signify that a DMSServletFilter is already handling this request has been detected. This filter will skip finding or activating any new context and will not signal the start or stop of an http request.");
            } else {
                httpServletRequest.setAttribute("oracle.dms.context.http.WebRequestContextProcessed", DomainContextManager.WEB_REQUEST_CONTEXT_ATTRIBUTE_VALUE_TRUE);
                if (DMSContextManager.isEnabled() && (startContext = this.mRequestInspector.getStartContext(httpServletRequest)) != null) {
                    HttpSession session;
                    httpServletResponse.addHeader("X-ORACLE-DMS-ECID", startContext.getECID());
                    startContext.getDomainExecutionContext().setCachedObject(DomainExecutionContext.ObjectCacheKey.HTTP_REQUEST, httpServletRequest);
                    if (sEagerlySetContextValues) {
                        for (WeakReference<ContextParameterDescriptorInternal> di : this.mValueHolderParamDescriptorsMap.values()) {
                            startContext.getValue((ContextParameterDescriptor)di.get());
                        }
                    }
                    if ((session = httpServletRequest.getSession(false)) != null) {
                        String httpSessionKey = (String)session.getAttribute("oracle.dms.context.DiagnosticHttpSessionId");
                        if (httpSessionKey == null) {
                            httpSessionKey = DMSServletFilter.generateHttpSessionKey();
                            session.setAttribute("oracle.dms.context.DiagnosticHttpSessionId", (Object)httpSessionKey);
                        }
                        startContext.setValue(DMSCtxParamDescriptor.DiagnosticHttpSessionId, httpSessionKey);
                    }
                }
                this.mRequestInspector.registerRequestStarted(httpServletRequest, httpServletResponse, startContext);
            }
            ExecutionContext endContext = null;
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                if (!skipFiltering) {
                    endContext = DMSContextManager.getActiveContext();
                    this.mRequestInspector.registerRequestEnded(httpServletRequest, httpServletResponse, endContext);
                    this.compareStartAndEndContexts(startContext, endContext, httpServletRequest);
                }
            }
            if (endContext != null) {
                try {
                    this.mRequestInspector.deactivateContext(endContext);
                }
                catch (Exception e) {
                    if (!sLogger.isLoggable(Level.WARNING)) break block15;
                    LogRecord lr = new LogRecord(Level.WARNING, "DMS-57006");
                    lr.setResourceBundle(sLogger.getResourceBundle());
                    lr.setSourceClassName(CLASS_NAME);
                    lr.setSourceMethodName(FILTER_METHOD_NAME);
                    lr.setParameters(new Object[]{endContext.getIDasString(), httpServletRequest.getRequestURL().toString()});
                    lr.setThrown(e);
                    this.mLogFloodCtlr.log(lr);
                }
            }
        }
    }

    private void compareStartAndEndContexts(ExecutionContext startContext, ExecutionContext endContext, HttpServletRequest httpServletRequest) {
        if (startContext != null && startContext != endContext && sLogger.isLoggable(Level.WARNING)) {
            LogRecord lr = new LogRecord(Level.WARNING, "DMS-57008");
            lr.setResourceBundle(sLogger.getResourceBundle());
            lr.setSourceClassName(CLASS_NAME);
            lr.setSourceMethodName(COMPARE_METHOD_NAME);
            lr.setParameters(new Object[]{startContext != null ? startContext.getIDasString() : "null", endContext != null ? endContext.getIDasString() : "null", ServletUtils.getRequestAsPrettyString(httpServletRequest)});
            this.mLogFloodCtlr.log(lr);
        }
    }

    public void destroy() {
        ContextParameterFactory factory = DMSContextManager.getContextParameterFactory();
        if (factory instanceof ContextParameterFactoryImpl) {
            ((ContextParameterFactoryImpl)factory).deregisterListener(this.mContextParameterListener);
        }
    }

    protected DMSServletRequestInspector getRequestInsepctor() {
        return new DMSServletRequestInspector();
    }

    private static String generateHttpSessionKey() {
        return WrapUtils.createECID();
    }

    public static void setEagerlySetContextValues(boolean eagerlySetContextValues) {
        sLogger.log(Level.INFO, "DMS-57016", eagerlySetContextValues);
        sEagerlySetContextValues = eagerlySetContextValues;
    }

    private class CtxParamListener
    implements ContextParameterListener {
        private CtxParamListener() {
        }

        @Override
        public void parameterDescriptorCreated(ContextParameterDescriptor d) {
            ContextParameterDescriptorInternal di;
            if (d instanceof ContextParameterDescriptorInternal && (di = (ContextParameterDescriptorInternal)d).getValueHolder() != null) {
                DMSServletFilter.this.mValueHolderParamDescriptorsMap.put(di.getName(), new WeakReference<ContextParameterDescriptorInternal>(di));
            }
        }
    }
}

