/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import oracle.core.ojdl.LogMessage;
import oracle.dms.http.DmsHttplet;
import oracle.dms.http.HttpAuthorizer;
import oracle.dms.http.HttpBasicAuthorizationException;
import oracle.dms.http.HttpException;
import oracle.dms.http.HttpParser;
import oracle.dms.http.HttpRequest;
import oracle.dms.http.HttpResponse;
import oracle.dms.http.HttpService;
import oracle.dms.http.Httpd;
import oracle.dms.http.Postlet;
import oracle.dms.instrument.CorrelationContext;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;

class HttpdThread
extends Thread {
    private static final int READ_CLIENT_SO_TIMEOUT = 20000;
    private static final String REALM = "DMS HTTP Listener";
    private Httpd m_parent = null;
    private volatile boolean m_shutdown = false;
    private Event m_httpError = null;
    private Event m_httpRequest = null;
    private PhaseEvent m_requestServiceTime = null;
    private static final String TOTAL_HTTP_ERRORS = "totalHttpErrors";
    private static final String TOTAL_HTTP_REQUESTS = "totalHttpRequests";
    private static final String TOTAL_REQUEST_SERVICE_TIME = "totalRequestServiceTime";

    HttpdThread(Httpd parent, int id) {
        super("Httpd-" + Integer.toHexString(id));
        if (parent == null) {
            throw new IllegalArgumentException(this.toString() + ": parent=" + parent);
        }
        this.m_parent = parent;
        if (DMSConsole.getSensorWeight() > 0) {
            this._initHttpListenerMetrics();
        }
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocket serverSocket = this.m_parent.getServerSocket();
        while (!this.m_shutdown) {
            Socket client = null;
            try {
                ServerSocket serverSocket2 = serverSocket;
                synchronized (serverSocket2) {
                    if (this.m_shutdown) {
                        break;
                    }
                    client = serverSocket.accept();
                }
                client.setSoTimeout(20000);
                client.setTcpNoDelay(true);
                if (this.m_shutdown) {
                    client.close();
                    break;
                }
                long serviceTimeToken = this.m_requestServiceTime == null ? 0L : this.m_requestServiceTime.start();
                try {
                    this._handleRequest(client);
                }
                finally {
                    if (this.m_requestServiceTime == null) continue;
                    this.m_requestServiceTime.stop(serviceTimeToken);
                }
            }
            catch (InterruptedIOException e) {
            }
            catch (IOException e) {
                if (client == null) break;
                try {
                    client.close();
                }
                catch (IOException ce) {}
                break;
            }
            catch (SecurityException e) {
                break;
            }
        }
    }

    void shutdown() {
        this.m_shutdown = true;
    }

    private void _initHttpListenerMetrics() {
        Noun listRoot = Noun.create(DMSUtil.genCompNounPath("HTTP"), "n/a");
        this.m_httpError = Event.create(listRoot, TOTAL_HTTP_ERRORS, DMSNLSupport.getString("HTTP_totalHttpErrors"));
        this.m_httpRequest = Event.create(listRoot, TOTAL_HTTP_REQUESTS, DMSNLSupport.getString("HTTP_totalHttpRequests"));
        this.m_requestServiceTime = PhaseEvent.create(listRoot, TOTAL_REQUEST_SERVICE_TIME, DMSNLSupport.getString("HTTP_totalRequestServiceTime"));
        this.m_requestServiceTime.deriveMetric(511);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleRequest(Socket client) {
        if (this.m_httpRequest != null) {
            this.m_httpRequest.occurred();
        }
        ServerSocket serverSocket = this.m_parent.getServerSocket();
        HttpRequest request = null;
        HttpResponse response = null;
        boolean contextEntered = false;
        try {
            request = new HttpRequest(client.getInputStream(), this.m_parent);
            response = new HttpResponse(request, client.getOutputStream());
            HttpParser.readRequest(request);
            if (this.m_shutdown) {
                return;
            }
            LogMessage.InstanceId instId = request.getInstanceID();
            contextEntered = true;
            if (instId != null) {
                CorrelationContext.enter("Collector", "DmsHttpd", instId);
            } else {
                CorrelationContext.enter("DmsHttpd");
            }
            if (this.m_shutdown) {
                return;
            }
            HttpAuthorizer autherizor = (HttpAuthorizer)this.m_parent.getAuthorizer();
            if (!autherizor.authenticate(client.getInetAddress(), request.getBasicAuthorization())) {
                if (autherizor.needPasswd()) {
                    throw new HttpBasicAuthorizationException(REALM);
                }
                throw new HttpException(403);
            }
            if (this.m_shutdown) {
                return;
            }
            DmsHttplet httplet = request.getHttplet();
            if (httplet == null) {
                throw new HttpException(404);
            }
            ByteArrayOutputStream perfData = new ByteArrayOutputStream();
            if (httplet instanceof HttpService) {
                PrintWriter out = new PrintWriter(perfData);
                ((HttpService)httplet).service(request, response, out);
                out.flush();
            } else if (httplet instanceof Postlet && request.getHttpMethod() == 2) {
                ((Postlet)httplet).service(request, response, perfData);
                perfData.flush();
            } else {
                throw new HttpException(404);
            }
            response.print(perfData.toByteArray());
            perfData.close();
        }
        catch (HttpException ex) {
            try {
                ex.print(response);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (this.m_httpError != null) {
                this.m_httpError.occurred();
            }
            if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                Httpd.LOGGER.logp(Level.FINEST, this.getClass().getName(), "_handleRequest", "port=" + serverSocket.getLocalPort(), ex);
            }
        }
        catch (IOException ex) {
            if (this.m_httpError != null) {
                this.m_httpError.occurred();
            }
            if (Httpd.LOGGER.isLoggable(Level.FINEST)) {
                Httpd.LOGGER.logp(Level.FINEST, this.getClass().getName(), "_handleRequest", "port=" + serverSocket.getLocalPort(), ex);
            }
        }
        finally {
            if (request != null) {
                request.close();
            }
            if (response != null) {
                response.close();
            }
            try {
                client.close();
            }
            catch (IOException ce) {}
            if (contextEntered) {
                CorrelationContext.exit();
            }
        }
    }
}

