/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dms.http.Request;
import oracle.dms.reporter.MetricTableReporter;
import oracle.dms.reporter.TableBaseReporter;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.TableSource;
import oracle.dms.table.TableSupport;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.QueryOptions;

public class MetricListReporter
extends TableBaseReporter {
    TableSource m_source = null;
    private boolean m_doTreelet = true;
    private static final String PREFIX = "TV_";
    private static final String[] KNOWN_CATEGORIES = new String[]{"DMS", "WebLogic", "WebSphere", "NON_J2EE", "Aggregation", "J2EEServer", "JseServer"};

    public MetricListReporter(TableSource tableSource, Request request, boolean doTreelet) {
        super(request);
        if (tableSource == null) {
            throw new IllegalArgumentException("source=" + tableSource);
        }
        this.m_source = tableSource;
        this.m_doTreelet = doTreelet;
    }

    @Override
    protected void setQueryOptions() {
        super.setQueryOptions();
        this.m_options.setQueryType(QueryOptions.QueryType.SCHEMA);
        this.m_options.setUseCache(QueryOptions.UseCache.CACHE_COPY);
    }

    @Override
    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    @Override
    public final void printResponse(PrintWriter out) {
        MetricTableReporter.printHTMLStart(out);
        out.println("</head><body>");
        MetricTableReporter.printBanner(DMSNLSupport.getString("TV_TABLES", "Metric Tables"), this.m_request, out);
        if (!this.m_doTreelet) {
            this._printTextFormat(null, "metricTableFrame", out);
            out.print("<p>");
        }
        TableSupport[] tables = (TableSupport[])this.m_source.getTables(null, this.m_options);
        Map<String, Set<String>> nameCategories = this._categorizeTableNames(tables);
        TreeSet<String> categoryNames = new TreeSet<String>(nameCategories.keySet());
        MetricTableReporter.printTableStart(0, 2, out, 100);
        for (String category : KNOWN_CATEGORIES) {
            if (!categoryNames.remove(category)) continue;
            this._printCategories(category, out);
        }
        for (String category : categoryNames) {
            this._printCategories(category, out);
        }
        out.println("</table><p>");
        for (String category : KNOWN_CATEGORIES) {
            Set<String> names = nameCategories.remove(category);
            this._printTables(category, names, out);
        }
        for (Map.Entry<String, Set<String>> entry : nameCategories.entrySet()) {
            String catetory = entry.getKey();
            Set<String> names = entry.getValue();
            this._printTables(catetory, names, out);
        }
        out.print("<hr>");
        out.print(new Date());
        out.print("<br>");
        out.print(DMSNLSupport.getString("TV_COPY_RIGHT", "Copyright &copy; 2002, 2013, Oracle and/or its affiliates. All rights reserved."));
        out.println("</body></html>");
    }

    private void _printTextFormat(String table, String target, PrintWriter out) {
        out.print("<a href=\"");
        out.print(DMSUtil.urlXssEscape(this.m_request.getRequestURI()));
        out.print("?format=raw");
        if (table != null && table.trim().length() > 0) {
            out.print('&');
            out.print("table");
            out.print('=');
            out.print(table);
        }
        out.println("\" ");
        MetricTableReporter.printStatusLine(DMSNLSupport.getString("TV_TEXT_DESC", "Show metrics in text format"), out);
        if (target != null && target.trim().length() > 0) {
            out.print(" target=");
            out.print(target);
        }
        out.print('>');
        out.print(DMSNLSupport.getString("TV_TEXT", "Text Format"));
        out.println("</a>");
    }

    private void _printTables(String category, Set<String> names, PrintWriter out) {
        if (names == null || names.size() == 0) {
            return;
        }
        MetricTableReporter.printTableStart(0, 2, out, 100);
        String translation = DMSNLSupport.getString(PREFIX + category, category);
        out.print("<tr class=lightRow><td class=list><b><a name='");
        out.print(category);
        out.print("'>");
        out.print(translation);
        out.println("</a></b></td></tr>");
        for (String table : names) {
            out.print("<tr class=lightRow><td class=list><a class=noLine");
            MetricTableReporter.printTableSort(table, DMSUtil.urlXssEscape(this.m_request.getRequestURI()), out);
            out.print(" target=");
            out.print("metricTableFrame");
            out.print('>');
            out.print(DMSUtil.xssEscape(table));
            out.println("</a></td></tr>");
        }
        out.println("</table><p>");
    }

    private void _printCategories(String category, PrintWriter out) {
        String translation = DMSNLSupport.getString(PREFIX + category, category);
        out.print("<tr class=lightRow><td class=list><a class=noLine href='#");
        out.print(category);
        out.print("'>");
        out.print(translation);
        out.print("</a></td></tr>");
    }

    private Map<String, Set<String>> _categorizeTableNames(TableSupport[] tables) {
        TreeMap<String, Set<String>> nameCategories = new TreeMap<String, Set<String>>();
        if (tables == null || tables.length == 0) {
            return nameCategories;
        }
        for (TableSupport table : tables) {
            TreeSet<String> names;
            if (table == null) continue;
            String name = table.getName();
            SchemaSupport schema = (SchemaSupport)table.getSchema();
            String category = null;
            if (schema != null) {
                category = schema.getProperty("SpyCategory");
            }
            if (category == null || category.trim().length() == 0) {
                category = "DMS";
            }
            if ((names = (TreeSet<String>)nameCategories.get(category)) == null) {
                names = new TreeSet<String>();
                nameCategories.put(category, names);
            }
            names.add(name);
        }
        return nameCategories;
    }
}

