/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.PrintStream;
import java.util.Set;
import oracle.dms.event.Event;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.config.DestinationDescription;
import oracle.dms.util.Validatable;
import oracle.dms.util.ValidationException;

@DestinationDescription(nlsDescriptionResourceBundle="oracle.dms.event.EventResourceBundle", nlsDescriptionID="STDOUT")
public class StdoutDestination
implements LoadableDestination {
    private String mName;
    private String mId;
    private PrintStream mPrintStream = System.out;

    @Override
    public void setName(String name) {
        if (this.mName == null) {
            this.mName = name;
        }
    }

    @Override
    public void setId(String id) {
        if (this.mId == null) {
            this.mId = id;
        }
    }

    public void setUseStdErr(String boolAsString) {
        this.mPrintStream = Boolean.valueOf(boolAsString) != false ? System.err : System.out;
    }

    @Override
    public void handleEvent(Event event) {
        this.mPrintStream.println(event.toString());
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public void initDestination() {
    }

    @Override
    public void shutdownDestination() {
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) throws ValidationException {
    }
}

