/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockState;

public class ClockManager {
    private static HashMap _clocks = new HashMap();
    private static volatile Clock _primary = null;
    public static final String DEFAULT = "default";
    public static final String LOGICAL = "logical";
    public static final String HIGHRES = "highres";
    private static HashMap _clockmap = new HashMap();
    public static final long TICKS = 1L;
    public static final long MSECS = 1000L;
    public static final long USECS = 1000000L;
    public static final long NSECS = 1000000000L;
    private static final Logger LOGGER;
    private static HashMap _unitmap;

    public static synchronized void shutdown() {
        _clocks.clear();
        _primary = null;
        ClockState.shutdown();
    }

    public static Clock getClock() {
        if (_primary == null) {
            Clock clock;
            _primary = clock = ClockManager.createClock(DEFAULT);
        }
        return _primary;
    }

    public static Clock createClock(String cname) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Checking if clock (" + cname + ") is loaded");
        }
        String clazzname = null;
        Clock clock = (Clock)_clocks.get(cname);
        if (clock != null) {
            return clock;
        }
        clazzname = (String)_clockmap.get(cname);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "The class name for (" + cname + ") is " + clazzname);
        }
        if (clazzname == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(clazzname);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Called Class.forName(\"" + clazzname + "\")");
            }
            clock = (Clock)clazz.newInstance();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Created a new instance of " + clazzname);
            }
            _clocks.put(cname.toLowerCase(), clock);
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("Can't find or load class " + clazzname);
            return null;
        }
        return clock;
    }

    public static long getFrequency(String units) {
        Long Lunits;
        if (units != null && (Lunits = (Long)_unitmap.get(units.toLowerCase())) != null) {
            return Lunits;
        }
        return ClockManager.getClock().getReportedFrequency();
    }

    public static String getUnits(long freq) {
        String units = (String)_unitmap.get(freq);
        if (units != null) {
            return units;
        }
        return ClockManager.getClock().getUnits();
    }

    public static Clock setClock(String cname) {
        Clock clock = ClockManager.createClock(cname);
        if (clock != null) {
            _primary = clock;
        } else {
            clock = ClockManager.getClock();
        }
        return clock;
    }

    static {
        _clockmap.put(DEFAULT, "oracle.dms.clock.SimpleClock");
        _clockmap.put(LOGICAL, "oracle.dms.clock.LogicalClock");
        _clockmap.put(HIGHRES, "oracle.dms.clock.HighResolutionClock");
        LOGGER = Logger.getLogger("oracle.dms.instrument", "oracle.dms.util.dms");
        _unitmap = new HashMap();
        _unitmap.put("ticks", 1L);
        _unitmap.put("msecs", 1000L);
        _unitmap.put("usecs", 1000000L);
        _unitmap.put("nsecs", 1000000000L);
        _unitmap.put(1L, "ticks");
        _unitmap.put(1000L, "msecs");
        _unitmap.put(1000000L, "usecs");
        _unitmap.put(1000000000L, "nsecs");
    }
}

