/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import oracle.dms.http.Request;
import oracle.dms.reporter.DMSTbmlGenerator;
import oracle.dms.reporter.TabletReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.NullValue;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;

public class TbmlReporter
extends TabletReporter {
    public TbmlReporter(Request request) {
        super(request);
        this.registerTbmlGenerator(new DMSTbmlGenerator());
    }

    @Override
    public void printHeading(PrintWriter out) {
        if (!"true".equalsIgnoreCase(this.m_request.getParameter("nodoctype"))) {
            out.print("<?xml version='1.0' encoding='UTF-8'?>\n");
        }
        out.print("<tbml xmlns=\"http://www.oracle.com/AS/collector\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version='");
        out.print("11.0");
        out.print("' id='");
        out.print(this.m_id);
        out.print("' host='");
        out.print(DMSUtil.getLocalHostname());
        out.print("' ");
        out.print("name");
        out.print("='");
        out.print(this.m_name);
        out.print("' timestamp='");
        long tstamp = Time.currentTimeMillis();
        out.print(tstamp);
        out.print("'>\n");
    }

    @Override
    public void printEnding(PrintWriter out) {
        out.print("</");
        out.print("tbml");
        out.print(">\n");
    }

    public static final void printColumnDefinition(String name, PrintWriter out) {
        TbmlReporter.printColumnDefinition(name, null, null, null, out);
    }

    public static final void printColumnDefinition(String name, String type, String unit, String description, PrintWriter out) {
        boolean hasDescription;
        out.print('<');
        out.print("columndef");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        if (type != null && type.trim().length() > 0 && !"string".equalsIgnoreCase(type)) {
            out.print("' ");
            out.print("type");
            out.print("='");
            out.print(type);
        }
        boolean hasUnit = unit != null && unit.trim().length() > 0;
        boolean bl = hasDescription = description != null && description.trim().length() > 0;
        if (hasUnit || hasDescription) {
            out.print("'>\n");
            if (hasUnit) {
                out.print('<');
                out.print("unit");
                out.print("><![CDATA[");
                out.print(DMSUtil.xmlEscape(unit));
                out.print("]]></");
                out.print("unit");
                out.print(">\n");
            }
            if (hasDescription) {
                out.print('<');
                out.print("description");
                out.print("><![CDATA[");
                out.print(DMSUtil.xmlEscape(description));
                out.print("]]></");
                out.print("description");
                out.print(">\n");
            }
            out.print("</");
            out.print("columndef");
            out.print(">\n");
        } else {
            out.print("'/>\n");
        }
    }

    public static final void printVariableName(String name, String description, PrintWriter out) {
        out.print('<');
        out.print("variable");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        if (description != null && description.length() > 0) {
            out.print("'><![CDATA[");
            out.print(DMSUtil.xmlEscape(description));
            out.print("]]></");
            out.print("variable");
            out.print(">\n");
        } else {
            out.print("'/>\n");
        }
    }

    public static final void printProperty(String name, String value, PrintWriter out) {
        out.print('<');
        out.print("property");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        out.print("'><![CDATA[");
        out.print(DMSUtil.xmlEscape(value));
        out.print("]]></");
        out.print("property");
        out.print(">\n");
    }

    public static final void printColumn(String name, Serializable value, ValueType type, PrintWriter out) {
        boolean isNumber = false;
        out.print('<');
        out.print("column");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        if (type == ValueType.INTEGER || type == ValueType.DOUBLE || type == ValueType.LONG) {
            out.print("' type='");
            out.print(type.toString());
            isNumber = true;
        } else if (type == ValueType.STRING) {
            if (value == null || value instanceof NullValue) {
                out.print("' type='");
                out.print(type.toString());
            }
        } else if (value instanceof Long) {
            out.print("' type='long");
            isNumber = true;
        } else if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            out.print("' type='integer");
            isNumber = true;
        } else if (value instanceof Double || value instanceof Float) {
            out.print("' type='double");
            isNumber = true;
        }
        if (value == null || value instanceof NullValue) {
            out.print("' ");
            out.print("null");
            out.print("='true'/>\n");
        } else if (value instanceof ErrorObject) {
            out.print("' ");
            out.print("error");
            out.print("='true'/>\n");
        } else {
            if (isNumber) {
                out.print("'>");
                out.print(value);
            } else {
                out.print("'><![CDATA[");
                out.print(DMSUtil.xmlEscape(value.toString()));
                out.print("]]>");
            }
            out.print("</");
            out.print("column");
            out.print(">\n");
        }
    }

    public static final void printRowHeading(boolean isCacheable, PrintWriter out) {
        out.print('<');
        out.print("row");
        if (!isCacheable) {
            TbmlReporter._printNonCacheable(out);
        }
        out.print(">\n");
    }

    public static final void printRowEnding(PrintWriter out) {
        out.print("</");
        out.print("row");
        out.print(">\n");
    }

    public static final void printTableHeading(String name, Collection<String> keys, Collection<String> serverNames, boolean isCacheable, PrintWriter out) {
        out.print('<');
        out.print("table");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        out.print("' ");
        out.print("keys");
        out.print("='");
        Iterator<String> iter = keys.iterator();
        while (iter.hasNext()) {
            out.print(iter.next());
            if (!iter.hasNext()) continue;
            out.print(' ');
        }
        out.print('\'');
        if (serverNames != null && serverNames.size() > 0) {
            out.print(' ');
            out.print("componentId");
            out.print("='");
            iter = serverNames.iterator();
            while (iter.hasNext()) {
                out.print(iter.next());
                if (!iter.hasNext()) continue;
                out.print(' ');
            }
            out.print('\'');
        }
        if (!isCacheable) {
            TbmlReporter._printNonCacheable(out);
        }
        out.print(">\n");
    }

    public static final void printTableHeading(String name, String[] keys, String[] serverNames, PrintWriter out) {
        int i;
        out.print('<');
        out.print("table");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(DMSUtil.xssEscape(name));
        out.print("' ");
        out.print("keys");
        out.print("='");
        for (i = 0; i < keys.length; ++i) {
            if (i != 0) {
                out.print(' ');
            }
            out.print(keys[i]);
        }
        out.print('\'');
        if (serverNames != null && serverNames.length > 0) {
            out.print(' ');
            out.print("componentId");
            out.print("='");
            for (i = 0; i < serverNames.length; ++i) {
                if (i != 0) {
                    out.print(' ');
                }
                out.print(serverNames[i]);
            }
            out.print('\'');
        }
        out.print(">\n");
    }

    public static final void printTableEnding(PrintWriter out) {
        out.print("</");
        out.print("table");
        out.print(">\n");
    }

    public static final void printColumnGroup(String name, String type, Collection<String> metricNames, String description, PrintWriter out) {
        out.print('<');
        out.print("columngroupdef");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        if (type != null && type.trim().length() > 0) {
            out.print("' ");
            out.print("type");
            out.print("='");
            out.print(type);
        }
        if (metricNames != null && metricNames.size() > 0) {
            out.print("' ");
            out.print("columns");
            out.print("='");
            Iterator<String> iter = metricNames.iterator();
            while (iter.hasNext()) {
                out.print(iter.next());
                if (!iter.hasNext()) continue;
                out.print(' ');
            }
        }
        if (description != null && description.trim().length() > 0) {
            out.print("'>\n<");
            out.print("description");
            out.print("><![CDATA[");
            out.print(DMSUtil.xmlEscape(description));
            out.print("]]></");
            out.print("description");
            out.print(">\n</");
            out.print("columngroupdef");
            out.print(">\n");
        } else {
            out.print("'/>\n");
        }
    }

    public static final void printColumnGroup(String name, String type, String[] metricNames, String description, PrintWriter out) {
        out.print('<');
        out.print("columngroupdef");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(name);
        if (type != null && type.trim().length() > 0) {
            out.print("' ");
            out.print("type");
            out.print("='");
            out.print(type);
        }
        if (metricNames != null && metricNames.length > 0) {
            out.print("' ");
            out.print("columns");
            out.print("='");
            for (int i = 0; i < metricNames.length; ++i) {
                if (i != 0) {
                    out.print(' ');
                }
                out.print(metricNames[i]);
            }
        }
        if (description != null && description.trim().length() > 0) {
            out.print("'>\n<");
            out.print("description");
            out.print("><![CDATA[");
            out.print(DMSUtil.xmlEscape(description));
            out.print("]]></");
            out.print("description");
            out.print(">\n</");
            out.print("columngroupdef");
            out.print(">\n");
        } else {
            out.print("'/>\n");
        }
    }

    private static final void _printNonCacheable(PrintWriter out) {
        out.print(' ');
        out.print("cacheable");
        out.print("='false'");
    }
}

