/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.websphere;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.LogUtil;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.framework.DiagnosticsFrameworkProvider;
import oracle.dfw.impl.common.SecurityContext;
import oracle.dfw.spi.portable.DiagnosticsFrameworkPlatformExtension;
import oracle.dfw.spi.websphere.SecurityContextImpl;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public class WebSphereDiagnosticsFrameworkExtension
implements DiagnosticsFrameworkPlatformExtension {
    private String m_productId = "domain";
    private String m_instanceId = "server";
    private String m_serverName;
    private String m_cellName;
    private String m_adrBase;
    private String m_serverConfigPath;
    private String m_domainConfigPath;
    private ServerPlatformSupport m_jrf = ServerPlatformSupportFactory.getInstance();
    private static final String CONFIG_FILE = "dfw_config.xml";
    private static final String COMMON_COMPONENTS_HOME = "common.components.home";
    private static final String WAS_DIAG_RULES = "/oracle/dfw/spi/websphere/was-rules.xml";

    public WebSphereDiagnosticsFrameworkExtension() throws Exception {
        this.setPropertiesFromServer();
    }

    @Override
    public String getOracleHome() {
        File adrHome;
        String oracleHome = WebSphereDiagnosticsFrameworkExtension.getProperty(COMMON_COMPONENTS_HOME, null);
        if (oracleHome != null && oracleHome.length() > 0 && WebSphereDiagnosticsFrameworkExtension.exists(adrHome = new File(oracleHome, "adr"))) {
            oracleHome = adrHome.getAbsolutePath();
        }
        return oracleHome;
    }

    @Override
    public String getADRBase() {
        return this.m_adrBase;
    }

    @Override
    public String getProductId() {
        return this.m_productId;
    }

    @Override
    public String getInstanceId() {
        return this.m_instanceId;
    }

    @Override
    public File getDiagnosticsConfigFile() {
        return new File(this.m_serverConfigPath + File.separator + CONFIG_FILE);
    }

    @Override
    public File[] getCustomRuleDirs() {
        return new File[]{new File(this.m_domainConfigPath, "dfw"), new File(this.m_serverConfigPath, "dfw")};
    }

    @Override
    public SecurityContext getSecurityContext() {
        SecurityContextImpl secContext = null;
        try {
            secContext = new SecurityContextImpl();
        }
        catch (Exception e) {
            LoggerFactory.getFrameworkLogger().log(Level.WARNING, "DFW-40203", e);
        }
        return secContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupExtension(DiagnosticsFrameworkProvider dfw, Map<String, String> properties) {
        if (dfw.getDDE() != null && this.m_serverName != null && this.m_serverName.length() > 0) {
            InputStreamReader isr = null;
            try {
                InputStream rulesStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return this.getClass().getResourceAsStream(WebSphereDiagnosticsFrameworkExtension.WAS_DIAG_RULES);
                    }
                });
                isr = new InputStreamReader(rulesStream);
                dfw.getDDE().registerRules(isr, "was-rules", true, null);
            }
            catch (Exception e) {
                LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40206", (Object[])new Object[]{WAS_DIAG_RULES}, (Throwable)e);
            }
            finally {
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (Exception e) {
                        LoggerFactory.getFrameworkLogger().log(Level.FINEST, "failure closing stream for /oracle/dfw/spi/websphere/was-rules.xml", e);
                    }
                }
            }
        }
        if (this.m_serverName != null) {
            properties.put("DFW_SERVER_NAME", this.m_serverName);
        }
        if (this.m_cellName != null) {
            properties.put("DFW_DOMAIN_NAME", this.m_cellName);
        }
    }

    private void setPropertiesFromServer() throws Exception {
        try {
            Class<?> adminServiceFactory = Class.forName("com.ibm.websphere.management.AdminServiceFactory");
            Class<?> adminServiceClass = Class.forName("com.ibm.websphere.management.AdminService");
            Object adminService = adminServiceFactory.getMethod("getAdminService", new Class[0]).invoke(null, new Object[0]);
            this.m_cellName = (String)adminServiceClass.getMethod("getCellName", new Class[0]).invoke(adminService, new Object[0]);
        }
        catch (Exception e) {
            LoggerFactory.getFrameworkLogger().log(Level.WARNING, "DFW-40207", e);
        }
        if (this.m_cellName == null) {
            this.m_cellName = "cell";
        }
        this.m_productId = this.m_cellName;
        this.m_instanceId = this.m_serverName = this.m_jrf.getServerName();
        File serverHome = new File(this.m_jrf.getServerLogPath());
        File adrHome = new File(serverHome, "adr");
        this.m_adrBase = adrHome.getCanonicalPath();
        this.m_serverConfigPath = this.m_jrf.getServerConfigDirectory(null, this.m_serverName);
        this.m_domainConfigPath = this.m_jrf.getDomainConfigDirectory();
    }

    private static String getProperty(final String key, final String def) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, def);
            }
        });
    }

    private static boolean exists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }
}

