/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassUtils {
    private static Logger sLogger = Logger.getLogger("oracle.dms.instrument", "oracle.dms.util.dms");
    private static final String CLASS_NAME = ClassUtils.class.getName();

    public static Object getClass(String className, Class requiredType) {
        ArrayList listObjects;
        block4: {
            if (className == null) {
                return null;
            }
            listObjects = new ArrayList();
            try {
                ClassUtils.getClassInstances(className, requiredType, listObjects);
            }
            catch (RuntimeException re) {
                if (!sLogger.getLevel().equals(Level.WARNING)) break block4;
                sLogger.log(Level.WARNING, re.getMessage());
            }
        }
        Object retVal = null;
        if (listObjects.size() > 0) {
            retVal = listObjects.get(0);
        }
        return retVal;
    }

    public static List getClassInstances(String classNames, Class requiredType) {
        ArrayList retVal;
        block3: {
            if (classNames == null) {
                return null;
            }
            retVal = new ArrayList();
            try {
                ClassUtils.getClassInstances(classNames, requiredType, retVal);
            }
            catch (RuntimeException re) {
                if (!sLogger.getLevel().equals(Level.WARNING)) break block3;
                sLogger.log(Level.WARNING, re.getMessage());
            }
        }
        return retVal;
    }

    public static void getClassInstances(String classNames, Class requiredType, List list) {
        if (classNames != null && list != null) {
            StringTokenizer st = new StringTokenizer(classNames, ",");
            while (st.hasMoreTokens()) {
                String className = st.nextToken();
                Object o = ClassUtils.getObjectOfClass(className);
                if ((o = requiredType.cast(o)) == null) continue;
                list.add(o);
            }
        }
    }

    private static Object getObjectOfClass(String className) {
        String METHOD_NAME = "getObjectOfClass";
        Object o = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = cl.loadClass(className);
            o = clazz.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to load class " + className, t);
        }
        return o;
    }

    public static void applyProperties(Object o, Map<String, String> properties) throws CompoundMapException {
        HashMap<String, Throwable> failedProperties = new HashMap<String, Throwable>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Class<?> oClass = o.getClass();
            String propertyName = entry.getKey();
            String methodName = ClassUtils.getSetMethodNameForProperty(propertyName);
            try {
                Method m = oClass.getMethod(methodName, String.class);
                m.invoke(o, entry.getValue());
            }
            catch (Throwable t) {
                failedProperties.put(entry.getKey(), t);
            }
        }
        if (failedProperties.size() > 0) {
            throw new CompoundMapException(failedProperties);
        }
    }

    public static String getSetMethodNameForProperty(String propertyName) {
        String methodName = null;
        if (propertyName != null) {
            methodName = propertyName.length() <= 1 ? "set" + propertyName.toUpperCase() : "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        }
        return methodName;
    }

    public static Method getSetMethodForProperty(Class clazz, String propertyName) {
        Method method = null;
        String methodName = ClassUtils.getSetMethodNameForProperty(propertyName);
        if (methodName != null) {
            try {
                method = clazz.getMethod(methodName, String.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return method;
    }

    public static List<String> getWriteablePropertyNamesForClass(Class clazz) {
        LinkedList<String> retVal = new LinkedList<String>();
        for (Method method : clazz.getMethods()) {
            if (!ClassUtils.isSetterMethod(method)) continue;
            String propertyName = ClassUtils.getPropertyNameForSetMethod(method);
            retVal.add(propertyName);
        }
        return retVal;
    }

    public static String getPropertyNameForSetMethod(Method method) {
        String propertyName = null;
        if (method != null && ClassUtils.isSetterMethod(method)) {
            propertyName = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        }
        return propertyName;
    }

    public static boolean isSetterMethod(Method method) {
        boolean retVal = false;
        if (method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == String.class) {
            retVal = true;
        }
        return retVal;
    }

    public static String getPrettyStack(StackTraceElement[] stackTraceElements) {
        String retVal = null;
        StringBuilder sb = new StringBuilder();
        ClassUtils.appendPrettyStack(sb, stackTraceElements);
        retVal = sb.toString();
        return retVal;
    }

    public static void appendPrettyStack(StringBuilder sb, StackTraceElement[] stackTraceElements) {
        Thread currentThread = Thread.currentThread();
        sb.append("Thread (id):\n    ").append(currentThread.getName()).append(" (").append(currentThread.getId()).append(")").append("\n Stack:\n");
        StackTraceElement[] stes = stackTraceElements != null ? stackTraceElements : Thread.currentThread().getStackTrace();
        for (int i = 2; i < stes.length; ++i) {
            StackTraceElement ste = stes[i];
            sb.append("    ").append(ste.getClassName()).append('(').append(ste.getFileName()).append(':').append(ste.getLineNumber()).append(')').append(':').append(ste.getMethodName()).append('\n');
        }
    }

    public static class CompoundMapException
    extends Exception {
        private Map<String, Throwable> mMapOfExceptions;

        CompoundMapException(Map<String, Throwable> mapOfExceptions) {
            this.mMapOfExceptions = mapOfExceptions;
        }

        @Override
        public String getMessage() {
            String retVal = null;
            if (this.mMapOfExceptions != null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, Throwable> entry : this.mMapOfExceptions.entrySet()) {
                    sb.append("[");
                    sb.append(entry.getKey());
                    sb.append(", ");
                    sb.append(entry.getValue().getClass().getName());
                    sb.append(": ");
                    sb.append(entry.getValue().getMessage());
                    sb.append("] ");
                }
                retVal = sb.toString();
            }
            return retVal;
        }
    }
}

