/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.as.management.tracing.HttpRequestListener;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.WrapUtils;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.util.Time;

public class DMSServletRequestInspector {
    protected static Logger sLogger = Logger.getLogger("oracle.dms.context", "oracle.dms.context.ContextResourceBundle");
    private String CLASS_NAME = DMSServletRequestInspector.class.getName();
    private Object mTracingListener = null;

    public DMSServletRequestInspector() {
        try {
            this.mTracingListener = Class.forName("oracle.as.management.tracing.impl.TracingController").getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            sLogger.log(Level.FINE, "Unable to get TracingController instance. Selective tracing support is disabled: " + t, t);
        }
    }

    public ExecutionContext getStartContext(HttpServletRequest httpServletRequest) {
        ExecutionContext startContext;
        block9: {
            String METHOD_NAME = "getStartContext";
            startContext = null;
            try {
                ExecutionContext unwrappedCtx = null;
                String ctxParam = this.findWrappedContextString(httpServletRequest);
                if (ctxParam != null && ctxParam.length() > 0) {
                    DomainContextManager dcm = DMSContextManager.getDomainContextManager();
                    if (dcm != null) {
                        dcm.deactivateContext();
                        WrapUtils.UnwrapResult ur = WrapUtils.unwrap(dcm, ctxParam, false, true, true, true, Level.FINE);
                        DomainExecutionContext dctx = ur.getUnwrappedDomainExecutionContext();
                        if (dctx != null) {
                            unwrappedCtx = dctx.getAsMutableExecutionContext();
                        }
                    }
                    if (sLogger.isLoggable(Level.FINE)) {
                        if (unwrappedCtx != null) {
                            sLogger.logp(Level.FINE, this.CLASS_NAME, "getStartContext", "Unwrapped context encoded within incoming request:" + unwrappedCtx.getIDasString());
                        } else {
                            sLogger.logp(Level.FINE, this.CLASS_NAME, "getStartContext", "Found wrapped context, but failed to unwrap it:" + ctxParam);
                        }
                    }
                } else {
                    sLogger.logp(Level.FINE, this.CLASS_NAME, "getStartContext", "No wrapped context found in request.");
                }
                startContext = unwrappedCtx != null ? unwrappedCtx : ExecutionContext.get();
            }
            catch (Exception e) {
                if (!sLogger.isLoggable(Level.WARNING)) break block9;
                LogRecord lr = new LogRecord(Level.WARNING, "DMS-57003");
                lr.setResourceBundle(sLogger.getResourceBundle());
                lr.setSourceClassName(this.CLASS_NAME);
                lr.setSourceMethodName("getStartContext");
                lr.setParameters(new Object[]{null, httpServletRequest.getRemoteAddr() + ":" + httpServletRequest.getRemotePort(), httpServletRequest.getHeader("USER-AGENT"), httpServletRequest.getRequestURL().toString()});
                lr.setThrown(e);
                sLogger.log(lr);
            }
        }
        return startContext;
    }

    public void deactivateContext(ExecutionContext endContext) {
        endContext.deactivate();
    }

    private String getWrappedContexFromQueryString(String queryString) {
        String retVal;
        block7: {
            String METHOD_NAME = "getWrappedContexFromQueryString";
            retVal = null;
            if (queryString != null) {
                String parameterValue = null;
                String paramNameWithEquals = "ECID-Context=";
                int paramNameLength = "ECID-Context".length();
                int startOfParamNameWithEquals = queryString.indexOf("ECID-Context=");
                if (startOfParamNameWithEquals != -1) {
                    int startOfNextParamName = queryString.indexOf(38, startOfParamNameWithEquals);
                    int startOfParamValue = startOfParamNameWithEquals + paramNameLength + 1;
                    if (startOfNextParamName == -1) {
                        parameterValue = queryString.substring(startOfParamValue);
                    } else {
                        int endOfParamValue = startOfNextParamName;
                        parameterValue = queryString.substring(startOfParamValue, endOfParamValue);
                    }
                }
                if (parameterValue != null) {
                    try {
                        retVal = URLDecoder.decode(parameterValue, "ascii");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!sLogger.isLoggable(Level.WARNING)) break block7;
                        sLogger.logp(Level.WARNING, this.CLASS_NAME, "getWrappedContexFromQueryString", "DMS-57007", new String[]{parameterValue, e.getMessage()});
                    }
                }
            }
        }
        return retVal;
    }

    private String findWrappedContextString(HttpServletRequest httpServletRequest) {
        String METHOD_NAME = "findWrappedContextString";
        String ctxParam = null;
        ctxParam = httpServletRequest.getHeader("ECID-Context");
        if (ctxParam != null && sLogger.isLoggable(Level.FINE)) {
            sLogger.logp(Level.FINE, this.CLASS_NAME, "findWrappedContextString", "Found wrapped context string in header of request:" + ctxParam);
        }
        if (ctxParam == null || ctxParam.length() == 0) {
            if ("POST".equals(httpServletRequest.getMethod())) {
                ctxParam = this.getWrappedContexFromQueryString(httpServletRequest.getQueryString());
                if (ctxParam != null && sLogger.isLoggable(Level.FINE)) {
                    sLogger.logp(Level.FINE, this.CLASS_NAME, "findWrappedContextString", "Found wrapped context string in query string of POST request:" + ctxParam);
                }
            } else {
                ctxParam = httpServletRequest.getParameter("ECID-Context");
                if (ctxParam != null && sLogger.isLoggable(Level.FINE)) {
                    sLogger.logp(Level.FINE, this.CLASS_NAME, "findWrappedContextString", "Found wrapped context string in parameter of non-POST request:" + ctxParam);
                }
            }
        }
        return ctxParam;
    }

    public void registerRequestStarted(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ExecutionContext ctx) {
        block7: {
            block6: {
                String METHOD_NAME = "registerRequestStarted";
                try {
                    if (this.mTracingListener != null) {
                        ((HttpRequestListener)this.mTracingListener).handleHttpRequest(httpServletRequest, ctx);
                    }
                }
                catch (Throwable t) {
                    if (!sLogger.isLoggable(Level.FINE)) break block6;
                    sLogger.logp(Level.FINE, this.CLASS_NAME, "registerRequestStarted", "Call to tracing controller failed: " + t, t);
                }
            }
            try {
                EventReportingManager eMgr = EventSystem.getEventReportingManager();
                if (eMgr != null) {
                    eMgr.reportEvent(null, EventSourceType.HTTP_REQUEST, EventActionType.START, Time.currentTimeMillis(), ctx, new Object[]{httpServletRequest, httpServletResponse});
                }
            }
            catch (Exception t) {
                if (!sLogger.isLoggable(Level.WARNING)) break block7;
                LogRecord lr = new LogRecord(Level.WARNING, "DMS-58034");
                lr.setResourceBundle(sLogger.getResourceBundle());
                lr.setSourceClassName(this.CLASS_NAME);
                lr.setSourceMethodName("registerRequestStarted");
                lr.setParameters(new Object[]{ctx == null ? "(unknown)" : ctx.getIDasString(), httpServletRequest.getRequestURL().toString()});
                lr.setThrown(t);
                sLogger.log(lr);
            }
        }
    }

    public void registerRequestEnded(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ExecutionContext ctx) {
        block3: {
            String METHOD_NAME = "registerRequestEnded";
            try {
                EventReportingManager eMgr = EventSystem.getEventReportingManager();
                if (eMgr != null) {
                    eMgr.reportEvent(null, EventSourceType.HTTP_REQUEST, EventActionType.STOP, Time.currentTimeMillis(), ctx, new Object[]{httpServletRequest, httpServletResponse});
                }
            }
            catch (Exception t) {
                if (!sLogger.isLoggable(Level.WARNING)) break block3;
                LogRecord lr = new LogRecord(Level.WARNING, "DMS-58034");
                lr.setResourceBundle(sLogger.getResourceBundle());
                lr.setSourceClassName(this.CLASS_NAME);
                lr.setSourceMethodName("registerRequestEnded");
                lr.setParameters(new Object[]{ctx == null ? "(unknown)" : ctx.getIDasString(), httpServletRequest.getRequestURL().toString()});
                lr.setThrown(t);
                sLogger.log(lr);
            }
        }
    }
}

