/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dms.http.Request;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounRefresh;
import oracle.dms.reporter.TableBaseReporter;
import oracle.dms.reporter.TableExporter;

public abstract class TabletReporter
extends TableBaseReporter {
    private List<TableExporter> m_tbmlGenerators = Collections.synchronizedList(new ArrayList());

    TabletReporter(Request request) {
        super(request);
    }

    @Override
    public void clear() {
        for (TableExporter tbmlGenerator : this.m_tbmlGenerators) {
            tbmlGenerator.close();
        }
        this.m_tbmlGenerators.clear();
        super.clear();
    }

    public void registerTbmlGenerators(Collection<TableExporter> tbmlGenerators) {
        if (tbmlGenerators != null) {
            this.m_tbmlGenerators.addAll(tbmlGenerators);
        }
    }

    public void registerTbmlGenerator(TableExporter tbmlGenerator) {
        if (tbmlGenerator != null) {
            this.m_tbmlGenerators.add(tbmlGenerator);
        }
    }

    public void unregisterTbmlGenerator(TableExporter tbmlGenerator) {
        if (tbmlGenerator != null) {
            this.m_tbmlGenerators.remove(tbmlGenerator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void printResponse(PrintWriter out) {
        TableExporter[] tbmlGenerators;
        if (out == null) {
            throw new IllegalArgumentException("out=" + out);
        }
        HashSet<String> badTables = new HashSet<String>();
        List<TableExporter> list = this.m_tbmlGenerators;
        synchronized (list) {
            tbmlGenerators = new TableExporter[this.m_tbmlGenerators.size()];
            for (int i = 0; i < this.m_tbmlGenerators.size(); ++i) {
                tbmlGenerators[i] = this.m_tbmlGenerators.get(i).copy();
            }
        }
        List[] tableLists = new List[tbmlGenerators.length];
        HashSet<String> tableSet = new HashSet<String>();
        for (int i = 0; i < tbmlGenerators.length; ++i) {
            tableLists[i] = new ArrayList();
        }
        String[] tables = this.m_request.getTables();
        if (tables == null || tables.length == 0) {
            for (int i = 0; i < tbmlGenerators.length; ++i) {
                tbmlGenerators[i].getTableNames(tableLists[i], this.m_options);
                tableSet.addAll(tableLists[i]);
            }
        } else {
            HashSet<String> handledTables = new HashSet<String>();
            for (String table : tables) {
                if (handledTables.contains(table)) continue;
                handledTables.add(table);
                boolean handled = false;
                for (int i = 0; i < tbmlGenerators.length; ++i) {
                    if (!tbmlGenerators[i].containsTable(table, this.m_options)) continue;
                    tableLists[i].add(table);
                    tableSet.add(table);
                    handled = true;
                    break;
                }
                if (handled) continue;
                badTables.add(table);
            }
            handledTables.clear();
        }
        this._refreshNoun(tableSet);
        this.printHeading(out);
        HashSet printedNames = new HashSet();
        for (int i = 0; i < tbmlGenerators.length; ++i) {
            if (!tbmlGenerators[i].init(tableLists[i], this.m_options)) continue;
            tbmlGenerators[i].refreshMetrics();
            tbmlGenerators[i].printTables(out);
            tbmlGenerators[i].close();
        }
        this.printBadParams(null, badTables, out);
        this.printEnding(out);
        badTables.clear();
        printedNames.clear();
        tableSet.clear();
    }

    private void _refreshNoun(Set<String> tables) {
        Set<NounRefresh> refreshes;
        boolean includeRows = true;
        if (this.m_options != null) {
            includeRows = this.m_options.includeRows();
        }
        if (!includeRows) {
            return;
        }
        HashSet<String> tableSet = new HashSet<String>();
        if (tables == null || tables.size() == 0) {
            refreshes = Noun.getNounRefresh();
        } else {
            refreshes = new HashSet<NounRefresh>();
            for (String table : tables) {
                if (table == null || table.length() == 0) continue;
                tableSet.add(table);
                NounRefresh refresh = Noun.getNounRefresh(table);
                if (refresh == null) continue;
                refreshes.add(refresh);
            }
        }
        for (NounRefresh refresh : refreshes) {
            if (refresh == null) continue;
            refresh.refresh(tableSet);
        }
    }

    public abstract void printHeading(PrintWriter var1);

    public abstract void printEnding(PrintWriter var1);
}

