/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class IncidentReadme {
    private String m_incidentId;
    private String m_incidentSource;
    private String m_createTime;
    private String m_problemKey;
    private String m_appName;
    private String m_userName;
    private String m_problemImpacts;
    private String m_messageId;
    private String m_ecid;
    private String m_description;
    private String m_contextValues;
    private String m_httpRequest;
    private String m_stackTrace;
    private String m_dumps;

    public IncidentReadme(InputStream readme) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(readme));
        this.parse(br);
    }

    private void parse(BufferedReader br) throws Exception {
        String line = null;
        boolean inMultiLine = false;
        String multiLineSection = null;
        String multiLineSectionName = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("Incident Id:")) {
                this.m_incidentId = line.substring("Incident Id:".length() + 1);
                continue;
            }
            if (line.startsWith("Incident Source:")) {
                this.m_incidentSource = line.substring("Incident Source:".length() + 1);
                continue;
            }
            if (line.startsWith("Create Time:")) {
                this.m_createTime = line.substring("Create Time:".length() + 1);
                continue;
            }
            if (line.startsWith("Problem Key:")) {
                this.m_problemKey = line.substring("Problem Key:".length() + 1);
                continue;
            }
            if (line.startsWith("ECID:")) {
                this.m_ecid = line.substring("ECID:".length() + 1);
                continue;
            }
            if (line.startsWith("Application Name:")) {
                this.m_appName = line.substring("Application Name:".length() + 1);
                continue;
            }
            if (line.startsWith("User Name:")) {
                this.m_userName = line.substring("User Name:".length() + 1);
                continue;
            }
            if (line.startsWith("Problem Impacts:")) {
                this.m_problemImpacts = line.substring("Problem Impacts:".length() + 1);
                continue;
            }
            if (line.startsWith("Error Message Id:")) {
                this.m_messageId = line.substring("Error Message Id:".length() + 1);
                continue;
            }
            if (line.startsWith("Context Values")) {
                if (inMultiLine) {
                    this.handleMultiLine(multiLineSectionName, multiLineSection);
                }
                inMultiLine = true;
                multiLineSection = "";
                multiLineSectionName = "Context Values";
                br.readLine();
                continue;
            }
            if (line.startsWith("HTTP Request")) {
                if (inMultiLine) {
                    this.handleMultiLine(multiLineSectionName, multiLineSection);
                }
                inMultiLine = true;
                multiLineSection = "";
                multiLineSectionName = "HTTP Request";
                br.readLine();
                continue;
            }
            if (line.startsWith("Description")) {
                if (inMultiLine) {
                    this.handleMultiLine(multiLineSectionName, multiLineSection);
                }
                inMultiLine = true;
                multiLineSection = "";
                multiLineSectionName = "Description";
                br.readLine();
                continue;
            }
            if (line.startsWith("Stack Trace")) {
                if (inMultiLine) {
                    this.handleMultiLine(multiLineSectionName, multiLineSection);
                }
                inMultiLine = true;
                multiLineSection = "";
                multiLineSectionName = "Stack Trace";
                br.readLine();
                continue;
            }
            if (line.startsWith("Diagnostic Dumps")) {
                if (inMultiLine) {
                    this.handleMultiLine(multiLineSectionName, multiLineSection);
                }
                inMultiLine = true;
                multiLineSection = "";
                multiLineSectionName = "Diagnostic Dumps";
                br.readLine();
                continue;
            }
            if (!inMultiLine) continue;
            multiLineSection = multiLineSection + line + "\n";
        }
        if (inMultiLine && multiLineSection != null) {
            this.handleMultiLine(multiLineSectionName, multiLineSection);
        }
    }

    private void handleMultiLine(String sectionName, String sectionText) {
        if (sectionName.equals("Description")) {
            this.m_description = sectionText;
        } else if (sectionName.equals("Stack Trace")) {
            this.m_stackTrace = sectionText;
        } else if (sectionName.equals("Diagnostic Dumps")) {
            this.m_dumps = sectionText;
        } else if (sectionName.equals("Context Values")) {
            this.m_contextValues = sectionText;
        } else if (sectionName.equals("HTTP Request")) {
            this.m_httpRequest = sectionText;
        }
    }

    public String toString() {
        StringBuffer readme = new StringBuffer();
        readme.append("Incident Id:");
        readme.append(' ');
        readme.append(this.m_incidentId);
        readme.append('\n');
        readme.append("Incident Source:");
        readme.append(' ');
        readme.append(this.m_incidentSource);
        readme.append('\n');
        readme.append("Create Time:");
        readme.append(' ');
        readme.append(this.m_createTime);
        readme.append('\n');
        readme.append("Problem Key:");
        readme.append(' ');
        readme.append(this.m_problemKey);
        readme.append('\n');
        readme.append("ECID:");
        readme.append(' ');
        readme.append(this.m_ecid);
        readme.append('\n');
        readme.append("Application Name:");
        readme.append(' ');
        readme.append(this.m_appName);
        readme.append('\n');
        readme.append("User Name:");
        readme.append(' ');
        readme.append(this.m_userName);
        readme.append('\n');
        readme.append("Problem Impacts:");
        readme.append(' ');
        readme.append(this.m_problemImpacts);
        readme.append('\n');
        readme.append("Error Message Id:");
        readme.append(' ');
        readme.append(this.m_messageId);
        readme.append('\n');
        readme.append("Context Values");
        readme.append(":\n");
        readme.append(this.m_contextValues);
        readme.append('\n');
        readme.append('\n');
        readme.append("HTTP Request");
        readme.append(":\n");
        readme.append(this.m_httpRequest);
        readme.append('\n');
        readme.append('\n');
        readme.append("Description");
        readme.append(":\n");
        readme.append(this.m_description);
        readme.append('\n');
        readme.append('\n');
        readme.append("Stack Trace");
        readme.append(":\n");
        readme.append(this.m_stackTrace);
        readme.append('\n');
        readme.append('\n');
        readme.append("Diagnostic Dumps");
        readme.append(":\n");
        readme.append(this.m_dumps);
        return readme.toString();
    }

    public String getIncidentId() {
        return this.m_incidentId;
    }

    public String getIncidentSource() {
        return this.m_incidentSource;
    }

    public String getIncidentTime() {
        return this.m_createTime;
    }

    public String getProblemKey() {
        return this.m_problemKey;
    }

    public String getApplicationName() {
        return this.m_appName;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getProblemImpacts() {
        return this.m_problemImpacts;
    }

    public String getMessageId() {
        return this.m_messageId;
    }

    public String getECID() {
        return this.m_ecid;
    }

    public String getContextValues() {
        return this.m_contextValues;
    }

    public String getHttpRequest() {
        return this.m_httpRequest;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getStackTrace() {
        return this.m_stackTrace;
    }

    public String getDiagnosticDumps() {
        return this.m_dumps;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("readme must be specified");
            return;
        }
        IncidentReadme ir = new IncidentReadme(new FileInputStream(args[0]));
        System.out.println(ir);
    }
}

