/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.config.paramscopedmetrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.config.Config;
import oracle.dms.config.ConfigChild;
import oracle.dms.config.DMSConfigurationException;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.internal.ParamScopedMetricsConfigBuilder;
import oracle.dms.instrument.internal.ParamScopedMetricsSystem;
import oracle.dms.jmx.ParameterConstraint;
import oracle.dms.jmx.ParameterScopedMetricsRule;
import oracle.dms.util.CollectionUtils;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.MapUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@JSONUtils.JSONFormatToString
public class ParamScopedMetricsConfig
implements ConfigChild {
    private Map<String, ParameterScopedMetricsRule> mRuleIdToRuleMap;
    private boolean mUpdatedSinceLastSave = false;
    private static Logger sLogger = Logger.getLogger("oracle.dms.config");
    private static AtomicInteger sInstanceCounter = new AtomicInteger();
    private int mInstanceNumber = sInstanceCounter.incrementAndGet();
    private static final String PARAM_SCOPED_METRIC_CONFIG_ELEMENT_NAME = "parameterScopedMetricsConfiguration";
    private static final String PARAM_SCOPED_METRIC_RULE_ELEMENT_NAME = "parameterScopedMetricsRule";
    private static final String PARAM_SCOPED_METRIC_RULE_ATTRIBUITE_ID_NAME = "id";
    private static final String PARAM_SCOPED_METRIC_NOUN_TYPE_ELEMENT_NAME = "nounType";
    private static final String PARAM_SCOPED_METRIC_NOUN_TYPE_ATTRIBUTE_NAME_NAME = "name";
    private static final String PARAM_SCOPED_METRIC_NOUN_TYPE_ATTRIBUTE_OPERATOR_NAME = "operator";
    private static final String PARAM_SCOPED_METRIC_ACTIVATION_PARAMETER_CONSTRAINTS_ELEMENT_NAME = "activationParameterConstraint";
    private static final String PARAM_SCOPED_METRIC_CONTEXT_PARAMETER_CONSTRAINTS_ELEMENT_NAME = "contextParameterConstraint";
    private static ParamScopedMetricsConfig sParamScopedMetricsConfig = null;
    public static final int DEFAULT_MAX_NUM_VALUES = 10;

    public ParamScopedMetricsConfig() {
        this.mRuleIdToRuleMap = new HashMap<String, ParameterScopedMetricsRule>();
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "Created new ParamScopedMetricsConfig instance -  " + this.mInstanceNumber);
        }
    }

    public Set<ParameterScopedMetricsRule> getParameterScopedMetricsRules(String ruleId) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").getParameterScopedMetricsRules:  " + ruleId);
        }
        HashSet<ParameterScopedMetricsRule> retVal = null;
        if (ruleId != null) {
            if (this.mRuleIdToRuleMap.get(ruleId) != null) {
                retVal = new HashSet();
                retVal.add(this.mRuleIdToRuleMap.get(ruleId));
            }
        } else if (!this.mRuleIdToRuleMap.isEmpty()) {
            retVal = new HashSet<ParameterScopedMetricsRule>();
            retVal.addAll(this.mRuleIdToRuleMap.values());
        }
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").getParameterScopedMetricsRules:  returning " + CollectionUtils.toString(retVal));
        }
        return retVal;
    }

    public Set<ParameterScopedMetricsRule> removeParameterScopedMetricsRules(String[] ruleIds) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").removeParameterScopedMetricsRules:  " + Arrays.toString(ruleIds));
        }
        HashSet<ParameterScopedMetricsRule> retVal = new HashSet<ParameterScopedMetricsRule>();
        for (String ruleId : ruleIds) {
            ParameterScopedMetricsRule removedRule = this.mRuleIdToRuleMap.remove(ruleId);
            if (removedRule == null) continue;
            this.mUpdatedSinceLastSave = true;
            retVal.add(removedRule);
        }
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").removeParameterScopedMetricsRules:  returning " + CollectionUtils.toString(retVal));
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterScopedMetricsRule addParameterScopedMetricsRule(ParameterScopedMetricsRule pRule, boolean replaceIfExists) throws DMSConfigurationException {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").addParameterScopedMetricsRule:  " + pRule);
        }
        ParameterScopedMetricsRule oldRule = null;
        ParameterScopedMetricsRule newRule = null;
        if (this.mRuleIdToRuleMap.containsKey(pRule.getId())) {
            if (!replaceIfExists) throw new DMSConfigurationException("DMS_59003", pRule.getId());
            newRule = pRule;
            oldRule = this.mRuleIdToRuleMap.get(pRule.getId());
        } else {
            newRule = pRule;
            oldRule = null;
        }
        this.checkRuleForConflictsWithCurrentRules(newRule, oldRule);
        this.applyRule(newRule, oldRule);
        if (!sLogger.isLoggable(Level.FINER)) return oldRule;
        sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").addParameterScopedMetricsRule:  returning " + oldRule);
        return oldRule;
    }

    private void applyRule(ParameterScopedMetricsRule newRule, ParameterScopedMetricsRule oldRule) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").applyRule:  " + newRule);
        }
        this.mRuleIdToRuleMap.put(newRule.getId(), newRule);
        this.mUpdatedSinceLastSave = true;
    }

    private void checkRuleForConflictsWithCurrentRules(ParameterScopedMetricsRule newRule, ParameterScopedMetricsRule oldRule) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").checkRuleForConflictsWithCurrentRules:  " + newRule + ", " + oldRule);
        }
        for (ParameterScopedMetricsRule r : this.mRuleIdToRuleMap.values()) {
            if (r == oldRule) continue;
            this.doRulesConflict(newRule, r);
        }
    }

    private void doRulesConflict(ParameterScopedMetricsRule newRule, ParameterScopedMetricsRule currentRule) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").doRulesConflict:  " + newRule + ", " + currentRule);
        }
        boolean nounTypesOverlap = false;
        boolean paramTypesOverlap = false;
        ParameterScopedMetricsRule.NounTypePattern[] newNounPatterns = newRule.getNounTypePatterns();
        ParameterScopedMetricsRule.NounTypePattern[] currentNounPatterns = currentRule.getNounTypePatterns();
        if (newNounPatterns == null || newNounPatterns.length == 0 || currentNounPatterns == null || currentNounPatterns.length == 0) {
            nounTypesOverlap = true;
        } else {
            for (ParameterScopedMetricsRule.NounTypePattern newNounPattern : newNounPatterns) {
                for (ParameterScopedMetricsRule.NounTypePattern currentNounPattern : currentNounPatterns) {
                    if (!currentNounPattern.isMatch(newNounPattern.getNounType()) && !newNounPattern.isMatch(currentNounPattern.getNounType())) continue;
                    nounTypesOverlap = true;
                }
            }
        }
        if (nounTypesOverlap) {
            String[] currentParamNames;
            String[] newParamNames = this.getParamNames(newRule.getActivationParameterConstraints());
            if (CollectionUtils.getArrayIntersection(newParamNames, currentParamNames = this.getParamNames(currentRule.getActivationParameterConstraints()), false) != null) {
                paramTypesOverlap = true;
            }
            if (CollectionUtils.getArrayIntersection(newParamNames = this.getParamNames(newRule.getContextParameterConstraints()), currentParamNames = this.getParamNames(currentRule.getContextParameterConstraints()), false) != null) {
                paramTypesOverlap = true;
            }
        }
        if (nounTypesOverlap && paramTypesOverlap) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").doRulesConflict: Yes noun and parameter types overlap " + newRule + ", " + currentRule);
            }
            throw new RuntimeException("Conflicting rules detected - The noun types and parameters to be used by new rule " + newRule.getId() + " conflict with the noun types and parameter already in use by rule " + currentRule.getId());
        }
    }

    private String[] getParamNames(ParameterConstraint[] constraintArray) {
        Object[] retVal = null;
        if (constraintArray != null) {
            retVal = new String[constraintArray.length];
            for (int i = 0; i < constraintArray.length; ++i) {
                retVal[i] = constraintArray[i].getParameterName();
            }
        }
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").getParamNames, returning: " + Arrays.toString(retVal));
        }
        return retVal;
    }

    @Override
    public synchronized void parseConfigDocument(Element xdms) throws DMSConfigurationException {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").parseConfigDocument - start");
        }
        HashMap<String, ParameterScopedMetricsRule> parsedConfig = new HashMap<String, ParameterScopedMetricsRule>();
        if (xdms == null) {
            throw new IllegalArgumentException("xdms=null");
        }
        try {
            Element paramScopedMetricConfig;
            NodeList paramScopedMetricRuleList;
            NodeList paramScopedMetricConfigList = xdms.getElementsByTagName(PARAM_SCOPED_METRIC_CONFIG_ELEMENT_NAME);
            if (paramScopedMetricConfigList.getLength() == 1 && (paramScopedMetricRuleList = (paramScopedMetricConfig = (Element)paramScopedMetricConfigList.item(0)).getElementsByTagName(PARAM_SCOPED_METRIC_RULE_ELEMENT_NAME)).getLength() > 0) {
                for (int i = 0; i < paramScopedMetricRuleList.getLength(); ++i) {
                    Element paramScopedMetricRule = (Element)paramScopedMetricRuleList.item(i);
                    ParameterScopedMetricsRule psmr = this.parseParamScopedMetricsRule(paramScopedMetricRule);
                    parsedConfig.put(psmr.getId(), psmr);
                }
            }
        }
        catch (Exception e) {
            String mesg = DMSUtil.errorMessage("50727", new Object[0]);
            throw new DMSConfigurationException(mesg, e);
        }
        this.mRuleIdToRuleMap = parsedConfig;
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").parseConfigDocument - done: " + MapUtils.toString(this.mRuleIdToRuleMap));
        }
    }

    private ParameterScopedMetricsRule parseParamScopedMetricsRule(Element paramScopedMetricRuleElement) {
        NodeList nounTypeNodeList;
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").parseParamScopedMetricsRule - start");
        }
        ParameterScopedMetricsRule retVal = null;
        LinkedList<ParameterScopedMetricsRule.NounTypePattern> nounPatternsList = new LinkedList<ParameterScopedMetricsRule.NounTypePattern>();
        String ruleId = null;
        boolean enabled = true;
        ruleId = paramScopedMetricRuleElement.getAttribute(PARAM_SCOPED_METRIC_RULE_ATTRIBUITE_ID_NAME);
        String enabledString = paramScopedMetricRuleElement.getAttribute("enabled");
        if (enabledString != null) {
            enabled = Boolean.parseBoolean(enabledString);
        }
        if ((nounTypeNodeList = paramScopedMetricRuleElement.getElementsByTagName(PARAM_SCOPED_METRIC_NOUN_TYPE_ELEMENT_NAME)).getLength() > 0) {
            for (int i = 0; i < nounTypeNodeList.getLength(); ++i) {
                String nounType = ((Element)nounTypeNodeList.item(i)).getAttribute(PARAM_SCOPED_METRIC_NOUN_TYPE_ATTRIBUTE_NAME_NAME);
                String operatorAsString = ((Element)nounTypeNodeList.item(i)).getAttribute(PARAM_SCOPED_METRIC_NOUN_TYPE_ATTRIBUTE_OPERATOR_NAME);
                ParameterScopedMetricsRule.NounTypeOperator operator = ParameterScopedMetricsRule.NounTypeOperator.findOperator(operatorAsString);
                if (operator == null) {
                    operator = ParameterScopedMetricsRule.NounTypeOperator.EQUALS;
                }
                if (nounType == null) continue;
                nounPatternsList.add(new ParameterScopedMetricsRule.NounTypePattern(nounType, operator));
            }
        }
        List<ParameterConstraint> actParamConstraintList = this.parseParameterConstraints(paramScopedMetricRuleElement, PARAM_SCOPED_METRIC_ACTIVATION_PARAMETER_CONSTRAINTS_ELEMENT_NAME);
        List<ParameterConstraint> ctxParamConstraintList = this.parseParameterConstraints(paramScopedMetricRuleElement, PARAM_SCOPED_METRIC_CONTEXT_PARAMETER_CONSTRAINTS_ELEMENT_NAME);
        if (ruleId != null && (actParamConstraintList.size() > 0 || ctxParamConstraintList.size() > 0)) {
            ParameterScopedMetricsRule.NounTypePattern[] nounPatternsArr = null;
            if (nounPatternsList.size() > 0) {
                nounPatternsArr = new ParameterScopedMetricsRule.NounTypePattern[nounPatternsList.size()];
                nounPatternsList.toArray(nounPatternsArr);
            }
            ParameterConstraint[] actParamConstraintsArr = null;
            if (actParamConstraintList.size() > 0) {
                actParamConstraintsArr = new ParameterConstraint[actParamConstraintList.size()];
                actParamConstraintList.toArray(actParamConstraintsArr);
            }
            ParameterConstraint[] ctxParamConstraintsArr = null;
            if (ctxParamConstraintList.size() > 0) {
                ctxParamConstraintsArr = new ParameterConstraint[ctxParamConstraintList.size()];
                ctxParamConstraintList.toArray(ctxParamConstraintsArr);
            }
            retVal = new ParameterScopedMetricsRule(ruleId, nounPatternsArr, actParamConstraintsArr, ctxParamConstraintsArr);
        }
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").parseParamScopedMetricsRule - returning " + retVal);
        }
        return retVal;
    }

    private List<ParameterConstraint> parseParameterConstraints(Element paramScopedMetricRuleElement, String childElementTagName) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").parseParameterConstraints - starting ");
        }
        LinkedList<ParameterConstraint> retVal = new LinkedList<ParameterConstraint>();
        NodeList paramScopeMetricConstraintList = paramScopedMetricRuleElement.getElementsByTagName(childElementTagName);
        for (int i = 0; i < paramScopeMetricConstraintList.getLength(); ++i) {
            ParameterConstraint pc = this.parseParameterConstraint((Element)paramScopeMetricConstraintList.item(i));
            if (pc == null) continue;
            retVal.add(pc);
        }
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").parseParameterConstraints - returning: " + CollectionUtils.toString(retVal));
        }
        return retVal;
    }

    private ParameterConstraint parseParameterConstraint(Element parameterConstraintElement) {
        String maxNumValuesString;
        NodeList parameterValueNodeList;
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").parseParameterConstraint - starting ");
        }
        ParameterConstraint retVal = null;
        String parameterName = null;
        LinkedList<String> parameterValueList = new LinkedList<String>();
        int maxNumOfValues = -2;
        String defaultValue = null;
        if (parameterConstraintElement.getElementsByTagName("parameterName").getLength() == 1) {
            parameterName = this.getElementsTextBody((Element)parameterConstraintElement.getElementsByTagName("parameterName").item(0));
        }
        if ((parameterValueNodeList = parameterConstraintElement.getElementsByTagName("parameterValue")).getLength() > 0) {
            for (int i = 0; i < parameterValueNodeList.getLength(); ++i) {
                Element parameterValueElement = (Element)parameterValueNodeList.item(i);
                String parameterValue = this.getElementsTextBody(parameterValueElement);
                if (parameterValue == null) continue;
                parameterValueList.add(parameterValue);
            }
        } else if (parameterConstraintElement.getElementsByTagName("maxNumOfValues").getLength() == 1 && (maxNumValuesString = this.getElementsTextBody((Element)parameterConstraintElement.getElementsByTagName("maxNumOfValues").item(0))) != null) {
            maxNumOfValues = Integer.parseInt(maxNumValuesString);
        }
        if (parameterConstraintElement.getElementsByTagName("valueIfNull").getLength() == 1) {
            defaultValue = this.getElementsTextBody((Element)parameterConstraintElement.getElementsByTagName("valueIfNull").item(0));
        }
        if (parameterName != null) {
            String[] parameterValueArray = null;
            if (parameterValueList.size() > 0) {
                parameterValueArray = new String[parameterValueList.size()];
                parameterValueList.toArray(parameterValueArray);
            }
            retVal = new ParameterConstraint(parameterName, parameterValueArray, defaultValue, maxNumOfValues);
        }
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").parseParameterConstraint - returning: " + retVal);
        }
        return retVal;
    }

    private String getElementsTextBody(Element element) {
        String retVal = null;
        if (element != null && element.getChildNodes().getLength() == 1 && element.getChildNodes().item(0).getNodeType() == 3) {
            retVal = element.getTextContent();
        }
        return retVal;
    }

    @Override
    public synchronized Element buildElement(Document document) throws DMSConfigurationException {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").buildElement - starting ");
        }
        Element retVal = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", PARAM_SCOPED_METRIC_CONFIG_ELEMENT_NAME);
        if (this.mRuleIdToRuleMap != null && this.mRuleIdToRuleMap.size() > 0) {
            for (ParameterScopedMetricsRule psmr : this.mRuleIdToRuleMap.values()) {
                Element psmrElement = document.createElement(PARAM_SCOPED_METRIC_RULE_ELEMENT_NAME);
                psmrElement.setAttribute(PARAM_SCOPED_METRIC_RULE_ATTRIBUITE_ID_NAME, psmr.getId());
                if (psmr.getNounTypePatterns() != null && psmr.getNounTypePatterns().length > 0) {
                    for (ParameterScopedMetricsRule.NounTypePattern nounTypePattern : psmr.getNounTypePatterns()) {
                        Element nounTypeElement = document.createElement(PARAM_SCOPED_METRIC_NOUN_TYPE_ELEMENT_NAME);
                        nounTypeElement.setAttribute(PARAM_SCOPED_METRIC_NOUN_TYPE_ATTRIBUTE_NAME_NAME, nounTypePattern.getNounType());
                        nounTypeElement.setAttribute(PARAM_SCOPED_METRIC_NOUN_TYPE_ATTRIBUTE_OPERATOR_NAME, nounTypePattern.getNounTypeOperator().getPrimaryAlias());
                        psmrElement.appendChild(nounTypeElement);
                    }
                }
                if (psmr.getActivationParameterConstraints() != null && psmr.getActivationParameterConstraints().length > 0) {
                    this.appendParameterConstraints(document, psmrElement, PARAM_SCOPED_METRIC_ACTIVATION_PARAMETER_CONSTRAINTS_ELEMENT_NAME, psmr.getActivationParameterConstraints());
                }
                if (psmr.getContextParameterConstraints() != null && psmr.getContextParameterConstraints().length > 0) {
                    this.appendParameterConstraints(document, psmrElement, PARAM_SCOPED_METRIC_CONTEXT_PARAMETER_CONSTRAINTS_ELEMENT_NAME, psmr.getContextParameterConstraints());
                }
                retVal.appendChild(psmrElement);
            }
        }
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").buildElement - done ");
        }
        return retVal;
    }

    private void appendParameterConstraints(Document rootDocument, Element paramScopedMetricRuleElement, String elementName, ParameterConstraint[] paramConstraints) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").appendParameterConstraints - starting: " + Arrays.toString(paramConstraints));
        }
        if (paramConstraints != null && paramConstraints.length > 0) {
            for (ParameterConstraint constraint : paramConstraints) {
                Element e;
                Element paramConstraintsElement = rootDocument.createElement(elementName);
                paramScopedMetricRuleElement.appendChild(paramConstraintsElement);
                Element paramNameElement = rootDocument.createElement("parameterName");
                paramNameElement.setTextContent(constraint.getParameterName());
                paramConstraintsElement.appendChild(paramNameElement);
                if (constraint.getParameterValues() != null && constraint.getParameterValues().length > 0) {
                    for (String value : constraint.getParameterValues()) {
                        Element e2 = rootDocument.createElement("parameterValue");
                        e2.setTextContent(value);
                        paramConstraintsElement.appendChild(e2);
                    }
                } else if (constraint.getMaxNumberOfValues() != -2) {
                    e = rootDocument.createElement("maxNumOfValues");
                    e.setTextContent(Integer.toString(constraint.getMaxNumberOfValues()));
                    paramConstraintsElement.appendChild(e);
                }
                if (constraint.getDefaultValue() == null) continue;
                e = rootDocument.createElement("valueIfNull");
                e.setTextContent(constraint.getDefaultValue());
                paramConstraintsElement.appendChild(e);
            }
        }
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").appendParameterConstraints - done");
        }
    }

    @Override
    public boolean isConfigurationUpdated() {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").isConfigUpdated - returning: " + Boolean.toString(this.mUpdatedSinceLastSave));
        }
        return this.mUpdatedSinceLastSave;
    }

    @Override
    public void setConfigurationUpdated(boolean updated) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").setConfigurationUpdated - set to " + Boolean.toString(updated));
        }
        this.mUpdatedSinceLastSave = updated;
    }

    @Override
    public synchronized void sync(Config config) throws DMSConfigurationException {
        ParamScopedMetricsConfig pendingConfig = config.getParamScopedMetricsConfig();
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").sync -  starting: " + pendingConfig);
        }
        ParamScopedMetricsConfig.makeConfigActiveInRuntime(pendingConfig);
        this.mRuleIdToRuleMap = pendingConfig.mRuleIdToRuleMap;
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").sync -  done: ");
        }
    }

    public static void makeConfigActiveInRuntime(ParamScopedMetricsConfig configToActivate) {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(static).activateConfiguration -  start: " + configToActivate);
        }
        ParamScopedMetricsConfigBuilder builder = ParamScopedMetricsSystem.getConfigBuilder();
        Map<String, ParameterScopedMetricsRule> rulesMap = configToActivate.mRuleIdToRuleMap;
        if (rulesMap != null && !rulesMap.isEmpty()) {
            for (ParameterScopedMetricsRule rule : rulesMap.values()) {
                HashSet<ParameterScopedMetricsRule.NounTypePattern> nounPatterns = null;
                if (rule.getNounTypePatterns() != null && rule.getNounTypePatterns().length > 0) {
                    nounPatterns = CollectionUtils.toSetFromArray(rule.getNounTypePatterns());
                } else {
                    nounPatterns = new HashSet<ParameterScopedMetricsRule.NounTypePattern>(1);
                    nounPatterns.add(ParameterScopedMetricsRule.NounTypePattern.ALL_NOUN_TYPES);
                }
                if (rule.getActivationParameterConstraints() != null) {
                    for (ParameterConstraint pc : rule.getActivationParameterConstraints()) {
                        String paramName = pc.getParameterName();
                        Set<String> paramValues = CollectionUtils.toSetFromArray(pc.getParameterValues());
                        builder.addRule(paramName, ActivationParameterDescriptor.class, nounPatterns, paramValues, pc.getMaxNumberOfValues(), pc.getDefaultValue());
                    }
                }
                DomainContextManager dcm = DMSContextManager.getDomainContextManager();
                if (rule.getContextParameterConstraints() == null || dcm == null) continue;
                for (ParameterConstraint pc : rule.getContextParameterConstraints()) {
                    String paramName = pc.getParameterName();
                    Set<String> paramValues = CollectionUtils.toSetFromArray(pc.getParameterValues());
                    builder.addRule(paramName, ContextParameterDescriptor.class, nounPatterns, paramValues, pc.getMaxNumberOfValues(), pc.getDefaultValue());
                }
            }
        }
        builder.getConfig().activate();
        ParamScopedMetricsConfig.setCurrentParamScopedMetricsConfig(configToActivate);
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(static).activateConfiguration -  done: " + builder);
        }
    }

    public Map<String, ParameterScopedMetricsRule> getConfigRules() {
        if (sLogger.isLoggable(Level.FINER)) {
            sLogger.log(Level.FINER, "ParamScopedMetricsConfig(" + this.mInstanceNumber + ").getConfigRules -  returning: " + MapUtils.toString(this.mRuleIdToRuleMap));
        }
        return this.mRuleIdToRuleMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        JSONUtils.appendNameValuePair(sb, "instanceNumber", this.mInstanceNumber);
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "rules", this.mRuleIdToRuleMap);
        sb.append('}');
        String retVal = sb.toString();
        return retVal;
    }

    public static void setCurrentParamScopedMetricsConfig(ParamScopedMetricsConfig psmc) {
        sParamScopedMetricsConfig = psmc;
    }

    public static ParamScopedMetricsConfig getCurrentParamScopedMetricsConfig() {
        return sParamScopedMetricsConfig;
    }
}

