/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.wls;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;

public class DMSStartup {
    private static final String CLASS_NAME = DMSStartup.class.getName();
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");

    public static void main(String[] args) {
        DMSStartup.start();
    }

    public static void start() {
        block6: {
            block5: {
                String METHOD_NAME = "start";
                PlatformSupport platform = PlatformSupportFactory.getPlatformSupport();
                PlatformSupportFactory.injectPlatformSupport(platform);
                DMSConsole console = new DMSConsole();
                try {
                    console.init(null);
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block5;
                    LOGGER.logp(Level.INFO, CLASS_NAME, "start", "DMS-50700", e);
                }
            }
            try {
                DiagnosticsFramework df = new DiagnosticsFramework();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Diagnostics Framework successfully initialized; ADR Base: " + df.getADRBase() + "; ADR Product Type: " + df.getProductType() + "; ADR Product Id: " + df.getProductId() + "; ADR Instance Id: " + df.getInstanceId());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block6;
                LOGGER.logp(Level.WARNING, CLASS_NAME, "start", "failure initializing Diagnostics Framework", e);
            }
        }
    }
}

