/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.SampleDataProcessor;
import oracle.jvmmon.agent.UncaughtStatistic;

class UncaughtExpStat
implements GroupRefresh {
    static final String NOUN_NAME = "Uncaught";
    static final int MAX_ROW = 5;
    static final byte COL_NAME = 0;
    static final byte COL_COUNT = 1;
    static final byte COL_EARLIEST = 2;
    static final byte COL_LATEST = 3;
    static final byte COL_CLASSNAME = 4;
    static final byte COL_METHODNAME = 5;
    static final byte COL_FILENAME = 6;
    static final byte COL_LINE = 7;
    static final byte COL_ISNATIVE = 8;
    static final String[] COLUMN_NAMES = new String[]{"Name", "Count", "EarliestDetectTime", "LatestDetectTime", "LocationClassname", "LocationMethodName", "LocationSourceFilename", "LocationSourceLine", "LocationIsNative"};
    static final String[] COLUMN_DESCS = new String[]{"Exception class name", "Total number of uncaught cases being detected", "Earliest detect time", "Latest detect time", "Class name of the location", "Method name of the location", "Source filename of the location", "Source line number", "Is thrown from native frame"};
    static final byte[] COLUMN_STATES = new byte[]{5, 2, 2, 2, 5, 5, 5, 3, 3};
    private static Noun s_baseNoun;
    private static Vector<UncaughtExpStat> s_allStats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    UncaughtExpStat(Noun baseNoun, int index) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/Uncaught") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, Integer.toString(index), "JVMMON_Uncaught");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        UncaughtExpStat.create(base, 5);
    }

    static void create(Noun base, int quantity) {
        if (s_allStats != null) {
            return;
        }
        s_allStats = new Vector(quantity);
        for (int i = 1; i <= quantity; ++i) {
            s_allStats.addElement(new UncaughtExpStat(base, i));
        }
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        UncaughtStatistic[] uncaughts = this.dataPsr_.getExceptionStat().getUncaughtUsage();
        if (uncaughts == null) {
            return;
        }
        for (int index = 0; index < s_allStats.size(); ++index) {
            UncaughtExpStat stat = s_allStats.elementAt(index);
            block12: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
                State state = stat.states_[col];
                if (index >= uncaughts.length) {
                    if (state.getValueType() == 5) {
                        state.update("-NA-");
                        continue;
                    }
                    state.update(0);
                    continue;
                }
                switch (col) {
                    case 0: {
                        state.update(uncaughts[index].getExceptionClassName());
                        continue block12;
                    }
                    case 1: {
                        state.update(uncaughts[index].getOccurrence());
                        continue block12;
                    }
                    case 2: {
                        state.update(uncaughts[index].getEarlestTime());
                        continue block12;
                    }
                    case 3: {
                        state.update(uncaughts[index].getLatestTime());
                        continue block12;
                    }
                    case 4: {
                        state.update(uncaughts[index].getLocation().getClassName());
                        continue block12;
                    }
                    case 5: {
                        state.update(uncaughts[index].getLocation().getMethodName());
                        continue block12;
                    }
                    case 7: {
                        state.update(uncaughts[index].getLocation().getLineNumber());
                        continue block12;
                    }
                    case 8: {
                        state.update(uncaughts[index].getLocation().isNativeMethod());
                        continue block12;
                    }
                    case 6: {
                        state.update(uncaughts[index].getLocation().getFileName());
                    }
                }
            }
        }
    }

    static void exit() {
        if (s_allStats != null) {
            s_allStats.clear();
        }
        s_baseNoun = null;
    }
}

