/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.ExceptionTypeStatistic;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.SampleDataProcessor;

class ExceptionStat
implements GroupRefresh {
    static final String NOUN_NAME = "Exceptions";
    static final int MAX_ROW = 5;
    static final byte COL_CLASSNAME = 0;
    static final byte COL_THROWNCNT = 1;
    static final byte COL_CAUGHTCNT = 2;
    static final String[] COLUMN_NAMES = new String[]{"Name", "ThrownCount", "CaughtCount"};
    static final String[] COLUMN_DESCS = new String[]{"Exception class name", "Total count of thrown", "Total count of caught"};
    static final byte[] COLUMN_STATES = new byte[]{5, 2, 2};
    private static Noun s_baseNoun;
    private static Vector<ExceptionStat> s_allStats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    ExceptionStat(Noun baseNoun, int index) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/Exceptions") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, Integer.toString(index), "JVMMON_Exceptions");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        ExceptionStat.create(base, 5);
    }

    static void create(Noun base, int quantity) {
        if (s_allStats != null) {
            return;
        }
        s_allStats = new Vector(quantity);
        for (int i = 1; i <= quantity; ++i) {
            s_allStats.addElement(new ExceptionStat(base, i));
        }
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        ExceptionTypeStatistic[] exUsages = this.dataPsr_.getExceptionStat().getTopExceptionUsage();
        if (exUsages == null) {
            return;
        }
        for (int index = 0; index < s_allStats.size(); ++index) {
            ExceptionStat stat = s_allStats.elementAt(index);
            block6: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
                State state = stat.states_[col];
                if (index >= exUsages.length) {
                    if (state.getValueType() == 5) {
                        state.update("-NA-");
                        continue;
                    }
                    state.update(0);
                    continue;
                }
                switch (col) {
                    case 0: {
                        state.update(exUsages[index].getClassName());
                        continue block6;
                    }
                    case 1: {
                        state.update(exUsages[index].getThrownCount());
                        continue block6;
                    }
                    case 2: {
                        state.update(exUsages[index].getCaughtCount());
                    }
                }
            }
        }
    }

    static void exit() {
        if (s_allStats != null) {
            s_allStats.clear();
        }
        s_baseNoun = null;
    }
}

