/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.dfwdump;

import java.util.EnumSet;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.formatter.TableFormatter;
import oracle.jvmmon.agent.GCEvent;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.common.StringID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullGC
extends ComponentDiagnosticDump {
    private static final int COL_WIDTH = 10;

    public FullGC() {
        this.defineArgument(StringID.translate("1085", new Object[0]), ArgumentType.BOOLEAN, false, StringID.translate("1086", new Object[0]));
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException {
        TableFormatter tf;
        block5: {
            DumpWriter dw = new DumpWriter(context);
            tf = new TableFormatter(dw, true);
            try {
                boolean isForceGC = context.getArguments().getBool(StringID.translate("1085", new Object[0]), false);
                if (isForceGC) {
                    System.gc();
                }
                tf.addColumn(StringID.translate("1081", new Object[0]), 10);
                tf.addColumn(StringID.translate("1082", new Object[0]), 10);
                tf.addColumn(StringID.translate("1083", new Object[0]), 10);
                tf.addColumn(StringID.translate("1084", new Object[0]), 10);
                GCEvent[] gcEv = JVMMonitor.getDataProcessor().getGCStatistics().getFullGCEvents();
                if (gcEv != null && gcEv.length > 0) {
                    for (int i = 0; i < gcEv.length; ++i) {
                        tf.addRow(gcEv[i].getBeginTime(), gcEv[i].getElapsedTime(), gcEv[i].getTotalMemoryAfter(), gcEv[i].getFreeMemoryAfter());
                    }
                    break block5;
                }
                dw.dump(StringID.translate("901", new Object[0]));
                return dw.getDumpResult();
            }
            catch (Exception ex) {
                throw new DumpExecutionException("56000", (Throwable)ex, "DMS", "oracle.jvmmon.messages.Translation");
            }
        }
        return tf.getDumpWriter().getDumpResult();
    }

    @Override
    public String getName() {
        return StringID.translate("1018", new Object[0]);
    }

    @Override
    public String getOwner() {
        return "jvmmon";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.MEMORY);
    }

    @Override
    public String getDumpDescription() {
        return StringID.translate("1019", new Object[0]);
    }
}

