/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.dms.util.NameSupport;
import oracle.dms.util.QueryOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableQueryDescriptor
extends NameSupport {
    private QueryOptions.QueryType m_queryType;
    private HashSet<String> m_columns = new HashSet();
    private long m_schemaRefreshTime = 0L;
    private long m_valueRefreshTime = 0L;
    private RankingSelection m_rankingSelection = null;

    public TableQueryDescriptor(String name, QueryOptions.QueryType queryType) {
        super(name);
        if (queryType == null) {
            throw new IllegalArgumentException("queryType=" + (Object)((Object)queryType));
        }
        this.m_queryType = queryType;
    }

    void setQueryType(QueryOptions.QueryType queryType) {
        if (queryType == null) {
            throw new IllegalArgumentException("queryType=" + (Object)((Object)queryType));
        }
        this.m_queryType = queryType;
    }

    public QueryOptions.QueryType getQueryType() {
        return this.m_queryType;
    }

    public boolean includeSchema() {
        return this.m_queryType.includeSchema();
    }

    public boolean includeRows() {
        return this.m_queryType.includeRows();
    }

    public void addColumn(String column) {
        if (column != null && column.trim().length() > 0) {
            this.m_columns.add(column);
        }
    }

    public void addColumns(Collection<String> columns) {
        if (columns != null) {
            this.m_columns.addAll(columns);
        }
    }

    public Set<String> getColumns() {
        return this.m_columns;
    }

    public void setSchemaRefreshTime(long schemaRefreshTime) {
        if (schemaRefreshTime > 0L) {
            this.m_schemaRefreshTime = schemaRefreshTime;
        }
    }

    public long schemaRefreshTime() {
        return this.m_schemaRefreshTime;
    }

    public void setValueRefreshTime(long valueRefreshTime) {
        if (valueRefreshTime > 0L) {
            this.m_valueRefreshTime = valueRefreshTime;
        }
    }

    public long valueRefreshTime() {
        return this.m_valueRefreshTime;
    }

    public void setRankingSelection(RankingSelection rankingSelection) {
        if (rankingSelection != null) {
            this.m_rankingSelection = rankingSelection;
        }
    }

    public RankingSelection getRankingSelection() {
        return this.m_rankingSelection;
    }

    public Object clone() {
        TableQueryDescriptor clone = null;
        try {
            clone = (TableQueryDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.m_columns = new HashSet<String>(this.m_columns);
        return clone;
    }

    public static class RankingSelection {
        private int m_numRows;
        private String m_column;
        private Order m_order = Order.ASC;

        public RankingSelection(Order order, int numRows, String column) {
            if (order == null || column == null || column.trim().length() == 0 || numRows <= 0) {
                throw new IllegalArgumentException("order=" + (Object)((Object)order) + " column=" + column + " numRows=" + numRows);
            }
            this.m_order = order;
            this.m_column = column;
            this.m_numRows = numRows;
        }

        public int getNumRows() {
            return this.m_numRows;
        }

        public String getColumn() {
            return this.m_column;
        }

        public Order getOrder() {
            return this.m_order;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        ASC,
        DESC;

    }
}

