/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.ColumnGroup;
import oracle.dms.table.ColumnGroupSupport;
import oracle.dms.table.Schema;
import oracle.dms.table.TableBaseSupport;
import oracle.dms.table.TableSupport;
import oracle.dms.util.NameSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaSupport
extends TableBaseSupport
implements Schema {
    private String m_displayName = null;
    private String m_nlsId = null;
    private String m_description = null;
    protected Hashtable<String, ColumnDefinitionSupport> m_columnDefinitions = new Hashtable();
    protected TreeMap<String, ColumnGroupSupport> m_columnGroups = new TreeMap();
    private static final long serialVersionUID = -1150676615528L;

    protected SchemaSupport(String displayName, String nlsId, String description, TableSupport table) {
        super(table);
        table.setSchema(this);
        this.m_displayName = displayName;
        this.m_nlsId = nlsId == null || nlsId.trim().length() == 0 ? "QU_" + table.getName() : nlsId;
        this.m_description = description;
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public String getNLSID() {
        return this.m_nlsId;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public int columnCount() {
        return this.m_columnDefinitions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnNames() {
        String[] ret = null;
        Hashtable<String, ColumnDefinitionSupport> hashtable = this.m_columnDefinitions;
        synchronized (hashtable) {
            ret = new String[this.m_columnDefinitions.size()];
            this.m_columnDefinitions.keySet().toArray(ret);
        }
        return ret;
    }

    @Override
    public boolean containsColumn(String column) {
        if (column == null || column.trim().length() == 0) {
            return false;
        }
        return this.m_columnDefinitions.containsKey(column);
    }

    @Override
    public ColumnDefinition getColumnDefinition(String column) {
        if (column == null || column.trim().length() == 0) {
            return null;
        }
        return this.m_columnDefinitions.get(column);
    }

    @Override
    public ColumnDefinition[] getColumnDefinitions() {
        ColumnDefinition[] columnDefinitions = new ColumnDefinitionSupport[this.m_columnDefinitions.size()];
        this.m_columnDefinitions.values().toArray(columnDefinitions);
        return columnDefinitions;
    }

    @Override
    public Enumeration<? extends ColumnDefinition> enumerateColumnDefinitions(boolean sorted) {
        if (!sorted) {
            return this.m_columnDefinitions.elements();
        }
        Vector<ColumnDefinitionSupport> vec = new Vector<ColumnDefinitionSupport>(this.m_columnDefinitions.values());
        Collections.sort(vec);
        return vec.elements();
    }

    @Override
    public int columnGroupCount() {
        return this.m_columnGroups.size();
    }

    @Override
    public ColumnGroup getColumnGroup(String group) {
        if (group == null || group.trim().length() == 0) {
            return null;
        }
        return this.m_columnGroups.get(group);
    }

    @Override
    public boolean containsColumnGroup(String group) {
        if (group == null || group.trim().length() == 0) {
            return false;
        }
        return this.m_columnGroups.containsKey(group);
    }

    @Override
    public ColumnGroup[] getColumnGroups() {
        ColumnGroup[] columnGroups = new ColumnGroupSupport[this.m_columnGroups.size()];
        this.m_columnGroups.values().toArray(columnGroups);
        return columnGroups;
    }

    @Override
    public Enumeration<? extends ColumnGroup> enumerateColumnGroups(boolean sorted) {
        return Collections.enumeration(this.m_columnGroups.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnGroupNames() {
        String[] ret = null;
        TreeMap<String, ColumnGroupSupport> treeMap = this.m_columnGroups;
        synchronized (treeMap) {
            ret = new String[this.m_columnGroups.size()];
            this.m_columnGroups.keySet().toArray(ret);
        }
        return ret;
    }

    public String toString() {
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter out = new PrintWriter(buf);
        this.printTbml(0L, true, out);
        out.close();
        return buf.toString();
    }

    protected void addColumnDefinition(ColumnDefinitionSupport desc) {
        if (desc == null) {
            return;
        }
        String name = desc.getName();
        this.m_columnDefinitions.put(name, desc);
        String nlsId = desc.getNLSID();
        if (nlsId == null || nlsId.trim().length() == 0) {
            desc.setNLSID(this.m_table.getName());
        }
    }

    protected void addColumnGroup(ColumnGroupSupport group) {
        if (group == null) {
            return;
        }
        this.m_columnGroups.put(group.getName(), group);
    }

    protected synchronized Object clone() {
        String name;
        SchemaSupport clone = null;
        try {
            clone = (SchemaSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.m_columnDefinitions = new Hashtable<String, ColumnDefinitionSupport>(this.m_columnDefinitions);
        for (Map.Entry<String, ColumnDefinitionSupport> entry : clone.m_columnDefinitions.entrySet()) {
            name = entry.getKey();
            ColumnDefinitionSupport cdef = entry.getValue();
            ColumnDefinitionSupport newdef = cdef.clone(clone);
            entry.setValue(newdef);
        }
        clone.m_columnGroups = new TreeMap<String, ColumnGroupSupport>((SortedMap<String, ColumnGroupSupport>)this.m_columnGroups);
        for (Map.Entry<String, NameSupport> entry : clone.m_columnGroups.entrySet()) {
            name = entry.getKey();
            ColumnGroupSupport group = (ColumnGroupSupport)entry.getValue();
            ColumnGroupSupport newGroup = (ColumnGroupSupport)group.clone();
            entry.setValue(newGroup);
        }
        return clone;
    }

    protected synchronized SchemaSupport clone(TableSupport table) {
        SchemaSupport clone = (SchemaSupport)this.clone();
        if (table != null) {
            clone.m_table = table;
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        TreeMap<String, ColumnGroupSupport> columnGroups;
        SchemaSupport schemaSupport = this;
        synchronized (schemaSupport) {
            this.m_columnDefinitions.clear();
            columnGroups = new TreeMap<String, ColumnGroupSupport>((SortedMap<String, ColumnGroupSupport>)this.m_columnGroups);
            this.m_columnGroups.clear();
        }
        for (ColumnGroupSupport group : columnGroups.values()) {
            group.close();
        }
        columnGroups.clear();
    }

    protected void printTbml(long schemaRefreshTime, boolean verbose, PrintWriter out) {
        if (verbose) {
            for (ColumnGroupSupport group : this.m_columnGroups.values()) {
                group.printTbml(schemaRefreshTime, out);
            }
        }
        for (ColumnDefinitionSupport columndef : this.m_columnDefinitions.values()) {
            columndef.printTbml(schemaRefreshTime, verbose, out);
        }
    }
}

