/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Date;
import oracle.dms.http.Request;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.Tracer;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.TreeletReporter;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class TransTraceReporter
extends TreeletReporter {
    public TransTraceReporter(Request request) {
        super(request);
    }

    void printHeading(PrintWriter out) {
        out.print("<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE transtrace>\n<transtrace version='");
        out.print("11.0");
        out.print("' id='");
        out.print(this.m_id);
        out.print("' host='");
        out.print(DMSUtil.getLocalHostname());
        out.print("' name='");
        out.print(this.m_name);
        out.print("' timestamp='");
        long tstamp = System.currentTimeMillis();
        out.print(tstamp);
        out.print(" (");
        out.print(new Date(tstamp));
        out.print(")'>\n");
    }

    void printEnding(PrintWriter out) {
        out.print("</transtrace>\n");
    }

    void startPrintNounNode(NounTreeletNode node, PrintWriter out) {
        out.print("<noun name='");
        out.print(node.getName());
        out.print("' type='");
        out.print(node.getTable());
        out.print("'>\n");
    }

    void printMetricNode(MetricTreeletNode node, PrintWriter out) {
        Sensor sensor = ((Metric)node.m_mappedNode).getSensor();
        if (sensor instanceof Tracer) {
            out.print("<trace ");
            out.print(" name='");
            out.print(sensor.getName());
            out.print('\'');
            out.print(">\n");
            out.print(((Tracer)sensor).getTraceString());
            out.print("</trace>\n");
        }
    }

    void endPrintNounNode(NounTreeletNode node, PrintWriter out) {
        out.print("</noun>\n");
    }
}

