/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import oracle.dms.http.Request;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.TreeletNode;
import oracle.dms.reporter.TreeletReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.util.DMSUtil;

public class PdmlReporter
extends TreeletReporter {
    public PdmlReporter(Request request) {
        super(request);
        this.m_isOrdered = true;
    }

    void printHeading(PrintWriter out) {
        out.print("<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE pdml>\n<pdml version='");
        out.print("11.0");
        out.print("' id='");
        out.print(this.m_id);
        out.print("' host='");
        out.print(DMSUtil.getLocalHostname());
        out.print("' name='");
        out.print(this.m_name);
        out.print("' timestamp='");
        long tstamp = System.currentTimeMillis();
        out.print(tstamp);
        out.print("'>\n");
    }

    void printEnding(PrintWriter out) {
        out.print("</pdml>\n");
    }

    void startPrintNounNode(NounTreeletNode node, PrintWriter out) {
        out.print("<noun name='");
        out.print(node.getName());
        out.print("' type='");
        out.print(node.getTable());
        out.print("'>\n");
    }

    void printMetricNode(MetricTreeletNode node, PrintWriter out) {
        out.print("<metric name='");
        out.print(node.getName());
        if (this.m_includeDescriptions) {
            String description = node.getDescription();
            out.print("' description='");
            if (description != null && description.trim().length() > 0) {
                out.print(description);
            }
        }
        if (this.m_includeUnits) {
            String unit = node.getUnit();
            out.print("' units='");
            if (unit != null && unit.trim().length() > 0) {
                out.print(unit);
            }
        }
        out.print("'>\n");
        if (this.m_includeValues) {
            Serializable metricValue = node.getObjValue();
            if (metricValue == null) {
                out.print("<null/>\n");
            } else if (metricValue instanceof ErrorObject) {
                out.print("<error/>\n");
            } else {
                out.print("<value type='");
                out.print(TreeletNode.getValueType(metricValue));
                out.print("'><![CDATA[");
                out.print(DMSUtil.xmlEscape(metricValue.toString()));
                out.print("]]></value>\n");
            }
        }
        out.print("</metric>\n");
    }

    void endPrintNounNode(NounTreeletNode node, PrintWriter out) {
        out.print("</noun>\n");
    }
}

