/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class AnyValue
extends Value {
    private Object _value = null;
    private double _min = Double.MAX_VALUE;
    private double _max = Double.MIN_VALUE;

    public void update(int newval) {
        Integer value = new Integer(newval);
        double dval = newval;
        this.setNumber(value, dval);
        this._initialized = true;
    }

    public void update(double newval) {
        Double value = new Double(newval);
        double dval = newval;
        this.setNumber(value, dval);
        this._initialized = true;
    }

    public void update(long newval) {
        Long value = new Long(newval);
        double dval = newval;
        this.setNumber(value, dval);
        this._initialized = true;
    }

    public void update(Object newval) {
        this._value = newval;
        this._initialized = true;
    }

    public void increment(int inc) {
        if (!this.isInitialized()) {
            return;
        }
        int ival = ((Number)this._value).intValue() + inc;
        double newval = ival;
        Integer value = new Integer(ival);
        this.setNumber(value, newval);
    }

    public void increment(double inc) {
        if (!this.isInitialized()) {
            return;
        }
        double newval = ((Number)this._value).doubleValue() + inc;
        Double value = new Double(newval);
        this.setNumber(value, newval);
    }

    public void increment(long inc) {
        if (!this.isInitialized()) {
            return;
        }
        long newval = ((Number)this._value).longValue() + inc;
        Long value = new Long(newval);
        double dval = newval;
        this.setNumber(value, dval);
    }

    private void setNumber(Number value, double dval) {
        this._value = value;
        if (this.MIN && dval < this._min) {
            this._min = dval;
        }
        if (this.MAX && dval > this._max) {
            this._max = dval;
        }
    }

    void initMinMax() {
        if (this._initialized && this._value instanceof Number) {
            double dval = ((Number)this._value).doubleValue();
            if (this.MIN && this._min > dval) {
                this._min = dval;
            }
            if (this.MAX && this._max < dval) {
                this._max = dval;
            }
        }
    }

    public void reset() {
        super.reset();
        if (this._value != null && this._value instanceof Number) {
            if (this.MIN) {
                this._min = ((Number)this._value).doubleValue();
            }
            if (this.MAX) {
                this._max = ((Number)this._value).doubleValue();
            }
        }
    }

    public Object getValue() {
        return this._value;
    }

    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Double.MAX_VALUE) {
            return new Double(this._min);
        }
        return new Double(0.0);
    }

    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Double.MIN_VALUE) {
            return new Double(this._max);
        }
        return new Double(0.0);
    }
}

